/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.github.zafarkhaja.semver.Version;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.LedgerOffloader;
import org.apache.bookkeeper.mledger.ManagedLedgerConfig;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.ManagedLedgerInfo;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerFactoryImpl;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerOfflineBacklog;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.admin.AdminResource;
import org.apache.pulsar.broker.admin.ZkAdminPaths;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.Subscription;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.broker.service.persistent.PersistentReplicator;
import org.apache.pulsar.broker.service.persistent.PersistentSubscription;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.client.admin.LongRunningProcessStatus;
import org.apache.pulsar.client.admin.OffloadProcessStatus;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.common.allocator.PulsarByteBufAllocator;
import org.apache.pulsar.common.api.proto.PulsarApi;
import org.apache.pulsar.common.compression.CompressionCodec;
import org.apache.pulsar.common.compression.CompressionCodecProvider;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.PartitionedManagedLedgerInfo;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.partition.PartitionedTopicMetadata;
import org.apache.pulsar.common.policies.data.AuthAction;
import org.apache.pulsar.common.policies.data.AuthPolicies;
import org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.common.policies.data.DelayedDeliveryPolicies;
import org.apache.pulsar.common.policies.data.DispatchRate;
import org.apache.pulsar.common.policies.data.InactiveTopicPolicies;
import org.apache.pulsar.common.policies.data.OffloadPolicies;
import org.apache.pulsar.common.policies.data.PartitionedTopicInternalStats;
import org.apache.pulsar.common.policies.data.PartitionedTopicStats;
import org.apache.pulsar.common.policies.data.PersistencePolicies;
import org.apache.pulsar.common.policies.data.PersistentOfflineTopicStats;
import org.apache.pulsar.common.policies.data.PersistentTopicInternalStats;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.policies.data.PublishRate;
import org.apache.pulsar.common.policies.data.RetentionPolicies;
import org.apache.pulsar.common.policies.data.SubscribeRate;
import org.apache.pulsar.common.policies.data.SubscriptionStats;
import org.apache.pulsar.common.policies.data.TopicPolicies;
import org.apache.pulsar.common.policies.data.TopicStats;
import org.apache.pulsar.common.protocol.Commands;
import org.apache.pulsar.common.util.Codec;
import org.apache.pulsar.common.util.DateFormatter;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.common.util.collections.BitSetRecyclable;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentTopicsBase
extends AdminResource {
    private static final Logger log = LoggerFactory.getLogger(PersistentTopicsBase.class);
    private static final int OFFLINE_TOPIC_STAT_TTL_MINS = 10;
    private static final String DEPRECATED_CLIENT_VERSION_PREFIX = "Pulsar-CPP-v";
    private static final Version LEAST_SUPPORTED_CLIENT_VERSION_PREFIX = Version.forIntegers((int)1, (int)21);

    protected List<String> internalGetList() {
        this.validateAdminAccessForTenant(this.namespaceName.getTenant());
        try {
            this.policiesCache().get(PersistentTopicsBase.path("policies", this.namespaceName.toString()));
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to get topic list {}: Namespace does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (Exception e) {
            log.error("[{}] Failed to get topic list {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
        ArrayList topics = Lists.newArrayList();
        try {
            String path = String.format("/managed-ledgers/%s/%s", this.namespaceName.toString(), this.domain());
            for (String topic : this.managedLedgerListCache().get(path)) {
                if (!this.domain().equals(TopicDomain.persistent.toString())) continue;
                topics.add(TopicName.get((String)this.domain(), (NamespaceName)this.namespaceName, (String)Codec.decode((String)topic)).toString());
            }
        }
        catch (KeeperException.NoNodeException path) {
        }
        catch (Exception e) {
            log.error("[{}] Failed to get topics list for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
        topics.sort(null);
        return topics;
    }

    protected List<String> internalGetPartitionedTopicList() {
        this.validateAdminAccessForTenant(this.namespaceName.getTenant());
        try {
            this.policiesCache().get(PersistentTopicsBase.path("policies", this.namespaceName.toString()));
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to get partitioned topic list {}: Namespace does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (Exception e) {
            log.error("[{}] Failed to get partitioned topic list for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
        return this.getPartitionedTopicList(TopicDomain.getEnum((String)this.domain()));
    }

    protected Map<String, Set<AuthAction>> internalGetPermissionsOnTopic() {
        this.validateAdminAccessForTenant(this.namespaceName.getTenant());
        String topicUri = this.topicName.toString();
        try {
            Policies policies = (Policies)this.policiesCache().get(PersistentTopicsBase.path("policies", this.namespaceName.toString())).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Namespace does not exist"));
            HashMap permissions = Maps.newHashMap();
            AuthPolicies auth = policies.auth_policies;
            for (String string : auth.namespace_auth.keySet()) {
                permissions.put(string, auth.namespace_auth.get(string));
            }
            if (auth.destination_auth.containsKey(topicUri)) {
                for (Map.Entry entry : ((Map)auth.destination_auth.get(topicUri)).entrySet()) {
                    String role = (String)entry.getKey();
                    Set topicPermissions = (Set)entry.getValue();
                    if (!permissions.containsKey(role)) {
                        permissions.put(role, topicPermissions);
                        continue;
                    }
                    Sets.SetView union = Sets.union((Set)((Set)permissions.get(role)), (Set)topicPermissions);
                    permissions.put(role, union);
                }
            }
            return permissions;
        }
        catch (Exception e) {
            log.error("[{}] Failed to get permissions for topic {}", new Object[]{this.clientAppId(), topicUri, e});
            throw new RestException(e);
        }
    }

    protected void validateAdminAndClientPermission() {
        try {
            this.validateAdminAccessForTenant(this.topicName.getTenant());
        }
        catch (Exception ve) {
            try {
                PersistentTopicsBase.checkAuthorization(this.pulsar(), this.topicName, this.clientAppId(), (AuthenticationDataSource)this.clientAuthData());
            }
            catch (RestException re) {
                throw re;
            }
            catch (Exception e) {
                log.warn("Unexpected error while authorizing request. topic={}, role={}. Error: {}", new Object[]{this.topicName, this.clientAppId(), e.getMessage(), e});
                throw new RestException(e);
            }
        }
    }

    public void validateAdminOperationOnTopic(boolean authoritative) {
        this.validateAdminAccessForTenant(this.topicName.getTenant());
        this.validateTopicOwnership(this.topicName, authoritative);
    }

    public void validateReadOperationOnTopic(boolean authoritative) {
        this.validateTopicOwnership(this.topicName, authoritative);
        try {
            this.validateAdminAccessForTenant(this.topicName.getTenant());
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] failed to validate admin access for {}", (Object)this.topicName, (Object)this.clientAppId());
            }
            this.validateAdminAccessForSubscriber("");
        }
    }

    public void validateWriteOperationOnTopic(boolean authoritative) {
        this.validateTopicOwnership(this.topicName, authoritative);
        try {
            this.validateAdminAccessForTenant(this.topicName.getTenant());
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] failed to validate admin access for {}", (Object)this.topicName, (Object)this.clientAppId());
            }
            try {
                if (!this.pulsar().getBrokerService().getAuthorizationService().canProduce(this.topicName, this.clientAppId(), (AuthenticationDataSource)this.clientAuthData())) {
                    log.warn("[{}} Subscriber {} is not authorized to access api", (Object)this.topicName, (Object)this.clientAppId());
                    throw new RestException(Response.Status.UNAUTHORIZED, String.format("Subscriber %s is not authorized to access this operation", this.clientAppId()));
                }
            }
            catch (RestException re) {
                throw re;
            }
            catch (Exception ex) {
                log.warn("Unexpected error while authorizing request. topic={}, role={}. Error: {}", new Object[]{this.topicName, this.clientAppId(), e.getMessage(), ex});
                throw new RestException(ex);
            }
        }
    }

    protected void validateAdminAccessForSubscriber(String subscriptionName, boolean authoritative) {
        this.validateTopicOwnership(this.topicName, authoritative);
        try {
            this.validateAdminAccessForTenant(this.topicName.getTenant());
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] failed to validate admin access for {}", (Object)this.topicName, (Object)this.clientAppId());
            }
            this.validateAdminAccessForSubscriber(subscriptionName);
        }
    }

    private void validateAdminAccessForSubscriber(String subscriptionName) {
        try {
            if (!this.pulsar().getBrokerService().getAuthorizationService().canConsume(this.topicName, this.clientAppId(), (AuthenticationDataSource)this.clientAuthData(), subscriptionName)) {
                log.warn("[{}} Subscriber {} is not authorized to access api", (Object)this.topicName, (Object)this.clientAppId());
                throw new RestException(Response.Status.UNAUTHORIZED, String.format("Subscriber %s is not authorized to access this operation", this.clientAppId()));
            }
        }
        catch (RestException re) {
            throw re;
        }
        catch (Exception e) {
            log.warn("Unexpected error while authorizing request. topic={}, role={}. Error: {}", new Object[]{this.topicName, this.clientAppId(), e.getMessage(), e});
            throw new RestException(e);
        }
    }

    private void grantPermissions(String topicUri, String role, Set<AuthAction> actions) {
        try {
            Stat nodeStat = new Stat();
            byte[] content = this.globalZk().getData(PersistentTopicsBase.path("policies", this.namespaceName.toString()), null, nodeStat);
            Policies policies = (Policies)PersistentTopicsBase.jsonMapper().readValue(content, Policies.class);
            if (!policies.auth_policies.destination_auth.containsKey(topicUri)) {
                policies.auth_policies.destination_auth.put(topicUri, new HashMap());
            }
            ((Map)policies.auth_policies.destination_auth.get(topicUri)).put(role, actions);
            this.globalZk().setData(PersistentTopicsBase.path("policies", this.namespaceName.toString()), PersistentTopicsBase.jsonMapper().writeValueAsBytes((Object)policies), nodeStat.getVersion());
            this.policiesCache().invalidate(PersistentTopicsBase.path("policies", this.namespaceName.toString()));
            log.info("[{}] Successfully granted access for role {}: {} - topic {}", new Object[]{this.clientAppId(), role, actions, topicUri});
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to grant permissions on topic {}: Namespace does not exist", (Object)this.clientAppId(), (Object)topicUri);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (KeeperException.BadVersionException e) {
            log.warn("[{}] Failed to grant permissions on topic {}: concurrent modification", (Object)this.clientAppId(), (Object)topicUri);
            throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
        }
        catch (Exception e) {
            log.error("[{}] Failed to grant permissions for topic {}", new Object[]{this.clientAppId(), topicUri, e});
            throw new RestException(e);
        }
    }

    protected void internalGrantPermissionsOnTopic(String role, Set<AuthAction> actions) {
        this.validateAdminAccessForTenant(this.namespaceName.getTenant());
        this.validatePoliciesReadOnlyAccess();
        PartitionedTopicMetadata meta = this.getPartitionedTopicMetadata(this.topicName, true, false);
        int numPartitions = meta.partitions;
        if (numPartitions > 0) {
            for (int i = 0; i < numPartitions; ++i) {
                TopicName topicNamePartition = this.topicName.getPartition(i);
                this.grantPermissions(topicNamePartition.toString(), role, actions);
            }
        }
        this.grantPermissions(this.topicName.toString(), role, actions);
    }

    protected void internalDeleteTopicForcefully(boolean authoritative, boolean deleteSchema) {
        this.validateWriteOperationOnTopic(authoritative);
        try {
            this.pulsar().getBrokerService().deleteTopic(this.topicName.toString(), true, deleteSchema).get();
        }
        catch (Exception e) {
            if (e.getCause() instanceof ManagedLedgerException.MetadataNotFoundException) {
                log.info("[{}] Topic was already not existing {}", new Object[]{this.clientAppId(), this.topicName, e});
            }
            log.error("[{}] Failed to delete topic forcefully {}", new Object[]{this.clientAppId(), this.topicName, e});
            throw new RestException(e);
        }
    }

    private void revokePermissions(String topicUri, String role) {
        Policies policies;
        Stat nodeStat = new Stat();
        try {
            byte[] content = this.globalZk().getData(PersistentTopicsBase.path("policies", this.namespaceName.toString()), null, nodeStat);
            policies = (Policies)PersistentTopicsBase.jsonMapper().readValue(content, Policies.class);
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to revoke permissions on topic {}: Namespace does not exist", (Object)this.clientAppId(), (Object)topicUri);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (KeeperException.BadVersionException e) {
            log.warn("[{}] Failed to revoke permissions on topic {}: concurrent modification", (Object)this.clientAppId(), (Object)topicUri);
            throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
        }
        catch (Exception e) {
            log.error("[{}] Failed to revoke permissions for topic {}", new Object[]{this.clientAppId(), topicUri, e});
            throw new RestException(e);
        }
        if (!policies.auth_policies.destination_auth.containsKey(topicUri) || !((Map)policies.auth_policies.destination_auth.get(topicUri)).containsKey(role)) {
            log.warn("[{}] Failed to revoke permission from role {} on topic: Not set at topic level {}", new Object[]{this.clientAppId(), role, topicUri});
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Permissions are not set at the topic level");
        }
        ((Map)policies.auth_policies.destination_auth.get(topicUri)).remove(role);
        try {
            String namespacePath = PersistentTopicsBase.path("policies", this.namespaceName.toString());
            this.globalZk().setData(namespacePath, PersistentTopicsBase.jsonMapper().writeValueAsBytes((Object)policies), nodeStat.getVersion());
            this.policiesCache().invalidate(namespacePath);
            this.globalZkCache().invalidate(namespacePath);
            log.info("[{}] Successfully revoke access for role {} - topic {}", new Object[]{this.clientAppId(), role, topicUri});
        }
        catch (Exception e) {
            log.error("[{}] Failed to revoke permissions for topic {}", new Object[]{this.clientAppId(), topicUri, e});
            throw new RestException(e);
        }
    }

    protected void internalRevokePermissionsOnTopic(String role) {
        this.validateAdminAccessForTenant(this.namespaceName.getTenant());
        this.validatePoliciesReadOnlyAccess();
        PartitionedTopicMetadata meta = this.getPartitionedTopicMetadata(this.topicName, true, false);
        int numPartitions = meta.partitions;
        if (numPartitions > 0) {
            for (int i = 0; i < numPartitions; ++i) {
                TopicName topicNamePartition = this.topicName.getPartition(i);
                this.revokePermissions(topicNamePartition.toString(), role);
            }
        }
        this.revokePermissions(this.topicName.toString(), role);
    }

    protected void internalCreateNonPartitionedTopic(boolean authoritative) {
        this.validateWriteOperationOnTopic(authoritative);
        this.validateNonPartitionTopicName(this.topicName.getLocalName());
        if (this.topicName.isGlobal()) {
            this.validateGlobalNamespaceOwnership(this.namespaceName);
        }
        this.validateTopicOwnership(this.topicName, authoritative);
        PartitionedTopicMetadata partitionMetadata = this.getPartitionedTopicMetadata(this.topicName, authoritative, false);
        if (partitionMetadata.partitions > 0) {
            log.warn("[{}] Partitioned topic with the same name already exists {}", (Object)this.clientAppId(), (Object)this.topicName);
            throw new RestException(Response.Status.CONFLICT, "This topic already exists");
        }
        try {
            Topic createdTopic = this.getOrCreateTopic(this.topicName);
            log.info("[{}] Successfully created non-partitioned topic {}", (Object)this.clientAppId(), (Object)createdTopic);
        }
        catch (Exception e) {
            log.error("[{}] Failed to create non-partitioned topic {}", new Object[]{this.clientAppId(), this.topicName, e});
            throw new RestException(e);
        }
    }

    protected void internalUpdatePartitionedTopic(int numPartitions, boolean updateLocalTopicOnly, boolean authoritative) {
        int maxPartitions;
        this.validateWriteOperationOnTopic(authoritative);
        if (!updateLocalTopicOnly) {
            this.validatePartitionTopicUpdate(this.topicName.getLocalName(), numPartitions);
        }
        if ((maxPartitions = this.pulsar().getConfig().getMaxNumPartitionsPerPartitionedTopic()) > 0 && numPartitions > maxPartitions) {
            throw new RestException(Response.Status.NOT_ACCEPTABLE, "Number of partitions should be less than or equal to " + maxPartitions);
        }
        if (this.topicName.isGlobal() && this.isNamespaceReplicated(this.topicName.getNamespaceObject())) {
            Set<String> clusters = this.getNamespaceReplicatedClusters(this.topicName.getNamespaceObject());
            if (!clusters.contains(this.pulsar().getConfig().getClusterName())) {
                log.error("[{}] local cluster is not part of replicated cluster for namespace {}", (Object)this.clientAppId(), (Object)this.topicName);
                throw new RestException(Response.Status.FORBIDDEN, "Local cluster is not part of replicate cluster list");
            }
            try {
                this.tryCreatePartitionsAsync(numPartitions).get();
                this.createSubscriptions(this.topicName, numPartitions).get();
            }
            catch (Exception e) {
                if (e.getCause() instanceof RestException) {
                    throw (RestException)((Object)e.getCause());
                }
                log.error("[{}] Failed to update partitioned topic {}", new Object[]{this.clientAppId(), this.topicName, e});
                throw new RestException(e);
            }
            if (!updateLocalTopicOnly) {
                CompletableFuture updatePartition = new CompletableFuture();
                String path = ZkAdminPaths.partitionedTopicPath(this.topicName);
                ((CompletableFuture)this.updatePartitionInOtherCluster(numPartitions, clusters).thenRun(() -> {
                    try {
                        byte[] data = PersistentTopicsBase.jsonMapper().writeValueAsBytes((Object)new PartitionedTopicMetadata(numPartitions));
                        this.globalZk().setData(path, data, -1, (rc, path1, ctx, stat) -> {
                            if (rc == KeeperException.Code.OK.intValue()) {
                                updatePartition.complete(null);
                            } else {
                                updatePartition.completeExceptionally(KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc), (String)"failed to create update partitions"));
                            }
                        }, null);
                    }
                    catch (Exception e) {
                        updatePartition.completeExceptionally(e);
                    }
                })).exceptionally(ex -> {
                    updatePartition.completeExceptionally((Throwable)ex);
                    return null;
                });
                try {
                    updatePartition.get();
                }
                catch (Exception e) {
                    log.error("{} Failed to update number of partitions in zk for topic {} and partitions {}", new Object[]{this.clientAppId(), this.topicName, numPartitions, e});
                    if (e.getCause() instanceof RestException) {
                        throw (RestException)((Object)e.getCause());
                    }
                    throw new RestException(e);
                }
            }
            return;
        }
        if (numPartitions <= 0) {
            throw new RestException(Response.Status.NOT_ACCEPTABLE, "Number of partitions should be more than 0");
        }
        try {
            this.tryCreatePartitionsAsync(numPartitions).get();
            this.updatePartitionedTopic(this.topicName, numPartitions).get();
        }
        catch (Exception e) {
            if (e.getCause() instanceof RestException) {
                throw (RestException)((Object)e.getCause());
            }
            log.error("[{}] Failed to update partitioned topic {}", new Object[]{this.clientAppId(), this.topicName, e});
            throw new RestException(e);
        }
    }

    protected void internalCreateMissedPartitions(AsyncResponse asyncResponse) {
        ((CompletableFuture)this.getPartitionedTopicMetadataAsync(this.topicName, false, false).thenAccept(metadata -> {
            if (metadata != null) {
                ((CompletableFuture)this.tryCreatePartitionsAsync(metadata.partitions).thenAccept(v -> asyncResponse.resume((Object)Response.noContent().build()))).exceptionally(e -> {
                    log.error("[{}] Failed to create partitions for topic {}", (Object)this.clientAppId(), (Object)this.topicName);
                    this.resumeAsyncResponseExceptionally(asyncResponse, (Throwable)e);
                    return null;
                });
            }
        })).exceptionally(e -> {
            log.error("[{}] Failed to create partitions for topic {}", (Object)this.clientAppId(), (Object)this.topicName);
            this.resumeAsyncResponseExceptionally(asyncResponse, (Throwable)e);
            return null;
        });
    }

    protected CompletableFuture<Void> internalSetDelayedDeliveryPolicies(DelayedDeliveryPolicies deliveryPolicies) {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName).thenCompose(op -> {
            TopicPolicies topicPolicies = op.orElseGet(TopicPolicies::new);
            topicPolicies.setDelayedDeliveryEnabled(deliveryPolicies == null ? null : Boolean.valueOf(deliveryPolicies.isActive()));
            topicPolicies.setDelayedDeliveryTickTimeMillis(deliveryPolicies == null ? null : Long.valueOf(deliveryPolicies.getTickTime()));
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, topicPolicies);
        });
    }

    private CompletableFuture<Void> updatePartitionInOtherCluster(int numPartitions, Set<String> clusters) {
        ArrayList results = new ArrayList(clusters.size() - 1);
        clusters.forEach(cluster -> {
            if (cluster.equals(this.pulsar().getConfig().getClusterName())) {
                return;
            }
            results.add(this.pulsar().getBrokerService().getClusterPulsarAdmin((String)cluster).topics().updatePartitionedTopicAsync(this.topicName.toString(), numPartitions, true));
        });
        return FutureUtil.waitForAll(results);
    }

    protected PartitionedTopicMetadata internalGetPartitionedMetadata(boolean authoritative, boolean checkAllowAutoCreation) {
        PartitionedTopicMetadata metadata = this.getPartitionedTopicMetadata(this.topicName, authoritative, checkAllowAutoCreation);
        if (metadata.partitions > 1) {
            this.validateClientVersion();
        }
        return metadata;
    }

    protected void internalDeletePartitionedTopic(AsyncResponse asyncResponse, boolean authoritative, boolean force, boolean deleteSchema) {
        try {
            this.validateWriteOperationOnTopic(authoritative);
        }
        catch (WebApplicationException wae) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Failed to delete partitioned topic {}, redirecting to other brokers.", new Object[]{this.clientAppId(), this.topicName, wae});
            }
            this.resumeAsyncResponseExceptionally(asyncResponse, wae);
            return;
        }
        catch (Exception e) {
            log.error("[{}] Failed to delete partitioned topic {}", new Object[]{this.clientAppId(), this.topicName, e});
            this.resumeAsyncResponseExceptionally(asyncResponse, e);
            return;
        }
        CompletableFuture future = new CompletableFuture();
        ((CompletableFuture)this.pulsar().getBrokerService().fetchPartitionedTopicMetadataAsync(this.topicName).thenAccept(partitionMeta -> {
            int numPartitions = partitionMeta.partitions;
            if (numPartitions > 0) {
                AtomicInteger count = new AtomicInteger(numPartitions);
                if (deleteSchema) {
                    count.incrementAndGet();
                    this.pulsar().getBrokerService().deleteSchemaStorage(this.topicName.getPartition(0).toString()).whenComplete((r, ex) -> {
                        if (ex != null) {
                            log.warn("Failed to delete schema storage of topic: {}", (Object)this.topicName);
                        }
                        if (count.decrementAndGet() == 0) {
                            future.complete(null);
                        }
                    });
                }
                for (int i = 0; i < numPartitions; ++i) {
                    TopicName topicNamePartition = this.topicName.getPartition(i);
                    try {
                        this.pulsar().getAdminClient().topics().deleteAsync(topicNamePartition.toString(), force).whenComplete((r, ex) -> {
                            if (ex != null) {
                                if (!(ex instanceof PulsarAdminException.NotFoundException)) {
                                    log.error("[{}] Failed to delete partition {}", new Object[]{this.clientAppId(), topicNamePartition, ex});
                                    future.completeExceptionally((Throwable)ex);
                                    return;
                                }
                                if (log.isDebugEnabled()) {
                                    log.debug("[{}] Partition not found: {}", (Object)this.clientAppId(), (Object)topicNamePartition);
                                }
                            } else {
                                log.info("[{}] Deleted partition {}", (Object)this.clientAppId(), (Object)topicNamePartition);
                            }
                            if (count.decrementAndGet() == 0) {
                                future.complete(null);
                            }
                        });
                        continue;
                    }
                    catch (Exception e) {
                        log.error("[{}] Failed to delete partition {}", new Object[]{this.clientAppId(), topicNamePartition, e});
                        future.completeExceptionally(e);
                    }
                }
            } else {
                future.complete(null);
            }
        })).exceptionally(ex -> {
            future.completeExceptionally((Throwable)ex);
            return null;
        });
        future.whenComplete((r, ex) -> {
            if (ex != null) {
                if (ex instanceof PulsarAdminException.PreconditionFailedException) {
                    asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.PRECONDITION_FAILED, "Topic has active producers/subscriptions")));
                    return;
                }
                if (ex instanceof PulsarAdminException) {
                    asyncResponse.resume((Throwable)((Object)new RestException((PulsarAdminException)((Object)ex))));
                    return;
                }
                if (ex instanceof WebApplicationException) {
                    asyncResponse.resume(ex);
                    return;
                }
                asyncResponse.resume((Throwable)((Object)new RestException((Throwable)ex)));
                return;
            }
            String path = PersistentTopicsBase.path("partitioned-topics", this.namespaceName.toString(), this.domain(), this.topicName.getEncodedLocalName());
            this.globalZk().delete(path, -1, (rc, s, o) -> {
                if (KeeperException.Code.OK.intValue() == rc) {
                    try {
                        this.globalZkCache().invalidate(path);
                        this.globalZk().sync(path, (rc2, s2, ctx) -> {
                            if (KeeperException.Code.OK.intValue() == rc2) {
                                log.info("[{}] Deleted partitioned topic {}", (Object)this.clientAppId(), (Object)this.topicName);
                                asyncResponse.resume((Object)Response.noContent().build());
                            } else {
                                log.error("[{}] Failed to delete partitioned topic {}", new Object[]{this.clientAppId(), this.topicName, KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc2))});
                                asyncResponse.resume((Throwable)((Object)new RestException(KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc2)))));
                            }
                        }, null);
                    }
                    catch (Exception e) {
                        log.error("Failed to delete partitioned topic.", (Throwable)e);
                        asyncResponse.resume((Throwable)((Object)new RestException(e)));
                    }
                } else if (KeeperException.Code.NONODE.intValue() == rc) {
                    asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Partitioned topic does not exist")));
                } else if (KeeperException.Code.BADVERSION.intValue() == rc) {
                    log.warn("[{}] Failed to delete partitioned topic {}: concurrent modification", (Object)this.clientAppId(), (Object)this.topicName);
                    asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.CONFLICT, "Concurrent modification")));
                } else {
                    log.error("[{}] Failed to delete partitioned topic {}", new Object[]{this.clientAppId(), this.topicName, KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc))});
                    asyncResponse.resume((Throwable)((Object)new RestException(KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc)))));
                }
            }, null);
        });
    }

    protected void internalUnloadTopic(AsyncResponse asyncResponse, boolean authoritative) {
        log.info("[{}] Unloading topic {}", (Object)this.clientAppId(), (Object)this.topicName);
        try {
            if (this.topicName.isGlobal()) {
                this.validateGlobalNamespaceOwnership(this.namespaceName);
            }
        }
        catch (Exception e) {
            log.error("[{}] Failed to unload topic {}", new Object[]{this.clientAppId(), this.topicName, e});
            this.resumeAsyncResponseExceptionally(asyncResponse, e);
            return;
        }
        if (this.topicName.isPartitioned()) {
            this.internalUnloadNonPartitionedTopic(asyncResponse, authoritative);
        } else {
            ((CompletableFuture)this.getPartitionedTopicMetadataAsync(this.topicName, authoritative, false).whenComplete((meta, t) -> {
                if (meta.partitions > 0) {
                    ArrayList futures = Lists.newArrayList();
                    for (int i = 0; i < meta.partitions; ++i) {
                        TopicName topicNamePartition = this.topicName.getPartition(i);
                        try {
                            futures.add(this.pulsar().getAdminClient().topics().unloadAsync(topicNamePartition.toString()));
                            continue;
                        }
                        catch (Exception e) {
                            log.error("[{}] Failed to unload topic {}", new Object[]{this.clientAppId(), topicNamePartition, e});
                            asyncResponse.resume((Throwable)((Object)new RestException(e)));
                            return;
                        }
                    }
                    FutureUtil.waitForAll((List)futures).handle((result, exception) -> {
                        if (exception != null) {
                            Throwable th = exception.getCause();
                            if (th instanceof PulsarAdminException.NotFoundException) {
                                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, th.getMessage())));
                            } else if (th instanceof WebApplicationException) {
                                asyncResponse.resume(th);
                            } else {
                                log.error("[{}] Failed to unload topic {}", new Object[]{this.clientAppId(), this.topicName, exception});
                                asyncResponse.resume((Throwable)((Object)new RestException((Throwable)exception)));
                            }
                        } else {
                            asyncResponse.resume((Object)Response.noContent().build());
                        }
                        return null;
                    });
                } else {
                    this.internalUnloadNonPartitionedTopic(asyncResponse, authoritative);
                }
            })).exceptionally(t -> {
                log.error("[{}] Failed to unload topic {}", new Object[]{this.clientAppId(), this.topicName, t});
                if (t instanceof WebApplicationException) {
                    asyncResponse.resume(t);
                } else {
                    asyncResponse.resume((Throwable)((Object)new RestException((Throwable)t)));
                }
                return null;
            });
        }
    }

    protected CompletableFuture<Void> internalSetOffloadPolicies(OffloadPolicies offloadPolicies) {
        return ((CompletableFuture)this.getTopicPoliciesAsyncWithRetry(this.topicName).thenCompose(op -> {
            TopicPolicies topicPolicies = op.orElseGet(TopicPolicies::new);
            topicPolicies.setOffloadPolicies(offloadPolicies);
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, topicPolicies);
        })).thenCompose(__ -> {
            PartitionedTopicMetadata metadata = PersistentTopicsBase.fetchPartitionedTopicMetadata(this.pulsar(), this.topicName);
            if (metadata.partitions > 0) {
                ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>(metadata.partitions);
                for (int i = 0; i < metadata.partitions; ++i) {
                    futures.add(this.internalUpdateOffloadPolicies(offloadPolicies, this.topicName.getPartition(i)));
                }
                return FutureUtil.waitForAll(futures);
            }
            return this.internalUpdateOffloadPolicies(offloadPolicies, this.topicName);
        });
    }

    protected CompletableFuture<Void> internalSetInactiveTopicPolicies(InactiveTopicPolicies inactiveTopicPolicies) {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName).thenCompose(op -> {
            TopicPolicies topicPolicies = op.orElseGet(TopicPolicies::new);
            topicPolicies.setInactiveTopicPolicies(inactiveTopicPolicies);
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, topicPolicies);
        });
    }

    private CompletableFuture<Void> internalUpdateOffloadPolicies(OffloadPolicies offloadPolicies, TopicName topicName) {
        return this.pulsar().getBrokerService().getTopicIfExists(topicName.toString()).thenAccept(optionalTopic -> {
            try {
                if (!optionalTopic.isPresent() || !topicName.isPersistent()) {
                    return;
                }
                PersistentTopic persistentTopic = (PersistentTopic)optionalTopic.get();
                ManagedLedgerConfig managedLedgerConfig = persistentTopic.getManagedLedger().getConfig();
                if (offloadPolicies == null) {
                    LedgerOffloader namespaceOffloader = this.pulsar().getLedgerOffloaderMap().get(topicName.getNamespaceObject());
                    LedgerOffloader topicOffloader = managedLedgerConfig.getLedgerOffloader();
                    if (topicOffloader != null && topicOffloader != namespaceOffloader) {
                        topicOffloader.close();
                    }
                    managedLedgerConfig.setLedgerOffloader(namespaceOffloader);
                } else {
                    managedLedgerConfig.setLedgerOffloader(this.pulsar().createManagedLedgerOffloader(offloadPolicies));
                }
                persistentTopic.getManagedLedger().setConfig(managedLedgerConfig);
            }
            catch (PulsarServerException e) {
                throw new RestException(e);
            }
        });
    }

    protected CompletableFuture<Void> internalSetMaxUnackedMessagesOnSubscription(Integer maxUnackedNum) {
        if (maxUnackedNum != null && maxUnackedNum < 0) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "maxUnackedNum must be 0 or more");
        }
        return this.getTopicPoliciesAsyncWithRetry(this.topicName).thenCompose(op -> {
            TopicPolicies topicPolicies = op.orElseGet(TopicPolicies::new);
            topicPolicies.setMaxUnackedMessagesOnSubscription(maxUnackedNum);
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, topicPolicies);
        });
    }

    protected CompletableFuture<Void> internalSetMaxUnackedMessagesOnConsumer(Integer maxUnackedNum) {
        if (maxUnackedNum != null && maxUnackedNum < 0) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "maxUnackedNum must be 0 or more");
        }
        return this.getTopicPoliciesAsyncWithRetry(this.topicName).thenCompose(op -> {
            TopicPolicies topicPolicies = op.orElseGet(TopicPolicies::new);
            topicPolicies.setMaxUnackedMessagesOnConsumer(maxUnackedNum);
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, topicPolicies);
        });
    }

    protected CompletableFuture<Void> internalSetDeduplicationSnapshotInterval(Integer interval) {
        if (interval != null && interval < 0) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "interval must be 0 or more");
        }
        return this.getTopicPoliciesAsyncWithRetry(this.topicName).thenCompose(op -> {
            TopicPolicies policies = op.orElseGet(TopicPolicies::new);
            policies.setDeduplicationSnapshotIntervalSeconds(interval);
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, policies);
        });
    }

    private void internalUnloadNonPartitionedTopic(AsyncResponse asyncResponse, boolean authoritative) {
        Topic topic;
        try {
            this.validateAdminAccessForTenant(this.topicName.getTenant());
            this.validateTopicOwnership(this.topicName, authoritative);
            topic = this.getTopicReference(this.topicName);
        }
        catch (Exception e) {
            log.error("[{}] Failed to unload topic {}", new Object[]{this.clientAppId(), this.topicName, e});
            this.resumeAsyncResponseExceptionally(asyncResponse, e);
            return;
        }
        topic.close(false).whenComplete((r, ex) -> {
            if (ex != null) {
                log.error("[{}] Failed to unload topic {}, {}", new Object[]{this.clientAppId(), this.topicName, ex.getMessage(), ex});
                asyncResponse.resume((Throwable)((Object)new RestException((Throwable)ex)));
            } else {
                log.info("[{}] Successfully unloaded topic {}", (Object)this.clientAppId(), (Object)this.topicName);
                asyncResponse.resume((Object)Response.noContent().build());
            }
        });
    }

    protected void internalDeleteTopic(boolean authoritative, boolean force, boolean deleteSchema) {
        if (force) {
            this.internalDeleteTopicForcefully(authoritative, deleteSchema);
        } else {
            this.internalDeleteTopic(authoritative, deleteSchema);
        }
    }

    protected void internalDeleteTopic(boolean authoritative, boolean deleteSchema) {
        this.validateWriteOperationOnTopic(authoritative);
        try {
            this.pulsar().getBrokerService().deleteTopic(this.topicName.toString(), false, deleteSchema).get();
            log.info("[{}] Successfully removed topic {}", (Object)this.clientAppId(), (Object)this.topicName);
        }
        catch (Exception e) {
            Throwable t = e.getCause();
            log.error("[{}] Failed to delete topic {}", new Object[]{this.clientAppId(), this.topicName, t});
            if (t instanceof BrokerServiceException.TopicBusyException) {
                throw new RestException(Response.Status.PRECONDITION_FAILED, "Topic has active producers/subscriptions");
            }
            if (t instanceof ManagedLedgerException.MetadataNotFoundException) {
                throw new RestException(Response.Status.NOT_FOUND, "Topic not found");
            }
            throw new RestException(t);
        }
    }

    protected void internalGetSubscriptions(AsyncResponse asyncResponse, boolean authoritative) {
        if (this.topicName.isGlobal()) {
            try {
                this.validateGlobalNamespaceOwnership(this.namespaceName);
            }
            catch (Exception e) {
                log.error("[{}] Failed to get subscriptions for topic {}", new Object[]{this.clientAppId(), this.topicName, e});
                this.resumeAsyncResponseExceptionally(asyncResponse, e);
                return;
            }
        }
        if (this.topicName.isPartitioned()) {
            this.internalGetSubscriptionsForNonPartitionedTopic(asyncResponse, authoritative);
        } else {
            ((CompletableFuture)this.getPartitionedTopicMetadataAsync(this.topicName, authoritative, false).thenAccept(partitionMetadata -> {
                block7: {
                    if (partitionMetadata.partitions > 0) {
                        try {
                            Set subscriptions = Sets.newConcurrentHashSet();
                            ArrayList subscriptionFutures = Lists.newArrayList();
                            if (this.topicName.getDomain() == TopicDomain.persistent) {
                                ConcurrentMap existsFutures = Maps.newConcurrentMap();
                                for (int i = 0; i < partitionMetadata.partitions; ++i) {
                                    String path = String.format("/managed-ledgers/%s/%s/%s", this.namespaceName.toString(), this.domain(), this.topicName.getPartition(i).getEncodedLocalName());
                                    CompletableFuture exists = this.localZkCache().existsAsync(path, null);
                                    existsFutures.put(i, exists);
                                }
                                ((CompletableFuture)((CompletableFuture)FutureUtil.waitForAll((List)Lists.newArrayList(existsFutures.values())).thenApply(__ -> existsFutures.entrySet().stream().filter(e -> (Boolean)((CompletableFuture)e.getValue()).join()).map(item -> this.topicName.getPartition(((Integer)item.getKey()).intValue()).toString()).collect(Collectors.toList()))).thenAccept(topics -> {
                                    if (log.isDebugEnabled()) {
                                        log.debug("activeTopics : {}", topics);
                                    }
                                    topics.forEach(topic -> {
                                        try {
                                            CompletableFuture subscriptionsAsync = this.pulsar().getAdminClient().topics().getSubscriptionsAsync(topic);
                                            subscriptionFutures.add(subscriptionsAsync.thenApply(subscriptions::addAll));
                                        }
                                        catch (PulsarServerException e) {
                                            throw new RestException(e);
                                        }
                                    });
                                })).thenAccept(__ -> this.resumeAsyncResponse(asyncResponse, subscriptions, subscriptionFutures));
                                break block7;
                            }
                            for (int i = 0; i < partitionMetadata.partitions; ++i) {
                                CompletableFuture subscriptionsAsync = this.pulsar().getAdminClient().topics().getSubscriptionsAsync(this.topicName.getPartition(i).toString());
                                subscriptionFutures.add(subscriptionsAsync.thenApply(subscriptions::addAll));
                            }
                            this.resumeAsyncResponse(asyncResponse, subscriptions, subscriptionFutures);
                        }
                        catch (Exception e) {
                            log.error("[{}] Failed to get list of subscriptions for {}", new Object[]{this.clientAppId(), this.topicName, e});
                            asyncResponse.resume((Throwable)e);
                        }
                    } else {
                        this.internalGetSubscriptionsForNonPartitionedTopic(asyncResponse, authoritative);
                    }
                }
            })).exceptionally(ex -> {
                log.error("[{}] Failed to get subscriptions for topic {}", new Object[]{this.clientAppId(), this.topicName, ex});
                this.resumeAsyncResponseExceptionally(asyncResponse, (Throwable)ex);
                return null;
            });
        }
    }

    private void resumeAsyncResponse(AsyncResponse asyncResponse, Set<String> subscriptions, List<CompletableFuture<Object>> subscriptionFutures) {
        FutureUtil.waitForAll(subscriptionFutures).whenComplete((r, ex) -> {
            if (ex != null) {
                log.warn("[{}] Failed to get list of subscriptions for {}: {}", new Object[]{this.clientAppId(), this.topicName, ex.getMessage()});
                if (ex instanceof PulsarAdminException) {
                    PulsarAdminException pae = (PulsarAdminException)((Object)ex);
                    if (pae.getStatusCode() == Response.Status.NOT_FOUND.getStatusCode()) {
                        asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Internal topics have not been generated yet")));
                        return;
                    }
                    asyncResponse.resume((Throwable)((Object)new RestException(pae)));
                    return;
                }
                asyncResponse.resume((Throwable)((Object)new RestException((Throwable)ex)));
                return;
            }
            asyncResponse.resume(new ArrayList(subscriptions));
        });
    }

    private void internalGetSubscriptionsForNonPartitionedTopic(AsyncResponse asyncResponse, boolean authoritative) {
        try {
            this.validateReadOperationOnTopic(authoritative);
            Topic topic = this.getTopicReference(this.topicName);
            ArrayList subscriptions = Lists.newArrayList();
            topic.getSubscriptions().forEach((subName, sub) -> subscriptions.add(subName));
            asyncResponse.resume((Object)subscriptions);
        }
        catch (WebApplicationException wae) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Failed to get subscriptions for non-partitioned topic {}, redirecting to other brokers.", new Object[]{this.clientAppId(), this.topicName, wae});
            }
            this.resumeAsyncResponseExceptionally(asyncResponse, wae);
            return;
        }
        catch (Exception e) {
            log.error("[{}] Failed to get list of subscriptions for {}", new Object[]{this.clientAppId(), this.topicName, e});
            this.resumeAsyncResponseExceptionally(asyncResponse, e);
        }
    }

    protected TopicStats internalGetStats(boolean authoritative, boolean getPreciseBacklog, boolean subscriptionBacklogSize) {
        this.validateAdminAndClientPermission();
        if (this.topicName.isGlobal()) {
            this.validateGlobalNamespaceOwnership(this.namespaceName);
        }
        this.validateTopicOwnership(this.topicName, authoritative);
        Topic topic = this.getTopicReference(this.topicName);
        return topic.getStats(getPreciseBacklog, subscriptionBacklogSize);
    }

    protected PersistentTopicInternalStats internalGetInternalStats(boolean authoritative, boolean metadata) {
        this.validateAdminAndClientPermission();
        if (this.topicName.isGlobal()) {
            this.validateGlobalNamespaceOwnership(this.namespaceName);
        }
        this.validateTopicOwnership(this.topicName, authoritative);
        Topic topic = this.getTopicReference(this.topicName);
        try {
            boolean includeMetadata = metadata && this.hasSuperUserAccess();
            return topic.getInternalStats(includeMetadata).get();
        }
        catch (Exception e) {
            log.error("[{}] Failed to get internal stats for {}", new Object[]{this.clientAppId(), this.topicName, e});
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e instanceof ExecutionException ? e.getCause().getMessage() : e.getMessage());
        }
    }

    protected void internalGetManagedLedgerInfo(AsyncResponse asyncResponse, boolean authoritative) {
        if (this.topicName.isGlobal()) {
            try {
                this.validateGlobalNamespaceOwnership(this.namespaceName);
            }
            catch (Exception e) {
                log.error("[{}] Failed to get managed info for {}", new Object[]{this.clientAppId(), this.topicName, e});
                this.resumeAsyncResponseExceptionally(asyncResponse, e);
                return;
            }
        }
        if (this.topicName.isPartitioned()) {
            this.internalGetManagedLedgerInfoForNonPartitionedTopic(asyncResponse);
        } else {
            ((CompletableFuture)this.getPartitionedTopicMetadataAsync(this.topicName, authoritative, false).thenAccept(partitionMetadata -> {
                if (partitionMetadata.partitions > 0) {
                    ArrayList futures = Lists.newArrayList();
                    PartitionedManagedLedgerInfo partitionedManagedLedgerInfo = new PartitionedManagedLedgerInfo();
                    for (int i = 0; i < partitionMetadata.partitions; ++i) {
                        TopicName topicNamePartition = this.topicName.getPartition(i);
                        try {
                            futures.add(this.pulsar().getAdminClient().topics().getInternalInfoAsync(topicNamePartition.toString()).whenComplete((jsonObject, throwable) -> {
                                if (throwable != null) {
                                    log.error("[{}] Failed to get managed info for {}", new Object[]{this.clientAppId(), topicNamePartition, throwable});
                                    asyncResponse.resume((Throwable)((Object)new RestException((Throwable)throwable)));
                                }
                                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                                try {
                                    partitionedManagedLedgerInfo.partitions.put(topicNamePartition.toString(), (ManagedLedgerInfo)PersistentTopicsBase.jsonMapper().readValue(gson.toJson((JsonElement)jsonObject), ManagedLedgerInfo.class));
                                }
                                catch (JsonProcessingException ex) {
                                    log.error("[{}] Failed to parse ManagedLedgerInfo for {} from [{}]", new Object[]{this.clientAppId(), topicNamePartition, gson.toJson((JsonElement)jsonObject), ex});
                                }
                            }));
                            continue;
                        }
                        catch (Exception e) {
                            log.error("[{}] Failed to get managed info for {}", new Object[]{this.clientAppId(), topicNamePartition, e});
                            throw new RestException(e);
                        }
                    }
                    FutureUtil.waitForAll((List)futures).handle((result, exception) -> {
                        if (exception != null) {
                            Throwable t = exception.getCause();
                            if (t instanceof PulsarAdminException.NotFoundException) {
                                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Topic not found")));
                            } else {
                                log.error("[{}] Failed to get managed info for {}", new Object[]{this.clientAppId(), this.topicName, t});
                                asyncResponse.resume((Throwable)((Object)new RestException(t)));
                            }
                        }
                        asyncResponse.resume(output -> PersistentTopicsBase.jsonMapper().writer().writeValue(output, (Object)partitionedManagedLedgerInfo));
                        return null;
                    });
                } else {
                    this.internalGetManagedLedgerInfoForNonPartitionedTopic(asyncResponse);
                }
            })).exceptionally(ex -> {
                log.error("[{}] Failed to get managed info for {}", new Object[]{this.clientAppId(), this.topicName, ex});
                this.resumeAsyncResponseExceptionally(asyncResponse, (Throwable)ex);
                return null;
            });
        }
    }

    protected void internalGetManagedLedgerInfoForNonPartitionedTopic(final AsyncResponse asyncResponse) {
        String managedLedger;
        try {
            this.validateAdminAccessForTenant(this.topicName.getTenant());
            managedLedger = this.topicName.getPersistenceNamingEncoding();
        }
        catch (Exception e) {
            log.error("[{}] Failed to get managed info for {}", new Object[]{this.clientAppId(), this.topicName, e});
            this.resumeAsyncResponseExceptionally(asyncResponse, e);
            return;
        }
        this.pulsar().getManagedLedgerFactory().asyncGetManagedLedgerInfo(managedLedger, new AsyncCallbacks.ManagedLedgerInfoCallback(){

            public void getInfoComplete(ManagedLedgerInfo info, Object ctx) {
                asyncResponse.resume(output -> AdminResource.jsonMapper().writer().writeValue(output, (Object)info));
            }

            public void getInfoFailed(ManagedLedgerException exception, Object ctx) {
                asyncResponse.resume((Throwable)exception);
            }
        }, null);
    }

    protected void internalGetPartitionedStats(AsyncResponse asyncResponse, boolean authoritative, boolean perPartition, boolean getPreciseBacklog, boolean subscriptionBacklogSize) {
        if (this.topicName.isGlobal()) {
            try {
                this.validateGlobalNamespaceOwnership(this.namespaceName);
            }
            catch (Exception e) {
                log.error("[{}] Failed to get partitioned stats for {}", new Object[]{this.clientAppId(), this.topicName, e});
                this.resumeAsyncResponseExceptionally(asyncResponse, e);
                return;
            }
        }
        ((CompletableFuture)this.getPartitionedTopicMetadataAsync(this.topicName, authoritative, false).thenAccept(partitionMetadata -> {
            if (partitionMetadata.partitions == 0) {
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Partitioned Topic not found")));
                return;
            }
            PartitionedTopicStats stats = new PartitionedTopicStats(partitionMetadata);
            ArrayList topicStatsFutureList = Lists.newArrayList();
            for (int i = 0; i < partitionMetadata.partitions; ++i) {
                try {
                    topicStatsFutureList.add(this.pulsar().getAdminClient().topics().getStatsAsync(this.topicName.getPartition(i).toString(), getPreciseBacklog, subscriptionBacklogSize));
                    continue;
                }
                catch (PulsarServerException e) {
                    asyncResponse.resume((Throwable)((Object)new RestException(e)));
                    return;
                }
            }
            FutureUtil.waitForAll((List)topicStatsFutureList).handle((result, exception) -> {
                CompletableFuture statFuture = null;
                for (int i = 0; i < topicStatsFutureList.size(); ++i) {
                    statFuture = (CompletableFuture)topicStatsFutureList.get(i);
                    if (!statFuture.isDone() || statFuture.isCompletedExceptionally()) continue;
                    try {
                        stats.add((TopicStats)statFuture.get());
                        if (!perPartition) continue;
                        stats.partitions.put(this.topicName.getPartition(i).toString(), statFuture.get());
                        continue;
                    }
                    catch (Exception e) {
                        asyncResponse.resume((Throwable)((Object)new RestException(e)));
                        return null;
                    }
                }
                if (perPartition && stats.partitions.isEmpty()) {
                    String path = ZkAdminPaths.partitionedTopicPath(this.topicName);
                    try {
                        boolean zkPathExists = this.zkPathExists(path);
                        if (!zkPathExists) {
                            asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Internal topics have not been generated yet")));
                            return null;
                        }
                        stats.partitions.put(this.topicName.toString(), new TopicStats());
                    }
                    catch (InterruptedException | KeeperException e) {
                        asyncResponse.resume((Throwable)((Object)new RestException(e)));
                        return null;
                    }
                }
                asyncResponse.resume((Object)stats);
                return null;
            });
        })).exceptionally(ex -> {
            log.error("[{}] Failed to get partitioned stats for {}", new Object[]{this.clientAppId(), this.topicName, ex});
            this.resumeAsyncResponseExceptionally(asyncResponse, (Throwable)ex);
            return null;
        });
    }

    protected void internalGetPartitionedStatsInternal(AsyncResponse asyncResponse, boolean authoritative) {
        if (this.topicName.isGlobal()) {
            try {
                this.validateGlobalNamespaceOwnership(this.namespaceName);
            }
            catch (Exception e) {
                log.error("[{}] Failed to get partitioned internal stats for {}", new Object[]{this.clientAppId(), this.topicName, e});
                this.resumeAsyncResponseExceptionally(asyncResponse, e);
                return;
            }
        }
        ((CompletableFuture)this.getPartitionedTopicMetadataAsync(this.topicName, authoritative, false).thenAccept(partitionMetadata -> {
            if (partitionMetadata.partitions == 0) {
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Partitioned Topic not found")));
                return;
            }
            PartitionedTopicInternalStats stats = new PartitionedTopicInternalStats(partitionMetadata);
            ArrayList topicStatsFutureList = Lists.newArrayList();
            for (int i = 0; i < partitionMetadata.partitions; ++i) {
                try {
                    topicStatsFutureList.add(this.pulsar().getAdminClient().topics().getInternalStatsAsync(this.topicName.getPartition(i).toString(), false));
                    continue;
                }
                catch (PulsarServerException e) {
                    asyncResponse.resume((Throwable)((Object)new RestException(e)));
                    return;
                }
            }
            FutureUtil.waitForAll((List)topicStatsFutureList).handle((result, exception) -> {
                CompletableFuture statFuture = null;
                for (int i = 0; i < topicStatsFutureList.size(); ++i) {
                    statFuture = (CompletableFuture)topicStatsFutureList.get(i);
                    if (!statFuture.isDone() || statFuture.isCompletedExceptionally()) continue;
                    try {
                        stats.partitions.put(this.topicName.getPartition(i).toString(), statFuture.get());
                        continue;
                    }
                    catch (Exception e) {
                        asyncResponse.resume((Throwable)((Object)new RestException(e)));
                        return null;
                    }
                }
                asyncResponse.resume(!stats.partitions.isEmpty() ? stats : new RestException(Response.Status.NOT_FOUND, "Internal topics have not been generated yet"));
                return null;
            });
        })).exceptionally(ex -> {
            log.error("[{}] Failed to get partitioned internal stats for {}", new Object[]{this.clientAppId(), this.topicName, ex});
            this.resumeAsyncResponseExceptionally(asyncResponse, (Throwable)ex);
            return null;
        });
    }

    protected void internalDeleteSubscription(AsyncResponse asyncResponse, String subName, boolean authoritative, boolean force) {
        if (force) {
            this.internalDeleteSubscriptionForcefully(asyncResponse, subName, authoritative);
        } else {
            this.internalDeleteSubscription(asyncResponse, subName, authoritative);
        }
    }

    protected void internalDeleteSubscription(AsyncResponse asyncResponse, String subName, boolean authoritative) {
        if (this.topicName.isGlobal()) {
            try {
                this.validateGlobalNamespaceOwnership(this.namespaceName);
            }
            catch (Exception e) {
                log.error("[{}] Failed to delete subscription {} from topic {}", new Object[]{this.clientAppId(), subName, this.topicName, e});
                this.resumeAsyncResponseExceptionally(asyncResponse, e);
                return;
            }
        }
        if (this.topicName.isPartitioned()) {
            this.internalDeleteSubscriptionForNonPartitionedTopic(asyncResponse, subName, authoritative);
        } else {
            ((CompletableFuture)this.getPartitionedTopicMetadataAsync(this.topicName, authoritative, false).thenAccept(partitionMetadata -> {
                if (partitionMetadata.partitions > 0) {
                    ArrayList futures = Lists.newArrayList();
                    for (int i = 0; i < partitionMetadata.partitions; ++i) {
                        TopicName topicNamePartition = this.topicName.getPartition(i);
                        try {
                            futures.add(this.pulsar().getAdminClient().topics().deleteSubscriptionAsync(topicNamePartition.toString(), subName, false));
                            continue;
                        }
                        catch (Exception e) {
                            log.error("[{}] Failed to delete subscription {} {}", new Object[]{this.clientAppId(), topicNamePartition, subName, e});
                            asyncResponse.resume((Throwable)((Object)new RestException(e)));
                            return;
                        }
                    }
                    FutureUtil.waitForAll((List)futures).handle((result, exception) -> {
                        if (exception != null) {
                            Throwable t = exception.getCause();
                            if (t instanceof PulsarAdminException.NotFoundException) {
                                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Subscription not found")));
                                return null;
                            }
                            if (t instanceof PulsarAdminException.PreconditionFailedException) {
                                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.PRECONDITION_FAILED, "Subscription has active connected consumers")));
                                return null;
                            }
                            log.error("[{}] Failed to delete subscription {} {}", new Object[]{this.clientAppId(), this.topicName, subName, t});
                            asyncResponse.resume((Throwable)((Object)new RestException(t)));
                            return null;
                        }
                        asyncResponse.resume((Object)Response.noContent().build());
                        return null;
                    });
                } else {
                    this.internalDeleteSubscriptionForNonPartitionedTopic(asyncResponse, subName, authoritative);
                }
            })).exceptionally(ex -> {
                log.error("[{}] Failed to delete subscription {} from topic {}", new Object[]{this.clientAppId(), subName, this.topicName, ex});
                this.resumeAsyncResponseExceptionally(asyncResponse, (Throwable)ex);
                return null;
            });
        }
    }

    private void internalDeleteSubscriptionForNonPartitionedTopic(AsyncResponse asyncResponse, String subName, boolean authoritative) {
        try {
            this.validateAdminAccessForSubscriber(subName, authoritative);
            Topic topic = this.getTopicReference(this.topicName);
            Subscription sub = topic.getSubscription(subName);
            if (sub == null) {
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Subscription not found")));
                return;
            }
            sub.delete().get();
            log.info("[{}][{}] Deleted subscription {}", new Object[]{this.clientAppId(), this.topicName, subName});
            asyncResponse.resume((Object)Response.noContent().build());
        }
        catch (Exception e) {
            if (e.getCause() instanceof BrokerServiceException.SubscriptionBusyException) {
                log.error("[{}] Failed to delete subscription {} from topic {}", new Object[]{this.clientAppId(), subName, this.topicName, e});
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.PRECONDITION_FAILED, "Subscription has active connected consumers")));
            }
            if (e instanceof WebApplicationException) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Failed to delete subscription from topic {}, redirecting to other brokers.", new Object[]{this.clientAppId(), this.topicName, e});
                }
                asyncResponse.resume((Throwable)e);
            }
            log.error("[{}] Failed to delete subscription {} {}", new Object[]{this.clientAppId(), this.topicName, subName, e});
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    protected void internalDeleteSubscriptionForcefully(AsyncResponse asyncResponse, String subName, boolean authoritative) {
        if (this.topicName.isGlobal()) {
            try {
                this.validateGlobalNamespaceOwnership(this.namespaceName);
            }
            catch (Exception e) {
                log.error("[{}] Failed to delete subscription forcefully {} from topic {}", new Object[]{this.clientAppId(), subName, this.topicName, e});
                this.resumeAsyncResponseExceptionally(asyncResponse, e);
                return;
            }
        }
        if (this.topicName.isPartitioned()) {
            this.internalDeleteSubscriptionForNonPartitionedTopicForcefully(asyncResponse, subName, authoritative);
        } else {
            ((CompletableFuture)this.getPartitionedTopicMetadataAsync(this.topicName, authoritative, false).thenAccept(partitionMetadata -> {
                if (partitionMetadata.partitions > 0) {
                    ArrayList futures = Lists.newArrayList();
                    for (int i = 0; i < partitionMetadata.partitions; ++i) {
                        TopicName topicNamePartition = this.topicName.getPartition(i);
                        try {
                            futures.add(this.pulsar().getAdminClient().topics().deleteSubscriptionAsync(topicNamePartition.toString(), subName, true));
                            continue;
                        }
                        catch (Exception e) {
                            log.error("[{}] Failed to delete subscription forcefully {} {}", new Object[]{this.clientAppId(), topicNamePartition, subName, e});
                            asyncResponse.resume((Throwable)((Object)new RestException(e)));
                            return;
                        }
                    }
                    FutureUtil.waitForAll((List)futures).handle((result, exception) -> {
                        if (exception != null) {
                            Throwable t = exception.getCause();
                            if (t instanceof PulsarAdminException.NotFoundException) {
                                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Subscription not found")));
                                return null;
                            }
                            log.error("[{}] Failed to delete subscription forcefully {} {}", new Object[]{this.clientAppId(), this.topicName, subName, t});
                            asyncResponse.resume((Throwable)((Object)new RestException(t)));
                            return null;
                        }
                        asyncResponse.resume((Object)Response.noContent().build());
                        return null;
                    });
                } else {
                    this.internalDeleteSubscriptionForNonPartitionedTopicForcefully(asyncResponse, subName, authoritative);
                }
            })).exceptionally(ex -> {
                log.error("[{}] Failed to delete subscription forcefully {} from topic {}", new Object[]{this.clientAppId(), subName, this.topicName, ex});
                this.resumeAsyncResponseExceptionally(asyncResponse, (Throwable)ex);
                return null;
            });
        }
    }

    private void internalDeleteSubscriptionForNonPartitionedTopicForcefully(AsyncResponse asyncResponse, String subName, boolean authoritative) {
        try {
            this.validateAdminAccessForSubscriber(subName, authoritative);
            Topic topic = this.getTopicReference(this.topicName);
            Subscription sub = topic.getSubscription(subName);
            if (sub == null) {
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Subscription not found")));
                return;
            }
            sub.deleteForcefully().get();
            log.info("[{}][{}] Deleted subscription forcefully {}", new Object[]{this.clientAppId(), this.topicName, subName});
            asyncResponse.resume((Object)Response.noContent().build());
        }
        catch (Exception e) {
            if (e instanceof WebApplicationException) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Failed to delete subscription forcefully from topic {}, redirecting to other brokers.", new Object[]{this.clientAppId(), this.topicName, e});
                }
                asyncResponse.resume((Throwable)e);
            }
            log.error("[{}] Failed to delete subscription forcefully {} {}", new Object[]{this.clientAppId(), this.topicName, subName, e});
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    protected void internalSkipAllMessages(AsyncResponse asyncResponse, String subName, boolean authoritative) {
        if (this.topicName.isGlobal()) {
            try {
                this.validateGlobalNamespaceOwnership(this.namespaceName);
            }
            catch (Exception e) {
                log.error("[{}] Failed to skip all messages for subscription {} on topic {}", new Object[]{this.clientAppId(), subName, this.topicName, e});
                this.resumeAsyncResponseExceptionally(asyncResponse, e);
                return;
            }
        }
        if (this.topicName.isPartitioned()) {
            this.internalSkipAllMessagesForNonPartitionedTopic(asyncResponse, subName, authoritative);
        } else {
            ((CompletableFuture)this.getPartitionedTopicMetadataAsync(this.topicName, authoritative, false).thenAccept(partitionMetadata -> {
                if (partitionMetadata.partitions > 0) {
                    ArrayList futures = Lists.newArrayList();
                    for (int i = 0; i < partitionMetadata.partitions; ++i) {
                        TopicName topicNamePartition = this.topicName.getPartition(i);
                        try {
                            futures.add(this.pulsar().getAdminClient().topics().skipAllMessagesAsync(topicNamePartition.toString(), subName));
                            continue;
                        }
                        catch (Exception e) {
                            log.error("[{}] Failed to skip all messages {} {}", new Object[]{this.clientAppId(), topicNamePartition, subName, e});
                            asyncResponse.resume((Throwable)((Object)new RestException(e)));
                            return;
                        }
                    }
                    FutureUtil.waitForAll((List)futures).handle((result, exception) -> {
                        if (exception != null) {
                            Throwable t = exception.getCause();
                            if (t instanceof PulsarAdminException.NotFoundException) {
                                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Subscription not found")));
                                return null;
                            }
                            log.error("[{}] Failed to skip all messages {} {}", new Object[]{this.clientAppId(), this.topicName, subName, t});
                            asyncResponse.resume((Throwable)((Object)new RestException(t)));
                            return null;
                        }
                        asyncResponse.resume((Object)Response.noContent().build());
                        return null;
                    });
                } else {
                    this.internalSkipAllMessagesForNonPartitionedTopic(asyncResponse, subName, authoritative);
                }
            })).exceptionally(ex -> {
                log.error("[{}] Failed to skip all messages for subscription {} on topic {}", new Object[]{this.clientAppId(), subName, this.topicName, ex});
                this.resumeAsyncResponseExceptionally(asyncResponse, (Throwable)ex);
                return null;
            });
        }
    }

    private void internalSkipAllMessagesForNonPartitionedTopic(AsyncResponse asyncResponse, String subName, boolean authoritative) {
        try {
            this.validateAdminAccessForSubscriber(subName, authoritative);
            PersistentTopic topic = (PersistentTopic)this.getTopicReference(this.topicName);
            BiConsumer<Void, Throwable> biConsumer = (v, ex) -> {
                if (ex != null) {
                    asyncResponse.resume((Throwable)((Object)new RestException((Throwable)ex)));
                    log.error("[{}] Failed to skip all messages {} {}", new Object[]{this.clientAppId(), this.topicName, subName, ex});
                } else {
                    asyncResponse.resume((Object)Response.noContent().build());
                    log.info("[{}] Cleared backlog on {} {}", new Object[]{this.clientAppId(), this.topicName, subName});
                }
            };
            if (subName.startsWith(topic.getReplicatorPrefix())) {
                String remoteCluster = PersistentReplicator.getRemoteCluster(subName);
                PersistentReplicator repl = (PersistentReplicator)topic.getPersistentReplicator(remoteCluster);
                if (repl == null) {
                    asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Subscription not found")));
                    return;
                }
                repl.clearBacklog().whenComplete((BiConsumer)biConsumer);
            } else {
                PersistentSubscription sub = topic.getSubscription(subName);
                if (sub == null) {
                    asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Subscription not found")));
                    return;
                }
                sub.clearBacklog().whenComplete((BiConsumer)biConsumer);
            }
        }
        catch (WebApplicationException wae) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Failed to skip all messages for subscription on topic {}, redirecting to other brokers.", new Object[]{this.clientAppId(), this.topicName, wae});
            }
            this.resumeAsyncResponseExceptionally(asyncResponse, wae);
        }
        catch (Exception e) {
            log.error("[{}] Failed to skip all messages for subscription {} on topic {}", new Object[]{this.clientAppId(), subName, this.topicName, e});
            this.resumeAsyncResponseExceptionally(asyncResponse, e);
        }
    }

    protected void internalSkipMessages(String subName, int numMessages, boolean authoritative) {
        if (this.topicName.isGlobal()) {
            this.validateGlobalNamespaceOwnership(this.namespaceName);
        }
        PartitionedTopicMetadata partitionMetadata = this.getPartitionedTopicMetadata(this.topicName, authoritative, false);
        if (partitionMetadata.partitions > 0) {
            throw new RestException(Response.Status.METHOD_NOT_ALLOWED, "Skip messages on a partitioned topic is not allowed");
        }
        this.validateAdminAccessForSubscriber(subName, authoritative);
        PersistentTopic topic = (PersistentTopic)this.getTopicReference(this.topicName);
        try {
            if (subName.startsWith(topic.getReplicatorPrefix())) {
                String remoteCluster = PersistentReplicator.getRemoteCluster(subName);
                PersistentReplicator repl = (PersistentReplicator)topic.getPersistentReplicator(remoteCluster);
                PersistentTopicsBase.checkNotNull(repl);
                repl.skipMessages(numMessages).get();
            } else {
                PersistentSubscription sub = topic.getSubscription(subName);
                PersistentTopicsBase.checkNotNull(sub);
                sub.skipMessages(numMessages).get();
            }
            log.info("[{}] Skipped {} messages on {} {}", new Object[]{this.clientAppId(), numMessages, this.topicName, subName});
        }
        catch (NullPointerException npe) {
            throw new RestException(Response.Status.NOT_FOUND, "Subscription not found");
        }
        catch (Exception exception) {
            log.error("[{}] Failed to skip {} messages {} {}", new Object[]{this.clientAppId(), numMessages, this.topicName, subName, exception});
            throw new RestException(exception);
        }
    }

    protected void internalExpireMessagesForAllSubscriptions(AsyncResponse asyncResponse, int expireTimeInSeconds, boolean authoritative) {
        if (this.topicName.isGlobal()) {
            try {
                this.validateGlobalNamespaceOwnership(this.namespaceName);
            }
            catch (Exception e) {
                log.error("[{}] Failed to expire messages for all subscription on topic {}", new Object[]{this.clientAppId(), this.topicName, e});
                this.resumeAsyncResponseExceptionally(asyncResponse, e);
                return;
            }
        }
        if (this.topicName.isPartitioned()) {
            this.internalExpireMessagesForAllSubscriptionsForNonPartitionedTopic(asyncResponse, expireTimeInSeconds, authoritative);
        } else {
            ((CompletableFuture)this.getPartitionedTopicMetadataAsync(this.topicName, authoritative, false).thenAccept(partitionMetadata -> {
                if (partitionMetadata.partitions > 0) {
                    ArrayList futures = Lists.newArrayList();
                    for (int i = 0; i < partitionMetadata.partitions; ++i) {
                        TopicName topicNamePartition = this.topicName.getPartition(i);
                        try {
                            futures.add(this.pulsar().getAdminClient().topics().expireMessagesForAllSubscriptionsAsync(topicNamePartition.toString(), (long)expireTimeInSeconds));
                            continue;
                        }
                        catch (Exception e) {
                            log.error("[{}] Failed to expire messages up to {} on {}", new Object[]{this.clientAppId(), expireTimeInSeconds, topicNamePartition, e});
                            asyncResponse.resume((Throwable)((Object)new RestException(e)));
                            return;
                        }
                    }
                    FutureUtil.waitForAll((List)futures).handle((result, exception) -> {
                        if (exception != null) {
                            Throwable t = exception.getCause();
                            log.error("[{}] Failed to expire messages up to {} on {}", new Object[]{this.clientAppId(), expireTimeInSeconds, this.topicName, t});
                            asyncResponse.resume((Throwable)((Object)new RestException(t)));
                            return null;
                        }
                        asyncResponse.resume((Object)Response.noContent().build());
                        return null;
                    });
                } else {
                    this.internalExpireMessagesForAllSubscriptionsForNonPartitionedTopic(asyncResponse, expireTimeInSeconds, authoritative);
                }
            })).exceptionally(ex -> {
                log.error("[{}] Failed to expire messages for all subscription on topic {}", new Object[]{this.clientAppId(), this.topicName, ex});
                this.resumeAsyncResponseExceptionally(asyncResponse, (Throwable)ex);
                return null;
            });
        }
    }

    private void internalExpireMessagesForAllSubscriptionsForNonPartitionedTopic(AsyncResponse asyncResponse, int expireTimeInSeconds, boolean authoritative) {
        PersistentTopic topic;
        try {
            this.validateWriteOperationOnTopic(authoritative);
            topic = (PersistentTopic)this.getTopicReference(this.topicName);
        }
        catch (WebApplicationException wae) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Failed to expire messages for all subscription on topic {}, redirecting to other brokers.", new Object[]{this.clientAppId(), this.topicName, wae});
            }
            this.resumeAsyncResponseExceptionally(asyncResponse, wae);
            return;
        }
        catch (Exception e) {
            log.error("[{}] Failed to expire messages for all subscription on topic {}", new Object[]{this.clientAppId(), this.topicName, e});
            this.resumeAsyncResponseExceptionally(asyncResponse, e);
            return;
        }
        AtomicReference exception = new AtomicReference();
        topic.getReplicators().forEach((subName, replicator) -> {
            try {
                this.internalExpireMessagesByTimestampForSinglePartition((String)subName, expireTimeInSeconds, authoritative);
            }
            catch (Throwable t) {
                exception.set(t);
            }
        });
        topic.getSubscriptions().forEach((subName, subscriber) -> {
            try {
                this.internalExpireMessagesByTimestampForSinglePartition((String)subName, expireTimeInSeconds, authoritative);
            }
            catch (Throwable t) {
                exception.set(t);
            }
        });
        if (exception.get() != null) {
            if (exception.get() instanceof WebApplicationException) {
                WebApplicationException wae = (WebApplicationException)((Object)exception.get());
                asyncResponse.resume((Throwable)wae);
                return;
            }
            asyncResponse.resume((Throwable)((Object)new RestException((Throwable)exception.get())));
            return;
        }
        asyncResponse.resume((Object)Response.noContent().build());
    }

    protected void internalResetCursor(AsyncResponse asyncResponse, String subName, long timestamp, boolean authoritative) {
        if (this.topicName.isGlobal()) {
            try {
                this.validateGlobalNamespaceOwnership(this.namespaceName);
            }
            catch (Exception e) {
                log.warn("[{}][{}] Failed to reset cursor on subscription {} to time {}: {}", new Object[]{this.clientAppId(), this.topicName, subName, timestamp, e.getMessage()});
                this.resumeAsyncResponseExceptionally(asyncResponse, e);
                return;
            }
        }
        if (this.topicName.isPartitioned()) {
            this.internalResetCursorForNonPartitionedTopic(asyncResponse, subName, timestamp, authoritative);
        } else {
            ((CompletableFuture)this.getPartitionedTopicMetadataAsync(this.topicName, authoritative, false).thenAccept(partitionMetadata -> {
                int numPartitions = partitionMetadata.partitions;
                if (numPartitions > 0) {
                    CompletableFuture future = new CompletableFuture();
                    AtomicInteger count = new AtomicInteger(numPartitions);
                    AtomicInteger failureCount = new AtomicInteger(0);
                    AtomicReference partitionException = new AtomicReference();
                    for (int i = 0; i < numPartitions; ++i) {
                        TopicName topicNamePartition = this.topicName.getPartition(i);
                        try {
                            this.pulsar().getAdminClient().topics().resetCursorAsync(topicNamePartition.toString(), subName, timestamp).handle((r, ex) -> {
                                if (ex != null) {
                                    if (ex instanceof PulsarAdminException.PreconditionFailedException) {
                                        failureCount.incrementAndGet();
                                        partitionException.set(ex);
                                    } else {
                                        log.warn("[{}] [{}] Failed to reset cursor on subscription {} to time {}", new Object[]{this.clientAppId(), topicNamePartition, subName, timestamp, ex});
                                        future.completeExceptionally((Throwable)ex);
                                        return null;
                                    }
                                }
                                if (count.decrementAndGet() == 0) {
                                    future.complete(null);
                                }
                                return null;
                            });
                            continue;
                        }
                        catch (Exception e) {
                            log.warn("[{}] [{}] Failed to reset cursor on subscription {} to time {}", new Object[]{this.clientAppId(), topicNamePartition, subName, timestamp, e});
                            future.completeExceptionally(e);
                        }
                    }
                    future.whenComplete((r, ex) -> {
                        if (ex != null) {
                            if (ex instanceof PulsarAdminException) {
                                asyncResponse.resume((Throwable)((Object)new RestException((PulsarAdminException)((Object)((Object)ex)))));
                                return;
                            }
                            asyncResponse.resume((Throwable)((Object)new RestException((Throwable)ex)));
                            return;
                        }
                        if (failureCount.get() == numPartitions) {
                            log.warn("[{}] [{}] Failed to reset cursor on subscription {} to time {}", new Object[]{this.clientAppId(), this.topicName, subName, timestamp, partitionException.get()});
                            asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.PRECONDITION_FAILED, ((Throwable)partitionException.get()).getMessage())));
                            return;
                        }
                        if (failureCount.get() > 0) {
                            log.warn("[{}] [{}] Partial errors for reset cursor on subscription {} to time {}", new Object[]{this.clientAppId(), this.topicName, subName, timestamp, partitionException.get()});
                        }
                        asyncResponse.resume((Object)Response.noContent().build());
                    });
                } else {
                    this.internalResetCursorForNonPartitionedTopic(asyncResponse, subName, timestamp, authoritative);
                }
            })).exceptionally(ex -> {
                log.error("[{}] Failed to expire messages for all subscription on topic {}", new Object[]{this.clientAppId(), this.topicName, ex});
                this.resumeAsyncResponseExceptionally(asyncResponse, (Throwable)ex);
                return null;
            });
        }
    }

    private void internalResetCursorForNonPartitionedTopic(AsyncResponse asyncResponse, String subName, long timestamp, boolean authoritative) {
        try {
            this.validateAdminAccessForSubscriber(subName, authoritative);
            log.info("[{}] [{}] Received reset cursor on subscription {} to time {}", new Object[]{this.clientAppId(), this.topicName, subName, timestamp});
            PersistentTopic topic = (PersistentTopic)this.getTopicReference(this.topicName);
            if (topic == null) {
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Topic not found")));
                return;
            }
            PersistentSubscription sub = topic.getSubscription(subName);
            if (sub == null) {
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Subscription not found")));
                return;
            }
            ((CompletableFuture)sub.resetCursor(timestamp).thenRun(() -> {
                log.info("[{}][{}] Reset cursor on subscription {} to time {}", new Object[]{this.clientAppId(), this.topicName, subName, timestamp});
                asyncResponse.resume((Object)Response.noContent().build());
            })).exceptionally(ex -> {
                Throwable t = ex instanceof CompletionException ? ex.getCause() : ex;
                log.warn("[{}][{}] Failed to reset cursor on subscription {} to time {}", new Object[]{this.clientAppId(), this.topicName, subName, timestamp, t});
                if (t instanceof BrokerServiceException.SubscriptionInvalidCursorPosition) {
                    asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.PRECONDITION_FAILED, "Unable to find position for timestamp specified: " + t.getMessage())));
                } else if (t instanceof BrokerServiceException.SubscriptionBusyException) {
                    asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.PRECONDITION_FAILED, "Failed for Subscription Busy: " + t.getMessage())));
                } else {
                    this.resumeAsyncResponseExceptionally(asyncResponse, t);
                }
                return null;
            });
        }
        catch (Exception e) {
            log.warn("[{}][{}] Failed to reset cursor on subscription {} to time {}", new Object[]{this.clientAppId(), this.topicName, subName, timestamp, e});
            if (e instanceof BrokerServiceException.NotAllowedException) {
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.METHOD_NOT_ALLOWED, e.getMessage())));
            }
            this.resumeAsyncResponseExceptionally(asyncResponse, e);
        }
    }

    protected void internalCreateSubscription(AsyncResponse asyncResponse, String subscriptionName, MessageIdImpl messageId, boolean authoritative, boolean replicated) {
        if (this.topicName.isGlobal()) {
            try {
                this.validateGlobalNamespaceOwnership(this.namespaceName);
            }
            catch (Exception e) {
                log.error("[{}] Failed to create subscription {} on topic {}", new Object[]{this.clientAppId(), subscriptionName, this.topicName, e});
                this.resumeAsyncResponseExceptionally(asyncResponse, e);
                return;
            }
        }
        MessageIdImpl targetMessageId = messageId == null ? (MessageIdImpl)MessageId.latest : messageId;
        log.info("[{}][{}] Creating subscription {} at message id {}", new Object[]{this.clientAppId(), this.topicName, subscriptionName, targetMessageId});
        if (this.topicName.isPartitioned()) {
            this.internalCreateSubscriptionForNonPartitionedTopic(asyncResponse, subscriptionName, targetMessageId, authoritative, replicated);
        } else {
            boolean allowAutoTopicCreation = this.pulsar().getConfiguration().isAllowAutoTopicCreation();
            ((CompletableFuture)this.getPartitionedTopicMetadataAsync(this.topicName, authoritative, allowAutoTopicCreation).thenAccept(partitionMetadata -> {
                int numPartitions = partitionMetadata.partitions;
                if (numPartitions > 0) {
                    CompletableFuture future = new CompletableFuture();
                    AtomicInteger count = new AtomicInteger(numPartitions);
                    AtomicInteger failureCount = new AtomicInteger(0);
                    AtomicReference partitionException = new AtomicReference();
                    for (int i = 0; i < numPartitions; ++i) {
                        TopicName topicNamePartition = this.topicName.getPartition(i);
                        try {
                            this.pulsar().getAdminClient().topics().createSubscriptionAsync(topicNamePartition.toString(), subscriptionName, (MessageId)targetMessageId).handle((r, ex) -> {
                                if (!(ex == null || failureCount.incrementAndGet() != numPartitions && ex instanceof PulsarAdminException.ConflictException)) {
                                    partitionException.set(ex);
                                }
                                if (count.decrementAndGet() == 0) {
                                    future.complete(null);
                                }
                                return null;
                            });
                            continue;
                        }
                        catch (Exception e) {
                            log.warn("[{}] [{}] Failed to create subscription {} at message id {}", new Object[]{this.clientAppId(), topicNamePartition, subscriptionName, targetMessageId, e});
                            future.completeExceptionally(e);
                        }
                    }
                    future.whenComplete((r, ex) -> {
                        if (ex != null) {
                            if (ex instanceof PulsarAdminException) {
                                asyncResponse.resume((Throwable)((Object)new RestException((PulsarAdminException)((Object)((Object)ex)))));
                                return;
                            }
                            asyncResponse.resume((Throwable)((Object)new RestException((Throwable)ex)));
                            return;
                        }
                        if (partitionException.get() != null) {
                            log.warn("[{}] [{}] Failed to create subscription {} at message id {}", new Object[]{this.clientAppId(), this.topicName, subscriptionName, targetMessageId, partitionException.get()});
                            if (partitionException.get() instanceof PulsarAdminException) {
                                asyncResponse.resume((Throwable)((Object)new RestException((PulsarAdminException)((Object)((Object)((Object)partitionException.get()))))));
                                return;
                            }
                            asyncResponse.resume((Throwable)((Object)new RestException((Throwable)partitionException.get())));
                            return;
                        }
                        asyncResponse.resume((Object)Response.noContent().build());
                    });
                } else {
                    this.internalCreateSubscriptionForNonPartitionedTopic(asyncResponse, subscriptionName, targetMessageId, authoritative, replicated);
                }
            })).exceptionally(ex -> {
                log.error("[{}] Failed to create subscription {} on topic {}", new Object[]{this.clientAppId(), subscriptionName, this.topicName, ex});
                this.resumeAsyncResponseExceptionally(asyncResponse, (Throwable)ex);
                return null;
            });
        }
    }

    private void internalCreateSubscriptionForNonPartitionedTopic(AsyncResponse asyncResponse, String subscriptionName, MessageIdImpl targetMessageId, boolean authoritative, boolean replicated) {
        try {
            this.validateAdminAccessForSubscriber(subscriptionName, authoritative);
            boolean isAllowAutoTopicCreation = this.pulsar().getConfiguration().isAllowAutoTopicCreation();
            PersistentTopic topic = (PersistentTopic)((CompletableFuture)this.pulsar().getBrokerService().getTopic(this.topicName.toString(), isAllowAutoTopicCreation).thenApply(Optional::get)).join();
            if (topic.getSubscriptions().containsKey((Object)subscriptionName)) {
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.CONFLICT, "Subscription already exists for topic")));
                return;
            }
            PersistentSubscription subscription = (PersistentSubscription)topic.createSubscription(subscriptionName, PulsarApi.CommandSubscribe.InitialPosition.Latest, replicated).get();
            subscription.deactivateCursor();
            ((CompletableFuture)subscription.resetCursor((Position)PositionImpl.get((long)targetMessageId.getLedgerId(), (long)targetMessageId.getEntryId())).thenRun(() -> {
                log.info("[{}][{}] Successfully created subscription {} at message id {}", new Object[]{this.clientAppId(), this.topicName, subscriptionName, targetMessageId});
                asyncResponse.resume((Object)Response.noContent().build());
            })).exceptionally(ex -> {
                Throwable t = ex instanceof CompletionException ? ex.getCause() : ex;
                log.warn("[{}][{}] Failed to create subscription {} at message id {}", new Object[]{this.clientAppId(), this.topicName, subscriptionName, targetMessageId, t});
                if (t instanceof BrokerServiceException.SubscriptionInvalidCursorPosition) {
                    asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.PRECONDITION_FAILED, "Unable to find position for position specified: " + t.getMessage())));
                } else if (t instanceof BrokerServiceException.SubscriptionBusyException) {
                    asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.PRECONDITION_FAILED, "Failed for Subscription Busy: " + t.getMessage())));
                } else {
                    this.resumeAsyncResponseExceptionally(asyncResponse, t);
                }
                return null;
            });
        }
        catch (Throwable e) {
            log.warn("[{}][{}] Failed to create subscription {} at message id {}", new Object[]{this.clientAppId(), this.topicName, subscriptionName, targetMessageId, e});
            this.resumeAsyncResponseExceptionally(asyncResponse, e);
        }
    }

    protected void internalResetCursorOnPosition(AsyncResponse asyncResponse, String subName, boolean authoritative, MessageIdImpl messageId, boolean isExcluded, int batchIndex) {
        if (this.topicName.isGlobal()) {
            try {
                this.validateGlobalNamespaceOwnership(this.namespaceName);
            }
            catch (Exception e2) {
                log.warn("[{}][{}] Failed to reset cursor on subscription {} to position {}: {}", new Object[]{this.clientAppId(), this.topicName, subName, messageId, e2.getMessage()});
                this.resumeAsyncResponseExceptionally(asyncResponse, e2);
                return;
            }
        }
        log.info("[{}][{}] received reset cursor on subscription {} to position {}", new Object[]{this.clientAppId(), this.topicName, subName, messageId});
        if (!this.topicName.isPartitioned() && this.getPartitionedTopicMetadata((TopicName)this.topicName, (boolean)authoritative, (boolean)false).partitions > 0) {
            log.warn("[{}] Not supported operation on partitioned-topic {} {}", new Object[]{this.clientAppId(), this.topicName, subName});
            asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.METHOD_NOT_ALLOWED, "Reset-cursor at position is not allowed for partitioned-topic")));
            return;
        }
        this.validateAdminAccessForSubscriber(subName, authoritative);
        this.validateReadOperationOnTopic(authoritative);
        PersistentTopic topic = (PersistentTopic)this.getTopicReference(this.topicName);
        if (topic == null) {
            asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Topic not found")));
            return;
        }
        try {
            PersistentSubscription sub = topic.getSubscription(subName);
            if (sub == null) {
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Subscription not found")));
                return;
            }
            CompletableFuture<Integer> batchSizeFuture = new CompletableFuture<Integer>();
            this.getEntryBatchSize(batchSizeFuture, topic, messageId, batchIndex);
            ((CompletableFuture)batchSizeFuture.thenAccept(bi -> {
                PositionImpl seekPosition = this.calculatePositionAckSet(isExcluded, (int)bi, batchIndex, messageId);
                ((CompletableFuture)sub.resetCursor((Position)seekPosition).thenRun(() -> {
                    log.info("[{}][{}] successfully reset cursor on subscription {} to position {}", new Object[]{this.clientAppId(), this.topicName, subName, messageId});
                    asyncResponse.resume((Object)Response.noContent().build());
                })).exceptionally(ex -> {
                    Throwable t = ex instanceof CompletionException ? ex.getCause() : ex;
                    log.warn("[{}][{}] Failed to reset cursor on subscription {} to position {}", new Object[]{this.clientAppId(), this.topicName, subName, messageId, t});
                    if (t instanceof BrokerServiceException.SubscriptionInvalidCursorPosition) {
                        asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.PRECONDITION_FAILED, "Unable to find position for position specified: " + t.getMessage())));
                    } else if (t instanceof BrokerServiceException.SubscriptionBusyException) {
                        asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.PRECONDITION_FAILED, "Failed for Subscription Busy: " + t.getMessage())));
                    } else {
                        this.resumeAsyncResponseExceptionally(asyncResponse, t);
                    }
                    return null;
                });
            })).exceptionally(e -> {
                asyncResponse.resume(e);
                return null;
            });
        }
        catch (Exception e3) {
            log.warn("[{}][{}] Failed to reset cursor on subscription {} to position {}", new Object[]{this.clientAppId(), this.topicName, subName, messageId, e3});
            this.resumeAsyncResponseExceptionally(asyncResponse, e3);
        }
    }

    private void getEntryBatchSize(final CompletableFuture<Integer> batchSizeFuture, PersistentTopic topic, MessageIdImpl messageId, int batchIndex) {
        if (batchIndex >= 0) {
            try {
                ManagedLedgerImpl ledger = (ManagedLedgerImpl)topic.getManagedLedger();
                ledger.asyncReadEntry(new PositionImpl(messageId.getLedgerId(), messageId.getEntryId()), new AsyncCallbacks.ReadEntryCallback(){

                    public void readEntryFailed(ManagedLedgerException exception, Object ctx) {
                        batchSizeFuture.complete(0);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void readEntryComplete(Entry entry, Object ctx) {
                        block7: {
                            try {
                                try {
                                    if (entry == null) {
                                        batchSizeFuture.complete(0);
                                        break block7;
                                    }
                                    PulsarApi.MessageMetadata metadata = Commands.parseMessageMetadata((ByteBuf)entry.getDataBuffer());
                                    batchSizeFuture.complete(metadata.getNumMessagesInBatch());
                                }
                                catch (Exception e) {
                                    batchSizeFuture.completeExceptionally((Throwable)((Object)new RestException(e)));
                                }
                            }
                            finally {
                                if (entry != null) {
                                    entry.release();
                                }
                            }
                        }
                    }
                }, null);
            }
            catch (NullPointerException npe) {
                batchSizeFuture.completeExceptionally((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Message not found")));
            }
            catch (Exception exception) {
                log.error("[{}] Failed to get message with ledgerId {} entryId {} from {}", new Object[]{this.clientAppId(), messageId.getLedgerId(), messageId.getEntryId(), this.topicName, exception});
                batchSizeFuture.completeExceptionally((Throwable)((Object)new RestException(exception)));
            }
        } else {
            batchSizeFuture.complete(0);
        }
    }

    private PositionImpl calculatePositionAckSet(boolean isExcluded, int batchSize, int batchIndex, MessageIdImpl messageId) {
        PositionImpl seekPosition;
        if (batchSize > 0) {
            BitSetRecyclable bitSet = BitSetRecyclable.create();
            bitSet.set(0, batchSize);
            if (isExcluded) {
                bitSet.clear(0, Math.max(batchIndex + 1, 0));
                if (bitSet.length() > 0) {
                    long[] ackSet = bitSet.toLongArray();
                    seekPosition = PositionImpl.get((long)messageId.getLedgerId(), (long)messageId.getEntryId(), (long[])ackSet);
                } else {
                    seekPosition = PositionImpl.get((long)messageId.getLedgerId(), (long)messageId.getEntryId());
                    seekPosition = seekPosition.getNext();
                }
            } else if (batchIndex - 1 >= 0) {
                bitSet.clear(0, batchIndex);
                long[] ackSet = bitSet.toLongArray();
                seekPosition = PositionImpl.get((long)messageId.getLedgerId(), (long)messageId.getEntryId(), (long[])ackSet);
            } else {
                seekPosition = PositionImpl.get((long)messageId.getLedgerId(), (long)messageId.getEntryId());
            }
            bitSet.recycle();
        } else {
            seekPosition = PositionImpl.get((long)messageId.getLedgerId(), (long)messageId.getEntryId());
            seekPosition = isExcluded ? seekPosition.getNext() : seekPosition;
        }
        return seekPosition;
    }

    protected void internalGetMessageById(final AsyncResponse asyncResponse, long ledgerId, long entryId, boolean authoritative) {
        try {
            this.validateReadOperationOnTopic(authoritative);
            PersistentTopic topic = (PersistentTopic)this.getTopicReference(this.topicName);
            ManagedLedgerImpl ledger = (ManagedLedgerImpl)topic.getManagedLedger();
            ledger.asyncReadEntry(new PositionImpl(ledgerId, entryId), new AsyncCallbacks.ReadEntryCallback(){

                public void readEntryFailed(ManagedLedgerException exception, Object ctx) {
                    asyncResponse.resume((Throwable)((Object)new RestException((Throwable)exception)));
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void readEntryComplete(Entry entry, Object ctx) {
                    try {
                        asyncResponse.resume((Object)PersistentTopicsBase.this.generateResponseWithEntry(entry));
                    }
                    catch (IOException exception) {
                        asyncResponse.resume((Throwable)((Object)new RestException(exception)));
                    }
                    finally {
                        if (entry != null) {
                            entry.release();
                        }
                    }
                }
            }, null);
        }
        catch (NullPointerException npe) {
            asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Message not found")));
        }
        catch (Exception exception) {
            log.error("[{}] Failed to get message with ledgerId {} entryId {} from {}", new Object[]{this.clientAppId(), ledgerId, entryId, this.topicName, exception});
            asyncResponse.resume((Throwable)((Object)new RestException(exception)));
        }
    }

    protected Response internalPeekNthMessage(String subName, int messagePosition, boolean authoritative) {
        this.verifyReadOperation(authoritative);
        if (!this.topicName.isPartitioned() && this.getPartitionedTopicMetadata((TopicName)this.topicName, (boolean)authoritative, (boolean)false).partitions > 0) {
            throw new RestException(Response.Status.METHOD_NOT_ALLOWED, "Peek messages on a partitioned topic is not allowed");
        }
        this.validateAdminAccessForSubscriber(subName, authoritative);
        if (!(this.getTopicReference(this.topicName) instanceof PersistentTopic)) {
            log.error("[{}] Not supported operation of non-persistent topic {} {}", new Object[]{this.clientAppId(), this.topicName, subName});
            throw new RestException(Response.Status.METHOD_NOT_ALLOWED, "Peek messages on a non-persistent topic is not allowed");
        }
        PersistentTopic topic = (PersistentTopic)this.getTopicReference(this.topicName);
        PersistentReplicator repl = null;
        PersistentSubscription sub = null;
        Entry entry = null;
        if (subName.startsWith(topic.getReplicatorPrefix())) {
            repl = this.getReplicatorReference(subName, topic);
        } else {
            sub = (PersistentSubscription)this.getSubscriptionReference(subName, topic);
        }
        try {
            entry = subName.startsWith(topic.getReplicatorPrefix()) ? repl.peekNthMessage(messagePosition).get() : sub.peekNthMessage(messagePosition).get();
            Response response = this.generateResponseWithEntry(entry);
            return response;
        }
        catch (NullPointerException npe) {
            throw new RestException(Response.Status.NOT_FOUND, "Message not found");
        }
        catch (Exception exception) {
            log.error("[{}] Failed to peek message at position {} from {} {}", new Object[]{this.clientAppId(), messagePosition, this.topicName, subName, exception});
            throw new RestException(exception);
        }
        finally {
            if (entry != null) {
                entry.release();
            }
        }
    }

    protected Response internalExamineMessage(String initialPosition, long messagePosition, boolean authoritative) {
        if (this.topicName.isGlobal()) {
            this.validateGlobalNamespaceOwnership(this.namespaceName);
        }
        if (!this.topicName.isPartitioned() && this.getPartitionedTopicMetadata((TopicName)this.topicName, (boolean)authoritative, (boolean)false).partitions > 0) {
            throw new RestException(Response.Status.METHOD_NOT_ALLOWED, "Examine messages on a partitioned topic is not allowed, please try examine message on specific topic partition");
        }
        this.validateTopicOwnership(this.topicName, authoritative);
        if (!(this.getTopicReference(this.topicName) instanceof PersistentTopic)) {
            log.error("[{}] Not supported operation of non-persistent topic {} ", (Object)this.clientAppId(), (Object)this.topicName);
            throw new RestException(Response.Status.METHOD_NOT_ALLOWED, "Examine messages on a non-persistent topic is not allowed");
        }
        if (messagePosition < 1L) {
            messagePosition = 1L;
        }
        if (null == initialPosition) {
            initialPosition = "latest";
        }
        try {
            PersistentTopic topic = (PersistentTopic)this.getTopicReference(this.topicName);
            long totalMessage = topic.getNumberOfEntries();
            PositionImpl startPosition = topic.getFirstPosition();
            long messageToSkip = initialPosition.equals("earliest") ? messagePosition : totalMessage - messagePosition + 1L;
            final CompletableFuture future = new CompletableFuture();
            PositionImpl readPosition = topic.getPositionAfterN(startPosition, messageToSkip);
            topic.asyncReadEntry(readPosition, new AsyncCallbacks.ReadEntryCallback(){

                public void readEntryComplete(Entry entry, Object ctx) {
                    future.complete(entry);
                }

                public void readEntryFailed(ManagedLedgerException exception, Object ctx) {
                    future.completeExceptionally((Throwable)exception);
                }
            }, null);
            return this.generateResponseWithEntry((Entry)future.get());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            log.error("[{}] Failed to examine message at position {} from {} due to {}", new Object[]{this.clientAppId(), messagePosition, this.topicName, exception});
            throw new RestException(exception);
        }
    }

    private void verifyReadOperation(boolean authoritative) {
        if (this.topicName.isGlobal()) {
            this.validateGlobalNamespaceOwnership(this.namespaceName);
        }
        PartitionedTopicMetadata partitionMetadata = this.getPartitionedTopicMetadata(this.topicName, authoritative, false);
        if (partitionMetadata.partitions > 0) {
            throw new RestException(Response.Status.METHOD_NOT_ALLOWED, "Peek messages on a partitioned topic is not allowed");
        }
    }

    private Response generateResponseWithEntry(Entry entry) throws IOException {
        PersistentTopicsBase.checkNotNull(entry);
        PositionImpl pos = (PositionImpl)entry.getPosition();
        ByteBuf metadataAndPayload = entry.getDataBuffer();
        PulsarApi.MessageMetadata metadata = Commands.parseMessageMetadata((ByteBuf)metadataAndPayload);
        Response.ResponseBuilder responseBuilder = Response.ok();
        responseBuilder.header("X-Pulsar-Message-ID", (Object)pos.toString());
        for (PulsarApi.KeyValue keyValue : metadata.getPropertiesList()) {
            responseBuilder.header("X-Pulsar-PROPERTY-" + keyValue.getKey(), (Object)keyValue.getValue());
        }
        if (metadata.hasPublishTime()) {
            responseBuilder.header("X-Pulsar-publish-time", (Object)DateFormatter.format((long)metadata.getPublishTime()));
        }
        if (metadata.hasEventTime()) {
            responseBuilder.header("X-Pulsar-event-time", (Object)DateFormatter.format((long)metadata.getEventTime()));
        }
        if (metadata.hasNumMessagesInBatch()) {
            responseBuilder.header("X-Pulsar-num-batch-message", (Object)metadata.getNumMessagesInBatch());
            responseBuilder.header("X-Pulsar-batch-size", (Object)(metadataAndPayload.readableBytes() - metadata.getSerializedSize()));
        }
        if (metadata.hasNullValue()) {
            responseBuilder.header("X-Pulsar-null-value", (Object)metadata.hasNullValue());
        }
        if (metadata.getNumChunksFromMsg() > 0) {
            responseBuilder.header("X-Pulsar-PROPERTY-TOTAL-CHUNKS", (Object)Integer.toString(metadata.getNumChunksFromMsg()));
            responseBuilder.header("X-Pulsar-PROPERTY-CHUNK-ID", (Object)Integer.toString(metadata.getChunkId()));
        }
        CompressionCodec codec = CompressionCodecProvider.getCompressionCodec((PulsarApi.CompressionType)metadata.getCompression());
        ByteBuf uncompressedPayload = codec.decode(metadataAndPayload, metadata.getUncompressedSize());
        ByteBuf data = PulsarByteBufAllocator.DEFAULT.heapBuffer(uncompressedPayload.readableBytes(), uncompressedPayload.readableBytes());
        data.writeBytes(uncompressedPayload);
        uncompressedPayload.release();
        StreamingOutput stream = output -> {
            output.write(data.array(), data.arrayOffset(), data.readableBytes());
            data.release();
        };
        return responseBuilder.entity((Object)stream).build();
    }

    protected PersistentOfflineTopicStats internalGetBacklog(boolean authoritative) {
        if (this.topicName.isGlobal()) {
            this.validateGlobalNamespaceOwnership(this.namespaceName);
        }
        try {
            this.policiesCache().get(PersistentTopicsBase.path("policies", this.namespaceName.toString()));
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to get topic backlog {}: Namespace does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (Exception e) {
            log.error("[{}] Failed to get topic backlog {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
        PersistentOfflineTopicStats offlineTopicStats = null;
        try {
            long elapsedMs;
            offlineTopicStats = this.pulsar().getBrokerService().getOfflineTopicStat(this.topicName);
            if (offlineTopicStats != null && TimeUnit.MINUTES.convert(elapsedMs = System.currentTimeMillis() - offlineTopicStats.statGeneratedAt.getTime(), TimeUnit.MILLISECONDS) < 10L) {
                return offlineTopicStats;
            }
            ManagedLedgerConfig config = this.pulsar().getBrokerService().getManagedLedgerConfig(this.topicName).get();
            ManagedLedgerOfflineBacklog offlineTopicBacklog = new ManagedLedgerOfflineBacklog(config.getDigestType(), config.getPassword(), this.pulsar().getAdvertisedAddress(), false);
            offlineTopicStats = offlineTopicBacklog.estimateUnloadedTopicBacklog((ManagedLedgerFactoryImpl)this.pulsar().getManagedLedgerFactory(), this.topicName);
            this.pulsar().getBrokerService().cacheOfflineTopicStats(this.topicName, offlineTopicStats);
        }
        catch (Exception exception) {
            throw new RestException(exception);
        }
        return offlineTopicStats;
    }

    protected CompletableFuture<Void> internalSetBacklogQuota(BacklogQuota.BacklogQuotaType backlogQuotaType, BacklogQuota backlogQuota) {
        this.validatePoliciesReadOnlyAccess();
        BacklogQuota.BacklogQuotaType finalBacklogQuotaType = backlogQuotaType == null ? BacklogQuota.BacklogQuotaType.destination_storage : backlogQuotaType;
        return this.getTopicPoliciesAsyncWithRetry(this.topicName).thenCompose(op -> {
            TopicPolicies topicPolicies = op.orElseGet(TopicPolicies::new);
            RetentionPolicies retentionPolicies = this.getRetentionPolicies(this.topicName, topicPolicies);
            if (!this.checkBacklogQuota(backlogQuota, retentionPolicies)) {
                log.warn("[{}] Failed to update backlog configuration for topic {}: conflicts with retention quota", (Object)this.clientAppId(), (Object)this.topicName);
                return FutureUtil.failedFuture((Throwable)((Object)new RestException(Response.Status.PRECONDITION_FAILED, "Backlog Quota exceeds configured retention quota for topic. Please increase retention quota and retry")));
            }
            if (backlogQuota != null) {
                topicPolicies.getBackLogQuotaMap().put(finalBacklogQuotaType.name(), backlogQuota);
            } else {
                topicPolicies.getBackLogQuotaMap().remove(finalBacklogQuotaType.name());
            }
            Map backLogQuotaMap = topicPolicies.getBackLogQuotaMap();
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, topicPolicies).thenRun(() -> {
                try {
                    log.info("[{}] Successfully updated backlog quota map: namespace={}, topic={}, map={}", new Object[]{this.clientAppId(), this.namespaceName, this.topicName.getLocalName(), PersistentTopicsBase.jsonMapper().writeValueAsString((Object)backLogQuotaMap)});
                }
                catch (JsonProcessingException jsonProcessingException) {
                    // empty catch block
                }
            });
        });
    }

    protected CompletableFuture<Void> internalSetDeduplicationEnabled(Boolean enabled) {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName).thenCompose(op -> {
            TopicPolicies topicPolicies = op.orElseGet(TopicPolicies::new);
            topicPolicies.setDeduplicationEnabled(enabled);
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, topicPolicies);
        });
    }

    protected CompletableFuture<Void> internalSetMessageTTL(Integer ttlInSecond) {
        if (ttlInSecond != null && ttlInSecond < 0) {
            return FutureUtil.failedFuture((Throwable)((Object)new RestException(Response.Status.PRECONDITION_FAILED, "Invalid value for message TTL")));
        }
        return this.getTopicPoliciesAsyncWithRetry(this.topicName).thenCompose(op -> {
            TopicPolicies topicPolicies = op.orElseGet(TopicPolicies::new);
            topicPolicies.setMessageTTLInSeconds(ttlInSecond);
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, topicPolicies).thenRun(() -> log.info("[{}] Successfully set topic message ttl: namespace={}, topic={}, ttl={}", new Object[]{this.clientAppId(), this.namespaceName, this.topicName.getLocalName(), ttlInSecond}));
        });
    }

    private RetentionPolicies getRetentionPolicies(TopicName topicName, TopicPolicies topicPolicies) {
        RetentionPolicies retentionPolicies = topicPolicies.getRetentionPolicies();
        if (retentionPolicies == null) {
            try {
                retentionPolicies = (RetentionPolicies)((CompletableFuture)this.getNamespacePoliciesAsync(topicName.getNamespaceObject()).thenApply(policies -> policies.retention_policies)).get(1L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                throw new RestException(e);
            }
        }
        return retentionPolicies;
    }

    protected CompletableFuture<RetentionPolicies> internalGetRetention() {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName).thenApply(op -> op.map(TopicPolicies::getRetentionPolicies).orElseGet(RetentionPolicies::new));
    }

    protected CompletableFuture<Void> internalSetRetention(RetentionPolicies retention) {
        if (retention == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this.getTopicPoliciesAsyncWithRetry(this.topicName).thenCompose(op -> {
            TopicPolicies topicPolicies = op.orElseGet(TopicPolicies::new);
            BacklogQuota backlogQuota = (BacklogQuota)topicPolicies.getBackLogQuotaMap().get(BacklogQuota.BacklogQuotaType.destination_storage.name());
            if (backlogQuota == null) {
                Policies policies = this.getNamespacePolicies(this.topicName.getNamespaceObject());
                backlogQuota = (BacklogQuota)policies.backlog_quota_map.get(BacklogQuota.BacklogQuotaType.destination_storage);
            }
            if (!this.checkBacklogQuota(backlogQuota, retention)) {
                log.warn("[{}] Failed to update retention quota configuration for topic {}: conflicts with retention quota", (Object)this.clientAppId(), (Object)this.topicName);
                throw new RestException(Response.Status.PRECONDITION_FAILED, "Retention Quota must exceed configured backlog quota for topic. Please increase retention quota and retry");
            }
            topicPolicies.setRetentionPolicies(retention);
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, topicPolicies);
        });
    }

    protected CompletableFuture<Void> internalRemoveRetention() {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName).thenCompose(op -> {
            if (!op.isPresent()) {
                return CompletableFuture.completedFuture(null);
            }
            ((TopicPolicies)op.get()).setRetentionPolicies(null);
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, (TopicPolicies)op.get());
        });
    }

    protected CompletableFuture<Optional<PersistencePolicies>> internalGetPersistence() {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName).thenApply(op -> op.map(TopicPolicies::getPersistence));
    }

    protected CompletableFuture<Void> internalSetPersistence(PersistencePolicies persistencePolicies) {
        this.validatePersistencePolicies(persistencePolicies);
        return this.getTopicPoliciesAsyncWithRetry(this.topicName).thenCompose(op -> {
            TopicPolicies topicPolicies = op.orElseGet(TopicPolicies::new);
            topicPolicies.setPersistence(persistencePolicies);
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, topicPolicies);
        });
    }

    protected CompletableFuture<Void> internalRemovePersistence() {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName).thenCompose(op -> {
            if (!op.isPresent()) {
                return CompletableFuture.completedFuture(null);
            }
            ((TopicPolicies)op.get()).setPersistence(null);
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, (TopicPolicies)op.get());
        });
    }

    protected CompletableFuture<Void> internalSetMaxMessageSize(Integer maxMessageSize) {
        if (maxMessageSize != null && (maxMessageSize < 0 || maxMessageSize > this.config().getMaxMessageSize())) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "topic-level maxMessageSize must be greater than or equal to 0 and must be smaller than that in the broker-level");
        }
        return this.getTopicPoliciesAsyncWithRetry(this.topicName).thenCompose(op -> {
            TopicPolicies topicPolicies = op.orElseGet(TopicPolicies::new);
            topicPolicies.setMaxMessageSize(maxMessageSize);
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, topicPolicies);
        });
    }

    protected CompletableFuture<Optional<Integer>> internalGetMaxMessageSize() {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName).thenApply(op -> op.map(TopicPolicies::getMaxMessageSize));
    }

    protected CompletableFuture<Optional<Integer>> internalGetMaxProducers() {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName).thenApply(op -> op.map(TopicPolicies::getMaxProducerPerTopic));
    }

    protected CompletableFuture<Void> internalSetMaxProducers(Integer maxProducers) {
        if (maxProducers != null && maxProducers < 0) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "maxProducers must be 0 or more");
        }
        return this.getTopicPoliciesAsyncWithRetry(this.topicName).thenCompose(op -> {
            TopicPolicies topicPolicies = op.orElseGet(TopicPolicies::new);
            topicPolicies.setMaxProducerPerTopic(maxProducers);
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, topicPolicies);
        });
    }

    protected CompletableFuture<Optional<Integer>> internalGetMaxSubscriptionsPerTopic() {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName).thenApply(op -> op.map(TopicPolicies::getMaxSubscriptionsPerTopic));
    }

    protected CompletableFuture<Void> internalSetMaxSubscriptionsPerTopic(Integer maxSubscriptionsPerTopic) {
        if (maxSubscriptionsPerTopic != null && maxSubscriptionsPerTopic < 0) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "maxSubscriptionsPerTopic must be 0 or more");
        }
        return this.getTopicPoliciesAsyncWithRetry(this.topicName).thenCompose(op -> {
            TopicPolicies topicPolicies = op.orElseGet(TopicPolicies::new);
            topicPolicies.setMaxSubscriptionsPerTopic(maxSubscriptionsPerTopic);
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, topicPolicies);
        });
    }

    protected CompletableFuture<Void> preValidation(boolean authoritative) {
        this.checkTopicLevelPolicyEnable();
        if (this.topicName.isPartitioned()) {
            return FutureUtil.failedFuture((Throwable)((Object)new RestException(Response.Status.PRECONDITION_FAILED, "Not allowed to set/get topic policy for a partition")));
        }
        if (this.topicName.isGlobal()) {
            this.validateGlobalNamespaceOwnership(this.namespaceName);
        }
        return this.checkTopicExistsAsync(this.topicName).thenCompose(exist -> {
            if (!exist.booleanValue()) {
                throw new RestException(Response.Status.NOT_FOUND, "Topic not found");
            }
            return this.getPartitionedTopicMetadataAsync(this.topicName, false, false).thenCompose(metadata -> {
                if (metadata.partitions > 0) {
                    return this.validateTopicOwnershipAsync(TopicName.get((String)(this.topicName.toString() + "-partition-" + 0)), authoritative);
                }
                return this.validateTopicOwnershipAsync(this.topicName, authoritative);
            });
        });
    }

    protected CompletableFuture<Void> internalRemoveMaxProducers() {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName).thenCompose(op -> {
            if (!op.isPresent()) {
                return CompletableFuture.completedFuture(null);
            }
            ((TopicPolicies)op.get()).setMaxProducerPerTopic(null);
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, (TopicPolicies)op.get());
        });
    }

    protected CompletableFuture<Optional<Integer>> internalGetMaxConsumers() {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName).thenApply(op -> op.map(TopicPolicies::getMaxConsumerPerTopic));
    }

    protected CompletableFuture<Void> internalSetMaxConsumers(Integer maxConsumers) {
        if (maxConsumers != null && maxConsumers < 0) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "maxConsumers must be 0 or more");
        }
        return this.getTopicPoliciesAsyncWithRetry(this.topicName).thenCompose(op -> {
            TopicPolicies topicPolicies = op.orElseGet(TopicPolicies::new);
            topicPolicies.setMaxConsumerPerTopic(maxConsumers);
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, topicPolicies);
        });
    }

    protected CompletableFuture<Void> internalRemoveMaxConsumers() {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName).thenCompose(op -> {
            if (!op.isPresent()) {
                return CompletableFuture.completedFuture(null);
            }
            ((TopicPolicies)op.get()).setMaxConsumerPerTopic(null);
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, (TopicPolicies)op.get());
        });
    }

    protected MessageId internalTerminate(boolean authoritative) {
        if (this.topicName.isGlobal()) {
            this.validateGlobalNamespaceOwnership(this.namespaceName);
        }
        PartitionedTopicMetadata partitionMetadata = this.getPartitionedTopicMetadata(this.topicName, authoritative, false);
        if (partitionMetadata.partitions > 0) {
            throw new RestException(Response.Status.METHOD_NOT_ALLOWED, "Termination of a partitioned topic is not allowed");
        }
        this.validateWriteOperationOnTopic(authoritative);
        Topic topic = this.getTopicReference(this.topicName);
        try {
            return ((PersistentTopic)topic).terminate().get();
        }
        catch (Exception exception) {
            log.error("[{}] Failed to terminated topic {}", new Object[]{this.clientAppId(), this.topicName, exception});
            throw new RestException(exception);
        }
    }

    protected void internalTerminatePartitionedTopic(AsyncResponse asyncResponse, boolean authoritative) {
        if (this.topicName.isGlobal()) {
            this.validateGlobalNamespaceOwnership(this.namespaceName);
        }
        this.validateAdminOperationOnTopic(authoritative);
        ArrayList messageIds = new ArrayList();
        PartitionedTopicMetadata partitionMetadata = this.getPartitionedTopicMetadata(this.topicName, authoritative, false);
        if (partitionMetadata.partitions > 0) {
            ArrayList futures = Lists.newArrayList();
            for (int i = 0; i < partitionMetadata.partitions; ++i) {
                TopicName topicNamePartition = this.topicName.getPartition(i);
                try {
                    futures.add(this.pulsar().getAdminClient().topics().terminateTopicAsync(topicNamePartition.toString()).whenComplete((messageId, throwable) -> {
                        if (throwable != null) {
                            log.error("[{}] Failed to terminate topic {}", new Object[]{this.clientAppId(), topicNamePartition, throwable});
                            asyncResponse.resume((Throwable)((Object)new RestException((Throwable)throwable)));
                        }
                        messageIds.add(messageId);
                    }));
                    continue;
                }
                catch (Exception e) {
                    log.error("[{}] Failed to terminate topic {}", new Object[]{this.clientAppId(), topicNamePartition, e});
                    throw new RestException(e);
                }
            }
            FutureUtil.waitForAll((List)futures).handle((result, exception) -> {
                if (exception != null) {
                    Throwable t = exception.getCause();
                    if (t instanceof PulsarAdminException.NotFoundException) {
                        asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Topic not found")));
                    } else {
                        log.error("[{}] Failed to terminate topic {}", new Object[]{this.clientAppId(), this.topicName, t});
                        asyncResponse.resume((Throwable)((Object)new RestException(t)));
                    }
                }
                asyncResponse.resume((Object)messageIds);
                return null;
            });
        }
    }

    protected void internalExpireMessagesByTimestamp(AsyncResponse asyncResponse, String subName, int expireTimeInSeconds, boolean authoritative) {
        if (this.topicName.isGlobal()) {
            this.validateGlobalNamespaceOwnership(this.namespaceName);
        }
        if (this.topicName.isPartitioned()) {
            try {
                this.internalExpireMessagesByTimestampForSinglePartition(subName, expireTimeInSeconds, authoritative);
            }
            catch (WebApplicationException wae) {
                asyncResponse.resume((Throwable)wae);
                return;
            }
            catch (Exception e) {
                asyncResponse.resume((Throwable)((Object)new RestException(e)));
                return;
            }
            asyncResponse.resume((Object)Response.noContent().build());
        } else {
            PartitionedTopicMetadata partitionMetadata = this.getPartitionedTopicMetadata(this.topicName, authoritative, false);
            if (partitionMetadata.partitions > 0) {
                ArrayList futures = Lists.newArrayList();
                for (int i = 0; i < partitionMetadata.partitions; ++i) {
                    TopicName topicNamePartition = this.topicName.getPartition(i);
                    try {
                        futures.add(this.pulsar().getAdminClient().topics().expireMessagesAsync(topicNamePartition.toString(), subName, (long)expireTimeInSeconds));
                        continue;
                    }
                    catch (Exception e) {
                        log.error("[{}] Failed to expire messages up to {} on {}", new Object[]{this.clientAppId(), expireTimeInSeconds, topicNamePartition, e});
                        asyncResponse.resume((Throwable)((Object)new RestException(e)));
                        return;
                    }
                }
                FutureUtil.waitForAll((List)futures).handle((result, exception) -> {
                    if (exception != null) {
                        Throwable t = exception.getCause();
                        if (t instanceof PulsarAdminException.NotFoundException) {
                            asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Subscription not found")));
                            return null;
                        }
                        log.error("[{}] Failed to expire messages up to {} on {}", new Object[]{this.clientAppId(), expireTimeInSeconds, this.topicName, t});
                        asyncResponse.resume((Throwable)((Object)new RestException(t)));
                        return null;
                    }
                    asyncResponse.resume((Object)Response.noContent().build());
                    return null;
                });
            } else {
                try {
                    this.internalExpireMessagesByTimestampForSinglePartition(subName, expireTimeInSeconds, authoritative);
                }
                catch (WebApplicationException wae) {
                    asyncResponse.resume((Throwable)wae);
                    return;
                }
                catch (Exception e) {
                    asyncResponse.resume((Throwable)((Object)new RestException(e)));
                    return;
                }
                asyncResponse.resume((Object)Response.noContent().build());
            }
        }
    }

    private void internalExpireMessagesByTimestampForSinglePartition(String subName, int expireTimeInSeconds, boolean authoritative) {
        if (this.topicName.isGlobal()) {
            this.validateGlobalNamespaceOwnership(this.namespaceName);
        }
        if (!this.topicName.isPartitioned() && this.getPartitionedTopicMetadata((TopicName)this.topicName, (boolean)authoritative, (boolean)false).partitions > 0) {
            String msg = "This method should not be called for partitioned topic";
            log.error("[{}] {} {} {}", new Object[]{this.clientAppId(), msg, this.topicName, subName});
            throw new IllegalStateException(msg);
        }
        this.validateAdminAccessForSubscriber(subName, authoritative);
        if (!(this.getTopicReference(this.topicName) instanceof PersistentTopic)) {
            log.error("[{}] Not supported operation of non-persistent topic {} {}", new Object[]{this.clientAppId(), this.topicName, subName});
            throw new RestException(Response.Status.METHOD_NOT_ALLOWED, "Expire messages on a non-persistent topic is not allowed");
        }
        PersistentTopic topic = (PersistentTopic)this.getTopicReference(this.topicName);
        try {
            boolean issued;
            if (subName.startsWith(topic.getReplicatorPrefix())) {
                String remoteCluster = PersistentReplicator.getRemoteCluster(subName);
                PersistentReplicator repl = (PersistentReplicator)topic.getPersistentReplicator(remoteCluster);
                PersistentTopicsBase.checkNotNull(repl);
                issued = repl.expireMessages(expireTimeInSeconds);
            } else {
                PersistentSubscription sub = topic.getSubscription(subName);
                PersistentTopicsBase.checkNotNull(sub);
                issued = sub.expireMessages(expireTimeInSeconds);
            }
            if (!issued) {
                if (log.isDebugEnabled()) {
                    log.debug("Expire message by timestamp not issued on topic {} for subscription {} due to ongoing message expiration not finished or subscription almost catch up. If it's performed on a partitioned topic operation might succeeded on other partitions, please check stats of individual partition.", (Object)this.topicName, (Object)subName);
                }
                throw new RestException(Response.Status.CONFLICT, "Expire message by timestamp not issued on topic " + this.topicName + " for subscription " + subName + " due to ongoing message expiration not finished or  subscription almost catch up. If it's performed on a partitioned topic operation might succeeded on other partitions, please check stats of individual partition.");
            }
            log.info("[{}] Message expire started up to {} on {} {}", new Object[]{this.clientAppId(), expireTimeInSeconds, this.topicName, subName});
        }
        catch (NullPointerException npe) {
            throw new RestException(Response.Status.NOT_FOUND, "Subscription not found");
        }
        catch (Exception exception) {
            log.error("[{}] Failed to expire messages up to {} on {} with subscription {} {}", new Object[]{this.clientAppId(), expireTimeInSeconds, this.topicName, subName, exception});
            throw new RestException(exception);
        }
    }

    protected void internalExpireMessagesByPosition(AsyncResponse asyncResponse, String subName, boolean authoritative, MessageIdImpl messageId, boolean isExcluded, int batchIndex) {
        if (this.topicName.isGlobal()) {
            try {
                this.validateGlobalNamespaceOwnership(this.namespaceName);
            }
            catch (Exception e2) {
                log.warn("[{}][{}] Failed to expire messages on subscription {} to position {}: {}", new Object[]{this.clientAppId(), this.topicName, subName, messageId, e2.getMessage()});
                this.resumeAsyncResponseExceptionally(asyncResponse, e2);
                return;
            }
        }
        log.info("[{}][{}] received expire messages on subscription {} to position {}", new Object[]{this.clientAppId(), this.topicName, subName, messageId});
        if (!this.topicName.isPartitioned() && this.getPartitionedTopicMetadata((TopicName)this.topicName, (boolean)authoritative, (boolean)false).partitions > 0) {
            log.warn("[{}] Not supported operation expire message up to {} on partitioned-topic {} {}", new Object[]{this.clientAppId(), messageId, this.topicName, subName});
            asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.METHOD_NOT_ALLOWED, "Expire message at position is not supported for partitioned-topic")));
            return;
        }
        if (messageId.getPartitionIndex() != this.topicName.getPartitionIndex()) {
            log.warn("[{}] Invalid parameter for expire message by position, partition index of passed in message position {} doesn't match partition index of topic requested {}.", new Object[]{this.clientAppId(), messageId, this.topicName});
            asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.PRECONDITION_FAILED, "Invalid parameter for expire message by position, partition index of message position passed in doesn't match partition index for the topic.")));
        } else {
            this.validateAdminAccessForSubscriber(subName, authoritative);
            this.validateReadOperationOnTopic(authoritative);
            PersistentTopic topic = (PersistentTopic)this.getTopicReference(this.topicName);
            if (topic == null) {
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Topic not found")));
                return;
            }
            try {
                PersistentSubscription sub = topic.getSubscription(subName);
                if (sub == null) {
                    asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Subscription not found")));
                    return;
                }
                CompletableFuture<Integer> batchSizeFuture = new CompletableFuture<Integer>();
                this.getEntryBatchSize(batchSizeFuture, topic, messageId, batchIndex);
                ((CompletableFuture)batchSizeFuture.thenAccept(bi -> {
                    PositionImpl position = this.calculatePositionAckSet(isExcluded, (int)bi, batchIndex, messageId);
                    try {
                        boolean issued;
                        if (subName.startsWith(topic.getReplicatorPrefix())) {
                            String remoteCluster = PersistentReplicator.getRemoteCluster(subName);
                            PersistentReplicator repl = (PersistentReplicator)topic.getPersistentReplicator(remoteCluster);
                            PersistentTopicsBase.checkNotNull(repl);
                            issued = repl.expireMessages((Position)position);
                        } else {
                            PersistentTopicsBase.checkNotNull(sub);
                            issued = sub.expireMessages((Position)position);
                        }
                        if (!issued) {
                            if (log.isDebugEnabled()) {
                                log.debug("Expire message by position not issued on topic {} for subscription {} due to ongoing message expiration not finished or subscription almost catch up.", (Object)this.topicName, (Object)subName);
                            }
                            throw new RestException(Response.Status.CONFLICT, "Expire message by position not issued on topic " + this.topicName + " for subscription " + subName + " due to ongoing message expiration not finished or invalid message position provided.");
                        }
                        log.info("[{}] Message expire started up to {} on {} {}", new Object[]{this.clientAppId(), position, this.topicName, subName});
                    }
                    catch (NullPointerException npe) {
                        throw new RestException(Response.Status.NOT_FOUND, "Subscription not found");
                    }
                    catch (Exception exception) {
                        log.error("[{}] Failed to expire messages up to {} on {} with subscription {} {}", new Object[]{this.clientAppId(), position, this.topicName, subName, exception});
                        throw new RestException(exception);
                    }
                })).exceptionally(e -> {
                    log.error("[{}] Failed to expire messages up to {} on {} with subscription {} {}", new Object[]{this.clientAppId(), messageId, this.topicName, subName, e});
                    asyncResponse.resume(e);
                    return null;
                });
            }
            catch (Exception e3) {
                log.warn("[{}][{}] Failed to expire messages up to {} on subscription {} to position {}", new Object[]{this.clientAppId(), this.topicName, messageId, subName, messageId, e3});
                this.resumeAsyncResponseExceptionally(asyncResponse, e3);
            }
        }
        asyncResponse.resume((Object)Response.noContent().build());
    }

    protected void internalTriggerCompaction(AsyncResponse asyncResponse, boolean authoritative) {
        log.info("[{}] Trigger compaction on topic {}", (Object)this.clientAppId(), (Object)this.topicName);
        try {
            if (this.topicName.isGlobal()) {
                this.validateGlobalNamespaceOwnership(this.namespaceName);
            }
        }
        catch (Exception e) {
            log.error("[{}] Failed to trigger compaction on topic {}", new Object[]{this.clientAppId(), this.topicName, e});
            this.resumeAsyncResponseExceptionally(asyncResponse, e);
            return;
        }
        if (this.topicName.isPartitioned()) {
            try {
                this.internalTriggerCompactionNonPartitionedTopic(authoritative);
            }
            catch (Exception e) {
                log.error("[{}] Failed to trigger compaction on topic {}", new Object[]{this.clientAppId(), this.topicName, e});
                this.resumeAsyncResponseExceptionally(asyncResponse, e);
                return;
            }
            asyncResponse.resume((Object)Response.noContent().build());
        } else {
            ((CompletableFuture)this.getPartitionedTopicMetadataAsync(this.topicName, authoritative, false).thenAccept(partitionMetadata -> {
                int numPartitions = partitionMetadata.partitions;
                if (numPartitions > 0) {
                    ArrayList futures = Lists.newArrayList();
                    for (int i = 0; i < numPartitions; ++i) {
                        TopicName topicNamePartition = this.topicName.getPartition(i);
                        try {
                            futures.add(this.pulsar().getAdminClient().topics().triggerCompactionAsync(topicNamePartition.toString()));
                            continue;
                        }
                        catch (Exception e) {
                            log.error("[{}] Failed to trigger compaction on topic {}", new Object[]{this.clientAppId(), topicNamePartition, e});
                            asyncResponse.resume((Throwable)((Object)new RestException(e)));
                            return;
                        }
                    }
                    FutureUtil.waitForAll((List)futures).handle((result, exception) -> {
                        if (exception != null) {
                            Throwable th = exception.getCause();
                            if (th instanceof PulsarAdminException.NotFoundException) {
                                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, th.getMessage())));
                                return null;
                            }
                            if (th instanceof WebApplicationException) {
                                asyncResponse.resume(th);
                                return null;
                            }
                            log.error("[{}] Failed to trigger compaction on topic {}", new Object[]{this.clientAppId(), this.topicName, exception});
                            asyncResponse.resume((Throwable)((Object)new RestException((Throwable)exception)));
                            return null;
                        }
                        asyncResponse.resume((Object)Response.noContent().build());
                        return null;
                    });
                } else {
                    try {
                        this.internalTriggerCompactionNonPartitionedTopic(authoritative);
                    }
                    catch (Exception e) {
                        log.error("[{}] Failed to trigger compaction on topic {}", new Object[]{this.clientAppId(), this.topicName, e});
                        this.resumeAsyncResponseExceptionally(asyncResponse, e);
                        return;
                    }
                    asyncResponse.resume((Object)Response.noContent().build());
                }
            })).exceptionally(ex -> {
                log.error("[{}] Failed to trigger compaction on topic {}", new Object[]{this.clientAppId(), this.topicName, ex});
                this.resumeAsyncResponseExceptionally(asyncResponse, (Throwable)ex);
                return null;
            });
        }
    }

    protected void internalTriggerCompactionNonPartitionedTopic(boolean authoritative) {
        this.validateWriteOperationOnTopic(authoritative);
        PersistentTopic topic = (PersistentTopic)this.getTopicReference(this.topicName);
        try {
            topic.triggerCompaction();
        }
        catch (BrokerServiceException.AlreadyRunningException e) {
            throw new RestException(Response.Status.CONFLICT, e.getMessage());
        }
        catch (Exception e) {
            log.error("[{}] Failed to trigger compaction on topic {}", new Object[]{this.clientAppId(), this.topicName, e});
            throw new RestException(e);
        }
    }

    protected LongRunningProcessStatus internalCompactionStatus(boolean authoritative) {
        this.validateReadOperationOnTopic(authoritative);
        PersistentTopic topic = (PersistentTopic)this.getTopicReference(this.topicName);
        return topic.compactionStatus();
    }

    protected void internalTriggerOffload(boolean authoritative, MessageIdImpl messageId) {
        this.validateWriteOperationOnTopic(authoritative);
        PersistentTopic topic = (PersistentTopic)this.getTopicReference(this.topicName);
        try {
            topic.triggerOffload(messageId);
        }
        catch (BrokerServiceException.AlreadyRunningException e) {
            throw new RestException(Response.Status.CONFLICT, e.getMessage());
        }
        catch (Exception e) {
            log.warn("Unexpected error triggering offload", (Throwable)e);
            throw new RestException(e);
        }
    }

    protected OffloadProcessStatus internalOffloadStatus(boolean authoritative) {
        this.validateReadOperationOnTopic(authoritative);
        PersistentTopic topic = (PersistentTopic)this.getTopicReference(this.topicName);
        return topic.offloadStatus();
    }

    public static CompletableFuture<PartitionedTopicMetadata> getPartitionedTopicMetadata(PulsarService pulsar, String clientAppId, String originalPrincipal, AuthenticationDataSource authenticationData, TopicName topicName) {
        CompletableFuture<PartitionedTopicMetadata> metadataFuture = new CompletableFuture<PartitionedTopicMetadata>();
        try {
            try {
                PersistentTopicsBase.checkAuthorization(pulsar, topicName, clientAppId, authenticationData);
            }
            catch (RestException e) {
                try {
                    PersistentTopicsBase.validateAdminAccessForTenant(pulsar, clientAppId, originalPrincipal, topicName.getTenant(), authenticationData);
                }
                catch (RestException authException) {
                    log.warn("Failed to authorize {} on cluster {}", (Object)clientAppId, (Object)topicName.toString());
                    throw new PulsarClientException(String.format("Authorization failed %s on topic %s with error %s", clientAppId, topicName.toString(), authException.getMessage()));
                }
            }
            catch (Exception ex2) {
                log.warn("Failed to authorize {} on cluster {} with unexpected exception {}", new Object[]{clientAppId, topicName.toString(), ex2.getMessage(), ex2});
                throw ex2;
            }
            ((CompletableFuture)((CompletableFuture)PersistentTopicsBase.checkLocalOrGetPeerReplicationCluster(pulsar, topicName.getNamespaceObject()).thenCompose(res -> pulsar.getBrokerService().fetchPartitionedTopicMetadataCheckAllowAutoCreationAsync(topicName))).thenAccept(metadata -> {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Total number of partitions for topic {} is {}", new Object[]{clientAppId, topicName, metadata.partitions});
                }
                metadataFuture.complete((PartitionedTopicMetadata)metadata);
            })).exceptionally(ex -> {
                metadataFuture.completeExceptionally(ex.getCause());
                return null;
            });
        }
        catch (Exception ex3) {
            metadataFuture.completeExceptionally(ex3);
        }
        return metadataFuture;
    }

    public static CompletableFuture<PartitionedTopicMetadata> unsafeGetPartitionedTopicMetadataAsync(PulsarService pulsar, TopicName topicName) {
        CompletableFuture<PartitionedTopicMetadata> metadataFuture = new CompletableFuture<PartitionedTopicMetadata>();
        ((CompletableFuture)((CompletableFuture)PersistentTopicsBase.checkLocalOrGetPeerReplicationCluster(pulsar, topicName.getNamespaceObject()).thenCompose(res -> pulsar.getBrokerService().fetchPartitionedTopicMetadataCheckAllowAutoCreationAsync(topicName))).thenAccept(metadata -> {
            if (log.isDebugEnabled()) {
                log.debug("Total number of partitions for topic {} is {}", (Object)topicName, (Object)metadata.partitions);
            }
            metadataFuture.complete((PartitionedTopicMetadata)metadata);
        })).exceptionally(ex -> {
            metadataFuture.completeExceptionally(ex.getCause());
            return null;
        });
        return metadataFuture;
    }

    private Topic getTopicReference(TopicName topicName) {
        try {
            return this.pulsar().getBrokerService().getTopicIfExists(topicName.toString()).get(this.pulsar().getConfiguration().getZooKeeperOperationTimeoutSeconds(), TimeUnit.SECONDS).orElseThrow(() -> this.topicNotFoundReason(topicName));
        }
        catch (RestException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RestException(e);
        }
    }

    private RestException topicNotFoundReason(TopicName topicName) {
        if (!topicName.isPartitioned()) {
            return new RestException(Response.Status.NOT_FOUND, "Topic not found");
        }
        PartitionedTopicMetadata partitionedTopicMetadata = this.getPartitionedTopicMetadata(TopicName.get((String)topicName.getPartitionedTopicName()), false, false);
        if (partitionedTopicMetadata == null || partitionedTopicMetadata.partitions == 0) {
            String topicErrorType = partitionedTopicMetadata == null ? "has no metadata" : "has zero partitions";
            return new RestException(Response.Status.NOT_FOUND, String.format("Partitioned Topic not found: %s %s", topicName.toString(), topicErrorType));
        }
        if (!this.internalGetList().contains(topicName.toString())) {
            return new RestException(Response.Status.NOT_FOUND, "Topic partitions were not yet created");
        }
        return new RestException(Response.Status.NOT_FOUND, "Partitioned Topic not found");
    }

    private Topic getOrCreateTopic(TopicName topicName) {
        return (Topic)((CompletableFuture)this.pulsar().getBrokerService().getTopic(topicName.toString(), true).thenApply(Optional::get)).join();
    }

    private Subscription getSubscriptionReference(String subName, PersistentTopic topic) {
        try {
            Subscription sub = topic.getSubscription(subName);
            if (sub == null) {
                sub = topic.createSubscription(subName, PulsarApi.CommandSubscribe.InitialPosition.Earliest, false).get();
            }
            return PersistentTopicsBase.checkNotNull(sub);
        }
        catch (Exception e) {
            throw new RestException(Response.Status.NOT_FOUND, "Subscription not found");
        }
    }

    private PersistentReplicator getReplicatorReference(String replName, PersistentTopic topic) {
        try {
            String remoteCluster = PersistentReplicator.getRemoteCluster(replName);
            PersistentReplicator repl = (PersistentReplicator)topic.getPersistentReplicator(remoteCluster);
            return PersistentTopicsBase.checkNotNull(repl);
        }
        catch (Exception e) {
            throw new RestException(Response.Status.NOT_FOUND, "Replicator not found");
        }
    }

    private CompletableFuture<Void> updatePartitionedTopic(TopicName topicName, int numPartitions) {
        String path = ZkAdminPaths.partitionedTopicPath(topicName);
        CompletableFuture<Void> updatePartition = new CompletableFuture<Void>();
        ((CompletableFuture)this.createSubscriptions(topicName, numPartitions).thenAccept(res -> {
            try {
                byte[] data = PersistentTopicsBase.jsonMapper().writeValueAsBytes((Object)new PartitionedTopicMetadata(numPartitions));
                this.globalZk().setData(path, data, -1, (rc, path1, ctx, stat) -> {
                    if (rc == KeeperException.Code.OK.intValue()) {
                        updatePartition.complete(null);
                    } else {
                        updatePartition.completeExceptionally(KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc), (String)"failed to create update partitions"));
                    }
                }, null);
            }
            catch (Exception e) {
                updatePartition.completeExceptionally(e);
            }
        })).exceptionally(ex -> {
            updatePartition.completeExceptionally((Throwable)ex);
            return null;
        });
        return updatePartition;
    }

    private CompletableFuture<Void> createSubscriptions(TopicName topicName, int numPartitions) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        ((CompletableFuture)this.pulsar().getBrokerService().fetchPartitionedTopicMetadataAsync(topicName).thenAccept(partitionMetadata -> {
            PulsarAdmin admin;
            if (partitionMetadata.partitions < 1) {
                result.completeExceptionally((Throwable)((Object)new RestException(Response.Status.CONFLICT, "Topic is not partitioned topic")));
                return;
            }
            if (partitionMetadata.partitions >= numPartitions) {
                result.completeExceptionally((Throwable)((Object)new RestException(Response.Status.CONFLICT, "number of partitions must be more than existing " + partitionMetadata.partitions)));
                return;
            }
            try {
                admin = this.pulsar().getAdminClient();
            }
            catch (PulsarServerException e1) {
                result.completeExceptionally(e1);
                return;
            }
            ((CompletableFuture)admin.topics().getStatsAsync(topicName.getPartition(0).toString()).thenAccept(stats -> {
                ArrayList subscriptionFutures = new ArrayList();
                stats.subscriptions.entrySet().forEach(e -> {
                    String subscription = (String)e.getKey();
                    SubscriptionStats ss = (SubscriptionStats)e.getValue();
                    if (!ss.isDurable) {
                        return;
                    }
                    for (int i = partitionMetadata.partitions; i < numPartitions; ++i) {
                        String topicNamePartition = topicName.getPartition(i).toString();
                        subscriptionFutures.add(admin.topics().createSubscriptionAsync(topicNamePartition, subscription, MessageId.latest));
                    }
                });
                ((CompletableFuture)FutureUtil.waitForAll(subscriptionFutures).thenRun(() -> {
                    log.info("[{}] Successfully created new partitions {}", (Object)this.clientAppId(), (Object)topicName);
                    result.complete(null);
                })).exceptionally(ex -> {
                    log.warn("[{}] Failed to create subscriptions on new partitions for {}", new Object[]{this.clientAppId(), topicName, ex});
                    result.completeExceptionally((Throwable)ex);
                    return null;
                });
            })).exceptionally(ex -> {
                if (ex.getCause() instanceof PulsarAdminException.NotFoundException) {
                    result.complete(null);
                } else {
                    log.warn("[{}] Failed to get list of subscriptions of {}", new Object[]{this.clientAppId(), topicName.getPartition(0), ex});
                    result.completeExceptionally((Throwable)ex);
                }
                return null;
            });
        })).exceptionally(ex -> {
            log.warn("[{}] Failed to get partition metadata for {}", (Object)this.clientAppId(), (Object)topicName.toString());
            result.completeExceptionally((Throwable)ex);
            return null;
        });
        return result;
    }

    private void validateClientVersion() {
        if (!this.pulsar().getConfiguration().isClientLibraryVersionCheckEnabled()) {
            return;
        }
        String userAgent = this.httpRequest.getHeader("User-Agent");
        if (StringUtils.isBlank((CharSequence)userAgent)) {
            throw new RestException(Response.Status.METHOD_NOT_ALLOWED, "Client lib is not compatible to access partitioned metadata: version in user-agent is not present");
        }
        if (userAgent.contains(DEPRECATED_CLIENT_VERSION_PREFIX)) {
            try {
                String[] splits;
                String[] tokens = userAgent.split(DEPRECATED_CLIENT_VERSION_PREFIX);
                String[] stringArray = splits = tokens.length > 1 ? tokens[1].split("-")[0].trim().split("\\.") : null;
                if (splits != null && splits.length > 1 && (LEAST_SUPPORTED_CLIENT_VERSION_PREFIX.getMajorVersion() > Integer.parseInt(splits[0]) || LEAST_SUPPORTED_CLIENT_VERSION_PREFIX.getMinorVersion() > Integer.parseInt(splits[1]))) {
                    throw new RestException(Response.Status.METHOD_NOT_ALLOWED, "Client lib is not compatible to access partitioned metadata: version " + userAgent + " is not supported");
                }
            }
            catch (RestException re) {
                throw re;
            }
            catch (Exception e) {
                log.warn("[{}] Failed to parse version {} ", (Object)this.clientAppId(), (Object)userAgent);
            }
        }
    }

    private void validatePartitionTopicUpdate(String topicName, int numberOfPartition) {
        List<String> existingTopicList = this.internalGetList();
        TopicName partitionTopicName = TopicName.get((String)this.domain(), (NamespaceName)this.namespaceName, (String)topicName);
        PartitionedTopicMetadata metadata = this.getPartitionedTopicMetadata(partitionTopicName, false, false);
        int oldPartition = metadata.partitions;
        String prefix = partitionTopicName.getPartitionedTopicName() + "-partition-";
        for (String exsitingTopicName : existingTopicList) {
            if (!exsitingTopicName.startsWith(prefix)) continue;
            try {
                long suffix = Long.parseLong(exsitingTopicName.substring(exsitingTopicName.indexOf("-partition-") + "-partition-".length()));
                if (suffix < (long)oldPartition || suffix > (long)numberOfPartition) continue;
                log.warn("[{}] Already have non partition topic {} which contains partition suffix '-partition-' and end with numeric value smaller than the new number of partition. Update of partitioned topic {} could cause conflict.", new Object[]{this.clientAppId(), exsitingTopicName, topicName});
                throw new RestException(Response.Status.PRECONDITION_FAILED, "Already have non partition topic " + exsitingTopicName + " which contains partition suffix '-partition-' and end with numeric value and end with numeric value smaller than the new number of partition. Update of partitioned topic " + topicName + " could cause conflict.");
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
    }

    private void validateNonPartitionTopicName(String topicName) {
        if (topicName.contains("-partition-")) {
            try {
                int partitionIndex = topicName.indexOf("-partition-");
                long suffix = Long.parseLong(topicName.substring(partitionIndex + "-partition-".length()));
                TopicName partitionTopicName = TopicName.get((String)this.domain(), (NamespaceName)this.namespaceName, (String)topicName.substring(0, partitionIndex));
                PartitionedTopicMetadata metadata = this.getPartitionedTopicMetadata(partitionTopicName, false, false);
                if (metadata.partitions > 0 && suffix >= (long)metadata.partitions) {
                    log.warn("[{}] Can't create topic {} with \"-partition-\" followed by a number smaller then number of partition of partitioned topic {}.", new Object[]{this.clientAppId(), topicName, partitionTopicName.getLocalName()});
                    throw new RestException(Response.Status.PRECONDITION_FAILED, "Can't create topic " + topicName + " with \"-partition-\" followed by a number smaller then number of partition of partitioned topic " + partitionTopicName.getLocalName());
                }
                if (metadata.partitions == 0) {
                    log.warn("[{}] Can't create topic {} with \"-partition-\" followed by numeric value if there isn't a partitioned topic {} created.", new Object[]{this.clientAppId(), topicName, partitionTopicName.getLocalName()});
                    throw new RestException(Response.Status.PRECONDITION_FAILED, "Can't create topic " + topicName + " with \"-partition-\" followed by numeric value if there isn't a partitioned topic " + partitionTopicName.getLocalName() + " created.");
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    protected void internalGetLastMessageId(AsyncResponse asyncResponse, boolean authoritative) {
        Topic topic;
        try {
            this.validateReadOperationOnTopic(authoritative);
            topic = this.getTopicReference(this.topicName);
        }
        catch (WebApplicationException wae) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Failed to get last messageId {}, redirecting to other brokers.", new Object[]{this.clientAppId(), this.topicName, wae});
            }
            this.resumeAsyncResponseExceptionally(asyncResponse, wae);
            return;
        }
        catch (Exception e2) {
            log.error("[{}] Failed to get last messageId {}", new Object[]{this.clientAppId(), this.topicName, e2});
            this.resumeAsyncResponseExceptionally(asyncResponse, e2);
            return;
        }
        if (!(topic instanceof PersistentTopic)) {
            log.error("[{}] Not supported operation of non-persistent topic {}", (Object)this.clientAppId(), (Object)this.topicName);
            asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.METHOD_NOT_ALLOWED, "GetLastMessageId on a non-persistent topic is not allowed")));
            return;
        }
        topic.getLastMessageId().whenComplete((v, e) -> {
            if (e != null) {
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage())));
            } else {
                asyncResponse.resume(v);
            }
        });
    }

    protected CompletableFuture<Optional<DispatchRate>> internalGetDispatchRate() {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName).thenApply(op -> op.map(TopicPolicies::getDispatchRate));
    }

    protected CompletableFuture<Void> internalSetDispatchRate(DispatchRate dispatchRate) {
        if (dispatchRate == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this.getTopicPoliciesAsyncWithRetry(this.topicName).thenCompose(op -> {
            TopicPolicies topicPolicies = op.orElseGet(TopicPolicies::new);
            topicPolicies.setDispatchRate(dispatchRate);
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, topicPolicies);
        });
    }

    protected CompletableFuture<Void> internalRemoveDispatchRate() {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName).thenCompose(op -> {
            if (!op.isPresent()) {
                return CompletableFuture.completedFuture(null);
            }
            ((TopicPolicies)op.get()).setDispatchRate(null);
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, (TopicPolicies)op.get());
        });
    }

    protected CompletableFuture<Optional<DispatchRate>> internalGetSubscriptionDispatchRate() {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName).thenApply(op -> op.map(TopicPolicies::getSubscriptionDispatchRate));
    }

    protected CompletableFuture<Void> internalSetSubscriptionDispatchRate(DispatchRate dispatchRate) {
        if (dispatchRate == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this.getTopicPoliciesAsyncWithRetry(this.topicName).thenCompose(op -> {
            TopicPolicies topicPolicies = op.orElseGet(TopicPolicies::new);
            topicPolicies.setSubscriptionDispatchRate(dispatchRate);
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, topicPolicies);
        });
    }

    protected CompletableFuture<Void> internalRemoveSubscriptionDispatchRate() {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName).thenCompose(op -> {
            if (!op.isPresent()) {
                return CompletableFuture.completedFuture(null);
            }
            ((TopicPolicies)op.get()).setSubscriptionDispatchRate(null);
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, (TopicPolicies)op.get());
        });
    }

    protected CompletableFuture<Optional<Integer>> internalGetMaxConsumersPerSubscription() {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName).thenApply(op -> op.map(TopicPolicies::getMaxConsumersPerSubscription));
    }

    protected CompletableFuture<Void> internalSetMaxConsumersPerSubscription(Integer maxConsumersPerSubscription) {
        if (maxConsumersPerSubscription != null && maxConsumersPerSubscription < 0) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Invalid value for maxConsumersPerSubscription");
        }
        return this.getTopicPoliciesAsyncWithRetry(this.topicName).thenCompose(op -> {
            TopicPolicies topicPolicies = op.orElseGet(TopicPolicies::new);
            topicPolicies.setMaxConsumersPerSubscription(maxConsumersPerSubscription);
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, topicPolicies);
        });
    }

    protected CompletableFuture<Void> internalRemoveMaxConsumersPerSubscription() {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName).thenCompose(op -> {
            if (!op.isPresent()) {
                return CompletableFuture.completedFuture(null);
            }
            ((TopicPolicies)op.get()).setMaxConsumersPerSubscription(null);
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, (TopicPolicies)op.get());
        });
    }

    protected CompletableFuture<Optional<Long>> internalGetCompactionThreshold() {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName).thenApply(op -> op.map(TopicPolicies::getCompactionThreshold));
    }

    protected CompletableFuture<Void> internalSetCompactionThreshold(Long compactionThreshold) {
        if (compactionThreshold != null && compactionThreshold < 0L) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Invalid value for compactionThreshold");
        }
        return this.getTopicPoliciesAsyncWithRetry(this.topicName).thenCompose(op -> {
            TopicPolicies topicPolicies = op.orElseGet(TopicPolicies::new);
            topicPolicies.setCompactionThreshold(compactionThreshold);
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, topicPolicies);
        });
    }

    protected CompletableFuture<Void> internalRemoveCompactionThreshold() {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName).thenCompose(op -> {
            if (!op.isPresent()) {
                return CompletableFuture.completedFuture(null);
            }
            ((TopicPolicies)op.get()).setCompactionThreshold(null);
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, (TopicPolicies)op.get());
        });
    }

    protected CompletableFuture<Optional<PublishRate>> internalGetPublishRate() {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName).thenApply(op -> op.map(TopicPolicies::getPublishRate));
    }

    protected CompletableFuture<Void> internalSetPublishRate(PublishRate publishRate) {
        if (publishRate == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this.getTopicPoliciesAsyncWithRetry(this.topicName).thenCompose(op -> {
            TopicPolicies topicPolicies = op.orElseGet(TopicPolicies::new);
            topicPolicies.setPublishRate(publishRate);
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, topicPolicies);
        });
    }

    protected CompletableFuture<Void> internalRemovePublishRate() {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName).thenCompose(op -> {
            if (!op.isPresent()) {
                return CompletableFuture.completedFuture(null);
            }
            ((TopicPolicies)op.get()).setPublishRate(null);
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, (TopicPolicies)op.get());
        });
    }

    protected CompletableFuture<Optional<SubscribeRate>> internalGetSubscribeRate() {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName).thenApply(op -> op.map(TopicPolicies::getSubscribeRate));
    }

    protected CompletableFuture<Void> internalSetSubscribeRate(SubscribeRate subscribeRate) {
        if (subscribeRate == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this.getTopicPoliciesAsyncWithRetry(this.topicName).thenCompose(op -> {
            TopicPolicies topicPolicies = op.orElseGet(TopicPolicies::new);
            topicPolicies.setSubscribeRate(subscribeRate);
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, topicPolicies);
        });
    }

    protected CompletableFuture<Void> internalRemoveSubscribeRate() {
        return this.getTopicPoliciesAsyncWithRetry(this.topicName).thenCompose(op -> {
            if (!op.isPresent()) {
                return CompletableFuture.completedFuture(null);
            }
            ((TopicPolicies)op.get()).setSubscribeRate(null);
            return this.pulsar().getTopicPoliciesService().updateTopicPoliciesAsync(this.topicName, (TopicPolicies)op.get());
        });
    }

    protected void handleTopicPolicyException(String methodName, Throwable thr, AsyncResponse asyncResponse) {
        Throwable cause = thr.getCause();
        if (!(cause instanceof WebApplicationException) || ((WebApplicationException)cause).getResponse().getStatus() != 307) {
            log.error("[{}] Failed to perform {} on topic {}", new Object[]{this.clientAppId(), methodName, this.topicName, cause});
        }
        this.resumeAsyncResponseExceptionally(asyncResponse, cause);
    }
}

