/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.transaction.buffer.impl;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.Position;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.broker.transaction.buffer.TransactionBuffer;
import org.apache.pulsar.broker.transaction.buffer.TransactionBufferReader;
import org.apache.pulsar.broker.transaction.buffer.TransactionMeta;
import org.apache.pulsar.client.api.transaction.TxnID;
import org.apache.pulsar.common.api.proto.PulsarApi;
import org.apache.pulsar.common.api.proto.PulsarMarkers;
import org.apache.pulsar.common.protocol.Markers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicTransactionBuffer
implements TransactionBuffer {
    private static final Logger log = LoggerFactory.getLogger(TopicTransactionBuffer.class);
    private final PersistentTopic topic;

    public TopicTransactionBuffer(PersistentTopic topic) {
        this.topic = topic;
    }

    @Override
    public CompletableFuture<TransactionMeta> getTransactionMeta(TxnID txnID) {
        return null;
    }

    @Override
    public CompletableFuture<Position> appendBufferToTxn(final TxnID txnId, long sequenceId, ByteBuf buffer) {
        final CompletableFuture<Position> completableFuture = new CompletableFuture<Position>();
        this.topic.getManagedLedger().asyncAddEntry(buffer, new AsyncCallbacks.AddEntryCallback(){

            public void addComplete(Position position, Object ctx) {
                completableFuture.complete(position);
            }

            public void addFailed(ManagedLedgerException exception, Object ctx) {
                log.error("Failed to append buffer to txn {}", (Object)txnId, (Object)exception);
                completableFuture.completeExceptionally(exception);
            }
        }, null);
        return completableFuture;
    }

    @Override
    public CompletableFuture<TransactionBufferReader> openTransactionBufferReader(TxnID txnID, long startSequenceId) {
        return null;
    }

    @Override
    public CompletableFuture<Void> commitTxn(final TxnID txnID, List<PulsarApi.MessageIdData> sendMessageIdList) {
        if (log.isDebugEnabled()) {
            log.debug("Transaction {} commit on topic {}.", (Object)txnID.toString(), (Object)this.topic.getName());
        }
        final CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        ByteBuf commitMarker = Markers.newTxnCommitMarker((long)-1L, (long)txnID.getMostSigBits(), (long)txnID.getLeastSigBits(), this.getMessageIdDataList(sendMessageIdList));
        this.topic.getManagedLedger().asyncAddEntry(commitMarker, new AsyncCallbacks.AddEntryCallback(){

            public void addComplete(Position position, Object ctx) {
                completableFuture.complete(null);
            }

            public void addFailed(ManagedLedgerException exception, Object ctx) {
                log.error("Failed to commit for txn {}", (Object)txnID, (Object)exception);
                completableFuture.completeExceptionally(exception);
            }
        }, null);
        return completableFuture;
    }

    @Override
    public CompletableFuture<Void> abortTxn(final TxnID txnID, List<PulsarApi.MessageIdData> sendMessageIdList) {
        if (log.isDebugEnabled()) {
            log.debug("Transaction {} abort on topic {}.", (Object)txnID.toString(), (Object)this.topic.getName());
        }
        final CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        ByteBuf abortMarker = Markers.newTxnAbortMarker((long)-1L, (long)txnID.getMostSigBits(), (long)txnID.getLeastSigBits(), this.getMessageIdDataList(sendMessageIdList));
        this.topic.getManagedLedger().asyncAddEntry(abortMarker, new AsyncCallbacks.AddEntryCallback(){

            public void addComplete(Position position, Object ctx) {
                completableFuture.complete(null);
            }

            public void addFailed(ManagedLedgerException exception, Object ctx) {
                log.error("Failed to abort for txn {}", (Object)txnID, (Object)exception);
                completableFuture.completeExceptionally(exception);
            }
        }, null);
        return completableFuture;
    }

    private List<PulsarMarkers.MessageIdData> getMessageIdDataList(List<PulsarApi.MessageIdData> sendMessageIdList) {
        ArrayList<PulsarMarkers.MessageIdData> messageIdDataList = new ArrayList<PulsarMarkers.MessageIdData>(sendMessageIdList.size());
        for (PulsarApi.MessageIdData msgIdData : sendMessageIdList) {
            messageIdDataList.add(PulsarMarkers.MessageIdData.newBuilder().setLedgerId(msgIdData.getLedgerId()).setEntryId(msgIdData.getEntryId()).build());
        }
        return messageIdDataList;
    }

    @Override
    public CompletableFuture<Void> purgeTxns(List<Long> dataLedgers) {
        return null;
    }

    @Override
    public CompletableFuture<Void> closeAsync() {
        return null;
    }
}

