/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import java.util.List;
import org.apache.pulsar.PulsarClusterMetadataSetup;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;

public class PulsarInitialNamespaceSetup {
    public static int doMain(String[] args) throws Exception {
        Arguments arguments = new Arguments();
        JCommander jcommander = new JCommander();
        try {
            jcommander.addObject((Object)arguments);
            jcommander.parse(args);
            if (arguments.help) {
                jcommander.usage();
                return 0;
            }
        }
        catch (Exception e) {
            jcommander.usage();
            return 1;
        }
        if (arguments.configurationStore == null) {
            System.err.println("Configuration store address argument is required (--configuration-store)");
            jcommander.usage();
            return 1;
        }
        try (MetadataStoreExtended configStore = PulsarClusterMetadataSetup.initMetadataStore(arguments.configurationStore, arguments.zkSessionTimeoutMillis);){
            for (String namespace : arguments.namespaces) {
                NamespaceName namespaceName = null;
                try {
                    namespaceName = NamespaceName.get((String)namespace);
                }
                catch (Exception e) {
                    System.out.println("Invalid namespace name.");
                    int n = 1;
                    if (configStore != null) {
                        configStore.close();
                    }
                    return n;
                }
                PulsarClusterMetadataSetup.createTenantIfAbsent((MetadataStore)configStore, namespaceName.getTenant(), arguments.cluster);
                PulsarClusterMetadataSetup.createNamespaceIfAbsent((MetadataStore)configStore, namespaceName, arguments.cluster);
            }
        }
        System.out.println("Initial namespace setup success");
        return 0;
    }

    public static void main(String[] args) throws Exception {
        System.exit(PulsarInitialNamespaceSetup.doMain(args));
    }

    private static class Arguments {
        @Parameter(names={"-c", "--cluster"}, description="Cluster name", required=true)
        private String cluster;
        @Parameter(names={"-cs", "--configuration-store"}, description="Configuration Store connection string", required=true)
        private String configurationStore;
        @Parameter(names={"--zookeeper-session-timeout-ms"}, description="Local zookeeper session timeout ms")
        private int zkSessionTimeoutMillis = 30000;
        @Parameter(description="tenant/namespace", required=true)
        private List<String> namespaces;
        @Parameter(names={"-h", "--help"}, description="Show this help message")
        private boolean help = false;

        private Arguments() {
        }
    }
}

