/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerMBeanImpl;
import org.apache.bookkeeper.mledger.util.StatsBuckets;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.admin.AdminResource;
import org.apache.pulsar.broker.service.BrokerService;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.PrecisPublishLimiter;
import org.apache.pulsar.broker.service.Producer;
import org.apache.pulsar.broker.service.PublishRateLimiter;
import org.apache.pulsar.broker.service.PublishRateLimiterImpl;
import org.apache.pulsar.broker.service.Subscription;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.broker.service.schema.SchemaRegistry;
import org.apache.pulsar.broker.service.schema.SchemaRegistryService;
import org.apache.pulsar.broker.service.schema.exceptions.IncompatibleSchemaException;
import org.apache.pulsar.broker.stats.prometheus.metrics.Summary;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.InactiveTopicDeleteMode;
import org.apache.pulsar.common.policies.data.InactiveTopicPolicies;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.policies.data.PublishRate;
import org.apache.pulsar.common.policies.data.SchemaAutoUpdateCompatibilityStrategy;
import org.apache.pulsar.common.policies.data.SchemaCompatibilityStrategy;
import org.apache.pulsar.common.policies.data.TopicPolicies;
import org.apache.pulsar.common.protocol.schema.SchemaData;
import org.apache.pulsar.common.protocol.schema.SchemaVersion;
import org.apache.pulsar.common.util.FutureUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTopic
implements Topic {
    protected static final long POLICY_UPDATE_FAILURE_RETRY_TIME_SECONDS = 60L;
    protected final String topic;
    protected final ConcurrentHashMap<String, Producer> producers;
    protected final BrokerService brokerService;
    protected final String replicatorPrefix;
    protected final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    protected volatile boolean isFenced;
    protected InactiveTopicPolicies inactiveTopicPolicies = new InactiveTopicPolicies();
    protected volatile long lastActive;
    protected volatile boolean hasBatchMessagePublished = false;
    protected StatsBuckets addEntryLatencyStatsUsec = new StatsBuckets(ManagedLedgerMBeanImpl.ENTRY_LATENCY_BUCKETS_USEC);
    protected volatile boolean isEncryptionRequired = false;
    protected volatile SchemaCompatibilityStrategy schemaCompatibilityStrategy = SchemaCompatibilityStrategy.FULL;
    protected volatile boolean isAllowAutoUpdateSchema = true;
    protected volatile boolean schemaValidationEnforced = false;
    protected volatile int maxUnackedMessagesOnConsumerAppilied = 0;
    protected volatile Integer maxSubscriptionsPerTopic = null;
    protected volatile PublishRateLimiter topicPublishRateLimiter;
    protected boolean preciseTopicPublishRateLimitingEnable;
    private LongAdder bytesInCounter = new LongAdder();
    private LongAdder msgInCounter = new LongAdder();
    protected volatile Optional<Long> topicEpoch = Optional.empty();
    private volatile boolean hasExclusiveProducer;
    private volatile String exclusiveProducerName;
    private final Queue<Pair<Producer, CompletableFuture<Optional<Long>>>> waitingExclusiveProducers = new ConcurrentLinkedQueue<Pair<Producer, CompletableFuture<Optional<Long>>>>();
    private static final AtomicLongFieldUpdater<AbstractTopic> USAGE_COUNT_UPDATER = AtomicLongFieldUpdater.newUpdater(AbstractTopic.class, "usageCount");
    private volatile long usageCount = 0L;
    private static final Summary PUBLISH_LATENCY = (Summary)Summary.build("pulsar_broker_publish_latency", "-").quantile(0.0).quantile(0.5).quantile(0.95).quantile(0.99).quantile(0.999).quantile(0.9999).quantile(1.0).register();
    private static final Logger log = LoggerFactory.getLogger(AbstractTopic.class);

    public AbstractTopic(String topic, BrokerService brokerService) {
        this.topic = topic;
        this.brokerService = brokerService;
        this.producers = new ConcurrentHashMap();
        this.isFenced = false;
        this.replicatorPrefix = brokerService.pulsar().getConfiguration().getReplicatorPrefix();
        this.inactiveTopicPolicies.setDeleteWhileInactive(brokerService.pulsar().getConfiguration().isBrokerDeleteInactiveTopicsEnabled());
        this.inactiveTopicPolicies.setMaxInactiveDurationSeconds(brokerService.pulsar().getConfiguration().getBrokerDeleteInactiveTopicsMaxInactiveDurationSeconds());
        this.inactiveTopicPolicies.setInactiveTopicDeleteMode(brokerService.pulsar().getConfiguration().getBrokerDeleteInactiveTopicsMode());
        this.lastActive = System.nanoTime();
        Policies policies = null;
        try {
            policies = brokerService.pulsar().getConfigurationCache().policiesCache().get(AdminResource.path("policies", TopicName.get((String)topic).getNamespace())).orElseGet(() -> new Policies());
        }
        catch (Exception e) {
            log.warn("[{}] Error getting policies {} and publish throttling will be disabled", (Object)topic, (Object)e.getMessage());
        }
        this.preciseTopicPublishRateLimitingEnable = brokerService.pulsar().getConfiguration().isPreciseTopicPublishRateLimiterEnable();
        this.updatePublishDispatcher(policies);
    }

    protected boolean isProducersExceeded() {
        Integer maxProducers = this.getTopicPolicies().map(TopicPolicies::getMaxProducerPerTopic).orElse(null);
        if (maxProducers == null) {
            Policies policies;
            try {
                policies = this.brokerService.pulsar().getConfigurationCache().policiesCache().get(AdminResource.path("policies", TopicName.get((String)this.topic).getNamespace())).orElseGet(() -> new Policies());
            }
            catch (Exception e) {
                policies = new Policies();
            }
            maxProducers = policies.max_producers_per_topic;
        }
        return (maxProducers = Integer.valueOf(maxProducers != null ? maxProducers.intValue() : this.brokerService.pulsar().getConfiguration().getMaxProducersPerTopic())) > 0 && maxProducers <= this.producers.size();
    }

    protected boolean isSameAddressProducersExceeded(Producer producer) {
        int maxSameAddressProducers = this.brokerService.pulsar().getConfiguration().getMaxSameAddressProducersPerTopic();
        return maxSameAddressProducers > 0 && this.getNumberOfSameAddressProducers(producer.getClientAddress()) >= maxSameAddressProducers;
    }

    public int getNumberOfSameAddressProducers(String clientAddress) {
        int count = 0;
        if (clientAddress != null) {
            for (Producer producer : this.producers.values()) {
                if (!clientAddress.equals(producer.getClientAddress())) continue;
                ++count;
            }
        }
        return count;
    }

    protected boolean isConsumersExceededOnTopic() {
        int maxConsumersPerTopic;
        Integer maxConsumers = this.getTopicPolicies().map(TopicPolicies::getMaxConsumerPerTopic).orElse(null);
        if (maxConsumers == null) {
            Policies policies;
            try {
                policies = (Policies)this.brokerService.pulsar().getConfigurationCache().policiesCache().getDataIfPresent(AdminResource.path("policies", TopicName.get((String)this.topic).getNamespace()));
                if (policies == null) {
                    policies = new Policies();
                }
            }
            catch (Exception e) {
                log.warn("[{}] Failed to get namespace policies that include max number of consumers: {}", (Object)this.topic, (Object)e.getMessage());
                policies = new Policies();
            }
            maxConsumers = policies.max_consumers_per_topic;
        }
        int n = maxConsumersPerTopic = maxConsumers != null ? maxConsumers.intValue() : this.brokerService.pulsar().getConfiguration().getMaxConsumersPerTopic();
        return maxConsumersPerTopic > 0 && maxConsumersPerTopic <= this.getNumberOfConsumers();
    }

    protected boolean isSameAddressConsumersExceededOnTopic(Consumer consumer) {
        int maxSameAddressConsumers = this.brokerService.pulsar().getConfiguration().getMaxSameAddressConsumersPerTopic();
        return maxSameAddressConsumers > 0 && this.getNumberOfSameAddressConsumers(consumer.getClientAddress()) >= maxSameAddressConsumers;
    }

    public abstract int getNumberOfConsumers();

    public abstract int getNumberOfSameAddressConsumers(String var1);

    protected int getNumberOfSameAddressConsumers(String clientAddress, List<? extends Subscription> subscriptions) {
        int count = 0;
        if (clientAddress != null) {
            for (Subscription subscription : subscriptions) {
                count += subscription.getNumberOfSameAddressConsumers(clientAddress);
            }
        }
        return count;
    }

    protected CompletableFuture<Void> addConsumerToSubscription(Subscription subscription, Consumer consumer) {
        if (this.isConsumersExceededOnTopic()) {
            log.warn("[{}] Attempting to add consumer to topic which reached max consumers limit", (Object)this.topic);
            return FutureUtil.failedFuture((Throwable)new BrokerServiceException.ConsumerBusyException("Topic reached max consumers limit"));
        }
        if (this.isSameAddressConsumersExceededOnTopic(consumer)) {
            log.warn("[{}] Attempting to add consumer to topic which reached max same address consumers limit", (Object)this.topic);
            return FutureUtil.failedFuture((Throwable)new BrokerServiceException.ConsumerBusyException("Topic reached max same address consumers limit"));
        }
        return subscription.addConsumer(consumer);
    }

    @Override
    public void disableCnxAutoRead() {
        this.producers.values().forEach(producer -> producer.getCnx().disableCnxAutoRead());
    }

    @Override
    public void enableCnxAutoRead() {
        this.producers.values().forEach(producer -> producer.getCnx().enableCnxAutoRead());
    }

    protected boolean hasLocalProducers() {
        AtomicBoolean foundLocal = new AtomicBoolean(false);
        this.producers.values().forEach(producer -> {
            if (!producer.isRemote()) {
                foundLocal.set(true);
            }
        });
        return foundLocal.get();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("topic", (Object)this.topic).toString();
    }

    @Override
    public Map<String, Producer> getProducers() {
        return this.producers;
    }

    public BrokerService getBrokerService() {
        return this.brokerService;
    }

    @Override
    public String getName() {
        return this.topic;
    }

    @Override
    public boolean isEncryptionRequired() {
        return this.isEncryptionRequired;
    }

    @Override
    public boolean getSchemaValidationEnforced() {
        return this.schemaValidationEnforced;
    }

    public void markBatchMessagePublished() {
        this.hasBatchMessagePublished = true;
    }

    public String getReplicatorPrefix() {
        return this.replicatorPrefix;
    }

    @Override
    public CompletableFuture<Boolean> hasSchema() {
        String base = TopicName.get((String)this.getName()).getPartitionedTopicName();
        String id = TopicName.get((String)base).getSchemaName();
        return this.brokerService.pulsar().getSchemaRegistryService().getSchema(id).thenApply(Objects::nonNull);
    }

    @Override
    public CompletableFuture<SchemaVersion> addSchema(SchemaData schema) {
        if (schema == null) {
            return CompletableFuture.completedFuture(SchemaVersion.Empty);
        }
        String base = TopicName.get((String)this.getName()).getPartitionedTopicName();
        String id = TopicName.get((String)base).getSchemaName();
        SchemaRegistryService schemaRegistryService = this.brokerService.pulsar().getSchemaRegistryService();
        return this.isAllowAutoUpdateSchema ? schemaRegistryService.putSchemaIfAbsent(id, schema, this.schemaCompatibilityStrategy) : schemaRegistryService.trimDeletedSchemaAndGetList(id).thenCompose(schemaAndMetadataList -> schemaRegistryService.getSchemaVersionBySchemaData((List<SchemaRegistry.SchemaAndMetadata>)schemaAndMetadataList, schema).thenCompose(schemaVersion -> {
            if (schemaVersion == null) {
                return FutureUtil.failedFuture((Throwable)new IncompatibleSchemaException("Schema not found and schema auto updating is disabled."));
            }
            return CompletableFuture.completedFuture(schemaVersion);
        }));
    }

    @Override
    public CompletableFuture<SchemaVersion> deleteSchema() {
        String base = TopicName.get((String)this.getName()).getPartitionedTopicName();
        String id = TopicName.get((String)base).getSchemaName();
        SchemaRegistryService schemaRegistryService = this.brokerService.pulsar().getSchemaRegistryService();
        return schemaRegistryService.getSchema(id).thenCompose(schema -> {
            if (schema != null) {
                log.info("Delete schema storage of id: {}", (Object)id);
                return schemaRegistryService.deleteSchemaStorage(id);
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    @Override
    public CompletableFuture<Void> checkSchemaCompatibleForConsumer(SchemaData schema) {
        String base = TopicName.get((String)this.getName()).getPartitionedTopicName();
        String id = TopicName.get((String)base).getSchemaName();
        return this.brokerService.pulsar().getSchemaRegistryService().checkConsumerCompatibility(id, schema, this.schemaCompatibilityStrategy);
    }

    @Override
    public CompletableFuture<Optional<Long>> addProducer(Producer producer, CompletableFuture<Void> producerQueuedFuture) {
        Preconditions.checkArgument((producer.getTopic() == this ? 1 : 0) != 0);
        CompletableFuture<Optional<Long>> future = new CompletableFuture<Optional<Long>>();
        ((CompletableFuture)this.incrementTopicEpochIfNeeded(producer, producerQueuedFuture).thenAccept(producerEpoch -> {
            this.lock.writeLock().lock();
            try {
                this.brokerService.checkTopicNsOwnership(this.getName());
                this.checkTopicFenced();
                if (this.isTerminated()) {
                    log.warn("[{}] Attempting to add producer to a terminated topic", (Object)this.topic);
                    throw new BrokerServiceException.TopicTerminatedException("Topic was already terminated");
                }
                this.internalAddProducer(producer);
                USAGE_COUNT_UPDATER.incrementAndGet(this);
                if (log.isDebugEnabled()) {
                    log.debug("[{}] [{}] Added producer -- count: {}", new Object[]{this.topic, producer.getProducerName(), USAGE_COUNT_UPDATER.get(this)});
                }
                future.complete((Optional<Long>)producerEpoch);
            }
            catch (Throwable e) {
                future.completeExceptionally(e);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        })).exceptionally(ex -> {
            future.completeExceptionally((Throwable)ex);
            return null;
        });
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletableFuture<Optional<Long>> incrementTopicEpochIfNeeded(Producer producer, CompletableFuture<Void> producerQueuedFuture) {
        this.lock.writeLock().lock();
        try {
            switch (producer.getAccessMode()) {
                case Shared: {
                    if (this.hasExclusiveProducer || !this.waitingExclusiveProducers.isEmpty()) {
                        CompletableFuture completableFuture = FutureUtil.failedFuture((Throwable)new BrokerServiceException.ProducerBusyException("Topic has an existing exclusive producer: " + this.exclusiveProducerName));
                        return completableFuture;
                    }
                    CompletableFuture<Optional<Long>> completableFuture = CompletableFuture.completedFuture(this.topicEpoch);
                    return completableFuture;
                }
                case Exclusive: {
                    if (this.hasExclusiveProducer || !this.waitingExclusiveProducers.isEmpty()) {
                        CompletableFuture completableFuture = FutureUtil.failedFuture((Throwable)new BrokerServiceException.ProducerFencedException("Topic has an existing exclusive producer: " + this.exclusiveProducerName));
                        return completableFuture;
                    }
                    if (!this.producers.isEmpty()) {
                        CompletableFuture completableFuture = FutureUtil.failedFuture((Throwable)new BrokerServiceException.ProducerFencedException("Topic has existing shared producers"));
                        return completableFuture;
                    }
                    if (producer.getTopicEpoch().isPresent() && producer.getTopicEpoch().get() < this.topicEpoch.orElse(-1L)) {
                        CompletableFuture completableFuture = FutureUtil.failedFuture((Throwable)new BrokerServiceException.ProducerFencedException(String.format("Topic epoch has already moved. Current epoch: %d, Producer epoch: %d", this.topicEpoch.get(), producer.getTopicEpoch().get())));
                        return completableFuture;
                    }
                    this.hasExclusiveProducer = true;
                    this.exclusiveProducerName = producer.getProducerName();
                    CompletableFuture<Long> future = producer.getTopicEpoch().isPresent() ? this.setTopicEpoch(producer.getTopicEpoch().get()) : this.incrementTopicEpoch(this.topicEpoch);
                    future.exceptionally(ex -> {
                        this.hasExclusiveProducer = false;
                        this.exclusiveProducerName = null;
                        return null;
                    });
                    CompletionStage completionStage = future.thenApply(epoch -> {
                        this.topicEpoch = Optional.of(epoch);
                        return this.topicEpoch;
                    });
                    return completionStage;
                }
                case WaitForExclusive: {
                    if (this.hasExclusiveProducer || !this.producers.isEmpty()) {
                        CompletableFuture<Optional<Long>> future = new CompletableFuture<Optional<Long>>();
                        log.info("[{}] Queuing producer {} since there's already a producer", (Object)this.topic, (Object)producer);
                        this.waitingExclusiveProducers.add((Pair<Producer, CompletableFuture<Optional<Long>>>)Pair.of((Object)producer, future));
                        producerQueuedFuture.complete(null);
                        CompletableFuture<Optional<Long>> completableFuture = future;
                        return completableFuture;
                    }
                    if (producer.getTopicEpoch().isPresent() && producer.getTopicEpoch().get() < this.topicEpoch.orElse(-1L)) {
                        CompletableFuture future = FutureUtil.failedFuture((Throwable)new BrokerServiceException.ProducerFencedException(String.format("Topic epoch has already moved. Current epoch: %d, Producer epoch: %d", this.topicEpoch.get(), producer.getTopicEpoch().get())));
                        return future;
                    }
                    this.hasExclusiveProducer = true;
                    this.exclusiveProducerName = producer.getProducerName();
                    CompletableFuture<Long> future = producer.getTopicEpoch().isPresent() ? this.setTopicEpoch(producer.getTopicEpoch().get()) : this.incrementTopicEpoch(this.topicEpoch);
                    future.exceptionally(ex -> {
                        this.hasExclusiveProducer = false;
                        this.exclusiveProducerName = null;
                        return null;
                    });
                    CompletionStage completionStage = future.thenApply(epoch -> {
                        this.topicEpoch = Optional.of(epoch);
                        return this.topicEpoch;
                    });
                    return completionStage;
                }
            }
            CompletableFuture future = FutureUtil.failedFuture((Throwable)new BrokerServiceException("Invalid producer access mode: " + producer.getAccessMode()));
            return future;
        }
        catch (Exception e) {
            log.error("Encountered unexpected error during exclusive producer creation", (Throwable)e);
            CompletableFuture completableFuture = FutureUtil.failedFuture((Throwable)new BrokerServiceException(e));
            return completableFuture;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected abstract CompletableFuture<Long> setTopicEpoch(long var1);

    protected abstract CompletableFuture<Long> incrementTopicEpoch(Optional<Long> var1);

    @Override
    public void recordAddLatency(long latency, TimeUnit unit) {
        this.addEntryLatencyStatsUsec.addValue(unit.toMicros(latency));
        PUBLISH_LATENCY.observe(latency, unit);
    }

    protected void setSchemaCompatibilityStrategy(Policies policies) {
        this.schemaCompatibilityStrategy = policies.schema_compatibility_strategy == SchemaCompatibilityStrategy.UNDEFINED ? SchemaCompatibilityStrategy.fromAutoUpdatePolicy((SchemaAutoUpdateCompatibilityStrategy)policies.schema_auto_update_compatibility_strategy) : policies.schema_compatibility_strategy;
    }

    @Override
    public void checkTopicPublishThrottlingRate() {
        this.topicPublishRateLimiter.checkPublishRate();
    }

    @Override
    public void incrementPublishCount(int numOfMessages, long msgSizeInBytes) {
        this.topicPublishRateLimiter.incrementPublishCount(numOfMessages, msgSizeInBytes);
        this.getBrokerPublishRateLimiter().incrementPublishCount(numOfMessages, msgSizeInBytes);
        this.bytesInCounter.add(msgSizeInBytes);
        this.msgInCounter.add(numOfMessages);
    }

    @Override
    public void resetTopicPublishCountAndEnableReadIfRequired() {
        if (!this.getBrokerPublishRateLimiter().isPublishRateExceeded() && this.topicPublishRateLimiter.resetPublishCount()) {
            this.enableProducerReadForPublishRateLimiting();
        }
    }

    @Override
    public void resetBrokerPublishCountAndEnableReadIfRequired(boolean doneBrokerReset) {
        if (!this.topicPublishRateLimiter.isPublishRateExceeded() && doneBrokerReset) {
            this.enableProducerReadForPublishRateLimiting();
        }
    }

    protected void enableProducerReadForPublishRateLimiting() {
        if (this.producers != null) {
            this.producers.values().forEach(producer -> {
                producer.getCnx().cancelPublishRateLimiting();
                producer.getCnx().enableCnxAutoRead();
            });
        }
    }

    protected void enableProducerReadForPublishBufferLimiting() {
        if (this.producers != null) {
            this.producers.values().forEach(producer -> {
                producer.getCnx().cancelPublishBufferLimiting();
                producer.getCnx().enableCnxAutoRead();
            });
        }
    }

    protected void disableProducerRead() {
        if (this.producers != null) {
            this.producers.values().forEach(producer -> producer.getCnx().disableCnxAutoRead());
        }
    }

    protected void checkTopicFenced() throws BrokerServiceException {
        if (this.isFenced) {
            log.warn("[{}] Attempting to add producer to a fenced topic", (Object)this.topic);
            throw new BrokerServiceException.TopicFencedException("Topic is temporarily unavailable");
        }
    }

    protected void internalAddProducer(Producer producer) throws BrokerServiceException {
        Producer existProducer;
        if (this.isProducersExceeded()) {
            log.warn("[{}] Attempting to add producer to topic which reached max producers limit", (Object)this.topic);
            throw new BrokerServiceException.ProducerBusyException("Topic reached max producers limit");
        }
        if (this.isSameAddressProducersExceeded(producer)) {
            log.warn("[{}] Attempting to add producer to topic which reached max same address producers limit", (Object)this.topic);
            throw new BrokerServiceException.ProducerBusyException("Topic reached max same address producers limit");
        }
        if (log.isDebugEnabled()) {
            log.debug("[{}] {} Got request to create producer ", (Object)this.topic, (Object)producer.getProducerName());
        }
        if ((existProducer = this.producers.putIfAbsent(producer.getProducerName(), producer)) != null) {
            this.tryOverwriteOldProducer(existProducer, producer);
        }
    }

    private void tryOverwriteOldProducer(Producer oldProducer, Producer newProducer) throws BrokerServiceException {
        boolean canOverwrite = false;
        if (oldProducer.equals(newProducer) && !this.isUserProvidedProducerName(oldProducer) && !this.isUserProvidedProducerName(newProducer) && newProducer.getEpoch() > oldProducer.getEpoch()) {
            oldProducer.close(false);
            canOverwrite = true;
        }
        if (canOverwrite) {
            if (!this.producers.replace(newProducer.getProducerName(), oldProducer, newProducer)) {
                throw new BrokerServiceException.NamingException("Producer with name '" + newProducer.getProducerName() + "' replace concurrency error");
            }
        } else {
            throw new BrokerServiceException.NamingException("Producer with name '" + newProducer.getProducerName() + "' is already connected to topic");
        }
        this.handleProducerRemoved(oldProducer);
    }

    private boolean isUserProvidedProducerName(Producer producer) {
        return producer.isUserProvidedProducerName() && !producer.getProducerName().startsWith(this.replicatorPrefix);
    }

    @Override
    public void removeProducer(Producer producer) {
        Preconditions.checkArgument((producer.getTopic() == this ? 1 : 0) != 0);
        if (this.producers.remove(producer.getProducerName(), producer)) {
            this.handleProducerRemoved(producer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleProducerRemoved(Producer producer) {
        USAGE_COUNT_UPDATER.decrementAndGet(this);
        if (this.hasExclusiveProducer) {
            this.lock.writeLock().lock();
            try {
                this.hasExclusiveProducer = false;
                this.exclusiveProducerName = null;
                Pair<Producer, CompletableFuture<Optional<Long>>> nextWaitingProducer = this.waitingExclusiveProducers.poll();
                if (nextWaitingProducer != null) {
                    Producer nextProducer = (Producer)nextWaitingProducer.getKey();
                    CompletableFuture producerFuture = (CompletableFuture)nextWaitingProducer.getValue();
                    this.hasExclusiveProducer = true;
                    this.exclusiveProducerName = nextProducer.getProducerName();
                    CompletableFuture<Long> future = nextProducer.getTopicEpoch().isPresent() ? this.setTopicEpoch(nextProducer.getTopicEpoch().get()) : this.incrementTopicEpoch(this.topicEpoch);
                    ((CompletableFuture)future.thenAccept(epoch -> {
                        this.topicEpoch = Optional.of(epoch);
                        producerFuture.complete(this.topicEpoch);
                    })).exceptionally(ex -> {
                        this.hasExclusiveProducer = false;
                        this.exclusiveProducerName = null;
                        producerFuture.completeExceptionally((Throwable)ex);
                        return null;
                    });
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("[{}] [{}] Removed producer -- count: {}", new Object[]{this.topic, producer.getProducerName(), USAGE_COUNT_UPDATER.get(this)});
        }
        this.lastActive = System.nanoTime();
    }

    public void handleConsumerAdded(String subscriptionName, String consumerName) {
        USAGE_COUNT_UPDATER.incrementAndGet(this);
        if (log.isDebugEnabled()) {
            log.debug("[{}] [{}] [{}] Added consumer -- count: {}", new Object[]{this.topic, subscriptionName, consumerName, USAGE_COUNT_UPDATER.get(this)});
        }
    }

    public void decrementUsageCount() {
        USAGE_COUNT_UPDATER.decrementAndGet(this);
    }

    public long currentUsageCount() {
        return this.usageCount;
    }

    @Override
    public boolean isPublishRateExceeded() {
        return this.topicPublishRateLimiter.isPublishRateExceeded() || this.getBrokerPublishRateLimiter().isPublishRateExceeded();
    }

    @Override
    public boolean isTopicPublishRateExceeded(int numberMessages, int bytes) {
        return this.preciseTopicPublishRateLimitingEnable && !this.topicPublishRateLimiter.tryAcquire(numberMessages, bytes);
    }

    @Override
    public boolean isBrokerPublishRateExceeded() {
        return this.getBrokerPublishRateLimiter().isPublishRateExceeded();
    }

    public PublishRateLimiter getTopicPublishRateLimiter() {
        return this.topicPublishRateLimiter;
    }

    public PublishRateLimiter getBrokerPublishRateLimiter() {
        return this.brokerService.getBrokerPublishRateLimiter();
    }

    public void updateMaxPublishRate(Policies policies) {
        this.updatePublishDispatcher(policies);
    }

    private void updatePublishDispatcher(Policies policies) {
        Optional<PublishRate> topicPublishRate = this.getTopicPolicies().map(TopicPolicies::getPublishRate);
        if (topicPublishRate.isPresent()) {
            log.info("Using topic policy publish rate instead of namespace level topic publish rate on topic {}", (Object)this.topic);
            this.updatePublishDispatcher(topicPublishRate.get());
            return;
        }
        String clusterName = this.brokerService.pulsar().getConfiguration().getClusterName();
        PublishRate publishRate = policies != null && policies.publishMaxMessageRate != null ? (PublishRate)policies.publishMaxMessageRate.get(clusterName) : null;
        ServiceConfiguration serviceConfiguration = this.brokerService.pulsar().getConfiguration();
        if (publishRate == null) {
            PublishRate brokerPublishRate = new PublishRate(serviceConfiguration.getMaxPublishRatePerTopicInMessages(), serviceConfiguration.getMaxPublishRatePerTopicInBytes());
            this.updatePublishDispatcher(brokerPublishRate);
            return;
        }
        this.updatePublishDispatcher(publishRate);
    }

    public long getMsgInCounter() {
        return this.msgInCounter.longValue();
    }

    public long getBytesInCounter() {
        return this.bytesInCounter.longValue();
    }

    public long getMsgOutCounter() {
        return this.getStats((boolean)false, (boolean)false).msgOutCounter;
    }

    public long getBytesOutCounter() {
        return this.getStats((boolean)false, (boolean)false).bytesOutCounter;
    }

    public boolean isDeleteWhileInactive() {
        return this.inactiveTopicPolicies.isDeleteWhileInactive();
    }

    public boolean deletePartitionedTopicMetadataWhileInactive() {
        return this.brokerService.pulsar().getConfiguration().isBrokerDeleteInactivePartitionedTopicMetadataEnabled();
    }

    public void setDeleteWhileInactive(boolean deleteWhileInactive) {
        this.inactiveTopicPolicies.setDeleteWhileInactive(deleteWhileInactive);
    }

    protected abstract boolean isTerminated();

    public InactiveTopicPolicies getInactiveTopicPolicies() {
        return this.inactiveTopicPolicies;
    }

    public void resetInactiveTopicPolicies(InactiveTopicDeleteMode inactiveTopicDeleteMode, int maxInactiveDurationSeconds, boolean deleteWhileInactive) {
        this.inactiveTopicPolicies.setInactiveTopicDeleteMode(inactiveTopicDeleteMode);
        this.inactiveTopicPolicies.setMaxInactiveDurationSeconds(maxInactiveDurationSeconds);
        this.inactiveTopicPolicies.setDeleteWhileInactive(deleteWhileInactive);
    }

    public Optional<TopicPolicies> getTopicPolicies() {
        return this.brokerService.getTopicPolicies(TopicName.get((String)this.topic));
    }

    protected int getWaitingProducersCount() {
        return this.waitingExclusiveProducers.size();
    }

    protected boolean isExceedMaximumMessageSize(int size) {
        return this.getTopicPolicies().map(TopicPolicies::getMaxMessageSize).map(maxMessageSize -> {
            if (maxMessageSize == 0) {
                return false;
            }
            return size > maxMessageSize;
        }).orElse(false);
    }

    protected void updatePublishDispatcher(PublishRate publishRate) {
        if (publishRate != null && (publishRate.publishThrottlingRateInByte > 0L || publishRate.publishThrottlingRateInMsg > 0)) {
            log.info("Enabling publish rate limiting {} ", (Object)publishRate);
            if (!this.preciseTopicPublishRateLimitingEnable) {
                this.brokerService.setupTopicPublishRateLimiterMonitor();
            }
            if (this.topicPublishRateLimiter == null || this.topicPublishRateLimiter == PublishRateLimiter.DISABLED_RATE_LIMITER) {
                this.topicPublishRateLimiter = this.preciseTopicPublishRateLimitingEnable ? new PrecisPublishLimiter(publishRate, () -> this.enableCnxAutoRead()) : new PublishRateLimiterImpl(publishRate);
            } else {
                this.topicPublishRateLimiter.update(publishRate);
            }
        } else {
            log.info("Disabling publish throttling for {}", (Object)this.topic);
            this.topicPublishRateLimiter = PublishRateLimiter.DISABLED_RATE_LIMITER;
            this.enableProducerReadForPublishRateLimiting();
        }
    }
}

