/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.mledger.Position;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.Producer;
import org.apache.pulsar.broker.service.Replicator;
import org.apache.pulsar.broker.service.Subscription;
import org.apache.pulsar.broker.service.TransportCnx;
import org.apache.pulsar.broker.service.persistent.DispatchRateLimiter;
import org.apache.pulsar.broker.stats.ClusterReplicationMetrics;
import org.apache.pulsar.broker.stats.NamespaceStats;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.transaction.TxnID;
import org.apache.pulsar.common.api.proto.CommandSubscribe;
import org.apache.pulsar.common.api.proto.KeySharedMeta;
import org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.common.policies.data.PersistentTopicInternalStats;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.policies.data.stats.TopicStatsImpl;
import org.apache.pulsar.common.protocol.schema.SchemaData;
import org.apache.pulsar.common.protocol.schema.SchemaVersion;
import org.apache.pulsar.common.util.collections.ConcurrentOpenHashMap;
import org.apache.pulsar.policies.data.loadbalancer.NamespaceBundleStats;
import org.apache.pulsar.utils.StatsOutputStream;

public interface Topic {
    public void publishMessage(ByteBuf var1, PublishContext var2);

    public CompletableFuture<Optional<Long>> addProducer(Producer var1, CompletableFuture<Void> var2);

    public void removeProducer(Producer var1);

    public void recordAddLatency(long var1, TimeUnit var3);

    public CompletableFuture<Consumer> subscribe(TransportCnx var1, String var2, long var3, CommandSubscribe.SubType var5, int var6, String var7, boolean var8, MessageId var9, Map<String, String> var10, boolean var11, CommandSubscribe.InitialPosition var12, long var13, boolean var15, KeySharedMeta var16);

    public CompletableFuture<Subscription> createSubscription(String var1, CommandSubscribe.InitialPosition var2, boolean var3);

    public CompletableFuture<Void> unsubscribe(String var1);

    public ConcurrentOpenHashMap<String, ? extends Subscription> getSubscriptions();

    public CompletableFuture<Void> delete();

    public Map<String, Producer> getProducers();

    public String getName();

    public CompletableFuture<Void> checkReplication();

    public CompletableFuture<Void> close(boolean var1);

    public void checkGC();

    public void checkInactiveSubscriptions();

    public void checkBackloggedCursors();

    public void checkDeduplicationSnapshot();

    public void checkMessageExpiry();

    public void checkMessageDeduplicationInfo();

    public void checkTopicPublishThrottlingRate();

    public void incrementPublishCount(int var1, long var2);

    public void resetTopicPublishCountAndEnableReadIfRequired();

    public void resetBrokerPublishCountAndEnableReadIfRequired(boolean var1);

    public boolean isPublishRateExceeded();

    public boolean isTopicPublishRateExceeded(int var1, int var2);

    public boolean isBrokerPublishRateExceeded();

    public void disableCnxAutoRead();

    public void enableCnxAutoRead();

    public CompletableFuture<Void> onPoliciesUpdate(Policies var1);

    public boolean isBacklogQuotaExceeded(String var1);

    public boolean isEncryptionRequired();

    public boolean getSchemaValidationEnforced();

    public boolean isReplicated();

    public BacklogQuota getBacklogQuota();

    public void updateRates(NamespaceStats var1, NamespaceBundleStats var2, StatsOutputStream var3, ClusterReplicationMetrics var4, String var5, boolean var6);

    public Subscription getSubscription(String var1);

    public ConcurrentOpenHashMap<String, ? extends Replicator> getReplicators();

    public TopicStatsImpl getStats(boolean var1, boolean var2);

    public CompletableFuture<PersistentTopicInternalStats> getInternalStats(boolean var1);

    public Position getLastPosition();

    public CompletableFuture<MessageId> getLastMessageId();

    public CompletableFuture<Boolean> hasSchema();

    public CompletableFuture<SchemaVersion> addSchema(SchemaData var1);

    public CompletableFuture<SchemaVersion> deleteSchema();

    public CompletableFuture<Void> checkSchemaCompatibleForConsumer(SchemaData var1);

    public CompletableFuture<Void> addSchemaIfIdleOrCheckCompatible(SchemaData var1);

    public CompletableFuture<Void> deleteForcefully();

    default public Optional<DispatchRateLimiter> getDispatchRateLimiter() {
        return Optional.empty();
    }

    default public boolean isSystemTopic() {
        return false;
    }

    public void publishTxnMessage(TxnID var1, ByteBuf var2, PublishContext var3);

    public CompletableFuture<Void> endTxn(TxnID var1, int var2, long var3);

    public CompletableFuture<Void> truncate();

    public static interface PublishContext {
        default public String getProducerName() {
            return null;
        }

        default public long getSequenceId() {
            return -1L;
        }

        default public void setOriginalProducerName(String originalProducerName) {
        }

        default public void setOriginalSequenceId(long originalSequenceId) {
        }

        default public String getOriginalProducerName() {
            return null;
        }

        default public long getOriginalSequenceId() {
            return -1L;
        }

        public void completed(Exception var1, long var2, long var4);

        default public void setMetadataFromEntryData(ByteBuf entryData) {
        }

        default public long getHighestSequenceId() {
            return -1L;
        }

        default public void setOriginalHighestSequenceId(long originalHighestSequenceId) {
        }

        default public long getOriginalHighestSequenceId() {
            return -1L;
        }

        default public long getNumberOfMessages() {
            return 1L;
        }
    }
}

