/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.persistent;

import com.carrotsearch.hppc.ObjectObjectHashMap;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import io.netty.util.concurrent.FastThreadLocal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.ManagedLedger;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.impl.ManagedCursorContainer;
import org.apache.bookkeeper.mledger.impl.ManagedCursorImpl;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.bookkeeper.mledger.proto.MLDataFormats;
import org.apache.bookkeeper.net.BookieId;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.admin.AdminResource;
import org.apache.pulsar.broker.resources.NamespaceResources;
import org.apache.pulsar.broker.service.AbstractTopic;
import org.apache.pulsar.broker.service.BrokerService;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.Dispatcher;
import org.apache.pulsar.broker.service.Producer;
import org.apache.pulsar.broker.service.Replicator;
import org.apache.pulsar.broker.service.StreamingStats;
import org.apache.pulsar.broker.service.Subscription;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.broker.service.TopicPolicyListener;
import org.apache.pulsar.broker.service.TransportCnx;
import org.apache.pulsar.broker.service.persistent.CompactorSubscription;
import org.apache.pulsar.broker.service.persistent.DispatchRateLimiter;
import org.apache.pulsar.broker.service.persistent.MessageDeduplication;
import org.apache.pulsar.broker.service.persistent.PersistentDispatcherMultipleConsumers;
import org.apache.pulsar.broker.service.persistent.PersistentDispatcherSingleActiveConsumer;
import org.apache.pulsar.broker.service.persistent.PersistentReplicator;
import org.apache.pulsar.broker.service.persistent.PersistentSubscription;
import org.apache.pulsar.broker.service.persistent.ReplicatedSubscriptionsController;
import org.apache.pulsar.broker.service.persistent.SubscribeRateLimiter;
import org.apache.pulsar.broker.service.schema.BookkeeperSchemaStorage;
import org.apache.pulsar.broker.stats.ClusterReplicationMetrics;
import org.apache.pulsar.broker.stats.NamespaceStats;
import org.apache.pulsar.broker.stats.ReplicationMetrics;
import org.apache.pulsar.broker.transaction.buffer.TransactionBuffer;
import org.apache.pulsar.broker.transaction.buffer.impl.TransactionBufferDisable;
import org.apache.pulsar.client.admin.LongRunningProcessStatus;
import org.apache.pulsar.client.admin.OffloadProcessStatus;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.transaction.TxnID;
import org.apache.pulsar.client.impl.BatchMessageIdImpl;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.client.impl.MessageImpl;
import org.apache.pulsar.common.api.proto.CommandSubscribe;
import org.apache.pulsar.common.api.proto.KeySharedMeta;
import org.apache.pulsar.common.api.proto.MessageMetadata;
import org.apache.pulsar.common.events.EventsTopicNames;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.common.policies.data.DispatchRate;
import org.apache.pulsar.common.policies.data.InactiveTopicDeleteMode;
import org.apache.pulsar.common.policies.data.ManagedLedgerInternalStats;
import org.apache.pulsar.common.policies.data.PersistentTopicInternalStats;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.policies.data.RetentionPolicies;
import org.apache.pulsar.common.policies.data.TopicPolicies;
import org.apache.pulsar.common.policies.data.TransactionBufferStats;
import org.apache.pulsar.common.policies.data.TransactionInBufferStats;
import org.apache.pulsar.common.policies.data.TransactionInPendingAckStats;
import org.apache.pulsar.common.policies.data.TransactionPendingAckStats;
import org.apache.pulsar.common.policies.data.stats.ConsumerStatsImpl;
import org.apache.pulsar.common.policies.data.stats.PublisherStatsImpl;
import org.apache.pulsar.common.policies.data.stats.ReplicatorStatsImpl;
import org.apache.pulsar.common.policies.data.stats.SubscriptionStatsImpl;
import org.apache.pulsar.common.policies.data.stats.TopicStatsImpl;
import org.apache.pulsar.common.protocol.Commands;
import org.apache.pulsar.common.protocol.schema.SchemaData;
import org.apache.pulsar.common.protocol.schema.SchemaVersion;
import org.apache.pulsar.common.util.Codec;
import org.apache.pulsar.common.util.DateFormatter;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.common.util.collections.ConcurrentOpenHashMap;
import org.apache.pulsar.compaction.CompactedTopic;
import org.apache.pulsar.compaction.CompactedTopicImpl;
import org.apache.pulsar.policies.data.loadbalancer.NamespaceBundleStats;
import org.apache.pulsar.utils.StatsOutputStream;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentTopic
extends AbstractTopic
implements Topic,
AsyncCallbacks.AddEntryCallback,
TopicPolicyListener<TopicPolicies> {
    protected final ManagedLedger ledger;
    private final ConcurrentOpenHashMap<String, PersistentSubscription> subscriptions;
    private final ConcurrentOpenHashMap<String, Replicator> replicators;
    static final String DEDUPLICATION_CURSOR_NAME = "pulsar.dedup";
    private static final String TOPIC_EPOCH_PROPERTY_NAME = "pulsar.topic.epoch";
    private static final double MESSAGE_EXPIRY_THRESHOLD = 1.5;
    private static final long POLICY_UPDATE_FAILURE_RETRY_TIME_SECONDS = 60L;
    public boolean msgChunkPublished;
    private Optional<DispatchRateLimiter> dispatchRateLimiter = Optional.empty();
    private Optional<SubscribeRateLimiter> subscribeRateLimiter = Optional.empty();
    public volatile long delayedDeliveryTickTimeMillis = 1000L;
    private final long backloggedCursorThresholdEntries;
    public volatile boolean delayedDeliveryEnabled = false;
    public static final int MESSAGE_RATE_BACKOFF_MS = 1000;
    protected final MessageDeduplication messageDeduplication;
    private static final long COMPACTION_NEVER_RUN = -4273917950L;
    private CompletableFuture<Long> currentCompaction = CompletableFuture.completedFuture(-4273917950L);
    private final CompactedTopic compactedTopic;
    private CompletableFuture<MessageIdImpl> currentOffload = CompletableFuture.completedFuture((MessageIdImpl)MessageId.earliest);
    private volatile Optional<ReplicatedSubscriptionsController> replicatedSubscriptionsController = Optional.empty();
    private static final FastThreadLocal<TopicStatsHelper> threadLocalTopicStats = new FastThreadLocal<TopicStatsHelper>(){

        protected TopicStatsHelper initialValue() {
            return new TopicStatsHelper();
        }
    };
    private final AtomicLong pendingWriteOps = new AtomicLong(0L);
    private volatile double lastUpdatedAvgPublishRateInMsg = 0.0;
    private volatile double lastUpdatedAvgPublishRateInByte = 0.0;
    private volatile int maxUnackedMessagesOnSubscriptionApplied;
    private volatile boolean isClosingOrDeleting = false;
    private ScheduledFuture<?> fencedTopicMonitoringTask = null;
    private volatile CompletableFuture<Void> transactionCompletableFuture;
    protected final TransactionBuffer transactionBuffer;
    private final LongAdder bytesOutFromRemovedSubscriptions = new LongAdder();
    private final LongAdder msgOutFromRemovedSubscriptions = new LongAdder();
    private static final Logger log = LoggerFactory.getLogger(PersistentTopic.class);

    public PersistentTopic(String topic, ManagedLedger ledger, BrokerService brokerService) throws BrokerServiceException.NamingException {
        super(topic, brokerService);
        this.ledger = ledger;
        this.subscriptions = new ConcurrentOpenHashMap(16, 1);
        this.replicators = new ConcurrentOpenHashMap(16, 1);
        this.delayedDeliveryEnabled = brokerService.pulsar().getConfiguration().isDelayedDeliveryEnabled();
        this.delayedDeliveryTickTimeMillis = brokerService.pulsar().getConfiguration().getDelayedDeliveryTickTimeMillis();
        this.backloggedCursorThresholdEntries = brokerService.pulsar().getConfiguration().getManagedLedgerCursorBackloggedThreshold();
        this.transactionCompletableFuture = new CompletableFuture();
        this.initializeDispatchRateLimiterIfNeeded(Optional.empty());
        this.registerTopicPolicyListener();
        this.compactedTopic = new CompactedTopicImpl(brokerService.pulsar().getBookKeeperClient());
        for (ManagedCursor cursor : ledger.getCursors()) {
            if (cursor.getName().startsWith(this.replicatorPrefix)) {
                String localCluster = brokerService.pulsar().getConfiguration().getClusterName();
                String remoteCluster = PersistentReplicator.getRemoteCluster(cursor.getName());
                boolean isReplicatorStarted = false;
                try {
                    isReplicatorStarted = this.addReplicationCluster(remoteCluster, cursor, localCluster);
                }
                catch (Exception e) {
                    log.warn("[{}] failed to start replication", (Object)topic, (Object)e);
                }
                if (isReplicatorStarted) continue;
                throw new BrokerServiceException.NamingException(this.getName() + " Failed to start replicator " + remoteCluster);
            }
            if (cursor.getName().equals(DEDUPLICATION_CURSOR_NAME)) continue;
            String subscriptionName = Codec.decode((String)cursor.getName());
            this.subscriptions.put((Object)subscriptionName, (Object)this.createPersistentSubscription(subscriptionName, cursor, PersistentSubscription.isCursorFromReplicatedSubscription(cursor)));
            ((PersistentSubscription)this.subscriptions.get((Object)subscriptionName)).deactivateCursor();
        }
        this.messageDeduplication = new MessageDeduplication(brokerService.pulsar(), this, ledger);
        try {
            Policies policies = (Policies)brokerService.pulsar().getConfigurationCache().policiesCache().get(AdminResource.path("policies", TopicName.get((String)topic).getNamespace())).orElseThrow(() -> new KeeperException.NoNodeException());
            this.isEncryptionRequired = policies.encryption_required;
            this.setSchemaCompatibilityStrategy(policies);
            this.isAllowAutoUpdateSchema = policies.is_allow_auto_update_schema;
            this.schemaValidationEnforced = policies.schema_validation_enforced;
            if (policies.inactive_topic_policies != null) {
                this.inactiveTopicPolicies = policies.inactive_topic_policies;
            }
            this.updateUnackedMessagesAppliedOnSubscription(policies);
            this.updateUnackedMessagesExceededOnConsumer(policies);
        }
        catch (Exception e) {
            log.warn("[{}] Error getting policies {} and isEncryptionRequired will be set to false", (Object)topic, (Object)e.getMessage());
            this.isEncryptionRequired = false;
            this.updateUnackedMessagesAppliedOnSubscription(null);
            this.updateUnackedMessagesExceededOnConsumer(null);
        }
        if (ledger.getProperties().containsKey(TOPIC_EPOCH_PROPERTY_NAME)) {
            this.topicEpoch = Optional.of(Long.parseLong((String)ledger.getProperties().get(TOPIC_EPOCH_PROPERTY_NAME)));
        }
        this.checkReplicatedSubscriptionControllerState();
        TopicName topicName = TopicName.get((String)topic);
        if (!(!brokerService.getPulsar().getConfiguration().isTransactionCoordinatorEnabled() || EventsTopicNames.checkTopicIsEventsNames((TopicName)topicName) || topicName.getEncodedLocalName().startsWith(TopicName.TRANSACTION_COORDINATOR_ASSIGN.getLocalName()) || topicName.getEncodedLocalName().startsWith("__transaction_log_") || topicName.getEncodedLocalName().endsWith("__transaction_pending_ack"))) {
            this.transactionBuffer = brokerService.getPulsar().getTransactionBufferProvider().newTransactionBuffer(this, this.transactionCompletableFuture);
        } else {
            this.transactionCompletableFuture.complete(null);
            this.transactionBuffer = new TransactionBufferDisable();
        }
        this.transactionBuffer.syncMaxReadPositionForNormalPublish((PositionImpl)ledger.getLastConfirmedEntry());
    }

    @VisibleForTesting
    PersistentTopic(String topic, BrokerService brokerService, ManagedLedger ledger, MessageDeduplication messageDeduplication) {
        super(topic, brokerService);
        this.ledger = ledger;
        this.messageDeduplication = messageDeduplication;
        this.subscriptions = new ConcurrentOpenHashMap(16, 1);
        this.replicators = new ConcurrentOpenHashMap(16, 1);
        this.compactedTopic = new CompactedTopicImpl(brokerService.pulsar().getBookKeeperClient());
        this.backloggedCursorThresholdEntries = brokerService.pulsar().getConfiguration().getManagedLedgerCursorBackloggedThreshold();
        this.transactionCompletableFuture = new CompletableFuture();
        if (brokerService.pulsar().getConfiguration().isTransactionCoordinatorEnabled()) {
            this.transactionBuffer = brokerService.getPulsar().getTransactionBufferProvider().newTransactionBuffer(this, this.transactionCompletableFuture);
        } else {
            this.transactionCompletableFuture.complete(null);
            this.transactionBuffer = new TransactionBufferDisable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeDispatchRateLimiterIfNeeded(Optional<Policies> policies) {
        Optional<DispatchRateLimiter> optional = this.dispatchRateLimiter;
        synchronized (optional) {
            if (!this.dispatchRateLimiter.isPresent() && DispatchRateLimiter.isDispatchRateNeeded(this.brokerService, policies, this.topic, DispatchRateLimiter.Type.TOPIC)) {
                this.dispatchRateLimiter = Optional.of(new DispatchRateLimiter(this, DispatchRateLimiter.Type.TOPIC));
            }
            if (!this.subscribeRateLimiter.isPresent() && SubscribeRateLimiter.isDispatchRateNeeded(this.brokerService, policies, this.topic)) {
                this.subscribeRateLimiter = Optional.of(new SubscribeRateLimiter(this));
            }
            this.subscriptions.forEach((name, subscription) -> {
                Dispatcher dispatcher = subscription.getDispatcher();
                if (dispatcher != null) {
                    dispatcher.initializeDispatchRateLimiterIfNeeded(policies);
                }
            });
            this.replicators.forEach((name, replicator) -> replicator.initializeDispatchRateLimiterIfNeeded(policies));
        }
    }

    private PersistentSubscription createPersistentSubscription(String subscriptionName, ManagedCursor cursor, boolean replicated) {
        Preconditions.checkNotNull((Object)this.compactedTopic);
        if (subscriptionName.equals("__compaction")) {
            return new CompactorSubscription(this, this.compactedTopic, subscriptionName, cursor);
        }
        return new PersistentSubscription(this, subscriptionName, cursor, replicated);
    }

    @Override
    public void publishMessage(ByteBuf headersAndPayload, Topic.PublishContext publishContext) {
        this.pendingWriteOps.incrementAndGet();
        if (this.isFenced) {
            publishContext.completed(new BrokerServiceException.TopicFencedException("fenced"), -1L, -1L);
            this.decrementPendingWriteOpsAndCheck();
            return;
        }
        if (this.isExceedMaximumMessageSize(headersAndPayload.readableBytes())) {
            publishContext.completed(new BrokerServiceException.NotAllowedException("Exceed maximum message size"), -1L, -1L);
            this.decrementPendingWriteOpsAndCheck();
            return;
        }
        MessageDeduplication.MessageDupStatus status = this.messageDeduplication.isDuplicate(publishContext, headersAndPayload);
        switch (status) {
            case NotDup: {
                this.asyncAddEntry(headersAndPayload, publishContext);
                break;
            }
            case Dup: {
                publishContext.completed(null, -1L, -1L);
                this.decrementPendingWriteOpsAndCheck();
                break;
            }
            default: {
                publishContext.completed(new MessageDeduplication.MessageDupUnknownException(), -1L, -1L);
                this.decrementPendingWriteOpsAndCheck();
            }
        }
    }

    private void asyncAddEntry(ByteBuf headersAndPayload, Topic.PublishContext publishContext) {
        if (this.brokerService.isBrokerEntryMetadataEnabled()) {
            this.ledger.asyncAddEntry(headersAndPayload, (int)publishContext.getNumberOfMessages(), (AsyncCallbacks.AddEntryCallback)this, (Object)publishContext);
        } else {
            this.ledger.asyncAddEntry(headersAndPayload, (AsyncCallbacks.AddEntryCallback)this, (Object)publishContext);
        }
    }

    public void asyncReadEntry(PositionImpl position, AsyncCallbacks.ReadEntryCallback callback, Object ctx) {
        if (this.ledger instanceof ManagedLedgerImpl) {
            ((ManagedLedgerImpl)this.ledger).asyncReadEntry(position, callback, ctx);
        } else {
            callback.readEntryFailed(new ManagedLedgerException("Unexpected managedledger implementation, doesn't support direct read entry operation."), ctx);
        }
    }

    public PositionImpl getPositionAfterN(PositionImpl startPosition, long n) throws ManagedLedgerException {
        if (this.ledger instanceof ManagedLedgerImpl) {
            return ((ManagedLedgerImpl)this.ledger).getPositionAfterN(startPosition, n, ManagedLedgerImpl.PositionBound.startExcluded);
        }
        throw new ManagedLedgerException("Unexpected managedledger implementation, doesn't support getPositionAfterN operation.");
    }

    public PositionImpl getFirstPosition() throws ManagedLedgerException {
        if (this.ledger instanceof ManagedLedgerImpl) {
            return ((ManagedLedgerImpl)this.ledger).getFirstPosition();
        }
        throw new ManagedLedgerException("Unexpected managedledger implementation, doesn't support getFirstPosition operation.");
    }

    public long getNumberOfEntries() {
        return this.ledger.getNumberOfEntries();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementPendingWriteOpsAndCheck() {
        long pending = this.pendingWriteOps.decrementAndGet();
        if (pending == 0L && this.isFenced && !this.isClosingOrDeleting) {
            PersistentTopic persistentTopic = this;
            synchronized (persistentTopic) {
                if (this.isFenced && !this.isClosingOrDeleting) {
                    this.messageDeduplication.resetHighestSequenceIdPushed();
                    log.info("[{}] Un-fencing topic...", (Object)this.topic);
                    this.ledger.readyToCreateNewLedger();
                    this.unfence();
                }
            }
        }
    }

    public void addComplete(Position pos, ByteBuf entryData, Object ctx) {
        Topic.PublishContext publishContext = (Topic.PublishContext)ctx;
        PositionImpl position = (PositionImpl)pos;
        this.messageDeduplication.recordMessagePersisted(publishContext, position);
        publishContext.setMetadataFromEntryData(entryData);
        publishContext.completed(null, position.getLedgerId(), position.getEntryId());
        this.transactionBuffer.syncMaxReadPositionForNormalPublish((PositionImpl)this.ledger.getLastConfirmedEntry());
        this.decrementPendingWriteOpsAndCheck();
    }

    public synchronized void addFailed(ManagedLedgerException exception, Object ctx) {
        if (exception instanceof ManagedLedgerException.ManagedLedgerFencedException) {
            this.close();
        } else {
            this.fence();
            ArrayList futures = Lists.newArrayList();
            this.producers.values().forEach(producer -> futures.add(producer.disconnect()));
            FutureUtil.waitForAll((List)futures).handle((aVoid, throwable) -> {
                this.decrementPendingWriteOpsAndCheck();
                return null;
            });
            Topic.PublishContext callback = (Topic.PublishContext)ctx;
            if (exception instanceof ManagedLedgerException.ManagedLedgerAlreadyClosedException) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Failed to persist msg in store: {}", (Object)this.topic, (Object)exception.getMessage());
                }
                callback.completed(new BrokerServiceException.TopicClosedException(exception), -1L, -1L);
                return;
            }
            log.warn("[{}] Failed to persist msg in store: {}", (Object)this.topic, (Object)exception.getMessage());
            if (exception instanceof ManagedLedgerException.ManagedLedgerTerminatedException) {
                callback.completed(new BrokerServiceException.TopicTerminatedException(exception), -1L, -1L);
            } else {
                callback.completed(new BrokerServiceException.PersistenceException(exception), -1L, -1L);
            }
        }
    }

    @Override
    public CompletableFuture<Optional<Long>> addProducer(Producer producer, CompletableFuture<Void> producerQueuedFuture) {
        return super.addProducer(producer, producerQueuedFuture).thenApply(topicEpoch -> {
            this.messageDeduplication.producerAdded(producer.getProducerName());
            this.startReplProducers();
            return topicEpoch;
        });
    }

    @Override
    protected CompletableFuture<Long> incrementTopicEpoch(Optional<Long> currentEpoch) {
        long newEpoch = currentEpoch.orElse(-1L) + 1L;
        return this.setTopicEpoch(newEpoch);
    }

    @Override
    protected CompletableFuture<Long> setTopicEpoch(final long newEpoch) {
        final CompletableFuture<Long> future = new CompletableFuture<Long>();
        this.ledger.asyncSetProperty(TOPIC_EPOCH_PROPERTY_NAME, String.valueOf(newEpoch), new AsyncCallbacks.UpdatePropertiesCallback(){

            public void updatePropertiesComplete(Map<String, String> properties, Object ctx) {
                log.info("[{}] Updated topic epoch to {}", (Object)PersistentTopic.this.getName(), (Object)newEpoch);
                future.complete(newEpoch);
            }

            public void updatePropertiesFailed(ManagedLedgerException exception, Object ctx) {
                log.warn("[{}] Failed to update topic epoch to {}: {}", new Object[]{PersistentTopic.this.getName(), newEpoch, exception.getMessage()});
                future.completeExceptionally(exception);
            }
        }, null);
        return future;
    }

    private boolean hasRemoteProducers() {
        AtomicBoolean foundRemote = new AtomicBoolean(false);
        this.producers.values().forEach(producer -> {
            if (producer.isRemote()) {
                foundRemote.set(true);
            }
        });
        return foundRemote.get();
    }

    public void startReplProducers() {
        try {
            Policies policies = (Policies)this.brokerService.pulsar().getConfigurationCache().policiesCache().get(AdminResource.path("policies", TopicName.get((String)this.topic).getNamespace())).orElseThrow(() -> new KeeperException.NoNodeException());
            if (policies.replication_clusters != null) {
                TreeSet configuredClusters = Sets.newTreeSet((Iterable)policies.replication_clusters);
                this.replicators.forEach((region, replicator) -> {
                    if (configuredClusters.contains(region)) {
                        replicator.startProducer();
                    }
                });
            }
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Error getting policies while starting repl-producers {}", (Object)this.topic, (Object)e.getMessage());
            }
            this.replicators.forEach((region, replicator) -> replicator.startProducer());
        }
    }

    public CompletableFuture<Void> stopReplProducers() {
        ArrayList closeFutures = Lists.newArrayList();
        this.replicators.forEach((region, replicator) -> closeFutures.add(replicator.disconnect()));
        return FutureUtil.waitForAll((List)closeFutures);
    }

    private synchronized CompletableFuture<Void> closeReplProducersIfNoBacklog() {
        ArrayList closeFutures = Lists.newArrayList();
        this.replicators.forEach((region, replicator) -> closeFutures.add(replicator.disconnect(true)));
        return FutureUtil.waitForAll((List)closeFutures);
    }

    @Override
    protected void handleProducerRemoved(Producer producer) {
        super.handleProducerRemoved(producer);
        this.messageDeduplication.producerRemoved(producer.getProducerName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Consumer> subscribe(TransportCnx cnx, String subscriptionName, long consumerId, CommandSubscribe.SubType subType, int priorityLevel, String consumerName, boolean isDurable, MessageId startMessageId, Map<String, String> metadata, boolean readCompacted, CommandSubscribe.InitialPosition initialPosition, long startMessageRollbackDurationSec, boolean replicatedSubscriptionState, KeySharedMeta keySharedMeta) {
        Object consumer;
        CompletableFuture<Consumer> future = new CompletableFuture<Consumer>();
        try {
            this.brokerService.checkTopicNsOwnership(this.getName());
        }
        catch (Exception e) {
            future.completeExceptionally(e);
            return future;
        }
        if (readCompacted && subType != CommandSubscribe.SubType.Failover && subType != CommandSubscribe.SubType.Exclusive) {
            future.completeExceptionally(new BrokerServiceException.NotAllowedException("readCompacted only allowed on failover or exclusive subscriptions"));
            return future;
        }
        if (replicatedSubscriptionState && !this.brokerService.pulsar().getConfiguration().isEnableReplicatedSubscriptions()) {
            log.warn("Replicated Subscription is disabled by broker.");
            replicatedSubscriptionState = false;
        }
        if (subType == CommandSubscribe.SubType.Key_Shared && !this.brokerService.pulsar().getConfiguration().isSubscriptionKeySharedEnable()) {
            future.completeExceptionally(new BrokerServiceException.NotAllowedException("Key_Shared subscription is disabled by broker."));
            return future;
        }
        try {
            if (!this.topic.endsWith("__change_events") && !this.checkSubscriptionTypesEnable(subType)) {
                future.completeExceptionally(new BrokerServiceException.NotAllowedException("Topic[{" + this.topic + "}] don't support " + subType.name() + " sub type!"));
                return future;
            }
        }
        catch (Exception e) {
            future.completeExceptionally(e);
            return future;
        }
        if (StringUtils.isBlank((CharSequence)subscriptionName)) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Empty subscription name", (Object)this.topic);
            }
            future.completeExceptionally(new BrokerServiceException.NamingException("Empty subscription name"));
            return future;
        }
        if (this.hasBatchMessagePublished && !cnx.isBatchMessageCompatibleVersion()) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Consumer doesn't support batch-message {}", (Object)this.topic, (Object)subscriptionName);
            }
            future.completeExceptionally(new BrokerServiceException.UnsupportedVersionException("Consumer doesn't support batch-message"));
            return future;
        }
        if (subscriptionName.startsWith(this.replicatorPrefix) || subscriptionName.equals(DEDUPLICATION_CURSOR_NAME)) {
            log.warn("[{}] Failed to create subscription for {}", (Object)this.topic, (Object)subscriptionName);
            future.completeExceptionally(new BrokerServiceException.NamingException("Subscription with reserved subscription name attempted"));
            return future;
        }
        if (cnx.clientAddress() != null && cnx.clientAddress().toString().contains(":")) {
            consumer = new SubscribeRateLimiter.ConsumerIdentifier(cnx.clientAddress().toString().split(":")[0], consumerName, consumerId);
            if (this.subscribeRateLimiter.isPresent() && !this.subscribeRateLimiter.get().subscribeAvailable((SubscribeRateLimiter.ConsumerIdentifier)consumer) || !this.subscribeRateLimiter.get().tryAcquire((SubscribeRateLimiter.ConsumerIdentifier)consumer)) {
                log.warn("[{}] Failed to create subscription for {} {} limited by {}, available {}", new Object[]{this.topic, subscriptionName, consumer, this.subscribeRateLimiter.get().getSubscribeRate(), this.subscribeRateLimiter.get().getAvailableSubscribeRateLimit((SubscribeRateLimiter.ConsumerIdentifier)consumer)});
                future.completeExceptionally(new BrokerServiceException.NotAllowedException("Subscribe limited by subscribe rate limit per consumer."));
                return future;
            }
        }
        this.lock.readLock().lock();
        try {
            if (this.isFenced) {
                log.warn("[{}] Attempting to subscribe to a fenced topic", (Object)this.topic);
                future.completeExceptionally(new BrokerServiceException.TopicFencedException("Topic is temporarily unavailable"));
                consumer = future;
                return consumer;
            }
            this.handleConsumerAdded(subscriptionName, consumerName);
        }
        finally {
            this.lock.readLock().unlock();
        }
        CompletableFuture<Subscription> subscriptionFuture = isDurable ? this.getDurableSubscription(subscriptionName, initialPosition, startMessageRollbackDurationSec, replicatedSubscriptionState) : this.getNonDurableSubscription(subscriptionName, startMessageId, initialPosition, startMessageRollbackDurationSec);
        int maxUnackedMessages = isDurable ? this.getMaxUnackedMessagesOnConsumer() : 0;
        ((CompletableFuture)subscriptionFuture.thenAccept(subscription -> {
            Consumer consumer = new Consumer((Subscription)subscription, subType, this.topic, consumerId, priorityLevel, consumerName, maxUnackedMessages, cnx, cnx.getAuthRole(), metadata, readCompacted, initialPosition, keySharedMeta);
            ((CompletableFuture)this.addConsumerToSubscription((Subscription)subscription, consumer).thenAccept(v -> {
                this.checkBackloggedCursors();
                if (!cnx.isActive()) {
                    try {
                        consumer.close();
                    }
                    catch (BrokerServiceException e) {
                        if (e instanceof BrokerServiceException.ConsumerBusyException) {
                            log.warn("[{}][{}] Consumer {} {} already connected", new Object[]{this.topic, subscriptionName, consumerId, consumerName});
                        } else if (e instanceof BrokerServiceException.SubscriptionBusyException) {
                            log.warn("[{}][{}] {}", new Object[]{this.topic, subscriptionName, e.getMessage()});
                        }
                        this.decrementUsageCount();
                        future.completeExceptionally(e);
                        return;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] [{}] [{}] Subscribe failed -- count: {}", new Object[]{this.topic, subscriptionName, consumer.consumerName(), this.currentUsageCount()});
                    }
                    this.decrementUsageCount();
                    future.completeExceptionally(new BrokerServiceException("Connection was closed while the opening the cursor "));
                } else {
                    this.checkReplicatedSubscriptionControllerState();
                    log.info("[{}][{}] Created new subscription for {}", new Object[]{this.topic, subscriptionName, consumerId});
                    future.complete(consumer);
                }
            })).exceptionally(e -> {
                if (e.getCause() instanceof BrokerServiceException.ConsumerBusyException) {
                    log.warn("[{}][{}] Consumer {} {} already connected", new Object[]{this.topic, subscriptionName, consumerId, consumerName});
                } else if (e.getCause() instanceof BrokerServiceException.SubscriptionBusyException) {
                    log.warn("[{}][{}] {}", new Object[]{this.topic, subscriptionName, e.getMessage()});
                }
                this.decrementUsageCount();
                future.completeExceptionally((Throwable)e);
                return null;
            });
        })).exceptionally(ex -> {
            log.error("[{}] Failed to create subscription: {} error: {}", new Object[]{this.topic, subscriptionName, ex});
            this.decrementUsageCount();
            if (ex.getCause() instanceof BrokerServiceException.NotAllowedException) {
                future.completeExceptionally(ex.getCause());
            } else {
                future.completeExceptionally(new BrokerServiceException.PersistenceException((Throwable)ex));
            }
            return null;
        });
        return future;
    }

    public void updateUnackedMessagesAppliedOnSubscription(Policies policies) {
        this.maxUnackedMessagesOnSubscriptionApplied = this.getTopicPolicies().map(TopicPolicies::getMaxUnackedMessagesOnSubscription).orElseGet(() -> policies != null && policies.max_unacked_messages_per_subscription != null ? policies.max_unacked_messages_per_subscription.intValue() : this.brokerService.pulsar().getConfiguration().getMaxUnackedMessagesPerSubscription());
    }

    private void updateUnackedMessagesExceededOnConsumer(Policies data) {
        this.maxUnackedMessagesOnConsumerAppilied = this.getTopicPolicies().map(TopicPolicies::getMaxUnackedMessagesOnConsumer).orElseGet(() -> data != null && data.max_unacked_messages_per_consumer != null ? data.max_unacked_messages_per_consumer.intValue() : this.brokerService.pulsar().getConfiguration().getMaxUnackedMessagesPerConsumer());
        this.getSubscriptions().forEach((name, sub) -> {
            if (sub != null) {
                sub.getConsumers().forEach(consumer -> {
                    if (consumer.getMaxUnackedMessages() != this.maxUnackedMessagesOnConsumerAppilied) {
                        consumer.setMaxUnackedMessages(this.maxUnackedMessagesOnConsumerAppilied);
                    }
                });
            }
        });
    }

    private CompletableFuture<Subscription> getDurableSubscription(final String subscriptionName, CommandSubscribe.InitialPosition initialPosition, final long startMessageRollbackDurationSec, final boolean replicated) {
        final CompletableFuture<Subscription> subscriptionFuture = new CompletableFuture<Subscription>();
        if (this.checkMaxSubscriptionsPerTopicExceed(subscriptionName)) {
            subscriptionFuture.completeExceptionally(new BrokerServiceException.NotAllowedException("Exceed the maximum number of subscriptions of the topic: " + this.topic));
            return subscriptionFuture;
        }
        Map<String, Long> properties = PersistentSubscription.getBaseCursorProperties(replicated);
        this.ledger.asyncOpenCursor(Codec.encode((String)subscriptionName), initialPosition, properties, new AsyncCallbacks.OpenCursorCallback(){

            public void openCursorComplete(ManagedCursor cursor, Object ctx) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}][{}] Opened cursor", (Object)PersistentTopic.this.topic, (Object)subscriptionName);
                }
                PersistentSubscription subscription = (PersistentSubscription)PersistentTopic.this.subscriptions.computeIfAbsent((Object)subscriptionName, name -> PersistentTopic.this.createPersistentSubscription(subscriptionName, cursor, replicated));
                if (replicated && !subscription.isReplicated()) {
                    subscription.setReplicated(replicated);
                }
                if (startMessageRollbackDurationSec > 0L) {
                    PersistentTopic.this.resetSubscriptionCursor(subscription, subscriptionFuture, startMessageRollbackDurationSec);
                } else {
                    subscriptionFuture.complete(subscription);
                }
            }

            public void openCursorFailed(ManagedLedgerException exception, Object ctx) {
                log.warn("[{}] Failed to create subscription for {}: {}", new Object[]{PersistentTopic.this.topic, subscriptionName, exception.getMessage()});
                PersistentTopic.this.decrementUsageCount();
                subscriptionFuture.completeExceptionally(new BrokerServiceException.PersistenceException(exception));
                if (exception instanceof ManagedLedgerException.ManagedLedgerFencedException) {
                    PersistentTopic.this.close();
                }
            }
        }, null);
        return subscriptionFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<? extends Subscription> getNonDurableSubscription(String subscriptionName, MessageId startMessageId, CommandSubscribe.InitialPosition initialPosition, long startMessageRollbackDurationSec) {
        log.info("[{}][{}] Creating non-durable subscription at msg id {}", new Object[]{this.topic, subscriptionName, startMessageId});
        CompletableFuture<Subscription> subscriptionFuture = new CompletableFuture<Subscription>();
        if (this.checkMaxSubscriptionsPerTopicExceed(subscriptionName)) {
            subscriptionFuture.completeExceptionally(new BrokerServiceException.NotAllowedException("Exceed the maximum number of subscriptions of the topic: " + this.topic));
            return subscriptionFuture;
        }
        ManagedLedger managedLedger = this.ledger;
        synchronized (managedLedger) {
            PersistentSubscription subscription = (PersistentSubscription)this.subscriptions.get((Object)subscriptionName);
            if (subscription == null) {
                MessageIdImpl msgId = startMessageId != null ? (MessageIdImpl)startMessageId : (MessageIdImpl)MessageId.latest;
                long ledgerId = msgId.getLedgerId();
                long entryId = msgId.getEntryId();
                if (ledgerId >= 0L && entryId >= 0L && msgId instanceof BatchMessageIdImpl) {
                    entryId = msgId.getEntryId() - 1L;
                }
                PositionImpl startPosition = new PositionImpl(ledgerId, entryId);
                ManagedCursor cursor = null;
                try {
                    cursor = this.ledger.newNonDurableCursor((Position)startPosition, subscriptionName, initialPosition);
                }
                catch (ManagedLedgerException e) {
                    return FutureUtil.failedFuture((Throwable)e);
                }
                subscription = new PersistentSubscription(this, subscriptionName, cursor, false);
                this.subscriptions.put((Object)subscriptionName, (Object)subscription);
            }
            if (startMessageRollbackDurationSec > 0L) {
                this.resetSubscriptionCursor(subscription, subscriptionFuture, startMessageRollbackDurationSec);
                return subscriptionFuture;
            }
            return CompletableFuture.completedFuture(subscription);
        }
    }

    private void resetSubscriptionCursor(Subscription subscription, CompletableFuture<Subscription> subscriptionFuture, long startMessageRollbackDurationSec) {
        long timestamp = System.currentTimeMillis() - TimeUnit.SECONDS.toMillis(startMessageRollbackDurationSec);
        Subscription finalSubscription = subscription;
        subscription.resetCursor(timestamp).handle((s, ex) -> {
            if (ex != null) {
                log.warn("[{}] Failed to reset cursor {} position at timestamp {}, caused by {}", new Object[]{this.topic, subscription.getName(), startMessageRollbackDurationSec, ex.getMessage()});
            }
            subscriptionFuture.complete(finalSubscription);
            return null;
        });
    }

    @Override
    public CompletableFuture<Subscription> createSubscription(String subscriptionName, CommandSubscribe.InitialPosition initialPosition, boolean replicateSubscriptionState) {
        return this.getDurableSubscription(subscriptionName, initialPosition, 0L, replicateSubscriptionState);
    }

    @Override
    public CompletableFuture<Void> unsubscribe(final String subscriptionName) {
        final CompletableFuture<Void> unsubscribeFuture = new CompletableFuture<Void>();
        this.ledger.asyncDeleteCursor(Codec.encode((String)subscriptionName), new AsyncCallbacks.DeleteCursorCallback(){

            public void deleteCursorComplete(Object ctx) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}][{}] Cursor deleted successfully", (Object)PersistentTopic.this.topic, (Object)subscriptionName);
                }
                PersistentTopic.this.removeSubscription(subscriptionName);
                unsubscribeFuture.complete(null);
                PersistentTopic.this.lastActive = System.nanoTime();
            }

            public void deleteCursorFailed(ManagedLedgerException exception, Object ctx) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}][{}] Error deleting cursor for subscription", new Object[]{PersistentTopic.this.topic, subscriptionName, exception});
                }
                unsubscribeFuture.completeExceptionally(new BrokerServiceException.PersistenceException(exception));
            }
        }, null);
        return unsubscribeFuture;
    }

    void removeSubscription(String subscriptionName) {
        PersistentSubscription sub = (PersistentSubscription)this.subscriptions.remove((Object)subscriptionName);
        SubscriptionStatsImpl stats = sub.getStats(false, false);
        this.bytesOutFromRemovedSubscriptions.add(stats.bytesOutCounter);
        this.msgOutFromRemovedSubscriptions.add(stats.msgOutCounter);
    }

    @Override
    public CompletableFuture<Void> delete() {
        return this.delete(false, false, false);
    }

    private CompletableFuture<Void> delete(boolean failIfHasSubscriptions, boolean failIfHasBacklogs, boolean deleteSchema) {
        return this.delete(failIfHasSubscriptions, failIfHasBacklogs, false, deleteSchema);
    }

    @Override
    public CompletableFuture<Void> deleteForcefully() {
        return this.delete(false, false, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Void> delete(boolean failIfHasSubscriptions, boolean failIfHasBacklogs, boolean closeIfClientsConnected, boolean deleteSchema) {
        final CompletableFuture<Void> deleteFuture = new CompletableFuture<Void>();
        this.lock.writeLock().lock();
        try {
            if (this.isClosingOrDeleting) {
                log.warn("[{}] Topic is already being closed or deleted", (Object)this.topic);
                CompletableFuture completableFuture = FutureUtil.failedFuture((Throwable)new BrokerServiceException.TopicFencedException("Topic is already fenced"));
                return completableFuture;
            }
            if (failIfHasSubscriptions && !this.subscriptions.isEmpty()) {
                CompletableFuture completableFuture = FutureUtil.failedFuture((Throwable)new BrokerServiceException.TopicBusyException("Topic has subscriptions"));
                return completableFuture;
            }
            if (failIfHasBacklogs && this.hasBacklogs()) {
                CompletableFuture completableFuture = FutureUtil.failedFuture((Throwable)new BrokerServiceException.TopicBusyException("Topic has subscriptions did not catch up"));
                return completableFuture;
            }
            this.fenceTopicToCloseOrDelete();
            CompletableFuture closeClientFuture = new CompletableFuture();
            if (closeIfClientsConnected) {
                ArrayList futures = Lists.newArrayList();
                this.replicators.forEach((cluster, replicator) -> futures.add(replicator.disconnect()));
                this.producers.values().forEach(producer -> futures.add(producer.disconnect()));
                this.subscriptions.forEach((s, sub) -> futures.add(sub.disconnect()));
                ((CompletableFuture)FutureUtil.waitForAll((List)futures).thenRun(() -> closeClientFuture.complete(null))).exceptionally(ex -> {
                    log.error("[{}] Error closing clients", (Object)this.topic, ex);
                    this.unfenceTopicToResume();
                    closeClientFuture.completeExceptionally((Throwable)ex);
                    return null;
                });
            } else {
                closeClientFuture.complete(null);
            }
            ((CompletableFuture)closeClientFuture.thenAccept(delete -> {
                if (this.currentUsageCount() == 0L || closeIfClientsConnected && !failIfHasSubscriptions) {
                    CompletableFuture<SchemaVersion> deleteSchemaFuture = deleteSchema ? this.deleteSchema() : CompletableFuture.completedFuture(null);
                    deleteSchemaFuture.whenComplete((v, ex) -> {
                        if (ex != null) {
                            log.error("[{}] Error deleting topic", (Object)this.topic, ex);
                            this.unfenceTopicToResume();
                            deleteFuture.completeExceptionally((Throwable)ex);
                        } else {
                            this.ledger.asyncDelete(new AsyncCallbacks.DeleteLedgerCallback(){

                                public void deleteLedgerComplete(Object ctx) {
                                    PersistentTopic.this.brokerService.removeTopicFromCache(PersistentTopic.this.topic);
                                    PersistentTopic.this.dispatchRateLimiter.ifPresent(DispatchRateLimiter::close);
                                    PersistentTopic.this.subscribeRateLimiter.ifPresent(SubscribeRateLimiter::close);
                                    PersistentTopic.this.brokerService.pulsar().getTopicPoliciesService().clean(TopicName.get((String)PersistentTopic.this.topic));
                                    log.info("[{}] Topic deleted", (Object)PersistentTopic.this.topic);
                                    deleteFuture.complete(null);
                                }

                                public void deleteLedgerFailed(ManagedLedgerException exception, Object ctx) {
                                    if (exception.getCause() instanceof KeeperException.NoNodeException) {
                                        log.info("[{}] Topic is already deleted {}", (Object)PersistentTopic.this.topic, (Object)exception.getMessage());
                                        this.deleteLedgerComplete(ctx);
                                    } else {
                                        PersistentTopic.this.unfenceTopicToResume();
                                        log.error("[{}] Error deleting topic", (Object)PersistentTopic.this.topic, (Object)exception);
                                        deleteFuture.completeExceptionally(new BrokerServiceException.PersistenceException(exception));
                                    }
                                }
                            }, null);
                        }
                    });
                } else {
                    this.unfenceTopicToResume();
                    deleteFuture.completeExceptionally(new BrokerServiceException.TopicBusyException("Topic has " + this.currentUsageCount() + " connected producers/consumers"));
                }
            })).exceptionally(ex -> {
                this.unfenceTopicToResume();
                deleteFuture.completeExceptionally(new BrokerServiceException.TopicBusyException("Failed to close clients before deleting topic."));
                return null;
            });
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return deleteFuture;
    }

    public CompletableFuture<Void> close() {
        return this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> close(boolean closeWithoutWaitingClientDisconnect) {
        CompletableFuture<Void> closeFuture;
        block4: {
            closeFuture = new CompletableFuture<Void>();
            this.lock.writeLock().lock();
            try {
                if (!this.isClosingOrDeleting || closeWithoutWaitingClientDisconnect) {
                    this.fenceTopicToCloseOrDelete();
                    break block4;
                }
                log.warn("[{}] Topic is already being closed or deleted", (Object)this.topic);
                closeFuture.completeExceptionally(new BrokerServiceException.TopicFencedException("Topic is already fenced"));
                CompletableFuture<Void> completableFuture = closeFuture;
                return completableFuture;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        ArrayList futures = Lists.newArrayList();
        futures.add(this.transactionBuffer.closeAsync());
        this.replicators.forEach((cluster, replicator) -> futures.add(replicator.disconnect()));
        this.producers.values().forEach(producer -> futures.add(producer.disconnect()));
        this.subscriptions.forEach((s, sub) -> futures.add(sub.disconnect()));
        CompletableFuture clientCloseFuture = closeWithoutWaitingClientDisconnect ? CompletableFuture.completedFuture(null) : FutureUtil.waitForAll((List)futures);
        ((CompletableFuture)clientCloseFuture.thenRun(() -> this.ledger.asyncClose(new AsyncCallbacks.CloseCallback(){

            public void closeComplete(Object ctx) {
                ((CompletableFuture)PersistentTopic.this.brokerService.removeTopicFromCache(PersistentTopic.this.topic).thenRun(() -> {
                    PersistentTopic.this.replicatedSubscriptionsController.ifPresent(ReplicatedSubscriptionsController::close);
                    PersistentTopic.this.dispatchRateLimiter.ifPresent(DispatchRateLimiter::close);
                    PersistentTopic.this.subscribeRateLimiter.ifPresent(SubscribeRateLimiter::close);
                    PersistentTopic.this.brokerService.pulsar().getTopicPoliciesService().clean(TopicName.get((String)PersistentTopic.this.topic));
                    log.info("[{}] Topic closed", (Object)PersistentTopic.this.topic);
                    closeFuture.complete(null);
                })).exceptionally(ex -> {
                    closeFuture.completeExceptionally((Throwable)ex);
                    return null;
                });
            }

            public void closeFailed(ManagedLedgerException exception, Object ctx) {
                log.error("[{}] Failed to close managed ledger, proceeding anyway.", (Object)PersistentTopic.this.topic, (Object)exception);
                PersistentTopic.this.brokerService.removeTopicFromCache(PersistentTopic.this.topic);
                closeFuture.complete(null);
            }
        }, null))).exceptionally(exception -> {
            log.error("[{}] Error closing topic", (Object)this.topic, exception);
            this.unfenceTopicToResume();
            closeFuture.completeExceptionally((Throwable)exception);
            return null;
        });
        return closeFuture;
    }

    @VisibleForTesting
    CompletableFuture<Void> checkReplicationAndRetryOnFailure() {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        ((CompletableFuture)this.checkReplication().thenAccept(res -> {
            log.info("[{}] Policies updated successfully", (Object)this.topic);
            result.complete(null);
        })).exceptionally(th -> {
            log.error("[{}] Policies update failed {}, scheduled retry in {} seconds", new Object[]{this.topic, th.getMessage(), 60L, th});
            if (!(th.getCause() instanceof BrokerServiceException.TopicFencedException)) {
                this.brokerService.executor().schedule(this::checkReplicationAndRetryOnFailure, 60L, TimeUnit.SECONDS);
            }
            result.completeExceptionally((Throwable)th);
            return null;
        });
        return result;
    }

    public CompletableFuture<Void> checkDeduplicationStatus() {
        return this.messageDeduplication.checkStatus();
    }

    private CompletableFuture<Void> checkPersistencePolicies() {
        TopicName topicName = TopicName.get((String)this.topic);
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        ((CompletableFuture)this.brokerService.getManagedLedgerConfig(topicName).thenAccept(config -> {
            this.ledger.setConfig(config);
            future.complete(null);
        })).exceptionally(ex -> {
            log.warn("[{}] Failed to update persistence-policies {}", (Object)this.topic, (Object)ex.getMessage());
            future.completeExceptionally((Throwable)ex);
            return null;
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> checkReplication() {
        int newMessageTTLinSeconds;
        TopicName name = TopicName.get((String)this.topic);
        if (!name.isGlobal()) {
            return CompletableFuture.completedFuture(null);
        }
        if (log.isDebugEnabled()) {
            log.debug("[{}] Checking replication status", (Object)name);
        }
        Policies policies = null;
        try {
            policies = (Policies)this.brokerService.pulsar().getConfigurationCache().policiesCache().get(AdminResource.path("policies", name.getNamespace())).orElseThrow(() -> new KeeperException.NoNodeException());
        }
        catch (Exception e) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            future.completeExceptionally(new BrokerServiceException.ServerMetadataException(e));
            return future;
        }
        try {
            newMessageTTLinSeconds = this.getMessageTTL();
        }
        catch (Exception e) {
            return FutureUtil.failedFuture((Throwable)new BrokerServiceException.ServerMetadataException(e));
        }
        TreeSet configuredClusters = policies.replication_clusters != null ? Sets.newTreeSet((Iterable)policies.replication_clusters) : Collections.emptySet();
        String localCluster = this.brokerService.pulsar().getConfiguration().getClusterName();
        if (TopicName.get((String)this.topic).isGlobal() && !configuredClusters.contains(localCluster)) {
            log.info("Deleting topic [{}] because local cluster is not part of global namespace repl list {}", (Object)this.topic, (Object)configuredClusters);
            return this.deleteForcefully();
        }
        ArrayList futures = Lists.newArrayList();
        for (String cluster2 : configuredClusters) {
            if (cluster2.equals(localCluster) || this.replicators.containsKey((Object)cluster2)) continue;
            futures.add(this.startReplicator(cluster2));
        }
        this.replicators.forEach((cluster, replicator) -> {
            ((PersistentReplicator)replicator).updateMessageTTL(newMessageTTLinSeconds);
            if (!cluster.equals(localCluster) && !configuredClusters.contains(cluster)) {
                futures.add(this.removeReplicator((String)cluster));
            }
        });
        return FutureUtil.waitForAll((List)futures);
    }

    @Override
    public void checkMessageExpiry() {
        block3: {
            try {
                int messageTtlInSeconds = this.getMessageTTL();
                if (messageTtlInSeconds != 0) {
                    this.subscriptions.forEach((__, sub) -> sub.expireMessages(messageTtlInSeconds));
                    this.replicators.forEach((__, replicator) -> ((PersistentReplicator)replicator).expireMessages(messageTtlInSeconds));
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug("[{}] Error getting policies", (Object)this.topic);
            }
        }
    }

    @Override
    public void checkMessageDeduplicationInfo() {
        this.messageDeduplication.purgeInactiveProducers();
    }

    public void checkCompaction() {
        TopicName name = TopicName.get((String)this.topic);
        try {
            Long compactionThreshold = this.getTopicPolicies().map(TopicPolicies::getCompactionThreshold).orElse(null);
            if (compactionThreshold == null) {
                Policies policies = (Policies)this.brokerService.pulsar().getConfigurationCache().policiesCache().get(AdminResource.path("policies", name.getNamespace())).orElseThrow(() -> new KeeperException.NoNodeException());
                compactionThreshold = policies.compaction_threshold;
            }
            if (compactionThreshold == null) {
                compactionThreshold = this.brokerService.pulsar().getConfiguration().getBrokerServiceCompactionThresholdInBytes();
            }
            if (this.isSystemTopic() || compactionThreshold != 0L && this.currentCompaction.isDone()) {
                long backlogEstimate = 0L;
                PersistentSubscription compactionSub = (PersistentSubscription)this.subscriptions.get((Object)"__compaction");
                if (compactionSub != null) {
                    backlogEstimate = compactionSub.estimateBacklogSize();
                } else {
                    long l = backlogEstimate = this.subscriptions.isEmpty() ? this.ledger.getTotalSize() : this.ledger.getEstimatedBacklogSize();
                }
                if (backlogEstimate > compactionThreshold) {
                    try {
                        this.triggerCompaction();
                    }
                    catch (BrokerServiceException.AlreadyRunningException are) {
                        log.debug("[{}] Compaction already running, so don't trigger again, even though backlog({}) is over threshold({})", new Object[]{name, backlogEstimate, compactionThreshold});
                    }
                }
            }
        }
        catch (Exception e) {
            log.debug("[{}] Error getting policies", (Object)this.topic);
        }
    }

    CompletableFuture<Void> startReplicator(final String remoteCluster) {
        log.info("[{}] Starting replicator to remote: {}", (Object)this.topic, (Object)remoteCluster);
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        String name = PersistentReplicator.getReplicatorName(this.replicatorPrefix, remoteCluster);
        this.ledger.asyncOpenCursor(name, new AsyncCallbacks.OpenCursorCallback(){

            public void openCursorComplete(ManagedCursor cursor, Object ctx) {
                String localCluster = PersistentTopic.this.brokerService.pulsar().getConfiguration().getClusterName();
                boolean isReplicatorStarted = PersistentTopic.this.addReplicationCluster(remoteCluster, cursor, localCluster);
                if (isReplicatorStarted) {
                    future.complete(null);
                } else {
                    future.completeExceptionally(new BrokerServiceException.NamingException(PersistentTopic.this.getName() + " Failed to start replicator " + remoteCluster));
                }
            }

            public void openCursorFailed(ManagedLedgerException exception, Object ctx) {
                future.completeExceptionally(new BrokerServiceException.PersistenceException(exception));
            }
        }, null);
        return future;
    }

    protected boolean addReplicationCluster(String remoteCluster, ManagedCursor cursor, String localCluster) {
        AtomicBoolean isReplicatorStarted = new AtomicBoolean(true);
        this.replicators.computeIfAbsent((Object)remoteCluster, r -> {
            try {
                return new PersistentReplicator(this, cursor, localCluster, remoteCluster, this.brokerService);
            }
            catch (BrokerServiceException.NamingException e) {
                isReplicatorStarted.set(false);
                log.error("[{}] Replicator startup failed due to partitioned-topic {}", (Object)this.topic, (Object)remoteCluster);
                return null;
            }
        });
        if (!isReplicatorStarted.get()) {
            this.replicators.remove((Object)remoteCluster);
        }
        return isReplicatorStarted.get();
    }

    CompletableFuture<Void> removeReplicator(final String remoteCluster) {
        log.info("[{}] Removing replicator to {}", (Object)this.topic, (Object)remoteCluster);
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        final String name = PersistentReplicator.getReplicatorName(this.replicatorPrefix, remoteCluster);
        ((CompletableFuture)((Replicator)this.replicators.get((Object)remoteCluster)).disconnect().thenRun(() -> this.ledger.asyncDeleteCursor(name, new AsyncCallbacks.DeleteCursorCallback(){

            public void deleteCursorComplete(Object ctx) {
                PersistentTopic.this.replicators.remove((Object)remoteCluster);
                future.complete(null);
            }

            public void deleteCursorFailed(ManagedLedgerException exception, Object ctx) {
                log.error("[{}] Failed to delete cursor {} {}", new Object[]{PersistentTopic.this.topic, name, exception.getMessage(), exception});
                future.completeExceptionally(new BrokerServiceException.PersistenceException(exception));
            }
        }, null))).exceptionally(e -> {
            log.error("[{}] Failed to close replication producer {} {}", new Object[]{this.topic, name, e.getMessage(), e});
            future.completeExceptionally((Throwable)e);
            return null;
        });
        return future;
    }

    public boolean isDeduplicationEnabled() {
        return this.messageDeduplication.isEnabled();
    }

    @Override
    public int getNumberOfConsumers() {
        int count = 0;
        for (PersistentSubscription subscription : this.subscriptions.values()) {
            count += subscription.getConsumers().size();
        }
        return count;
    }

    @Override
    public int getNumberOfSameAddressConsumers(String clientAddress) {
        return this.getNumberOfSameAddressConsumers(clientAddress, this.subscriptions.values());
    }

    public ConcurrentOpenHashMap<String, PersistentSubscription> getSubscriptions() {
        return this.subscriptions;
    }

    @Override
    public PersistentSubscription getSubscription(String subscriptionName) {
        return (PersistentSubscription)this.subscriptions.get((Object)subscriptionName);
    }

    public ConcurrentOpenHashMap<String, Replicator> getReplicators() {
        return this.replicators;
    }

    public Replicator getPersistentReplicator(String remoteCluster) {
        return (Replicator)this.replicators.get((Object)remoteCluster);
    }

    public ManagedLedger getManagedLedger() {
        return this.ledger;
    }

    @Override
    public void updateRates(NamespaceStats nsStats, NamespaceBundleStats bundleStats, StatsOutputStream topicStatsStream, ClusterReplicationMetrics replStats, String namespace, boolean hydratePublishers) {
        TopicStatsHelper topicStatsHelper = (TopicStatsHelper)threadLocalTopicStats.get();
        topicStatsHelper.reset();
        this.replicators.forEach((region, replicator) -> replicator.updateRates());
        nsStats.producerCount += this.producers.size();
        bundleStats.producerCount += this.producers.size();
        topicStatsStream.startObject(this.topic);
        topicStatsStream.startList("publishers");
        this.producers.values().forEach(producer -> {
            producer.updateRates();
            PublisherStatsImpl publisherStats = producer.getStats();
            topicStatsHelper.aggMsgRateIn += publisherStats.msgRateIn;
            topicStatsHelper.aggMsgThroughputIn += publisherStats.msgThroughputIn;
            if (producer.isRemote()) {
                topicStatsHelper.remotePublishersStats.put((Object)producer.getRemoteCluster(), (Object)publisherStats);
            }
            if (hydratePublishers) {
                StreamingStats.writePublisherStats(topicStatsStream, publisherStats);
            }
        });
        topicStatsStream.endList();
        this.lastUpdatedAvgPublishRateInMsg = topicStatsHelper.aggMsgRateIn > this.lastUpdatedAvgPublishRateInMsg ? topicStatsHelper.aggMsgRateIn : (topicStatsHelper.aggMsgRateIn + this.lastUpdatedAvgPublishRateInMsg) / 2.0;
        this.lastUpdatedAvgPublishRateInByte = topicStatsHelper.aggMsgThroughputIn > this.lastUpdatedAvgPublishRateInByte ? topicStatsHelper.aggMsgThroughputIn : (topicStatsHelper.aggMsgThroughputIn + this.lastUpdatedAvgPublishRateInByte) / 2.0;
        topicStatsStream.startObject("replication");
        nsStats.replicatorCount += topicStatsHelper.remotePublishersStats.size();
        this.replicators.forEach((cluster, replicator) -> {
            try {
                ((PersistentReplicator)replicator).updateCursorState();
            }
            catch (Exception e) {
                log.warn("[{}] Failed to update cursro state ", (Object)this.topic, (Object)e);
            }
            ReplicatorStatsImpl rStat = replicator.getStats();
            PublisherStatsImpl pubStats = (PublisherStatsImpl)topicStatsHelper.remotePublishersStats.get((Object)replicator.getRemoteCluster());
            rStat.msgRateIn = pubStats != null ? pubStats.msgRateIn : 0.0;
            rStat.msgThroughputIn = pubStats != null ? pubStats.msgThroughputIn : 0.0;
            rStat.inboundConnection = pubStats != null ? pubStats.getAddress() : null;
            rStat.inboundConnectedSince = pubStats != null ? pubStats.getConnectedSince() : null;
            topicStatsHelper.aggMsgRateOut += rStat.msgRateOut;
            topicStatsHelper.aggMsgThroughputOut += rStat.msgThroughputOut;
            topicStatsStream.startObject((String)cluster);
            topicStatsStream.writePair("connected", rStat.connected);
            topicStatsStream.writePair("msgRateExpired", rStat.msgRateExpired);
            topicStatsStream.writePair("msgRateIn", rStat.msgRateIn);
            topicStatsStream.writePair("msgRateOut", rStat.msgRateOut);
            topicStatsStream.writePair("msgThroughputIn", rStat.msgThroughputIn);
            topicStatsStream.writePair("msgThroughputOut", rStat.msgThroughputOut);
            topicStatsStream.writePair("replicationBacklog", rStat.replicationBacklog);
            topicStatsStream.writePair("replicationDelayInSeconds", rStat.replicationDelayInSeconds);
            topicStatsStream.writePair("inboundConnection", rStat.inboundConnection);
            topicStatsStream.writePair("inboundConnectedSince", rStat.inboundConnectedSince);
            topicStatsStream.writePair("outboundConnection", rStat.outboundConnection);
            topicStatsStream.writePair("outboundConnectedSince", rStat.outboundConnectedSince);
            topicStatsStream.endObject();
            nsStats.msgReplBacklog += (double)rStat.replicationBacklog;
            if (replStats.isMetricsEnabled()) {
                String namespaceClusterKey = replStats.getKeyName(namespace, (String)cluster);
                ReplicationMetrics replicationMetrics = replStats.get(namespaceClusterKey);
                boolean update = false;
                if (replicationMetrics == null) {
                    replicationMetrics = ReplicationMetrics.get();
                    update = true;
                }
                replicationMetrics.connected = replicationMetrics.connected + (rStat.connected ? 1 : 0);
                replicationMetrics.msgRateOut += rStat.msgRateOut;
                replicationMetrics.msgThroughputOut += rStat.msgThroughputOut;
                replicationMetrics.msgReplBacklog += (double)rStat.replicationBacklog;
                if (update) {
                    replStats.put(namespaceClusterKey, replicationMetrics);
                }
                if ((double)rStat.replicationDelayInSeconds > replicationMetrics.maxMsgReplDelayInSeconds) {
                    replicationMetrics.maxMsgReplDelayInSeconds = rStat.replicationDelayInSeconds;
                }
            }
        });
        topicStatsStream.endObject();
        topicStatsStream.startObject("subscriptions");
        nsStats.subsCount = (int)((long)nsStats.subsCount + this.subscriptions.size());
        this.subscriptions.forEach((subscriptionName, subscription) -> {
            double subMsgRateOut = 0.0;
            double subMsgThroughputOut = 0.0;
            double subMsgRateRedeliver = 0.0;
            try {
                topicStatsStream.startObject((String)subscriptionName);
                topicStatsStream.startList("consumers");
                for (Consumer consumer : subscription.getConsumers()) {
                    ++nsStats.consumerCount;
                    ++bundleStats.consumerCount;
                    consumer.updateRates();
                    ConsumerStatsImpl consumerStats = consumer.getStats();
                    subMsgRateOut += consumerStats.msgRateOut;
                    subMsgThroughputOut += consumerStats.msgThroughputOut;
                    subMsgRateRedeliver += consumerStats.msgRateRedeliver;
                    StreamingStats.writeConsumerStats(topicStatsStream, subscription.getType(), consumerStats);
                }
                topicStatsStream.endList();
                topicStatsStream.writePair("msgBacklog", subscription.getNumberOfEntriesInBacklog(true));
                topicStatsStream.writePair("msgRateExpired", subscription.getExpiredMessageRate());
                topicStatsStream.writePair("msgRateOut", subMsgRateOut);
                topicStatsStream.writePair("msgThroughputOut", subMsgThroughputOut);
                topicStatsStream.writePair("msgRateRedeliver", subMsgRateRedeliver);
                topicStatsStream.writePair("numberOfEntriesSinceFirstNotAckedMessage", subscription.getNumberOfEntriesSinceFirstNotAckedMessage());
                topicStatsStream.writePair("totalNonContiguousDeletedMessagesRange", subscription.getTotalNonContiguousDeletedMessagesRange());
                topicStatsStream.writePair("type", subscription.getTypeString());
                if (Subscription.isIndividualAckMode(subscription.getType()) && subscription.getDispatcher() instanceof PersistentDispatcherMultipleConsumers) {
                    PersistentDispatcherMultipleConsumers dispatcher = (PersistentDispatcherMultipleConsumers)subscription.getDispatcher();
                    topicStatsStream.writePair("blockedSubscriptionOnUnackedMsgs", dispatcher.isBlockedDispatcherOnUnackedMsgs());
                    topicStatsStream.writePair("unackedMessages", dispatcher.getTotalUnackedMessages());
                }
                topicStatsStream.endObject();
                topicStatsHelper.aggMsgRateOut += subMsgRateOut;
                topicStatsHelper.aggMsgThroughputOut += subMsgThroughputOut;
                nsStats.msgBacklog += (double)subscription.getNumberOfEntriesInBacklog(false);
                if (this.brokerService.getPulsar().getConfig().isUnblockStuckSubscriptionEnabled()) {
                    subscription.checkAndUnblockIfStuck();
                }
            }
            catch (Exception e) {
                log.error("Got exception when creating consumer stats for subscription {}: {}", new Object[]{subscriptionName, e.getMessage(), e});
            }
        });
        topicStatsStream.endObject();
        topicStatsHelper.averageMsgSize = topicStatsHelper.aggMsgRateIn == 0.0 ? 0.0 : topicStatsHelper.aggMsgThroughputIn / topicStatsHelper.aggMsgRateIn;
        topicStatsStream.writePair("producerCount", this.producers.size());
        topicStatsStream.writePair("averageMsgSize", topicStatsHelper.averageMsgSize);
        topicStatsStream.writePair("msgRateIn", topicStatsHelper.aggMsgRateIn);
        topicStatsStream.writePair("msgRateOut", topicStatsHelper.aggMsgRateOut);
        topicStatsStream.writePair("msgInCount", this.getMsgInCounter());
        topicStatsStream.writePair("bytesInCount", this.getBytesInCounter());
        topicStatsStream.writePair("msgOutCount", this.getMsgOutCounter());
        topicStatsStream.writePair("bytesOutCount", this.getBytesOutCounter());
        topicStatsStream.writePair("msgThroughputIn", topicStatsHelper.aggMsgThroughputIn);
        topicStatsStream.writePair("msgThroughputOut", topicStatsHelper.aggMsgThroughputOut);
        topicStatsStream.writePair("storageSize", this.ledger.getTotalSize());
        topicStatsStream.writePair("backlogSize", this.ledger.getEstimatedBacklogSize());
        topicStatsStream.writePair("pendingAddEntriesCount", ((ManagedLedgerImpl)this.ledger).getPendingAddEntriesCount());
        nsStats.msgRateIn += topicStatsHelper.aggMsgRateIn;
        nsStats.msgRateOut += topicStatsHelper.aggMsgRateOut;
        nsStats.msgThroughputIn += topicStatsHelper.aggMsgThroughputIn;
        nsStats.msgThroughputOut += topicStatsHelper.aggMsgThroughputOut;
        nsStats.storageSize += (double)this.ledger.getEstimatedBacklogSize();
        bundleStats.msgRateIn += topicStatsHelper.aggMsgRateIn;
        bundleStats.msgRateOut += topicStatsHelper.aggMsgRateOut;
        bundleStats.msgThroughputIn += topicStatsHelper.aggMsgThroughputIn;
        bundleStats.msgThroughputOut += topicStatsHelper.aggMsgThroughputOut;
        bundleStats.cacheSize += ((ManagedLedgerImpl)this.ledger).getCacheSize();
        topicStatsStream.endObject();
        this.addEntryLatencyStatsUsec.refresh();
        NamespaceStats.add(this.addEntryLatencyStatsUsec.getBuckets(), nsStats.addLatencyBucket);
        this.addEntryLatencyStatsUsec.reset();
    }

    public double getLastUpdatedAvgPublishRateInMsg() {
        return this.lastUpdatedAvgPublishRateInMsg;
    }

    public double getLastUpdatedAvgPublishRateInByte() {
        return this.lastUpdatedAvgPublishRateInByte;
    }

    @Override
    public TopicStatsImpl getStats(boolean getPreciseBacklog, boolean subscriptionBacklogSize) {
        TopicStatsImpl stats = new TopicStatsImpl();
        ObjectObjectHashMap remotePublishersStats = new ObjectObjectHashMap();
        this.producers.values().forEach(producer -> {
            PublisherStatsImpl publisherStats = producer.getStats();
            stats.msgRateIn += publisherStats.msgRateIn;
            stats.msgThroughputIn += publisherStats.msgThroughputIn;
            if (producer.isRemote()) {
                remotePublishersStats.put((Object)producer.getRemoteCluster(), (Object)publisherStats);
            } else {
                stats.publishers.add(publisherStats);
            }
        });
        stats.averageMsgSize = stats.msgRateIn == 0.0 ? 0.0 : stats.msgThroughputIn / stats.msgRateIn;
        stats.msgInCounter = this.getMsgInCounter();
        stats.bytesInCounter = this.getBytesInCounter();
        stats.msgChunkPublished = this.msgChunkPublished;
        stats.waitingPublishers = this.getWaitingProducersCount();
        stats.bytesOutCounter = this.bytesOutFromRemovedSubscriptions.longValue();
        stats.msgOutCounter = this.msgOutFromRemovedSubscriptions.longValue();
        this.subscriptions.forEach((name, subscription) -> {
            SubscriptionStatsImpl subStats = subscription.getStats(getPreciseBacklog, subscriptionBacklogSize);
            stats.msgRateOut += subStats.msgRateOut;
            stats.msgThroughputOut += subStats.msgThroughputOut;
            stats.bytesOutCounter += subStats.bytesOutCounter;
            stats.msgOutCounter += subStats.msgOutCounter;
            stats.subscriptions.put(name, subStats);
            stats.nonContiguousDeletedMessagesRanges += subStats.nonContiguousDeletedMessagesRanges;
            stats.nonContiguousDeletedMessagesRangesSerializedSize += subStats.nonContiguousDeletedMessagesRangesSerializedSize;
        });
        this.replicators.forEach((cluster, replicator) -> {
            ReplicatorStatsImpl replicatorStats = replicator.getStats();
            PublisherStatsImpl pubStats = (PublisherStatsImpl)remotePublishersStats.get((Object)replicator.getRemoteCluster());
            if (pubStats != null) {
                replicatorStats.msgRateIn = pubStats.msgRateIn;
                replicatorStats.msgThroughputIn = pubStats.msgThroughputIn;
                replicatorStats.inboundConnection = pubStats.getAddress();
                replicatorStats.inboundConnectedSince = pubStats.getConnectedSince();
            }
            stats.msgRateOut += replicatorStats.msgRateOut;
            stats.msgThroughputOut += replicatorStats.msgThroughputOut;
            stats.replication.put(replicator.getRemoteCluster(), replicatorStats);
        });
        stats.storageSize = this.ledger.getTotalSize();
        stats.backlogSize = this.ledger.getEstimatedBacklogSize();
        stats.deduplicationStatus = this.messageDeduplication.getStatus().toString();
        stats.topicEpoch = this.topicEpoch.orElse(null);
        stats.offloadedStorageSize = this.ledger.getOffloadedSize();
        return stats;
    }

    @Override
    public CompletableFuture<PersistentTopicInternalStats> getInternalStats(boolean includeLedgerMetadata) {
        String schemaId;
        CompletableFuture<PersistentTopicInternalStats> statFuture = new CompletableFuture<PersistentTopicInternalStats>();
        PersistentTopicInternalStats stats = new PersistentTopicInternalStats();
        ManagedLedgerImpl ml = (ManagedLedgerImpl)this.ledger;
        stats.entriesAddedCounter = ml.getEntriesAddedCounter();
        stats.numberOfEntries = ml.getNumberOfEntries();
        stats.totalSize = ml.getTotalSize();
        stats.currentLedgerEntries = ml.getCurrentLedgerEntries();
        stats.currentLedgerSize = ml.getCurrentLedgerSize();
        stats.lastLedgerCreatedTimestamp = DateFormatter.format((long)ml.getLastLedgerCreatedTimestamp());
        if (ml.getLastLedgerCreationFailureTimestamp() != 0L) {
            stats.lastLedgerCreationFailureTimestamp = DateFormatter.format((long)ml.getLastLedgerCreationFailureTimestamp());
        }
        stats.waitingCursorsCount = ml.getWaitingCursorsCount();
        stats.pendingAddEntriesCount = ml.getPendingAddEntriesCount();
        stats.lastConfirmedEntry = ml.getLastConfirmedEntry().toString();
        stats.state = ml.getState().toString();
        stats.ledgers = Lists.newArrayList();
        ArrayList futures = includeLedgerMetadata ? Lists.newArrayList() : null;
        CompletableFuture<Set<String>> availableBookiesFuture = this.brokerService.pulsar().getAvailableBookiesAsync();
        availableBookiesFuture.whenComplete((bookies, e) -> {
            if (e != null) {
                log.error("[{}] Failed to fetch available bookies.", (Object)this.topic, e);
                statFuture.completeExceptionally((Throwable)e);
            } else {
                ml.getLedgersInfo().forEach((id, li) -> {
                    ManagedLedgerInternalStats.LedgerInfo info = new ManagedLedgerInternalStats.LedgerInfo();
                    info.ledgerId = li.getLedgerId();
                    info.entries = li.getEntries();
                    info.size = li.getSize();
                    info.offloaded = li.hasOffloadContext() && li.getOffloadContext().getComplete();
                    stats.ledgers.add(info);
                    if (futures != null) {
                        futures.add(ml.getLedgerMetadata(li.getLedgerId()).handle((lMetadata, ex) -> {
                            if (ex == null) {
                                info.metadata = lMetadata;
                            }
                            return null;
                        }));
                        futures.add(ml.getEnsemblesAsync(li.getLedgerId()).handle((ensembles, ex) -> {
                            if (ex == null) {
                                info.underReplicated = !bookies.containsAll(ensembles.stream().map(BookieId::toString).collect(Collectors.toList()));
                            }
                            return null;
                        }));
                    }
                });
            }
        });
        ManagedLedgerInternalStats.LedgerInfo info = new ManagedLedgerInternalStats.LedgerInfo();
        info.ledgerId = -1L;
        info.entries = -1L;
        info.size = -1L;
        try {
            Optional<CompactedTopicImpl.CompactedTopicContext> compactedTopicContext = ((CompactedTopicImpl)this.compactedTopic).getCompactedTopicContext();
            if (compactedTopicContext.isPresent()) {
                CompactedTopicImpl.CompactedTopicContext ledgerContext = compactedTopicContext.get();
                info.ledgerId = ledgerContext.getLedger().getId();
                info.entries = ledgerContext.getLedger().getLastAddConfirmed() + 1L;
                info.size = ledgerContext.getLedger().getLength();
            }
        }
        catch (InterruptedException | ExecutionException e2) {
            log.warn("[{}]Fail to get ledger information for compacted topic.", (Object)this.topic);
        }
        stats.compactedLedger = info;
        stats.cursors = Maps.newTreeMap();
        ml.getCursors().forEach(c -> {
            ManagedCursorImpl cursor = (ManagedCursorImpl)c;
            ManagedLedgerInternalStats.CursorStats cs = new ManagedLedgerInternalStats.CursorStats();
            cs.markDeletePosition = cursor.getMarkDeletedPosition().toString();
            cs.readPosition = cursor.getReadPosition().toString();
            cs.waitingReadOp = cursor.hasPendingReadRequest();
            cs.pendingReadOps = cursor.getPendingReadOpsCount();
            cs.messagesConsumedCounter = cursor.getMessagesConsumedCounter();
            cs.cursorLedger = cursor.getCursorLedger();
            cs.cursorLedgerLastEntry = cursor.getCursorLedgerLastEntry();
            cs.individuallyDeletedMessages = cursor.getIndividuallyDeletedMessages();
            cs.lastLedgerSwitchTimestamp = DateFormatter.format((long)cursor.getLastLedgerSwitchTimestamp());
            cs.state = cursor.getState();
            cs.numberOfEntriesSinceFirstNotAckedMessage = cursor.getNumberOfEntriesSinceFirstNotAckedMessage();
            cs.totalNonContiguousDeletedMessagesRange = cursor.getTotalNonContiguousDeletedMessagesRange();
            cs.properties = cursor.getProperties();
            PersistentSubscription sub = (PersistentSubscription)this.subscriptions.get((Object)Codec.decode((String)c.getName()));
            if (sub != null) {
                if (sub.getDispatcher() instanceof PersistentDispatcherMultipleConsumers) {
                    PersistentDispatcherMultipleConsumers dispatcher = (PersistentDispatcherMultipleConsumers)sub.getDispatcher();
                    cs.subscriptionHavePendingRead = dispatcher.havePendingRead;
                    cs.subscriptionHavePendingReplayRead = dispatcher.havePendingReplayRead;
                } else if (sub.getDispatcher() instanceof PersistentDispatcherSingleActiveConsumer) {
                    PersistentDispatcherSingleActiveConsumer dispatcher = (PersistentDispatcherSingleActiveConsumer)sub.getDispatcher();
                    cs.subscriptionHavePendingRead = dispatcher.havePendingRead;
                }
            }
            stats.cursors.put(cursor.getName(), cs);
        });
        try {
            schemaId = TopicName.get((String)this.topic).getSchemaName();
        }
        catch (Throwable t) {
            statFuture.completeExceptionally(t);
            return statFuture;
        }
        CompletableFuture schemaStoreLedgersFuture = new CompletableFuture();
        stats.schemaLedgers = Collections.synchronizedList(new ArrayList());
        if (this.brokerService.getPulsar().getSchemaStorage() != null && this.brokerService.getPulsar().getSchemaStorage() instanceof BookkeeperSchemaStorage) {
            ((CompletableFuture)((BookkeeperSchemaStorage)this.brokerService.getPulsar().getSchemaStorage()).getStoreLedgerIdsBySchemaId(schemaId).thenAccept(ledgers -> {
                ArrayList getLedgerMetadataFutures = new ArrayList();
                ledgers.forEach(ledgerId -> {
                    CompletableFuture completableFuture = new CompletableFuture();
                    getLedgerMetadataFutures.add(completableFuture);
                    ((CompletableFuture)this.brokerService.getPulsar().getBookKeeperClient().getLedgerMetadata(ledgerId.longValue()).thenAccept(metadata -> {
                        ManagedLedgerInternalStats.LedgerInfo schemaLedgerInfo = new ManagedLedgerInternalStats.LedgerInfo();
                        schemaLedgerInfo.ledgerId = metadata.getLedgerId();
                        schemaLedgerInfo.entries = metadata.getLastEntryId() + 1L;
                        schemaLedgerInfo.size = metadata.getLength();
                        if (includeLedgerMetadata) {
                            info.metadata = metadata.toSafeString();
                        }
                        stats.schemaLedgers.add(schemaLedgerInfo);
                        completableFuture.complete(null);
                    })).exceptionally(e -> {
                        completableFuture.completeExceptionally((Throwable)e);
                        return null;
                    });
                });
                ((CompletableFuture)FutureUtil.waitForAll(getLedgerMetadataFutures).thenRun(() -> schemaStoreLedgersFuture.complete(null))).exceptionally(e -> {
                    schemaStoreLedgersFuture.completeExceptionally((Throwable)e);
                    return null;
                });
            })).exceptionally(e -> {
                schemaStoreLedgersFuture.completeExceptionally((Throwable)e);
                return null;
            });
        } else {
            schemaStoreLedgersFuture.complete(null);
        }
        ((CompletableFuture)schemaStoreLedgersFuture.thenRun(() -> {
            if (futures != null) {
                FutureUtil.waitForAll((List)futures).handle((res, ex) -> {
                    statFuture.complete(stats);
                    return null;
                });
            } else {
                statFuture.complete(stats);
            }
        })).exceptionally(e -> {
            statFuture.completeExceptionally((Throwable)e);
            return null;
        });
        return statFuture;
    }

    public long getBacklogSize() {
        return this.ledger.getEstimatedBacklogSize();
    }

    public boolean isActive(InactiveTopicDeleteMode deleteMode) {
        switch (deleteMode) {
            case delete_when_no_subscriptions: {
                if (this.subscriptions.isEmpty()) break;
                return true;
            }
            case delete_when_subscriptions_caught_up: {
                if (!this.hasBacklogs()) break;
                return true;
            }
        }
        if (TopicName.get((String)this.topic).isGlobal()) {
            return this.hasLocalProducers();
        }
        return this.currentUsageCount() != 0L;
    }

    private boolean hasBacklogs() {
        return this.subscriptions.values().stream().anyMatch(sub -> sub.getNumberOfEntriesInBacklog(false) > 0L);
    }

    @Override
    public void checkGC() {
        if (!this.isDeleteWhileInactive()) {
            return;
        }
        InactiveTopicDeleteMode deleteMode = this.inactiveTopicPolicies.getInactiveTopicDeleteMode();
        int maxInactiveDurationInSec = this.inactiveTopicPolicies.getMaxInactiveDurationSeconds();
        if (this.isActive(deleteMode)) {
            this.lastActive = System.nanoTime();
        } else {
            if (System.nanoTime() - this.lastActive < TimeUnit.SECONDS.toNanos(maxInactiveDurationInSec)) {
                return;
            }
            if (this.shouldTopicBeRetained()) {
                return;
            }
            CompletableFuture replCloseFuture = new CompletableFuture();
            if (TopicName.get((String)this.topic).isGlobal()) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Global topic inactive for {} seconds, closing repl producers.", (Object)this.topic, (Object)maxInactiveDurationInSec);
                }
                ((CompletableFuture)this.closeReplProducersIfNoBacklog().thenRun(() -> {
                    if (this.hasRemoteProducers()) {
                        if (log.isDebugEnabled()) {
                            log.debug("[{}] Global topic has connected remote producers. Not a candidate for GC", (Object)this.topic);
                        }
                        replCloseFuture.completeExceptionally(new BrokerServiceException.TopicBusyException("Topic has connected remote producers"));
                    } else {
                        log.info("[{}] Global topic inactive for {} seconds, closed repl producers", (Object)this.topic, (Object)maxInactiveDurationInSec);
                        replCloseFuture.complete(null);
                    }
                })).exceptionally(e -> {
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] Global topic has replication backlog. Not a candidate for GC", (Object)this.topic);
                    }
                    replCloseFuture.completeExceptionally(e.getCause());
                    return null;
                });
            } else {
                replCloseFuture.complete(null);
            }
            ((CompletableFuture)((CompletableFuture)((CompletableFuture)replCloseFuture.thenCompose(v -> this.delete(deleteMode == InactiveTopicDeleteMode.delete_when_no_subscriptions, deleteMode == InactiveTopicDeleteMode.delete_when_subscriptions_caught_up, true))).thenApply(res -> this.tryToDeletePartitionedMetadata())).thenRun(() -> log.info("[{}] Topic deleted successfully due to inactivity", (Object)this.topic))).exceptionally(e -> {
                if (e.getCause() instanceof BrokerServiceException.TopicBusyException) {
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] Did not delete busy topic: {}", (Object)this.topic, (Object)e.getCause().getMessage());
                    }
                } else {
                    log.warn("[{}] Inactive topic deletion failed", (Object)this.topic, e);
                }
                return null;
            });
        }
    }

    private CompletableFuture<Void> tryToDeletePartitionedMetadata() {
        if (TopicName.get((String)this.topic).isPartitioned() && !this.deletePartitionedTopicMetadataWhileInactive()) {
            return CompletableFuture.completedFuture(null);
        }
        TopicName topicName = TopicName.get((String)TopicName.get((String)this.topic).getPartitionedTopicName());
        String path = AdminResource.path("partitioned-topics", topicName.getNamespace(), topicName.getDomain().value(), topicName.getEncodedLocalName());
        try {
            NamespaceResources.PartitionedTopicResources partitionedTopicResources = this.getBrokerService().pulsar().getPulsarResources().getNamespaceResources().getPartitionedTopicResources();
            if (topicName.isPartitioned() && !partitionedTopicResources.exists(path)) {
                return CompletableFuture.completedFuture(null);
            }
            CompletableFuture<Void> deleteMetadataFuture = new CompletableFuture<Void>();
            ((CompletableFuture)((CompletableFuture)this.getBrokerService().fetchPartitionedTopicMetadataAsync(TopicName.get((String)topicName.getPartitionedTopicName())).thenAccept(metadata -> {
                String managedPath = String.format("/managed-ledgers/%s/%s", topicName.getNamespace(), topicName.getDomain().value());
                Set cache = null;
                try {
                    cache = this.brokerService.pulsar().getLocalZkCacheService().managedLedgerListCache().get(managedPath);
                }
                catch (Exception e) {
                    deleteMetadataFuture.completeExceptionally(e);
                }
                if (cache == null) {
                    return;
                }
                for (int i = 0; i < metadata.partitions; ++i) {
                    if (!cache.contains(topicName.getPartition(i).getLocalName())) continue;
                    throw new UnsupportedOperationException();
                }
            })).thenAccept(res -> ((CompletableFuture)partitionedTopicResources.deleteAsync(path).thenAccept(r -> deleteMetadataFuture.complete(null))).exceptionally(ex -> {
                deleteMetadataFuture.completeExceptionally(ex.getCause());
                return null;
            }))).exceptionally(e -> {
                if (!(e.getCause() instanceof UnsupportedOperationException)) {
                    log.error("delete metadata fail", e);
                }
                deleteMetadataFuture.complete(null);
                return null;
            });
            return deleteMetadataFuture;
        }
        catch (Exception e2) {
            return FutureUtil.failedFuture((Throwable)e2);
        }
    }

    @Override
    public void checkInactiveSubscriptions() {
        block3: {
            TopicName name = TopicName.get((String)this.topic);
            try {
                Policies policies = (Policies)this.brokerService.pulsar().getConfigurationCache().policiesCache().get(AdminResource.path("policies", name.getNamespace())).orElseThrow(() -> new KeeperException.NoNodeException());
                int defaultExpirationTime = this.brokerService.pulsar().getConfiguration().getSubscriptionExpirationTimeMinutes();
                long expirationTimeMillis = TimeUnit.MINUTES.toMillis(policies.subscription_expiration_time_minutes <= 0 && defaultExpirationTime > 0 ? (long)defaultExpirationTime : (long)policies.subscription_expiration_time_minutes);
                if (expirationTimeMillis > 0L) {
                    this.subscriptions.forEach((subName, sub) -> {
                        if (sub.dispatcher != null && sub.dispatcher.isConsumerConnected() || sub.isReplicated()) {
                            return;
                        }
                        if (System.currentTimeMillis() - sub.cursor.getLastActive() > expirationTimeMillis) {
                            sub.delete().thenAccept(v -> log.info("[{}][{}] The subscription was deleted due to expiration", (Object)this.topic, subName));
                        }
                    });
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug("[{}] Error getting policies", (Object)this.topic);
            }
        }
    }

    @Override
    public void checkBackloggedCursors() {
        this.subscriptions.forEach((subName, subscription) -> {
            if (!subscription.getConsumers().isEmpty() && subscription.getCursor().getNumberOfEntries() < this.backloggedCursorThresholdEntries) {
                subscription.getCursor().setActive();
            } else {
                subscription.getCursor().setInactive();
            }
        });
    }

    @Override
    public void checkDeduplicationSnapshot() {
        this.messageDeduplication.takeSnapshot();
    }

    private boolean shouldTopicBeRetained() {
        RetentionPolicies retentionPolicies = null;
        try {
            retentionPolicies = this.getTopicPolicies().map(TopicPolicies::getRetentionPolicies).orElse(null);
            if (retentionPolicies == null) {
                TopicName name = TopicName.get((String)this.topic);
                retentionPolicies = this.brokerService.pulsar().getConfigurationCache().policiesCache().get(AdminResource.path("policies", name.getNamespace())).map(p -> p.retention_policies).orElse(null);
            }
            if (retentionPolicies == null) {
                retentionPolicies = new RetentionPolicies(this.brokerService.pulsar().getConfiguration().getDefaultRetentionTimeInMinutes(), this.brokerService.pulsar().getConfiguration().getDefaultRetentionSizeInMB());
            }
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Error getting policies", (Object)this.topic);
            }
            return true;
        }
        long retentionTime = TimeUnit.MINUTES.toNanos(retentionPolicies.getRetentionTimeInMinutes());
        return retentionTime < 0L || System.nanoTime() - this.lastActive < retentionTime;
    }

    @Override
    public CompletableFuture<Void> onPoliciesUpdate(Policies data) {
        if (log.isDebugEnabled()) {
            log.debug("[{}] isEncryptionRequired changes: {} -> {}", new Object[]{this.topic, this.isEncryptionRequired, data.encryption_required});
        }
        if (data.deleted) {
            log.debug("Ignore the update because it has been deleted : {}", (Object)data);
            return CompletableFuture.completedFuture(null);
        }
        this.isEncryptionRequired = data.encryption_required;
        this.setSchemaCompatibilityStrategy(data);
        this.isAllowAutoUpdateSchema = data.is_allow_auto_update_schema;
        this.schemaValidationEnforced = data.schema_validation_enforced;
        this.updateUnackedMessagesAppliedOnSubscription(data);
        this.updateUnackedMessagesExceededOnConsumer(data);
        this.maxSubscriptionsPerTopic = data.max_subscriptions_per_topic;
        if (data.delayed_delivery_policies != null) {
            this.delayedDeliveryTickTimeMillis = data.delayed_delivery_policies.getTickTime();
            this.delayedDeliveryEnabled = data.delayed_delivery_policies.isActive();
        }
        Optional<TopicPolicies> topicPolicies = this.getTopicPolicies();
        if (data.inactive_topic_policies != null) {
            if (!topicPolicies.isPresent() || !topicPolicies.get().isInactiveTopicPoliciesSet()) {
                this.inactiveTopicPolicies = data.inactive_topic_policies;
            }
        } else {
            ServiceConfiguration cfg = this.brokerService.getPulsar().getConfiguration();
            this.resetInactiveTopicPolicies(cfg.getBrokerDeleteInactiveTopicsMode(), cfg.getBrokerDeleteInactiveTopicsMaxInactiveDurationSeconds(), cfg.isBrokerDeleteInactiveTopicsEnabled());
        }
        this.initializeDispatchRateLimiterIfNeeded(Optional.ofNullable(data));
        this.updateMaxPublishRate(data);
        this.producers.values().forEach(producer -> {
            producer.checkPermissions();
            producer.checkEncryption();
        });
        this.subscriptions.forEach((subName, sub) -> {
            sub.getConsumers().forEach(Consumer::checkPermissions);
            Dispatcher dispatcher = sub.getDispatcher();
            if (!(dispatcher == null || topicPolicies.isPresent() && ((TopicPolicies)topicPolicies.get()).isSubscriptionDispatchRateSet())) {
                dispatcher.getRateLimiter().ifPresent(rateLimiter -> rateLimiter.onPoliciesUpdate(data));
            }
        });
        this.replicators.forEach((name, replicator) -> replicator.getRateLimiter().ifPresent(DispatchRateLimiter::updateDispatchRate));
        this.checkMessageExpiry();
        CompletableFuture<Void> replicationFuture = this.checkReplicationAndRetryOnFailure();
        CompletableFuture<Void> dedupFuture = this.checkDeduplicationStatus();
        CompletableFuture<Void> persistentPoliciesFuture = this.checkPersistencePolicies();
        if (!(!this.dispatchRateLimiter.isPresent() || topicPolicies.isPresent() && topicPolicies.get().isDispatchRateSet())) {
            this.dispatchRateLimiter.get().onPoliciesUpdate(data);
        }
        if (this.subscribeRateLimiter.isPresent()) {
            this.subscribeRateLimiter.get().onPoliciesUpdate(data);
        }
        return CompletableFuture.allOf(replicationFuture, dedupFuture, persistentPoliciesFuture);
    }

    @Override
    public BacklogQuota getBacklogQuota() {
        TopicName topicName = TopicName.get((String)this.getName());
        return this.brokerService.getBacklogQuotaManager().getBacklogQuota(topicName);
    }

    @Override
    public boolean isBacklogQuotaExceeded(String producerName) {
        BacklogQuota backlogQuota = this.getBacklogQuota();
        if (backlogQuota != null) {
            BacklogQuota.RetentionPolicy retentionPolicy = backlogQuota.getPolicy();
            if ((retentionPolicy == BacklogQuota.RetentionPolicy.producer_request_hold || retentionPolicy == BacklogQuota.RetentionPolicy.producer_exception) && (this.isSizeBacklogExceeded() || this.isTimeBacklogExceeded())) {
                log.info("[{}] Backlog quota exceeded. Cannot create producer [{}]", (Object)this.getName(), (Object)producerName);
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean isSizeBacklogExceeded() {
        TopicName topicName = TopicName.get((String)this.getName());
        long backlogQuotaLimitInBytes = this.brokerService.getBacklogQuotaManager().getBacklogQuotaLimitInSize(topicName);
        if (backlogQuotaLimitInBytes < 0L) {
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug("[{}] - backlog quota limit = [{}]", (Object)this.getName(), (Object)backlogQuotaLimitInBytes);
        }
        long storageSize = this.getBacklogSize();
        if (log.isDebugEnabled()) {
            log.debug("[{}] Storage size = [{}], limit [{}]", new Object[]{this.getName(), storageSize, backlogQuotaLimitInBytes});
        }
        return storageSize >= backlogQuotaLimitInBytes;
    }

    public boolean isTimeBacklogExceeded() {
        final TopicName topicName = TopicName.get((String)this.getName());
        final CompletableFuture future = new CompletableFuture();
        final int backlogQuotaLimitInSecond = this.brokerService.getBacklogQuotaManager().getBacklogQuotaLimitInTime(topicName);
        if (backlogQuotaLimitInSecond <= 0 || ((ManagedCursorContainer)this.ledger.getCursors()).getSlowestReaderPosition() == null) {
            return false;
        }
        if (this.brokerService.pulsar().getConfiguration().isPreciseTimeBasedBacklogQuotaCheck()) {
            PositionImpl position = ((ManagedLedgerImpl)this.ledger).getNextValidPosition(((ManagedCursorContainer)this.ledger.getCursors()).getSlowestReaderPosition());
            ((ManagedLedgerImpl)this.ledger).asyncReadEntry(position, new AsyncCallbacks.ReadEntryCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void readEntryComplete(Entry entry, Object ctx) {
                    MessageImpl msg = null;
                    try {
                        msg = MessageImpl.deserializeBrokerEntryMetaDataFirst((ByteBuf)entry.getDataBuffer());
                        boolean expired = msg.isExpired(backlogQuotaLimitInSecond);
                        if (expired && log.isDebugEnabled()) {
                            log.debug("Time based backlog quota exceeded, oldest entry in cursor {}'s backlogexceeded quota {}", (Object)((ManagedLedgerImpl)PersistentTopic.this.ledger).getSlowestConsumer().getName(), (Object)backlogQuotaLimitInSecond);
                        }
                        future.complete(expired);
                    }
                    catch (Exception e) {
                        log.error("[{}][{}] Error deserializing message for backlog check", (Throwable)e);
                        future.complete(false);
                    }
                    finally {
                        entry.release();
                        if (msg != null) {
                            msg.recycle();
                        }
                    }
                }

                public void readEntryFailed(ManagedLedgerException exception, Object ctx) {
                    log.error("[{}][{}] Error reading entry for precise time based  backlog check", (Object)topicName, (Object)exception);
                    future.complete(false);
                }
            }, null);
            try {
                return (Boolean)future.get();
            }
            catch (Exception e) {
                log.error("[{}][{}] Error reading entry for precise time based backlog check", (Object)topicName, (Object)e);
                return false;
            }
        }
        Long ledgerId = ((ManagedCursorContainer)this.ledger.getCursors()).getSlowestReaderPosition().getLedgerId();
        try {
            MLDataFormats.ManagedLedgerInfo.LedgerInfo ledgerInfo = (MLDataFormats.ManagedLedgerInfo.LedgerInfo)this.ledger.getLedgerInfo(ledgerId.longValue()).get();
            if (ledgerInfo != null && ledgerInfo.hasTimestamp() && ledgerInfo.getTimestamp() > 0L && ((ManagedLedgerImpl)this.ledger).getClock().millis() - ledgerInfo.getTimestamp() > (long)(backlogQuotaLimitInSecond * 1000)) {
                if (log.isDebugEnabled()) {
                    log.debug("Time based backlog quota exceeded, quota {}, age of ledger slowest cursor currently on {}", (Object)(backlogQuotaLimitInSecond * 1000), (Object)(((ManagedLedgerImpl)this.ledger).getClock().millis() - ledgerInfo.getTimestamp()));
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            log.error("[{}][{}] Error reading entry for precise time based backlog check", (Object)topicName, (Object)e);
            return false;
        }
    }

    @Override
    public boolean isReplicated() {
        return !this.replicators.isEmpty();
    }

    public CompletableFuture<MessageId> terminate() {
        final CompletableFuture<MessageId> future = new CompletableFuture<MessageId>();
        this.ledger.asyncTerminate(new AsyncCallbacks.TerminateCallback(){

            public void terminateComplete(Position lastCommittedPosition, Object ctx) {
                PersistentTopic.this.producers.values().forEach(Producer::disconnect);
                PersistentTopic.this.subscriptions.forEach((name, sub) -> sub.topicTerminated());
                PositionImpl lastPosition = (PositionImpl)lastCommittedPosition;
                MessageIdImpl messageId = new MessageIdImpl(lastPosition.getLedgerId(), lastPosition.getEntryId(), -1);
                log.info("[{}] Topic terminated at {}", (Object)PersistentTopic.this.getName(), (Object)messageId);
                future.complete(messageId);
            }

            public void terminateFailed(ManagedLedgerException exception, Object ctx) {
                future.completeExceptionally(exception);
            }
        }, null);
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOldestMessageExpired(ManagedCursor cursor, int messageTTLInSeconds) {
        MessageImpl msg = null;
        Entry entry = null;
        boolean isOldestMessageExpired = false;
        try {
            entry = cursor.getNthEntry(1, ManagedCursor.IndividualDeletedEntries.Include);
            if (entry != null) {
                msg = MessageImpl.deserializeBrokerEntryMetaDataFirst((ByteBuf)entry.getDataBuffer());
                if (messageTTLInSeconds != 0) {
                    isOldestMessageExpired = msg.isExpired((int)((double)messageTTLInSeconds * 1.5));
                }
            }
        }
        catch (Exception e) {
            log.warn("[{}] Error while getting the oldest message", (Object)this.topic, (Object)e);
        }
        finally {
            if (entry != null) {
                entry.release();
            }
            if (msg != null) {
                msg.recycle();
            }
        }
        return isOldestMessageExpired;
    }

    public CompletableFuture<Void> clearBacklog() {
        log.info("[{}] Clearing backlog on all cursors in the topic.", (Object)this.topic);
        ArrayList futures = Lists.newArrayList();
        List cursors = this.getSubscriptions().keys();
        cursors.addAll(this.getReplicators().keys());
        for (String cursor : cursors) {
            futures.add(this.clearBacklog(cursor));
        }
        return FutureUtil.waitForAll((List)futures);
    }

    public CompletableFuture<Void> clearBacklog(String cursorName) {
        log.info("[{}] Clearing backlog for cursor {} in the topic.", (Object)this.topic, (Object)cursorName);
        PersistentSubscription sub = this.getSubscription(cursorName);
        if (sub != null) {
            return sub.clearBacklog();
        }
        PersistentReplicator repl = (PersistentReplicator)this.getPersistentReplicator(cursorName);
        if (repl != null) {
            return repl.clearBacklog();
        }
        return FutureUtil.failedFuture((Throwable)new BrokerServiceException("Cursor not found"));
    }

    @Override
    public Optional<DispatchRateLimiter> getDispatchRateLimiter() {
        return this.dispatchRateLimiter;
    }

    public Optional<SubscribeRateLimiter> getSubscribeRateLimiter() {
        return this.subscribeRateLimiter;
    }

    public long getLastPublishedSequenceId(String producerName) {
        return this.messageDeduplication.getLastPublishedSequenceId(producerName);
    }

    @Override
    public Position getLastPosition() {
        return this.ledger.getLastConfirmedEntry();
    }

    @Override
    public CompletableFuture<MessageId> getLastMessageId() {
        final CompletableFuture<MessageId> completableFuture = new CompletableFuture<MessageId>();
        final PositionImpl position = (PositionImpl)this.ledger.getLastConfirmedEntry();
        String name = this.getName();
        final int partitionIndex = TopicName.getPartitionIndex((String)name);
        if (log.isDebugEnabled()) {
            log.debug("getLastMessageId {}, partitionIndex{}, position {}", new Object[]{name, partitionIndex, position});
        }
        if (position.getEntryId() == -1L) {
            completableFuture.complete((MessageId)new MessageIdImpl(position.getLedgerId(), position.getEntryId(), partitionIndex));
            return completableFuture;
        }
        ManagedLedgerImpl ledgerImpl = (ManagedLedgerImpl)this.ledger;
        if (!ledgerImpl.ledgerExists(position.getLedgerId())) {
            completableFuture.complete(MessageId.earliest);
            return completableFuture;
        }
        ledgerImpl.asyncReadEntry(position, new AsyncCallbacks.ReadEntryCallback(){

            public void readEntryComplete(Entry entry, Object ctx) {
                MessageMetadata metadata = Commands.parseMessageMetadata((ByteBuf)entry.getDataBuffer());
                if (metadata.hasNumMessagesInBatch()) {
                    completableFuture.complete(new BatchMessageIdImpl(position.getLedgerId(), position.getEntryId(), partitionIndex, metadata.getNumMessagesInBatch() - 1));
                } else {
                    completableFuture.complete(new MessageIdImpl(position.getLedgerId(), position.getEntryId(), partitionIndex));
                }
            }

            public void readEntryFailed(ManagedLedgerException exception, Object ctx) {
                completableFuture.completeExceptionally(exception);
            }
        }, null);
        return completableFuture;
    }

    public synchronized void triggerCompaction() throws PulsarServerException, BrokerServiceException.AlreadyRunningException {
        if (!this.currentCompaction.isDone()) {
            throw new BrokerServiceException.AlreadyRunningException("Compaction already in progress");
        }
        this.currentCompaction = this.brokerService.pulsar().getCompactor().compact(this.topic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized LongRunningProcessStatus compactionStatus() {
        CompletableFuture<Long> current;
        PersistentTopic persistentTopic = this;
        synchronized (persistentTopic) {
            current = this.currentCompaction;
        }
        if (!current.isDone()) {
            return LongRunningProcessStatus.forStatus((LongRunningProcessStatus.Status)LongRunningProcessStatus.Status.RUNNING);
        }
        try {
            if (current.join() == -4273917950L) {
                return LongRunningProcessStatus.forStatus((LongRunningProcessStatus.Status)LongRunningProcessStatus.Status.NOT_RUN);
            }
            return LongRunningProcessStatus.forStatus((LongRunningProcessStatus.Status)LongRunningProcessStatus.Status.SUCCESS);
        }
        catch (CancellationException | CompletionException e) {
            return LongRunningProcessStatus.forError((String)e.getMessage());
        }
    }

    public synchronized void triggerOffload(final MessageIdImpl messageId) throws BrokerServiceException.AlreadyRunningException {
        if (!this.currentOffload.isDone()) {
            throw new BrokerServiceException.AlreadyRunningException("Offload already in progress");
        }
        this.currentOffload = new CompletableFuture();
        final CompletableFuture promise = this.currentOffload;
        log.info("[{}] Starting offload operation at messageId {}", (Object)this.topic, (Object)messageId);
        this.getManagedLedger().asyncOffloadPrefix((Position)PositionImpl.get((long)messageId.getLedgerId(), (long)messageId.getEntryId()), new AsyncCallbacks.OffloadCallback(){

            public void offloadComplete(Position pos, Object ctx) {
                PositionImpl impl = (PositionImpl)pos;
                log.info("[{}] Completed successfully offload operation at messageId {}", (Object)PersistentTopic.this.topic, (Object)messageId);
                promise.complete(new MessageIdImpl(impl.getLedgerId(), impl.getEntryId(), -1));
            }

            public void offloadFailed(ManagedLedgerException exception, Object ctx) {
                log.warn("[{}] Failed offload operation at messageId {}", new Object[]{PersistentTopic.this.topic, messageId, exception});
                promise.completeExceptionally(exception);
            }
        }, null);
    }

    public synchronized OffloadProcessStatus offloadStatus() {
        if (!this.currentOffload.isDone()) {
            return OffloadProcessStatus.forStatus((LongRunningProcessStatus.Status)LongRunningProcessStatus.Status.RUNNING);
        }
        try {
            if (this.currentOffload.join() == MessageId.earliest) {
                return OffloadProcessStatus.forStatus((LongRunningProcessStatus.Status)LongRunningProcessStatus.Status.NOT_RUN);
            }
            return OffloadProcessStatus.forSuccess((MessageId)((MessageId)this.currentOffload.join()));
        }
        catch (CancellationException | CompletionException e) {
            log.warn("Failed to offload", e.getCause());
            return OffloadProcessStatus.forError((String)e.getMessage());
        }
    }

    private int getMessageTTL() throws Exception {
        Optional<Integer> messageTtl = this.getTopicPolicies().map(TopicPolicies::getMessageTTLInSeconds);
        if (messageTtl.isPresent()) {
            return messageTtl.get();
        }
        TopicName name = TopicName.get((String)this.topic);
        Policies policies = (Policies)this.brokerService.pulsar().getConfigurationCache().policiesCache().get(AdminResource.path("policies", name.getNamespace())).orElseThrow(KeeperException.NoNodeException::new);
        if (policies.message_ttl_in_seconds != null) {
            return policies.message_ttl_in_seconds;
        }
        return this.brokerService.getPulsar().getConfiguration().getTtlDurationDefaultInSeconds();
    }

    @Override
    public CompletableFuture<Void> addSchemaIfIdleOrCheckCompatible(SchemaData schema) {
        return this.hasSchema().thenCompose(hasSchema -> {
            int numActiveConsumers = this.subscriptions.values().stream().mapToInt(subscription -> subscription.getConsumers().size()).sum();
            if (hasSchema.booleanValue() || !this.producers.isEmpty() || numActiveConsumers != 0 || this.ledger.getTotalSize() != 0L) {
                return this.checkSchemaCompatibleForConsumer(schema);
            }
            return this.addSchema(schema).thenCompose(schemaVersion -> CompletableFuture.completedFuture(null));
        });
    }

    private synchronized void checkReplicatedSubscriptionControllerState() {
        AtomicBoolean shouldBeEnabled = new AtomicBoolean(false);
        this.subscriptions.forEach((name, subscription) -> {
            if (subscription.isReplicated()) {
                shouldBeEnabled.set(true);
            }
        });
        if (!shouldBeEnabled.get()) {
            log.info("[{}] There are no replicated subscriptions on the topic", (Object)this.topic);
        }
        this.checkReplicatedSubscriptionControllerState(shouldBeEnabled.get());
    }

    private synchronized void checkReplicatedSubscriptionControllerState(boolean shouldBeEnabled) {
        boolean isCurrentlyEnabled = this.replicatedSubscriptionsController.isPresent();
        boolean isEnableReplicatedSubscriptions = this.brokerService.pulsar().getConfiguration().isEnableReplicatedSubscriptions();
        if (shouldBeEnabled && !isCurrentlyEnabled && isEnableReplicatedSubscriptions) {
            log.info("[{}] Enabling replicated subscriptions controller", (Object)this.topic);
            this.replicatedSubscriptionsController = Optional.of(new ReplicatedSubscriptionsController(this, this.brokerService.pulsar().getConfiguration().getClusterName()));
        } else if (isCurrentlyEnabled && !shouldBeEnabled || !isEnableReplicatedSubscriptions) {
            log.info("[{}] Disabled replicated subscriptions controller", (Object)this.topic);
            this.replicatedSubscriptionsController.ifPresent(ReplicatedSubscriptionsController::close);
            this.replicatedSubscriptionsController = Optional.empty();
        }
    }

    void receivedReplicatedSubscriptionMarker(Position position, int markerType, ByteBuf payload) {
        ReplicatedSubscriptionsController ctrl = this.replicatedSubscriptionsController.orElse(null);
        if (ctrl == null) {
            this.checkReplicatedSubscriptionControllerState(true);
            ctrl = this.replicatedSubscriptionsController.get();
        }
        ctrl.receivedReplicatedSubscriptionMarker(position, markerType, payload);
    }

    public Optional<ReplicatedSubscriptionsController> getReplicatedSubscriptionController() {
        return this.replicatedSubscriptionsController;
    }

    public CompactedTopic getCompactedTopic() {
        return this.compactedTopic;
    }

    @Override
    public boolean isSystemTopic() {
        return false;
    }

    private synchronized void fence() {
        int timeout;
        this.isFenced = true;
        ScheduledFuture<?> monitoringTask = this.fencedTopicMonitoringTask;
        if ((monitoringTask == null || monitoringTask.isDone()) && (timeout = this.brokerService.pulsar().getConfiguration().getTopicFencingTimeoutSeconds()) > 0) {
            this.fencedTopicMonitoringTask = this.brokerService.executor().schedule(this::closeFencedTopicForcefully, (long)timeout, TimeUnit.SECONDS);
        }
    }

    private synchronized void unfence() {
        this.isFenced = false;
        ScheduledFuture<?> monitoringTask = this.fencedTopicMonitoringTask;
        if (monitoringTask != null && !monitoringTask.isDone()) {
            monitoringTask.cancel(false);
        }
    }

    private void closeFencedTopicForcefully() {
        if (this.isFenced) {
            int timeout = this.brokerService.pulsar().getConfiguration().getTopicFencingTimeoutSeconds();
            if (this.isClosingOrDeleting) {
                log.warn("[{}] Topic remained fenced for {} seconds and is already closed (pendingWriteOps: {})", new Object[]{this.topic, timeout, this.pendingWriteOps.get()});
            } else {
                log.error("[{}] Topic remained fenced for {} seconds, so close it (pendingWriteOps: {})", new Object[]{this.topic, timeout, this.pendingWriteOps.get()});
                this.close();
            }
        }
    }

    private void fenceTopicToCloseOrDelete() {
        this.isClosingOrDeleting = true;
        this.isFenced = true;
    }

    private void unfenceTopicToResume() {
        this.isFenced = false;
        this.isClosingOrDeleting = false;
    }

    @Override
    public void publishTxnMessage(TxnID txnID, ByteBuf headersAndPayload, Topic.PublishContext publishContext) {
        this.pendingWriteOps.incrementAndGet();
        headersAndPayload.retain();
        this.transactionCompletableFuture = ((CompletableFuture)this.transactionCompletableFuture.thenAccept(v -> {
            try {
                if (this.isFenced) {
                    publishContext.completed(new BrokerServiceException.TopicFencedException("fenced"), -1L, -1L);
                    this.decrementPendingWriteOpsAndCheck();
                    return;
                }
                if (this.isExceedMaximumMessageSize(headersAndPayload.readableBytes())) {
                    publishContext.completed(new BrokerServiceException.NotAllowedException("Exceed maximum message size"), -1L, -1L);
                    this.decrementPendingWriteOpsAndCheck();
                    return;
                }
                MessageDeduplication.MessageDupStatus status = this.messageDeduplication.isDuplicate(publishContext, headersAndPayload);
                switch (status) {
                    case NotDup: {
                        ((CompletableFuture)this.transactionBuffer.appendBufferToTxn(txnID, publishContext.getSequenceId(), headersAndPayload).thenAccept(position -> {
                            this.messageDeduplication.recordMessagePersisted(publishContext, (PositionImpl)position);
                            publishContext.completed(null, ((PositionImpl)position).getLedgerId(), ((PositionImpl)position).getEntryId());
                            this.decrementPendingWriteOpsAndCheck();
                        })).exceptionally(throwable -> {
                            this.addFailed((ManagedLedgerException)((Object)((Object)throwable)), publishContext);
                            return null;
                        });
                        return;
                    }
                    case Dup: {
                        publishContext.completed(null, -1L, -1L);
                        this.decrementPendingWriteOpsAndCheck();
                        return;
                    }
                    default: {
                        publishContext.completed(new MessageDeduplication.MessageDupUnknownException(), -1L, -1L);
                        this.decrementPendingWriteOpsAndCheck();
                        return;
                    }
                }
            }
            finally {
                headersAndPayload.release();
            }
        })).exceptionally(e -> {
            headersAndPayload.release();
            return null;
        });
    }

    @Override
    public CompletableFuture<Void> endTxn(TxnID txnID, int txnAction, long lowWaterMark) {
        return this.transactionCompletableFuture.thenCompose(future -> {
            if (0 == txnAction) {
                return this.transactionBuffer.commitTxn(txnID, lowWaterMark);
            }
            if (1 == txnAction) {
                return this.transactionBuffer.abortTxn(txnID, lowWaterMark);
            }
            return FutureUtil.failedFuture((Throwable)new BrokerServiceException.NotAllowedException("Unsupported txnAction " + txnAction));
        });
    }

    @Override
    public CompletableFuture<Void> truncate() {
        return this.ledger.asyncTruncate();
    }

    public long getDelayedDeliveryTickTimeMillis() {
        return this.getTopicPolicies().map(TopicPolicies::getDelayedDeliveryTickTimeMillis).orElse(this.delayedDeliveryTickTimeMillis);
    }

    public int getMaxUnackedMessagesOnConsumer() {
        return this.maxUnackedMessagesOnConsumerAppilied;
    }

    public boolean isDelayedDeliveryEnabled() {
        return this.getTopicPolicies().map(TopicPolicies::getDelayedDeliveryEnabled).orElse(this.delayedDeliveryEnabled);
    }

    public int getMaxUnackedMessagesOnSubscription() {
        return this.maxUnackedMessagesOnSubscriptionApplied;
    }

    @Override
    public void onUpdate(TopicPolicies policies) {
        if (log.isDebugEnabled()) {
            log.debug("[{}] update topic policy: {}", (Object)this.topic, (Object)policies);
        }
        if (policies == null) {
            return;
        }
        Optional<Policies> namespacePolicies = this.getNamespacePolicies();
        this.initializeTopicDispatchRateLimiterIfNeeded(policies);
        this.dispatchRateLimiter.ifPresent(limiter -> {
            if (policies.isDispatchRateSet()) {
                this.dispatchRateLimiter.get().updateDispatchRate((DispatchRate)policies.getDispatchRate());
            } else {
                this.dispatchRateLimiter.get().updateDispatchRate();
            }
        });
        this.subscriptions.forEach((subName, sub) -> {
            sub.getConsumers().forEach(Consumer::checkPermissions);
            Dispatcher dispatcher = sub.getDispatcher();
            dispatcher.updateRateLimiter((DispatchRate)policies.getSubscriptionDispatchRate());
        });
        if (policies.getPublishRate() != null) {
            this.updatePublishDispatcher(policies.getPublishRate());
        } else {
            this.updateMaxPublishRate(namespacePolicies.orElse(null));
        }
        if (policies.isInactiveTopicPoliciesSet()) {
            this.inactiveTopicPolicies = policies.getInactiveTopicPolicies();
        } else if (namespacePolicies.isPresent() && namespacePolicies.get().inactive_topic_policies != null) {
            this.inactiveTopicPolicies = namespacePolicies.get().inactive_topic_policies;
        } else {
            ServiceConfiguration cfg = this.brokerService.getPulsar().getConfiguration();
            this.resetInactiveTopicPolicies(cfg.getBrokerDeleteInactiveTopicsMode(), cfg.getBrokerDeleteInactiveTopicsMaxInactiveDurationSeconds(), cfg.isBrokerDeleteInactiveTopicsEnabled());
        }
        this.updateUnackedMessagesAppliedOnSubscription(namespacePolicies.orElse(null));
        this.initializeTopicSubscribeRateLimiterIfNeeded(Optional.ofNullable(policies));
        if (this.subscribeRateLimiter.isPresent()) {
            this.subscribeRateLimiter.ifPresent(subscribeRateLimiter -> subscribeRateLimiter.onSubscribeRateUpdate(policies.getSubscribeRate()));
        }
        this.replicators.forEach((name, replicator) -> replicator.getRateLimiter().ifPresent(DispatchRateLimiter::updateDispatchRate));
        this.updateUnackedMessagesExceededOnConsumer(namespacePolicies.orElse(null));
        this.checkDeduplicationStatus();
    }

    private Optional<Policies> getNamespacePolicies() {
        return DispatchRateLimiter.getPolicies(this.brokerService, this.topic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeTopicDispatchRateLimiterIfNeeded(TopicPolicies policies) {
        Optional<DispatchRateLimiter> optional = this.dispatchRateLimiter;
        synchronized (optional) {
            if (!this.dispatchRateLimiter.isPresent() && policies.getDispatchRate() != null) {
                this.dispatchRateLimiter = Optional.of(new DispatchRateLimiter(this, DispatchRateLimiter.Type.TOPIC));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeTopicSubscribeRateLimiterIfNeeded(Optional<TopicPolicies> policies) {
        Optional<SubscribeRateLimiter> optional = this.subscribeRateLimiter;
        synchronized (optional) {
            if (!this.subscribeRateLimiter.isPresent() && policies.isPresent() && policies.get().getSubscribeRate() != null) {
                this.subscribeRateLimiter = Optional.of(new SubscribeRateLimiter(this));
            }
        }
    }

    private PersistentTopic getPersistentTopic() {
        return this;
    }

    private void registerTopicPolicyListener() {
        if (this.brokerService.pulsar().getConfig().isSystemTopicEnabled() && this.brokerService.pulsar().getConfig().isTopicLevelPoliciesEnabled()) {
            TopicName topicName;
            TopicName cloneTopicName = topicName = TopicName.get((String)this.topic);
            if (topicName.isPartitioned()) {
                cloneTopicName = TopicName.get((String)topicName.getPartitionedTopicName());
            }
            this.brokerService.getPulsar().getTopicPoliciesService().registerListener(cloneTopicName, this);
        }
    }

    @VisibleForTesting
    public MessageDeduplication getMessageDeduplication() {
        return this.messageDeduplication;
    }

    private boolean checkMaxSubscriptionsPerTopicExceed(String subscriptionName) {
        if (StringUtils.isNotEmpty((CharSequence)subscriptionName) && this.getSubscription(subscriptionName) != null) {
            return false;
        }
        Integer maxSubsPerTopic = this.getTopicPolicies().map(TopicPolicies::getMaxSubscriptionsPerTopic).orElseGet(() -> {
            if (this.maxSubscriptionsPerTopic != null) {
                return this.maxSubscriptionsPerTopic;
            }
            return this.brokerService.pulsar().getConfig().getMaxSubscriptionsPerTopic();
        });
        return maxSubsPerTopic > 0 && this.subscriptions != null && this.subscriptions.size() >= (long)maxSubsPerTopic.intValue();
    }

    public boolean checkSubscriptionTypesEnable(CommandSubscribe.SubType subType) throws Exception {
        TopicName topicName = TopicName.get((String)this.topic);
        if (this.brokerService.pulsar().getConfiguration().isTopicLevelPoliciesEnabled()) {
            try {
                TopicPolicies topicPolicies = this.brokerService.pulsar().getTopicPoliciesService().getTopicPolicies(TopicName.get((String)this.topic));
                if (topicPolicies == null) {
                    return this.checkNsAndBrokerSubscriptionTypesEnable(topicName, subType);
                }
                if (topicPolicies.getSubscriptionTypesEnabled().isEmpty()) {
                    return this.checkNsAndBrokerSubscriptionTypesEnable(topicName, subType);
                }
                return topicPolicies.getSubscriptionTypesEnabled().contains(subType);
            }
            catch (BrokerServiceException.TopicPoliciesCacheNotInitException e) {
                return this.checkNsAndBrokerSubscriptionTypesEnable(topicName, subType);
            }
        }
        return this.checkNsAndBrokerSubscriptionTypesEnable(topicName, subType);
    }

    private boolean checkNsAndBrokerSubscriptionTypesEnable(TopicName topicName, CommandSubscribe.SubType subType) throws Exception {
        Optional policies = this.brokerService.pulsar().getConfigurationCache().policiesCache().get(AdminResource.path("policies", topicName.getNamespaceObject().toString()));
        if (policies.isPresent()) {
            if (((Policies)policies.get()).subscription_types_enabled.isEmpty()) {
                return this.getBrokerService().getPulsar().getConfiguration().getSubscriptionTypesEnabled().contains(subType.name());
            }
            return ((Policies)policies.get()).subscription_types_enabled.contains(subType.name());
        }
        return this.getBrokerService().getPulsar().getConfiguration().getSubscriptionTypesEnabled().contains(subType.name());
    }

    public TransactionBufferStats getTransactionBufferStats() {
        return this.transactionBuffer.getStats();
    }

    public TransactionPendingAckStats getTransactionPendingAckStats(String subName) {
        return ((PersistentSubscription)this.subscriptions.get((Object)subName)).getTransactionPendingAckStats();
    }

    public PositionImpl getMaxReadPosition() {
        return this.transactionBuffer.getMaxReadPosition();
    }

    public boolean isTxnAborted(TxnID txnID) {
        return this.transactionBuffer.isTxnAborted(txnID);
    }

    public TransactionInBufferStats getTransactionInBufferStats(TxnID txnID) {
        return this.transactionBuffer.getTransactionInBufferStats(txnID);
    }

    @Override
    protected boolean isTerminated() {
        return this.ledger.isTerminated();
    }

    public TransactionInPendingAckStats getTransactionInPendingAckStats(TxnID txnID, String subName) {
        return ((PersistentSubscription)this.subscriptions.get((Object)subName)).getTransactionInPendingAckStats(txnID);
    }

    public CompletableFuture<ManagedLedger> getPendingAckManagedLedger(String subName) {
        PersistentSubscription subscription = (PersistentSubscription)this.subscriptions.get((Object)subName);
        if (subscription == null) {
            return FutureUtil.failedFuture((Throwable)new BrokerServiceException.SubscriptionNotFoundException(this.topic + " not found subscription : " + subName));
        }
        return subscription.getPendingAckManageLedger();
    }

    private static class TopicStatsHelper {
        public double averageMsgSize;
        public double aggMsgRateIn;
        public double aggMsgThroughputIn;
        public double aggMsgThrottlingFailure;
        public double aggMsgRateOut;
        public double aggMsgThroughputOut;
        public final ObjectObjectHashMap<String, PublisherStatsImpl> remotePublishersStats = new ObjectObjectHashMap();

        public TopicStatsHelper() {
            this.reset();
        }

        public void reset() {
            this.averageMsgSize = 0.0;
            this.aggMsgRateIn = 0.0;
            this.aggMsgThroughputIn = 0.0;
            this.aggMsgRateOut = 0.0;
            this.aggMsgThrottlingFailure = 0.0;
            this.aggMsgThroughputOut = 0.0;
            this.remotePublishersStats.clear();
        }
    }
}

