/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.nonpersistent;

import io.netty.buffer.ByteBuf;
import io.netty.util.concurrent.FastThreadLocal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.EntryBatchSizes;
import org.apache.pulsar.broker.service.SendMessageInfo;
import org.apache.pulsar.broker.service.StickyKeyConsumerSelector;
import org.apache.pulsar.broker.service.Subscription;
import org.apache.pulsar.broker.service.nonpersistent.NonPersistentDispatcherMultipleConsumers;
import org.apache.pulsar.broker.service.nonpersistent.NonPersistentTopic;
import org.apache.pulsar.common.api.proto.CommandSubscribe;
import org.apache.pulsar.common.protocol.Commands;

public class NonPersistentStickyKeyDispatcherMultipleConsumers
extends NonPersistentDispatcherMultipleConsumers {
    private final StickyKeyConsumerSelector selector;
    private static final FastThreadLocal<Map<Consumer, List<Entry>>> localGroupedEntries = new FastThreadLocal<Map<Consumer, List<Entry>>>(){

        protected Map<Consumer, List<Entry>> initialValue() throws Exception {
            return new HashMap<Consumer, List<Entry>>();
        }
    };

    public NonPersistentStickyKeyDispatcherMultipleConsumers(NonPersistentTopic topic, Subscription subscription, StickyKeyConsumerSelector selector) {
        super(topic, subscription);
        this.selector = selector;
    }

    @Override
    public synchronized void addConsumer(Consumer consumer) throws BrokerServiceException {
        super.addConsumer(consumer);
        try {
            this.selector.addConsumer(consumer);
        }
        catch (BrokerServiceException e) {
            this.consumerSet.removeAll((Object)consumer);
            this.consumerList.remove(consumer);
            throw e;
        }
    }

    @Override
    public synchronized void removeConsumer(Consumer consumer) throws BrokerServiceException {
        super.removeConsumer(consumer);
        this.selector.removeConsumer(consumer);
    }

    @Override
    public CommandSubscribe.SubType getType() {
        return CommandSubscribe.SubType.Key_Shared;
    }

    @Override
    public void sendMessages(List<Entry> entries) {
        Consumer consumer;
        if (entries.isEmpty()) {
            return;
        }
        if (this.consumerSet.isEmpty()) {
            entries.forEach(Entry::release);
            return;
        }
        Map groupedEntries = (Map)localGroupedEntries.get();
        groupedEntries.clear();
        for (Entry entry : entries) {
            consumer = this.selector.select(this.peekStickyKey(entry.getDataBuffer()));
            if (consumer != null) {
                groupedEntries.computeIfAbsent(consumer, k -> new ArrayList()).add(entry);
                continue;
            }
            entry.release();
        }
        for (Map.Entry entry : groupedEntries.entrySet()) {
            consumer = (Consumer)entry.getKey();
            List entriesForConsumer = (List)entry.getValue();
            SendMessageInfo sendMessageInfo = SendMessageInfo.getThreadLocal();
            EntryBatchSizes batchSizes = EntryBatchSizes.get(entriesForConsumer.size());
            this.filterEntriesForConsumer(entriesForConsumer, batchSizes, sendMessageInfo, null, null, false);
            if (consumer.getAvailablePermits() > 0 && consumer.isWritable()) {
                consumer.sendMessages(entriesForConsumer, batchSizes, null, sendMessageInfo.getTotalMessages(), sendMessageInfo.getTotalBytes(), sendMessageInfo.getTotalChunkedMessages(), this.getRedeliveryTracker());
                TOTAL_AVAILABLE_PERMITS_UPDATER.addAndGet(this, -sendMessageInfo.getTotalMessages());
                continue;
            }
            entriesForConsumer.forEach(e -> {
                int totalMsgs = Commands.getNumberOfMessagesInBatch((ByteBuf)e.getDataBuffer(), (String)this.subscription.toString(), (long)-1L);
                if (totalMsgs > 0) {
                    this.msgDrop.recordEvent((long)totalMsgs);
                }
                e.release();
            });
        }
    }
}

