/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.systopic;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.common.naming.TopicName;

public interface SystemTopicClient<T> {
    public TopicName getTopicName();

    public Reader<T> newReader() throws PulsarClientException;

    public CompletableFuture<Reader<T>> newReaderAsync();

    public Writer<T> newWriter() throws PulsarClientException;

    public CompletableFuture<Writer<T>> newWriterAsync();

    public void close() throws Exception;

    public CompletableFuture<Void> closeAsync();

    public List<Writer<T>> getWriters();

    public List<Reader<T>> getReaders();

    public static boolean isSystemTopic(TopicName topicName) {
        if (topicName.isPartitioned()) {
            return "__change_events".equals(TopicName.get((String)topicName.getPartitionedTopicName()).getLocalName());
        }
        return "__change_events".equals(topicName.getLocalName());
    }

    public static interface Reader<T> {
        public Message<T> readNext() throws PulsarClientException;

        public CompletableFuture<Message<T>> readNextAsync();

        public boolean hasMoreEvents() throws PulsarClientException;

        public CompletableFuture<Boolean> hasMoreEventsAsync();

        public void close() throws IOException;

        public CompletableFuture<Void> closeAsync();

        public SystemTopicClient<T> getSystemTopic();
    }

    public static interface Writer<T> {
        public MessageId write(T var1) throws PulsarClientException;

        public CompletableFuture<MessageId> writeAsync(T var1);

        public void close() throws IOException;

        public CompletableFuture<Void> closeAsync();

        public SystemTopicClient<T> getSystemTopicClient();
    }
}

