/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.transaction.pendingack.impl;

import com.google.common.collect.ComparisonChain;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.ManagedLedger;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.impl.ManagedCursorImpl;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.transaction.pendingack.PendingAckReplyCallBack;
import org.apache.pulsar.broker.transaction.pendingack.PendingAckStore;
import org.apache.pulsar.broker.transaction.pendingack.impl.MLPendingAckReplyCallBack;
import org.apache.pulsar.broker.transaction.pendingack.impl.PendingAckHandleImpl;
import org.apache.pulsar.broker.transaction.pendingack.proto.PendingAckMetadata;
import org.apache.pulsar.broker.transaction.pendingack.proto.PendingAckMetadataEntry;
import org.apache.pulsar.broker.transaction.pendingack.proto.PendingAckOp;
import org.apache.pulsar.client.api.transaction.TxnID;
import org.apache.pulsar.common.allocator.PulsarByteBufAllocator;
import org.apache.pulsar.common.api.proto.CommandAck;
import org.apache.pulsar.common.naming.TopicName;
import org.jctools.queues.MessagePassingQueue;
import org.jctools.queues.SpscArrayQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MLPendingAckStore
implements PendingAckStore {
    private final ManagedLedger managedLedger;
    private final ManagedCursor cursor;
    public static final String PENDING_ACK_STORE_SUFFIX = "__transaction_pending_ack";
    public static final String PENDING_ACK_STORE_CURSOR_NAME = "__pending_ack_state";
    private final SpscArrayQueue<Entry> entryQueue;
    private final PositionImpl lastConfirmedEntry;
    private PositionImpl currentLoadPosition;
    private final ConcurrentSkipListMap<PositionImpl, PositionImpl> metadataPositions;
    private final ManagedCursor subManagedCursor;
    private static final Logger log = LoggerFactory.getLogger(MLPendingAckStore.class);

    public MLPendingAckStore(ManagedLedger managedLedger, ManagedCursor cursor, ManagedCursor subManagedCursor) {
        this.managedLedger = managedLedger;
        this.cursor = cursor;
        this.currentLoadPosition = (PositionImpl)this.cursor.getMarkDeletedPosition();
        this.entryQueue = new SpscArrayQueue(2000);
        this.lastConfirmedEntry = (PositionImpl)managedLedger.getLastConfirmedEntry();
        this.metadataPositions = new ConcurrentSkipListMap();
        this.subManagedCursor = subManagedCursor;
    }

    @Override
    public void replayAsync(PendingAckHandleImpl pendingAckHandle, ScheduledExecutorService transactionReplayExecutor) {
        transactionReplayExecutor.execute(new PendingAckReplay(new MLPendingAckReplyCallBack(pendingAckHandle)));
    }

    private void readAsync(int numberOfEntriesToRead, AsyncCallbacks.ReadEntriesCallback readEntriesCallback) {
        this.cursor.asyncReadEntries(numberOfEntriesToRead, readEntriesCallback, (Object)System.nanoTime(), PositionImpl.latest);
    }

    @Override
    public CompletableFuture<Void> closeAsync() {
        final CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        this.cursor.asyncClose(new AsyncCallbacks.CloseCallback(){

            public void closeComplete(Object ctx) {
                MLPendingAckStore.this.managedLedger.asyncClose(new AsyncCallbacks.CloseCallback(){

                    public void closeComplete(Object ctx) {
                        if (log.isDebugEnabled()) {
                            log.debug("[{}][{}] MLPendingAckStore closed successfully\uff01", (Object)MLPendingAckStore.this.managedLedger.getName(), ctx);
                        }
                        completableFuture.complete(null);
                    }

                    public void closeFailed(ManagedLedgerException exception, Object ctx) {
                        log.error("[{}][{}] MLPendingAckStore closed failed,exception={}", new Object[]{MLPendingAckStore.this.managedLedger.getName(), ctx, exception});
                        completableFuture.completeExceptionally(exception);
                    }
                }, ctx);
            }

            public void closeFailed(ManagedLedgerException exception, Object ctx) {
                completableFuture.completeExceptionally(exception);
            }
        }, null);
        return completableFuture;
    }

    @Override
    public CompletableFuture<Void> appendIndividualAck(TxnID txnID, List<MutablePair<PositionImpl, Integer>> positions) {
        PendingAckMetadataEntry pendingAckMetadataEntry = new PendingAckMetadataEntry();
        pendingAckMetadataEntry.setPendingAckOp(PendingAckOp.ACK);
        pendingAckMetadataEntry.setAckType(CommandAck.AckType.Individual);
        ArrayList<PendingAckMetadata> pendingAckMetadataList = new ArrayList<PendingAckMetadata>();
        positions.forEach(positionIntegerMutablePair -> {
            PendingAckMetadata pendingAckMetadata = new PendingAckMetadata();
            PositionImpl position = (PositionImpl)positionIntegerMutablePair.getLeft();
            int batchSize = (Integer)positionIntegerMutablePair.getRight();
            if (((PositionImpl)positionIntegerMutablePair.getLeft()).getAckSet() != null) {
                for (long l : position.getAckSet()) {
                    pendingAckMetadata.addAckSet(l);
                }
            }
            pendingAckMetadata.setLedgerId(position.getLedgerId());
            pendingAckMetadata.setEntryId(position.getEntryId());
            pendingAckMetadata.setBatchSize(batchSize);
            pendingAckMetadataList.add(pendingAckMetadata);
        });
        pendingAckMetadataEntry.addAllPendingAckMetadatas(pendingAckMetadataList);
        return this.appendCommon(pendingAckMetadataEntry, txnID);
    }

    @Override
    public CompletableFuture<Void> appendCumulativeAck(TxnID txnID, PositionImpl position) {
        PendingAckMetadataEntry pendingAckMetadataEntry = new PendingAckMetadataEntry();
        pendingAckMetadataEntry.setPendingAckOp(PendingAckOp.ACK);
        pendingAckMetadataEntry.setAckType(CommandAck.AckType.Cumulative);
        PendingAckMetadata pendingAckMetadata = new PendingAckMetadata();
        if (position.getAckSet() != null) {
            for (long l : position.getAckSet()) {
                pendingAckMetadata.addAckSet(l);
            }
        }
        pendingAckMetadata.setLedgerId(position.getLedgerId());
        pendingAckMetadata.setEntryId(position.getEntryId());
        pendingAckMetadataEntry.addAllPendingAckMetadatas(Collections.singleton(pendingAckMetadata));
        return this.appendCommon(pendingAckMetadataEntry, txnID);
    }

    @Override
    public CompletableFuture<Void> appendCommitMark(TxnID txnID, CommandAck.AckType ackType) {
        PendingAckMetadataEntry pendingAckMetadataEntry = new PendingAckMetadataEntry();
        pendingAckMetadataEntry.setPendingAckOp(PendingAckOp.COMMIT);
        pendingAckMetadataEntry.setAckType(ackType);
        return this.appendCommon(pendingAckMetadataEntry, txnID);
    }

    @Override
    public CompletableFuture<Void> appendAbortMark(TxnID txnID, CommandAck.AckType ackType) {
        PendingAckMetadataEntry pendingAckMetadataEntry = new PendingAckMetadataEntry();
        pendingAckMetadataEntry.setPendingAckOp(PendingAckOp.ABORT);
        pendingAckMetadataEntry.setAckType(ackType);
        return this.appendCommon(pendingAckMetadataEntry, txnID);
    }

    private CompletableFuture<Void> appendCommon(final PendingAckMetadataEntry pendingAckMetadataEntry, final TxnID txnID) {
        final CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        pendingAckMetadataEntry.setTxnidLeastBits(txnID.getLeastSigBits());
        pendingAckMetadataEntry.setTxnidMostBits(txnID.getMostSigBits());
        int transactionMetadataEntrySize = pendingAckMetadataEntry.getSerializedSize();
        final ByteBuf buf = PulsarByteBufAllocator.DEFAULT.buffer(transactionMetadataEntrySize, transactionMetadataEntrySize);
        pendingAckMetadataEntry.writeTo(buf);
        this.managedLedger.asyncAddEntry(buf, new AsyncCallbacks.AddEntryCallback(){

            public void addComplete(Position position, ByteBuf entryData, Object ctx) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}][{}] MLPendingAckStore message append success at {} txnId: {}, operation : {}", new Object[]{MLPendingAckStore.this.managedLedger.getName(), ctx, position, txnID, pendingAckMetadataEntry.getPendingAckOp()});
                }
                if (pendingAckMetadataEntry.getPendingAckOp() != PendingAckOp.ABORT && pendingAckMetadataEntry.getPendingAckOp() != PendingAckOp.COMMIT) {
                    Optional optional = pendingAckMetadataEntry.getPendingAckMetadatasList().stream().max((o1, o2) -> ComparisonChain.start().compare(o1.getLedgerId(), o2.getLedgerId()).compare(o1.getEntryId(), o2.getEntryId()).result());
                    optional.ifPresent(pendingAckMetadata -> MLPendingAckStore.this.metadataPositions.compute((PositionImpl)position, (thisPosition, otherPosition) -> {
                        PositionImpl nowPosition = PositionImpl.get((long)pendingAckMetadata.getLedgerId(), (long)pendingAckMetadata.getEntryId());
                        if (otherPosition == null) {
                            return nowPosition;
                        }
                        return nowPosition.compareTo(otherPosition) > 0 ? nowPosition : otherPosition;
                    }));
                }
                buf.release();
                completableFuture.complete(null);
                if (!MLPendingAckStore.this.metadataPositions.isEmpty()) {
                    PositionImpl firstPosition = (PositionImpl)MLPendingAckStore.this.metadataPositions.firstEntry().getKey();
                    PositionImpl deletePosition = (PositionImpl)MLPendingAckStore.this.metadataPositions.firstEntry().getKey();
                    while (!MLPendingAckStore.this.metadataPositions.isEmpty() && MLPendingAckStore.this.metadataPositions.firstKey() != null && MLPendingAckStore.this.subManagedCursor.getPersistentMarkDeletedPosition() != null && ((PositionImpl)MLPendingAckStore.this.metadataPositions.firstEntry().getValue()).compareTo((PositionImpl)MLPendingAckStore.this.subManagedCursor.getPersistentMarkDeletedPosition()) <= 0) {
                        deletePosition = (PositionImpl)MLPendingAckStore.this.metadataPositions.firstKey();
                        MLPendingAckStore.this.metadataPositions.remove(MLPendingAckStore.this.metadataPositions.firstKey());
                    }
                    if (firstPosition != deletePosition) {
                        final PositionImpl finalDeletePosition = deletePosition;
                        MLPendingAckStore.this.cursor.asyncMarkDelete((Position)deletePosition, new AsyncCallbacks.MarkDeleteCallback(){

                            public void markDeleteComplete(Object ctx) {
                                if (log.isDebugEnabled()) {
                                    log.debug("[{}] Transaction pending ack store mark delete position : [{}] success", (Object)MLPendingAckStore.this.managedLedger.getName(), (Object)finalDeletePosition);
                                }
                            }

                            public void markDeleteFailed(ManagedLedgerException exception, Object ctx) {
                                if (log.isDebugEnabled()) {
                                    log.error("[{}] Transaction pending ack store mark delete position : [{}] fail!", new Object[]{MLPendingAckStore.this.managedLedger.getName(), finalDeletePosition, exception});
                                }
                            }
                        }, null);
                    }
                }
            }

            public void addFailed(ManagedLedgerException exception, Object ctx) {
                log.error("[{}][{}] MLPendingAckStore message append fail exception : {}, operation : {}", new Object[]{MLPendingAckStore.this.managedLedger.getName(), ctx, exception, pendingAckMetadataEntry.getPendingAckOp()});
                buf.release();
                completableFuture.completeExceptionally(new BrokerServiceException.PersistenceException(exception));
            }
        }, null);
        return completableFuture;
    }

    public CompletableFuture<ManagedLedger> getManagedLedger() {
        return CompletableFuture.completedFuture(this.managedLedger);
    }

    public static String getTransactionPendingAckStoreSuffix(String originTopicName, String subName) {
        return TopicName.get((String)originTopicName) + "-" + subName + PENDING_ACK_STORE_SUFFIX;
    }

    public static String getTransactionPendingAckStoreCursorName() {
        return PENDING_ACK_STORE_CURSOR_NAME;
    }

    class FillEntryQueueCallback
    implements AsyncCallbacks.ReadEntriesCallback {
        private final AtomicLong outstandingReadsRequests = new AtomicLong(0L);

        FillEntryQueueCallback() {
        }

        void fillQueue() {
            if (MLPendingAckStore.this.entryQueue.size() < MLPendingAckStore.this.entryQueue.capacity() && this.outstandingReadsRequests.get() == 0L && MLPendingAckStore.this.cursor.hasMoreEntries()) {
                this.outstandingReadsRequests.incrementAndGet();
                MLPendingAckStore.this.readAsync(100, this);
            }
        }

        public void readEntriesComplete(final List<Entry> entries, Object ctx) {
            MLPendingAckStore.this.entryQueue.fill((MessagePassingQueue.Supplier)new MessagePassingQueue.Supplier<Entry>(){
                private int i = 0;

                public Entry get() {
                    Entry entry = (Entry)entries.get(this.i);
                    ++this.i;
                    return entry;
                }
            }, entries.size());
            this.outstandingReadsRequests.decrementAndGet();
        }

        public void readEntriesFailed(ManagedLedgerException exception, Object ctx) {
            log.error("MLPendingAckStore stat reply fail!", (Throwable)exception);
            this.outstandingReadsRequests.decrementAndGet();
        }
    }

    class PendingAckReplay
    implements Runnable {
        private final FillEntryQueueCallback fillEntryQueueCallback;
        private final PendingAckReplyCallBack pendingAckReplyCallBack;

        PendingAckReplay(PendingAckReplyCallBack pendingAckReplyCallBack) {
            this.fillEntryQueueCallback = new FillEntryQueueCallback();
            this.pendingAckReplyCallBack = pendingAckReplyCallBack;
        }

        @Override
        public void run() {
            block4: while (true) {
                try {
                    while (MLPendingAckStore.this.lastConfirmedEntry.compareTo(MLPendingAckStore.this.currentLoadPosition) > 0) {
                        if (((ManagedCursorImpl)MLPendingAckStore.this.cursor).isClosed()) {
                            log.warn("[{}] MLPendingAckStore cursor have been closed, close replay thread.", (Object)MLPendingAckStore.this.cursor.getManagedLedger().getName());
                            return;
                        }
                        this.fillEntryQueueCallback.fillQueue();
                        Entry entry = (Entry)MLPendingAckStore.this.entryQueue.poll();
                        if (entry != null) {
                            ByteBuf buffer = entry.getDataBuffer();
                            MLPendingAckStore.this.currentLoadPosition = PositionImpl.get((long)entry.getLedgerId(), (long)entry.getEntryId());
                            PendingAckMetadataEntry pendingAckMetadataEntry = new PendingAckMetadataEntry();
                            pendingAckMetadataEntry.parseFrom(buffer, buffer.readableBytes());
                            if (pendingAckMetadataEntry.getPendingAckOp() != PendingAckOp.ABORT && pendingAckMetadataEntry.getPendingAckOp() != PendingAckOp.COMMIT) {
                                Optional optional = pendingAckMetadataEntry.getPendingAckMetadatasList().stream().max((o1, o2) -> ComparisonChain.start().compare(o1.getLedgerId(), o2.getLedgerId()).compare(o1.getEntryId(), o2.getEntryId()).result());
                                optional.ifPresent(pendingAckMetadata -> MLPendingAckStore.this.metadataPositions.compute(PositionImpl.get((long)entry.getLedgerId(), (long)entry.getEntryId()), (thisPosition, otherPosition) -> {
                                    PositionImpl nowPosition = PositionImpl.get((long)pendingAckMetadata.getLedgerId(), (long)pendingAckMetadata.getEntryId());
                                    if (otherPosition == null) {
                                        return nowPosition;
                                    }
                                    return nowPosition.compareTo(otherPosition) > 0 ? nowPosition : otherPosition;
                                }));
                            }
                            this.pendingAckReplyCallBack.handleMetadataEntry(pendingAckMetadataEntry);
                            entry.release();
                            continue;
                        }
                        try {
                            Thread.sleep(1L);
                            continue block4;
                        }
                        catch (InterruptedException e) {
                            if (!Thread.interrupted()) continue;
                            log.error("[{}]Transaction pending replay thread interrupt!", (Object)MLPendingAckStore.this.managedLedger.getName(), (Object)e);
                        }
                    }
                    break;
                }
                catch (Exception e) {
                    log.error("[{}] Pending ack recover fail!", (Object)MLPendingAckStore.this.subManagedCursor.getManagedLedger().getName(), (Object)e);
                    return;
                }
            }
            this.pendingAckReplyCallBack.replayComplete();
        }
    }
}

