/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.Response;
import org.apache.bookkeeper.mledger.ManagedLedger;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.admin.AdminResource;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.client.admin.Transactions;
import org.apache.pulsar.client.api.transaction.TxnID;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.ManagedLedgerInternalStats;
import org.apache.pulsar.common.policies.data.TransactionCoordinatorInternalStats;
import org.apache.pulsar.common.policies.data.TransactionCoordinatorStats;
import org.apache.pulsar.common.policies.data.TransactionInBufferStats;
import org.apache.pulsar.common.policies.data.TransactionInPendingAckStats;
import org.apache.pulsar.common.policies.data.TransactionLogStats;
import org.apache.pulsar.common.policies.data.TransactionMetadata;
import org.apache.pulsar.common.policies.data.TransactionPendingAckInternalStats;
import org.apache.pulsar.common.util.Codec;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.transaction.coordinator.TransactionCoordinatorID;
import org.apache.pulsar.transaction.coordinator.TransactionMetadataStore;
import org.apache.pulsar.transaction.coordinator.TxnMeta;
import org.apache.pulsar.transaction.coordinator.exceptions.CoordinatorException;
import org.apache.pulsar.transaction.coordinator.impl.MLTransactionMetadataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TransactionsBase
extends AdminResource {
    private static final Logger log = LoggerFactory.getLogger(TransactionsBase.class);

    protected void internalGetCoordinatorStats(AsyncResponse asyncResponse, boolean authoritative, Integer coordinatorId) {
        if (this.pulsar().getConfig().isTransactionCoordinatorEnabled()) {
            if (coordinatorId != null) {
                this.validateTopicOwnership(TopicName.TRANSACTION_COORDINATOR_ASSIGN.getPartition(coordinatorId.intValue()), authoritative);
                TransactionMetadataStore transactionMetadataStore = this.pulsar().getTransactionMetadataStoreService().getStores().get(TransactionCoordinatorID.get((long)coordinatorId.intValue()));
                if (transactionMetadataStore == null) {
                    asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Transaction coordinator not found! coordinator id : " + coordinatorId)));
                    return;
                }
                asyncResponse.resume((Object)transactionMetadataStore.getCoordinatorStats());
            } else {
                ((CompletableFuture)this.getPartitionedTopicMetadataAsync(TopicName.TRANSACTION_COORDINATOR_ASSIGN, false, false).thenAccept(partitionMetadata -> {
                    if (partitionMetadata.partitions == 0) {
                        asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Transaction coordinator not found")));
                        return;
                    }
                    ArrayList transactionMetadataStoreInfoFutures = Lists.newArrayList();
                    for (int i = 0; i < partitionMetadata.partitions; ++i) {
                        try {
                            transactionMetadataStoreInfoFutures.add(this.pulsar().getAdminClient().transactions().getCoordinatorStatsByIdAsync(i));
                            continue;
                        }
                        catch (PulsarServerException e2) {
                            asyncResponse.resume((Throwable)((Object)new RestException(e2)));
                            return;
                        }
                    }
                    HashMap stats = new HashMap();
                    FutureUtil.waitForAll((List)transactionMetadataStoreInfoFutures).whenComplete((result, e) -> {
                        if (e != null) {
                            asyncResponse.resume((Throwable)((Object)new RestException((Throwable)e)));
                            return;
                        }
                        for (int i = 0; i < transactionMetadataStoreInfoFutures.size(); ++i) {
                            try {
                                stats.put(i, (TransactionCoordinatorStats)((CompletableFuture)transactionMetadataStoreInfoFutures.get(i)).get());
                                continue;
                            }
                            catch (Exception exception) {
                                asyncResponse.resume((Throwable)((Object)new RestException(exception.getCause())));
                                return;
                            }
                        }
                        asyncResponse.resume((Object)stats);
                    });
                })).exceptionally(ex -> {
                    log.error("[{}] Failed to get transaction coordinator state.", (Object)this.clientAppId(), ex);
                    TransactionsBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
                    return null;
                });
            }
        } else {
            asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.SERVICE_UNAVAILABLE, "This Broker is not configured with transactionCoordinatorEnabled=true.")));
        }
    }

    protected void internalGetTransactionInPendingAckStats(AsyncResponse asyncResponse, boolean authoritative, long mostSigBits, long leastSigBits, String subName) {
        if (this.pulsar().getConfig().isTransactionCoordinatorEnabled()) {
            this.validateTopicOwnership(this.topicName, authoritative);
            CompletableFuture topicFuture = (CompletableFuture)this.pulsar().getBrokerService().getTopics().get((Object)this.topicName.toString());
            if (topicFuture != null) {
                topicFuture.whenComplete((optionalTopic, e) -> {
                    if (e != null) {
                        asyncResponse.resume((Throwable)((Object)new RestException((Throwable)e)));
                        return;
                    }
                    if (!optionalTopic.isPresent()) {
                        asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.TEMPORARY_REDIRECT, "Topic is not owned by this broker!")));
                        return;
                    }
                    Topic topicObject = (Topic)optionalTopic.get();
                    if (topicObject instanceof PersistentTopic) {
                        asyncResponse.resume((Object)((PersistentTopic)topicObject).getTransactionInPendingAckStats(new TxnID(mostSigBits, leastSigBits), subName));
                    } else {
                        asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.BAD_REQUEST, "Topic is not a persistent topic!")));
                    }
                });
            } else {
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.TEMPORARY_REDIRECT, "Topic is not owned by this broker!")));
            }
        } else {
            asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.SERVICE_UNAVAILABLE, "This Broker is not configured with transactionCoordinatorEnabled=true.")));
        }
    }

    protected void internalGetTransactionInBufferStats(AsyncResponse asyncResponse, boolean authoritative, long mostSigBits, long leastSigBits) {
        if (this.pulsar().getConfig().isTransactionCoordinatorEnabled()) {
            this.validateTopicOwnership(this.topicName, authoritative);
            CompletableFuture topicFuture = (CompletableFuture)this.pulsar().getBrokerService().getTopics().get((Object)this.topicName.toString());
            if (topicFuture != null) {
                topicFuture.whenComplete((optionalTopic, e) -> {
                    if (e != null) {
                        asyncResponse.resume((Throwable)((Object)new RestException((Throwable)e)));
                        return;
                    }
                    if (!optionalTopic.isPresent()) {
                        asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.TEMPORARY_REDIRECT, "Topic is not owned by this broker!")));
                        return;
                    }
                    Topic topicObject = (Topic)optionalTopic.get();
                    if (topicObject instanceof PersistentTopic) {
                        TransactionInBufferStats transactionInBufferStats = ((PersistentTopic)topicObject).getTransactionInBufferStats(new TxnID(mostSigBits, leastSigBits));
                        asyncResponse.resume((Object)transactionInBufferStats);
                    } else {
                        asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.BAD_REQUEST, "Topic is not a persistent topic!")));
                    }
                });
            } else {
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.TEMPORARY_REDIRECT, "Topic is not owned by this broker!")));
            }
        } else {
            asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.SERVICE_UNAVAILABLE, "This Broker is not configured with transactionCoordinatorEnabled=true.")));
        }
    }

    protected void internalGetTransactionBufferStats(AsyncResponse asyncResponse, boolean authoritative) {
        if (this.pulsar().getConfig().isTransactionCoordinatorEnabled()) {
            this.validateTopicOwnership(this.topicName, authoritative);
            CompletableFuture topicFuture = (CompletableFuture)this.pulsar().getBrokerService().getTopics().get((Object)this.topicName.toString());
            if (topicFuture != null) {
                topicFuture.whenComplete((optionalTopic, e) -> {
                    if (e != null) {
                        asyncResponse.resume((Throwable)((Object)new RestException((Throwable)e)));
                        return;
                    }
                    if (!optionalTopic.isPresent()) {
                        asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.TEMPORARY_REDIRECT, "Topic is not owned by this broker!")));
                        return;
                    }
                    Topic topicObject = (Topic)optionalTopic.get();
                    if (topicObject instanceof PersistentTopic) {
                        asyncResponse.resume((Object)((PersistentTopic)topicObject).getTransactionBufferStats());
                    } else {
                        asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.BAD_REQUEST, "Topic is not a persistent topic!")));
                    }
                });
            } else {
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.TEMPORARY_REDIRECT, "Topic is not owned by this broker!")));
            }
        } else {
            asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.SERVICE_UNAVAILABLE, "Broker don't support transaction!")));
        }
    }

    protected void internalGetPendingAckStats(AsyncResponse asyncResponse, boolean authoritative, String subName) {
        if (this.pulsar().getConfig().isTransactionCoordinatorEnabled()) {
            this.validateTopicOwnership(this.topicName, authoritative);
            CompletableFuture topicFuture = (CompletableFuture)this.pulsar().getBrokerService().getTopics().get((Object)this.topicName.toString());
            if (topicFuture != null) {
                topicFuture.whenComplete((optionalTopic, e) -> {
                    if (e != null) {
                        asyncResponse.resume((Throwable)((Object)new RestException((Throwable)e)));
                        return;
                    }
                    if (!optionalTopic.isPresent()) {
                        asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.TEMPORARY_REDIRECT, "Topic is not owned by this broker!")));
                        return;
                    }
                    Topic topicObject = (Topic)optionalTopic.get();
                    if (topicObject instanceof PersistentTopic) {
                        asyncResponse.resume((Object)((PersistentTopic)topicObject).getTransactionPendingAckStats(subName));
                    } else {
                        asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.BAD_REQUEST, "Topic is not a persistent topic!")));
                    }
                });
            } else {
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.TEMPORARY_REDIRECT, "Topic is not owned by this broker!")));
            }
        } else {
            asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.SERVICE_UNAVAILABLE, "Broker don't support transaction!")));
        }
    }

    protected void internalGetTransactionMetadata(AsyncResponse asyncResponse, boolean authoritative, int mostSigBits, long leastSigBits) {
        try {
            if (this.pulsar().getConfig().isTransactionCoordinatorEnabled()) {
                this.validateTopicOwnership(TopicName.TRANSACTION_COORDINATOR_ASSIGN.getPartition(mostSigBits), authoritative);
                CompletableFuture<TransactionMetadata> transactionMetadataFuture = new CompletableFuture<TransactionMetadata>();
                TxnMeta txnMeta = this.pulsar().getTransactionMetadataStoreService().getTxnMeta(new TxnID((long)mostSigBits, leastSigBits)).get();
                this.getTransactionMetadata(txnMeta, transactionMetadataFuture);
                asyncResponse.resume((Object)transactionMetadataFuture.get(10L, TimeUnit.SECONDS));
            } else {
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.SERVICE_UNAVAILABLE, "This Broker is not configured with transactionCoordinatorEnabled=true.")));
            }
        }
        catch (Exception e) {
            if (e instanceof ExecutionException) {
                if (e.getCause() instanceof CoordinatorException.CoordinatorNotFoundException || e.getCause() instanceof CoordinatorException.TransactionNotFoundException) {
                    asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, e.getCause())));
                    return;
                }
                asyncResponse.resume((Throwable)((Object)new RestException(e.getCause())));
            }
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    private void getTransactionMetadata(TxnMeta txnMeta, CompletableFuture<TransactionMetadata> transactionMetadataFuture) throws PulsarServerException {
        Transactions transactions = this.pulsar().getAdminClient().transactions();
        TransactionMetadata transactionMetadata = new TransactionMetadata();
        TxnID txnID = txnMeta.id();
        transactionMetadata.txnId = txnID.toString();
        transactionMetadata.status = txnMeta.status().name();
        transactionMetadata.openTimestamp = txnMeta.getOpenTimestamp();
        transactionMetadata.timeoutAt = txnMeta.getTimeoutAt();
        ArrayList ackedPartitionsFutures = new ArrayList();
        HashMap ackFutures = new HashMap();
        txnMeta.ackedPartitions().forEach(transactionSubscription -> {
            String topic = transactionSubscription.getTopic();
            String subName = transactionSubscription.getSubscription();
            CompletableFuture future = transactions.getTransactionInPendingAckStatsAsync(txnID, topic, subName);
            ackedPartitionsFutures.add(future);
            if (ackFutures.containsKey(topic)) {
                ((Map)ackFutures.get(topic)).put(transactionSubscription.getSubscription(), future);
            } else {
                HashMap<String, CompletableFuture> pendingAckStatsMap = new HashMap<String, CompletableFuture>();
                pendingAckStatsMap.put(transactionSubscription.getSubscription(), future);
                ackFutures.put(topic, pendingAckStatsMap);
            }
        });
        ArrayList producedPartitionsFutures = new ArrayList();
        HashMap produceFutures = new HashMap();
        txnMeta.producedPartitions().forEach(topic -> {
            CompletableFuture future = transactions.getTransactionInBufferStatsAsync(txnID, topic);
            producedPartitionsFutures.add(future);
            produceFutures.put(topic, future);
        });
        FutureUtil.waitForAll(ackedPartitionsFutures).whenComplete((v, e) -> {
            if (e != null) {
                transactionMetadataFuture.completeExceptionally((Throwable)e);
                return;
            }
            FutureUtil.waitForAll((List)producedPartitionsFutures).whenComplete((x, t) -> {
                if (t != null) {
                    transactionMetadataFuture.completeExceptionally((Throwable)e);
                    return;
                }
                HashMap ackedPartitions = new HashMap();
                HashMap<String, TransactionInBufferStats> producedPartitions = new HashMap<String, TransactionInBufferStats>();
                for (String topic : ackFutures.keySet()) {
                    HashMap<String, TransactionInPendingAckStats> subs = new HashMap<String, TransactionInPendingAckStats>();
                    for (String sub : ((Map)ackFutures.get(topic)).keySet()) {
                        try {
                            subs.put(sub, (TransactionInPendingAckStats)((CompletableFuture)((Map)ackFutures.get(topic)).get(sub)).get());
                        }
                        catch (Exception exception) {
                            transactionMetadataFuture.completeExceptionally(exception);
                            return;
                        }
                    }
                    ackedPartitions.put(topic, subs);
                }
                for (String topic : produceFutures.keySet()) {
                    try {
                        producedPartitions.put(topic, (TransactionInBufferStats)((CompletableFuture)produceFutures.get(topic)).get());
                    }
                    catch (Exception exception) {
                        transactionMetadataFuture.completeExceptionally(exception);
                        return;
                    }
                }
                transactionMetadata.ackedPartitions = ackedPartitions;
                transactionMetadata.producedPartitions = producedPartitions;
                transactionMetadataFuture.complete(transactionMetadata);
            });
        });
    }

    protected void internalGetSlowTransactions(AsyncResponse asyncResponse, boolean authoritative, long timeout, Integer coordinatorId) {
        try {
            if (this.pulsar().getConfig().isTransactionCoordinatorEnabled()) {
                if (coordinatorId != null) {
                    this.validateTopicOwnership(TopicName.TRANSACTION_COORDINATOR_ASSIGN.getPartition(coordinatorId.intValue()), authoritative);
                    TransactionMetadataStore transactionMetadataStore = this.pulsar().getTransactionMetadataStoreService().getStores().get(TransactionCoordinatorID.get((long)coordinatorId.intValue()));
                    if (transactionMetadataStore == null) {
                        asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Transaction coordinator not found! coordinator id : " + coordinatorId)));
                        return;
                    }
                    List transactions = transactionMetadataStore.getSlowTransactions(timeout);
                    ArrayList<CompletableFuture<TransactionMetadata>> completableFutures = new ArrayList<CompletableFuture<TransactionMetadata>>();
                    for (TxnMeta txnMeta : transactions) {
                        CompletableFuture<TransactionMetadata> completableFuture = new CompletableFuture<TransactionMetadata>();
                        this.getTransactionMetadata(txnMeta, completableFuture);
                        completableFutures.add(completableFuture);
                    }
                    FutureUtil.waitForAll(completableFutures).whenComplete((v, e) -> {
                        if (e != null) {
                            asyncResponse.resume((Throwable)((Object)new RestException(e.getCause())));
                            return;
                        }
                        HashMap<String, TransactionMetadata> transactionMetadata = new HashMap<String, TransactionMetadata>();
                        for (CompletableFuture future : completableFutures) {
                            try {
                                transactionMetadata.put(((TransactionMetadata)future.get()).txnId, (TransactionMetadata)future.get());
                            }
                            catch (Exception exception) {
                                asyncResponse.resume((Throwable)((Object)new RestException(exception.getCause())));
                                return;
                            }
                        }
                        asyncResponse.resume(transactionMetadata);
                    });
                } else {
                    ((CompletableFuture)this.getPartitionedTopicMetadataAsync(TopicName.TRANSACTION_COORDINATOR_ASSIGN, false, false).thenAccept(partitionMetadata -> {
                        if (partitionMetadata.partitions == 0) {
                            asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Transaction coordinator not found")));
                            return;
                        }
                        ArrayList completableFutures = Lists.newArrayList();
                        for (int i = 0; i < partitionMetadata.partitions; ++i) {
                            try {
                                completableFutures.add(this.pulsar().getAdminClient().transactions().getSlowTransactionsByCoordinatorIdAsync(Integer.valueOf(i), timeout, TimeUnit.MILLISECONDS));
                                continue;
                            }
                            catch (PulsarServerException e2) {
                                asyncResponse.resume((Throwable)((Object)new RestException(e2)));
                                return;
                            }
                        }
                        HashMap transactionMetadataMaps = new HashMap();
                        FutureUtil.waitForAll((List)completableFutures).whenComplete((result, e) -> {
                            if (e != null) {
                                asyncResponse.resume((Throwable)((Object)new RestException((Throwable)e)));
                                return;
                            }
                            for (CompletableFuture transactionMetadataMap : completableFutures) {
                                try {
                                    transactionMetadataMaps.putAll((Map)transactionMetadataMap.get());
                                }
                                catch (Exception exception) {
                                    asyncResponse.resume((Throwable)((Object)new RestException(exception.getCause())));
                                    return;
                                }
                            }
                            asyncResponse.resume((Object)transactionMetadataMaps);
                        });
                    })).exceptionally(ex -> {
                        log.error("[{}] Failed to get transaction coordinator state.", (Object)this.clientAppId(), ex);
                        TransactionsBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
                        return null;
                    });
                }
            } else {
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.SERVICE_UNAVAILABLE, "Broker don't support transaction!")));
            }
        }
        catch (Exception e2) {
            asyncResponse.resume((Throwable)((Object)new RestException(e2)));
        }
    }

    protected void internalGetCoordinatorInternalStats(AsyncResponse asyncResponse, boolean authoritative, boolean metadata, int coordinatorId) {
        try {
            if (this.pulsar().getConfig().isTransactionCoordinatorEnabled()) {
                TopicName topicName = TopicName.TRANSACTION_COORDINATOR_ASSIGN.getPartition(coordinatorId);
                this.validateTopicOwnership(topicName, authoritative);
                TransactionMetadataStore metadataStore = this.pulsar().getTransactionMetadataStoreService().getStores().get(TransactionCoordinatorID.get((long)coordinatorId));
                if (metadataStore == null) {
                    asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Transaction coordinator not found! coordinator id : " + coordinatorId)));
                    return;
                }
                if (metadataStore instanceof MLTransactionMetadataStore) {
                    ManagedLedger managedLedger = ((MLTransactionMetadataStore)metadataStore).getManagedLedger();
                    TransactionCoordinatorInternalStats transactionCoordinatorInternalStats = new TransactionCoordinatorInternalStats();
                    TransactionLogStats transactionLogStats = new TransactionLogStats();
                    transactionLogStats.managedLedgerName = managedLedger.getName();
                    transactionLogStats.managedLedgerInternalStats = (ManagedLedgerInternalStats)managedLedger.getManagedLedgerInternalStats(metadata).get();
                    transactionCoordinatorInternalStats.transactionLogStats = transactionLogStats;
                    asyncResponse.resume((Object)transactionCoordinatorInternalStats);
                } else {
                    asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.METHOD_NOT_ALLOWED, "Broker don't use MLTransactionMetadataStore!")));
                }
            } else {
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.SERVICE_UNAVAILABLE, "This Broker is not configured with transactionCoordinatorEnabled=true.")));
            }
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e.getCause())));
        }
    }

    protected void internalGetPendingAckInternalStats(AsyncResponse asyncResponse, boolean authoritative, TopicName topicName, String subName, boolean metadata) {
        try {
            if (this.pulsar().getConfig().isTransactionCoordinatorEnabled()) {
                this.validateTopicOwnership(topicName, authoritative);
                CompletableFuture topicFuture = (CompletableFuture)this.pulsar().getBrokerService().getTopics().get((Object)topicName.toString());
                if (topicFuture != null) {
                    topicFuture.whenComplete((optionalTopic, e) -> {
                        if (e != null) {
                            asyncResponse.resume((Throwable)((Object)new RestException((Throwable)e)));
                            return;
                        }
                        if (!optionalTopic.isPresent()) {
                            asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.TEMPORARY_REDIRECT, "Topic is not owned by this broker!")));
                            return;
                        }
                        Topic topicObject = (Topic)optionalTopic.get();
                        if (topicObject instanceof PersistentTopic) {
                            try {
                                ManagedLedger managedLedger = ((PersistentTopic)topicObject).getPendingAckManagedLedger(subName).get();
                                TransactionPendingAckInternalStats stats = new TransactionPendingAckInternalStats();
                                TransactionLogStats pendingAckLogStats = new TransactionLogStats();
                                pendingAckLogStats.managedLedgerName = managedLedger.getName();
                                pendingAckLogStats.managedLedgerInternalStats = (ManagedLedgerInternalStats)managedLedger.getManagedLedgerInternalStats(metadata).get();
                                stats.pendingAckLogStats = pendingAckLogStats;
                                asyncResponse.resume((Object)stats);
                            }
                            catch (Exception exception) {
                                if (exception instanceof ExecutionException) {
                                    if (exception.getCause() instanceof BrokerServiceException.ServiceUnitNotReadyException) {
                                        asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.SERVICE_UNAVAILABLE, exception.getCause())));
                                        return;
                                    }
                                    if (exception.getCause() instanceof BrokerServiceException.NotAllowedException) {
                                        asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.METHOD_NOT_ALLOWED, exception.getCause())));
                                        return;
                                    }
                                    if (exception.getCause() instanceof BrokerServiceException.SubscriptionNotFoundException) {
                                        asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, exception.getCause())));
                                        return;
                                    }
                                }
                                asyncResponse.resume((Throwable)((Object)new RestException(exception)));
                            }
                        } else {
                            asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.BAD_REQUEST, "Topic is not a persistent topic!")));
                        }
                    });
                } else {
                    asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.TEMPORARY_REDIRECT, "Topic is not owned by this broker!")));
                }
            } else {
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.SERVICE_UNAVAILABLE, "This Broker is not configured with transactionCoordinatorEnabled=true.")));
            }
        }
        catch (Exception e2) {
            asyncResponse.resume((Throwable)((Object)new RestException(e2.getCause())));
        }
    }

    @Override
    protected void validateTopicName(String property, String namespace, String encodedTopic) {
        String topic = Codec.decode((String)encodedTopic);
        try {
            this.namespaceName = NamespaceName.get((String)property, (String)namespace);
            this.topicName = TopicName.get((String)TopicDomain.persistent.toString(), (NamespaceName)this.namespaceName, (String)topic);
        }
        catch (IllegalArgumentException e) {
            log.warn("[{}] Failed to validate topic name {}://{}/{}/{}", new Object[]{this.clientAppId(), this.domain(), property, namespace, topic, e});
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Topic name is not valid");
        }
    }
}

