/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.annotations.VisibleForTesting;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.flow.FlowControlHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslProvider;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.util.SafeRunnable;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.service.ServerCnx;
import org.apache.pulsar.common.protocol.ByteBufPair;
import org.apache.pulsar.common.protocol.OptionalProxyProtocolDecoder;
import org.apache.pulsar.common.util.NettyServerSslContextBuilder;
import org.apache.pulsar.common.util.SslContextAutoRefreshBuilder;
import org.apache.pulsar.common.util.keystoretls.KeyStoreSSLContext;
import org.apache.pulsar.common.util.keystoretls.NettySSLContextAutoRefreshBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarChannelInitializer
extends ChannelInitializer<SocketChannel> {
    private static final Logger log = LoggerFactory.getLogger(PulsarChannelInitializer.class);
    public static final String TLS_HANDLER = "tls";
    private final PulsarService pulsar;
    private final boolean enableTls;
    private final boolean tlsEnabledWithKeyStore;
    private SslContextAutoRefreshBuilder<SslContext> sslCtxRefresher;
    private final ServiceConfiguration brokerConf;
    private NettySSLContextAutoRefreshBuilder nettySSLContextAutoRefreshBuilder;
    private final Cache<SocketAddress, ServerCnx> connections = Caffeine.newBuilder().weakKeys().weakValues().build();
    public static final Factory DEFAULT_FACTORY = (pulsar, tls) -> new PulsarChannelInitializer(pulsar, tls);

    public PulsarChannelInitializer(PulsarService pulsar, boolean enableTLS) throws Exception {
        this.pulsar = pulsar;
        this.enableTls = enableTLS;
        ServiceConfiguration serviceConfig = pulsar.getConfiguration();
        this.tlsEnabledWithKeyStore = serviceConfig.isTlsEnabledWithKeyStore();
        if (this.enableTls) {
            if (this.tlsEnabledWithKeyStore) {
                this.nettySSLContextAutoRefreshBuilder = new NettySSLContextAutoRefreshBuilder(serviceConfig.getTlsProvider(), serviceConfig.getTlsKeyStoreType(), serviceConfig.getTlsKeyStore(), serviceConfig.getTlsKeyStorePassword(), serviceConfig.isTlsAllowInsecureConnection(), serviceConfig.getTlsTrustStoreType(), serviceConfig.getTlsTrustStore(), serviceConfig.getTlsTrustStorePassword(), serviceConfig.isTlsRequireTrustedClientCertOnConnect(), serviceConfig.getTlsCiphers(), serviceConfig.getTlsProtocols(), serviceConfig.getTlsCertRefreshCheckDurationSec());
            } else {
                SslProvider sslProvider = null;
                if (serviceConfig.getTlsProvider() != null) {
                    sslProvider = SslProvider.valueOf((String)serviceConfig.getTlsProvider());
                }
                this.sslCtxRefresher = new NettyServerSslContextBuilder(sslProvider, serviceConfig.isTlsAllowInsecureConnection(), serviceConfig.getTlsTrustCertsFilePath(), serviceConfig.getTlsCertificateFilePath(), serviceConfig.getTlsKeyFilePath(), serviceConfig.getTlsCiphers(), serviceConfig.getTlsProtocols(), serviceConfig.isTlsRequireTrustedClientCertOnConnect(), serviceConfig.getTlsCertRefreshCheckDurationSec());
            }
        } else {
            this.sslCtxRefresher = null;
        }
        this.brokerConf = pulsar.getConfiguration();
        pulsar.getExecutor().scheduleAtFixedRate((Runnable)SafeRunnable.safeRun(this::refreshAuthenticationCredentials), pulsar.getConfig().getAuthenticationRefreshCheckSeconds(), pulsar.getConfig().getAuthenticationRefreshCheckSeconds(), TimeUnit.SECONDS);
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        if (this.enableTls) {
            if (this.tlsEnabledWithKeyStore) {
                ch.pipeline().addLast(TLS_HANDLER, (ChannelHandler)new SslHandler(((KeyStoreSSLContext)this.nettySSLContextAutoRefreshBuilder.get()).createSSLEngine()));
            } else {
                ch.pipeline().addLast(TLS_HANDLER, (ChannelHandler)((SslContext)this.sslCtxRefresher.get()).newHandler(ch.alloc()));
            }
            ch.pipeline().addLast("ByteBufPairEncoder", (ChannelHandler)ByteBufPair.COPYING_ENCODER);
        } else {
            ch.pipeline().addLast("ByteBufPairEncoder", (ChannelHandler)ByteBufPair.ENCODER);
        }
        if (this.pulsar.getConfiguration().isHaProxyProtocolEnabled()) {
            ch.pipeline().addLast("optional-proxy-protocol-decoder", (ChannelHandler)new OptionalProxyProtocolDecoder());
        }
        ch.pipeline().addLast("frameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(this.brokerConf.getMaxMessageSize() + 10240, 0, 4, 0, 4));
        ch.pipeline().addLast("flowController", (ChannelHandler)new FlowControlHandler());
        ServerCnx cnx = this.newServerCnx(this.pulsar);
        ch.pipeline().addLast("handler", (ChannelHandler)cnx);
        this.connections.put((Object)ch.remoteAddress(), (Object)cnx);
    }

    private void refreshAuthenticationCredentials() {
        this.connections.asMap().values().forEach(cnx -> {
            try {
                cnx.refreshAuthenticationCredentials();
            }
            catch (Throwable t) {
                log.warn("[{}] Failed to refresh auth credentials", (Object)cnx.clientAddress());
            }
        });
    }

    @VisibleForTesting
    protected ServerCnx newServerCnx(PulsarService pulsar) throws Exception {
        return new ServerCnx(pulsar);
    }

    public static interface Factory {
        public PulsarChannelInitializer newPulsarChannelInitializer(PulsarService var1, boolean var2) throws Exception;
    }
}

