/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.nonpersistent;

import io.netty.buffer.ByteBuf;
import io.netty.util.Recycler;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.Position;
import org.apache.pulsar.broker.service.AbstractReplicator;
import org.apache.pulsar.broker.service.BrokerService;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.Replicator;
import org.apache.pulsar.broker.service.nonpersistent.NonPersistentTopic;
import org.apache.pulsar.broker.service.persistent.PersistentReplicator;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.impl.MessageImpl;
import org.apache.pulsar.client.impl.ProducerImpl;
import org.apache.pulsar.client.impl.SendCallback;
import org.apache.pulsar.common.policies.data.stats.NonPersistentReplicatorStatsImpl;
import org.apache.pulsar.common.stats.Rate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonPersistentReplicator
extends AbstractReplicator
implements Replicator {
    private final Rate msgOut = new Rate();
    private final Rate msgDrop = new Rate();
    private final NonPersistentReplicatorStatsImpl stats = new NonPersistentReplicatorStatsImpl();
    private static final Logger log = LoggerFactory.getLogger(PersistentReplicator.class);

    public NonPersistentReplicator(NonPersistentTopic topic, String localCluster, String remoteCluster, BrokerService brokerService) throws BrokerServiceException.NamingException {
        super(topic.getName(), topic.getReplicatorPrefix(), localCluster, remoteCluster, brokerService);
        this.producerBuilder.blockIfQueueFull(false);
        this.startProducer();
    }

    @Override
    protected void readEntries(Producer<byte[]> producer) {
        this.producer = (ProducerImpl)producer;
        if (!STATE_UPDATER.compareAndSet(this, AbstractReplicator.State.Starting, AbstractReplicator.State.Started)) {
            log.info("[{}][{} -> {}] Replicator was stopped while creating the producer. Closing it. Replicator state: {}", new Object[]{this.topicName, this.localCluster, this.remoteCluster, STATE_UPDATER.get(this)});
            STATE_UPDATER.set(this, AbstractReplicator.State.Stopping);
            this.closeProducerAsync();
            return;
        }
        log.info("[{}][{} -> {}] Created replicator producer", new Object[]{this.topicName, this.localCluster, this.remoteCluster});
        this.backOff.reset();
    }

    public void sendMessage(Entry entry) {
        if (STATE_UPDATER.get(this) == AbstractReplicator.State.Started && this.isWritable()) {
            MessageImpl msg;
            int length = entry.getLength();
            ByteBuf headersAndPayload = entry.getDataBuffer();
            try {
                msg = MessageImpl.deserializeSkipBrokerEntryMetaData((ByteBuf)headersAndPayload);
            }
            catch (Throwable t) {
                log.error("[{}][{} -> {}] Failed to deserialize message at {} (buffer size: {}): {}", new Object[]{this.topicName, this.localCluster, this.remoteCluster, entry.getPosition(), length, t.getMessage(), t});
                entry.release();
                return;
            }
            if (msg.isReplicated()) {
                entry.release();
                msg.recycle();
                return;
            }
            if (msg.hasReplicateTo() && !msg.getReplicateTo().contains(this.remoteCluster)) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}][{} -> {}] Skipping message at {} / msg-id: {}: replicateTo {}", new Object[]{this.topicName, this.localCluster, this.remoteCluster, entry.getPosition(), msg.getMessageId(), msg.getReplicateTo()});
                }
                entry.release();
                msg.recycle();
                return;
            }
            this.msgOut.recordEvent((long)headersAndPayload.readableBytes());
            msg.setReplicatedFrom(this.localCluster);
            headersAndPayload.retain();
            this.producer.sendAsync((Message)msg, (SendCallback)ProducerSendCallback.create(this, entry, msg));
        } else {
            if (log.isDebugEnabled()) {
                log.debug("[{}][{} -> {}] dropping message because replicator producer is not started/writable", new Object[]{this.topicName, this.localCluster, this.remoteCluster});
            }
            this.msgDrop.recordEvent();
            entry.release();
        }
    }

    @Override
    public void updateRates() {
        this.msgOut.calculateRate();
        this.msgDrop.calculateRate();
        this.stats.msgRateOut = this.msgOut.getRate();
        this.stats.msgThroughputOut = this.msgOut.getValueRate();
        this.stats.msgDropRate = this.msgDrop.getRate();
    }

    public NonPersistentReplicatorStatsImpl getStats() {
        this.stats.connected = this.producer != null && this.producer.isConnected();
        this.stats.replicationDelayInSeconds = this.getReplicationDelayInSeconds();
        ProducerImpl producer = this.producer;
        if (producer != null) {
            this.stats.outboundConnection = producer.getConnectionId();
            this.stats.outboundConnectedSince = producer.getConnectedSince();
        } else {
            this.stats.outboundConnection = null;
            this.stats.outboundConnectedSince = null;
        }
        return this.stats;
    }

    private long getReplicationDelayInSeconds() {
        if (this.producer != null) {
            return TimeUnit.MILLISECONDS.toSeconds(this.producer.getDelayInMillis());
        }
        return 0L;
    }

    @Override
    protected Position getReplicatorReadPosition() {
        return null;
    }

    @Override
    protected long getNumberOfEntriesInBacklog() {
        return 0L;
    }

    @Override
    protected void disableReplicatorRead() {
    }

    @Override
    public boolean isConnected() {
        ProducerImpl producer = this.producer;
        return producer != null && producer.isConnected();
    }

    private static final class ProducerSendCallback
    implements SendCallback {
        private NonPersistentReplicator replicator;
        private Entry entry;
        private MessageImpl msg;
        private final Recycler.Handle<ProducerSendCallback> recyclerHandle;
        private static final Recycler<ProducerSendCallback> RECYCLER = new Recycler<ProducerSendCallback>(){

            protected ProducerSendCallback newObject(Recycler.Handle<ProducerSendCallback> handle) {
                return new ProducerSendCallback(handle);
            }
        };

        public void sendComplete(Exception exception) {
            if (exception != null) {
                log.error("[{}][{} -> {}] Error producing on remote broker", new Object[]{this.replicator.topicName, this.replicator.localCluster, this.replicator.remoteCluster, exception});
            } else if (log.isDebugEnabled()) {
                log.debug("[{}][{} -> {}] Message persisted on remote broker", new Object[]{this.replicator.topicName, this.replicator.localCluster, this.replicator.remoteCluster});
            }
            this.entry.release();
            this.recycle();
        }

        private ProducerSendCallback(Recycler.Handle<ProducerSendCallback> recyclerHandle) {
            this.recyclerHandle = recyclerHandle;
        }

        static ProducerSendCallback create(NonPersistentReplicator replicator, Entry entry, MessageImpl msg) {
            ProducerSendCallback sendCallback = (ProducerSendCallback)RECYCLER.get();
            sendCallback.replicator = replicator;
            sendCallback.entry = entry;
            sendCallback.msg = msg;
            return sendCallback;
        }

        private void recycle() {
            this.replicator = null;
            this.entry = null;
            if (this.msg != null) {
                this.msg.recycle();
                this.msg = null;
            }
            this.recyclerHandle.recycle((Object)this);
        }

        public void addCallback(MessageImpl<?> msg, SendCallback scb) {
        }

        public SendCallback getNextSendCallback() {
            return null;
        }

        public MessageImpl<?> getNextMessage() {
            return null;
        }

        public CompletableFuture<MessageId> getFuture() {
            return CompletableFuture.completedFuture(null);
        }
    }
}

