/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.transaction.buffer;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.broker.transaction.buffer.TransactionBuffer;

@Beta
public interface TransactionBufferProvider {
    public static TransactionBufferProvider newProvider(String providerClassName) throws IOException {
        try {
            Class<?> providerClass = Class.forName(providerClassName);
            Object obj = providerClass.newInstance();
            Preconditions.checkArgument((boolean)(obj instanceof TransactionBufferProvider), (Object)("The factory has to be an instance of " + TransactionBufferProvider.class.getName()));
            return (TransactionBufferProvider)obj;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public TransactionBuffer newTransactionBuffer(Topic var1, CompletableFuture<Void> var2);
}

