/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.web;

import java.io.PrintWriter;
import java.io.StringWriter;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.common.policies.data.ErrorData;

public class RestException
extends WebApplicationException {
    private Throwable cause = null;

    static String getExceptionData(Throwable t) {
        StringWriter writer = new StringWriter();
        writer.append("\n --- An unexpected error occurred in the server ---\n\n");
        if (t != null) {
            writer.append("Message: ").append(t.getMessage()).append("\n\n");
        }
        writer.append("Stacktrace:\n\n");
        t.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    public RestException(Response.Status status, String message) {
        this(status.getStatusCode(), message);
    }

    public RestException(int code, String message) {
        super(message, Response.status((int)code, (String)message).entity((Object)new ErrorData(message)).type("application/json").build());
    }

    public RestException(Throwable t) {
        super(RestException.getResponse(t));
    }

    public RestException(Response.Status status, Throwable t) {
        this(status.getStatusCode(), t.getMessage());
        this.cause = t;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public RestException(PulsarAdminException cae) {
        this(cae.getStatusCode(), cae.getHttpError());
    }

    private static Response getResponse(Throwable t) {
        if (t instanceof WebApplicationException) {
            WebApplicationException e = (WebApplicationException)t;
            return e.getResponse();
        }
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)RestException.getExceptionData(t)).type("text/plain").build();
    }
}

