/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.compaction;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.BookKeeperClientFactoryImpl;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.ServiceConfigurationUtils;
import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.internal.PropertiesUtils;
import org.apache.pulsar.common.configuration.PulsarConfigurationLoader;
import org.apache.pulsar.common.util.netty.EventLoopUtil;
import org.apache.pulsar.compaction.TwoPhaseCompactor;
import org.apache.pulsar.zookeeper.ZooKeeperClientFactory;
import org.apache.pulsar.zookeeper.ZookeeperBkClientFactoryImpl;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactorTool {
    private static final Logger log = LoggerFactory.getLogger(CompactorTool.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Arguments arguments = new Arguments();
        JCommander jcommander = new JCommander((Object)arguments);
        jcommander.setProgramName("PulsarTopicCompactor");
        jcommander.parse(args);
        if (arguments.help) {
            jcommander.usage();
            System.exit(-1);
        }
        if (StringUtils.isBlank((CharSequence)arguments.brokerConfigFile)) {
            jcommander.usage();
            throw new IllegalArgumentException("Need to specify a configuration file for broker");
        }
        log.info(String.format("read configuration file %s", arguments.brokerConfigFile));
        ServiceConfiguration brokerConfig = (ServiceConfiguration)PulsarConfigurationLoader.create((String)arguments.brokerConfigFile, ServiceConfiguration.class);
        if (StringUtils.isBlank((CharSequence)brokerConfig.getZookeeperServers())) {
            throw new IllegalArgumentException(String.format("Need to specify `zookeeperServers` in configuration file \nor specify configuration file path from command line.\nnow configuration file path is=[%s]\n", arguments.brokerConfigFile));
        }
        ClientBuilder clientBuilder = PulsarClient.builder();
        clientBuilder.loadConf(PropertiesUtils.filterAndMapProperties((Properties)brokerConfig.getProperties(), (String)"brokerClient_"));
        if (StringUtils.isNotBlank((CharSequence)brokerConfig.getBrokerClientAuthenticationPlugin())) {
            clientBuilder.authentication(brokerConfig.getBrokerClientAuthenticationPlugin(), brokerConfig.getBrokerClientAuthenticationParameters());
        }
        if (brokerConfig.getBrokerServicePortTls().isPresent()) {
            log.info("Found `brokerServicePortTls` in configuration file. \nWill connect pulsar use TLS.");
            clientBuilder.serviceUrl(PulsarService.brokerUrlTls(ServiceConfigurationUtils.getAppliedAdvertisedAddress((ServiceConfiguration)brokerConfig, (boolean)true), (Integer)brokerConfig.getBrokerServicePortTls().get())).allowTlsInsecureConnection(brokerConfig.isTlsAllowInsecureConnection()).tlsTrustCertsFilePath(brokerConfig.getTlsCertificateFilePath());
        } else {
            clientBuilder.serviceUrl(PulsarService.brokerUrl(ServiceConfigurationUtils.getAppliedAdvertisedAddress((ServiceConfiguration)brokerConfig, (boolean)true), (Integer)brokerConfig.getBrokerServicePort().get()));
        }
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("compaction-%d").setDaemon(true).build());
        OrderedScheduler executor = OrderedScheduler.newSchedulerBuilder().build();
        ZookeeperBkClientFactoryImpl zkClientFactory = new ZookeeperBkClientFactoryImpl((OrderedExecutor)executor);
        ZooKeeper zk = (ZooKeeper)zkClientFactory.create(brokerConfig.getZookeeperServers(), ZooKeeperClientFactory.SessionType.ReadWrite, (int)brokerConfig.getZooKeeperSessionTimeoutMillis()).get();
        BookKeeperClientFactoryImpl bkClientFactory = new BookKeeperClientFactoryImpl();
        EventLoopGroup eventLoopGroup = EventLoopUtil.newEventLoopGroup((int)1, (boolean)false, (ThreadFactory)new DefaultThreadFactory("compactor-io"));
        BookKeeper bk = bkClientFactory.create(brokerConfig, zk, eventLoopGroup, Optional.empty(), null);
        try (PulsarClient pulsar = clientBuilder.build();){
            TwoPhaseCompactor compactor = new TwoPhaseCompactor(brokerConfig, pulsar, bk, scheduler);
            long ledgerId = compactor.compact(arguments.topic).get();
            log.info("Compaction of topic {} complete. Compacted to ledger {}", (Object)arguments.topic, (Object)ledgerId);
        }
        finally {
            bk.close();
            bkClientFactory.close();
            zk.close();
            scheduler.shutdownNow();
            executor.shutdown();
            eventLoopGroup.shutdownGracefully();
        }
    }

    private static class Arguments {
        @Parameter(names={"-c", "--broker-conf"}, description="Configuration file for Broker")
        private String brokerConfigFile = Paths.get("", new String[0]).toAbsolutePath().normalize().toString() + "/conf/broker.conf";
        @Parameter(names={"-t", "--topic"}, description="Topic to compact", required=true)
        private String topic;
        @Parameter(names={"-h", "--help"}, description="Show this help message")
        private boolean help = false;

        private Arguments() {
        }
    }
}

