/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.pulsar.PulsarStandalone;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.common.configuration.PulsarConfigurationLoader;
import org.apache.pulsar.common.util.CmdGenerateDocs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarStandaloneStarter
extends PulsarStandalone {
    @Parameter(names={"-g", "--generate-docs"}, description="Generate docs")
    private boolean generateDocs = false;
    private static final Logger log = LoggerFactory.getLogger(PulsarStandaloneStarter.class);

    public PulsarStandaloneStarter(String[] args) throws Exception {
        JCommander jcommander = new JCommander();
        try {
            jcommander.addObject((Object)this);
            jcommander.parse(args);
            if (this.isHelp() || StringUtils.isBlank((CharSequence)this.getConfigFile())) {
                jcommander.usage();
                return;
            }
            if (this.generateDocs) {
                CmdGenerateDocs cmd = new CmdGenerateDocs("pulsar");
                cmd.addCommand("standalone", (Object)this);
                cmd.run(null);
                System.exit(0);
            }
            if (this.isNoBroker() && this.isOnlyBroker()) {
                log.error("Only one option is allowed between '--no-broker' and '--only-broker'");
                jcommander.usage();
                return;
            }
        }
        catch (Exception e) {
            jcommander.usage();
            log.error(e.getMessage());
            return;
        }
        try (FileInputStream inputStream = new FileInputStream(this.getConfigFile());){
            this.config = (ServiceConfiguration)PulsarConfigurationLoader.create((InputStream)inputStream, ServiceConfiguration.class);
        }
        String zkServers = "127.0.0.1";
        if (this.getAdvertisedAddress() != null) {
            this.config.setAdvertisedAddress(this.getAdvertisedAddress());
            zkServers = this.getAdvertisedAddress();
        } else if (StringUtils.isBlank((CharSequence)this.config.getAdvertisedAddress()) && StringUtils.isBlank((CharSequence)this.config.getAdvertisedListeners())) {
            this.config.setAdvertisedAddress("localhost");
        }
        if (PulsarStandaloneStarter.argsContains(args, "--zookeeper-port")) {
            this.config.setZookeeperServers(zkServers + ":" + this.getZkPort());
            this.config.setConfigurationStoreServers(zkServers + ":" + this.getZkPort());
        } else {
            if (this.config.getZookeeperServers() != null) {
                this.setZkPort(Integer.parseInt(this.config.getZookeeperServers().split(":")[1]));
            }
            this.config.setZookeeperServers(zkServers + ":" + this.getZkPort());
            this.config.setConfigurationStoreServers(zkServers + ":" + this.getZkPort());
        }
        this.config.setRunningStandalone(true);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    if (PulsarStandaloneStarter.this.fnWorkerService != null) {
                        PulsarStandaloneStarter.this.fnWorkerService.stop();
                    }
                    if (PulsarStandaloneStarter.this.broker != null) {
                        PulsarStandaloneStarter.this.broker.close();
                    }
                    if (PulsarStandaloneStarter.this.bkEnsemble != null) {
                        PulsarStandaloneStarter.this.bkEnsemble.stop();
                    }
                    LogManager.shutdown();
                }
                catch (Exception e) {
                    log.error("Shutdown failed: {}", (Object)e.getMessage(), (Object)e);
                }
            }
        });
    }

    private static boolean argsContains(String[] args, String arg) {
        return Arrays.asList(args).contains(arg);
    }

    public static void main(String[] args) throws Exception {
        PulsarStandaloneStarter standalone = new PulsarStandaloneStarter(args);
        try {
            standalone.start();
        }
        catch (Throwable th) {
            log.error("Failed to start pulsar service.", th);
            LogManager.shutdown();
            Runtime.getRuntime().exit(1);
        }
    }
}

