/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerMBeanImpl;
import org.apache.bookkeeper.mledger.util.StatsBuckets;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.resourcegroup.ResourceGroup;
import org.apache.pulsar.broker.resourcegroup.ResourceGroupPublishLimiter;
import org.apache.pulsar.broker.service.AbstractDispatcherSingleActiveConsumer;
import org.apache.pulsar.broker.service.BrokerService;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.Dispatcher;
import org.apache.pulsar.broker.service.PrecisPublishLimiter;
import org.apache.pulsar.broker.service.Producer;
import org.apache.pulsar.broker.service.PublishRateLimiter;
import org.apache.pulsar.broker.service.PublishRateLimiterImpl;
import org.apache.pulsar.broker.service.Subscription;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.broker.service.schema.BookkeeperSchemaStorage;
import org.apache.pulsar.broker.service.schema.SchemaRegistry;
import org.apache.pulsar.broker.service.schema.SchemaRegistryService;
import org.apache.pulsar.broker.service.schema.exceptions.IncompatibleSchemaException;
import org.apache.pulsar.broker.stats.prometheus.metrics.Summary;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.InactiveTopicDeleteMode;
import org.apache.pulsar.common.policies.data.InactiveTopicPolicies;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.policies.data.PublishRate;
import org.apache.pulsar.common.policies.data.SchemaAutoUpdateCompatibilityStrategy;
import org.apache.pulsar.common.policies.data.SchemaCompatibilityStrategy;
import org.apache.pulsar.common.policies.data.TopicPolicies;
import org.apache.pulsar.common.protocol.schema.SchemaData;
import org.apache.pulsar.common.protocol.schema.SchemaVersion;
import org.apache.pulsar.common.util.FutureUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTopic
implements Topic {
    protected static final long POLICY_UPDATE_FAILURE_RETRY_TIME_SECONDS = 60L;
    protected final String topic;
    protected final ConcurrentHashMap<String, Producer> producers;
    protected final BrokerService brokerService;
    protected final String replicatorPrefix;
    protected final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    protected volatile boolean isFenced;
    protected InactiveTopicPolicies inactiveTopicPolicies = new InactiveTopicPolicies();
    protected volatile long lastActive;
    protected volatile boolean hasBatchMessagePublished = false;
    protected StatsBuckets addEntryLatencyStatsUsec = new StatsBuckets(ManagedLedgerMBeanImpl.ENTRY_LATENCY_BUCKETS_USEC);
    protected volatile boolean isEncryptionRequired = false;
    protected volatile SchemaCompatibilityStrategy schemaCompatibilityStrategy = SchemaCompatibilityStrategy.FULL;
    protected volatile Boolean isAllowAutoUpdateSchema;
    protected volatile boolean schemaValidationEnforced = false;
    protected volatile int maxUnackedMessagesOnConsumerAppilied = 0;
    protected volatile Integer maxSubscriptionsPerTopic = null;
    protected volatile PublishRateLimiter topicPublishRateLimiter;
    protected volatile ResourceGroupPublishLimiter resourceGroupPublishLimiter;
    protected boolean preciseTopicPublishRateLimitingEnable;
    protected boolean resourceGroupRateLimitingEnabled;
    private LongAdder bytesInCounter = new LongAdder();
    private LongAdder msgInCounter = new LongAdder();
    private static final AtomicLongFieldUpdater<AbstractTopic> RATE_LIMITED_UPDATER = AtomicLongFieldUpdater.newUpdater(AbstractTopic.class, "publishRateLimitedTimes");
    protected volatile long publishRateLimitedTimes = 0L;
    protected volatile Optional<Long> topicEpoch = Optional.empty();
    private volatile boolean hasExclusiveProducer;
    private volatile String exclusiveProducerName;
    private final Queue<Pair<Producer, CompletableFuture<Optional<Long>>>> waitingExclusiveProducers = new ConcurrentLinkedQueue<Pair<Producer, CompletableFuture<Optional<Long>>>>();
    private static final AtomicLongFieldUpdater<AbstractTopic> USAGE_COUNT_UPDATER = AtomicLongFieldUpdater.newUpdater(AbstractTopic.class, "usageCount");
    private volatile long usageCount = 0L;
    private volatile int topicMaxMessageSize = 0;
    private volatile long lastTopicMaxMessageSizeCheckTimeStamp = 0L;
    private final long topicMaxMessageSizeCheckIntervalMs;
    private static final Summary PUBLISH_LATENCY = (Summary)Summary.build("pulsar_broker_publish_latency", "-").quantile(0.0).quantile(0.5).quantile(0.95).quantile(0.99).quantile(0.999).quantile(0.9999).quantile(1.0).register();
    private static final Logger log = LoggerFactory.getLogger(AbstractTopic.class);

    public AbstractTopic(String topic, BrokerService brokerService) {
        this.topic = topic;
        this.brokerService = brokerService;
        this.producers = new ConcurrentHashMap();
        this.isFenced = false;
        this.replicatorPrefix = brokerService.pulsar().getConfiguration().getReplicatorPrefix();
        this.inactiveTopicPolicies.setDeleteWhileInactive(brokerService.pulsar().getConfiguration().isBrokerDeleteInactiveTopicsEnabled());
        this.inactiveTopicPolicies.setMaxInactiveDurationSeconds(brokerService.pulsar().getConfiguration().getBrokerDeleteInactiveTopicsMaxInactiveDurationSeconds());
        this.inactiveTopicPolicies.setInactiveTopicDeleteMode(brokerService.pulsar().getConfiguration().getBrokerDeleteInactiveTopicsMode());
        this.topicMaxMessageSizeCheckIntervalMs = TimeUnit.SECONDS.toMillis(brokerService.pulsar().getConfiguration().getMaxMessageSizeCheckIntervalInSeconds());
        this.lastActive = System.nanoTime();
        this.preciseTopicPublishRateLimitingEnable = brokerService.pulsar().getConfiguration().isPreciseTopicPublishRateLimiterEnable();
        this.updatePublishDispatcher(Optional.empty());
    }

    protected boolean isProducersExceeded() {
        Integer maxProducers = this.getTopicPolicies().map(TopicPolicies::getMaxProducerPerTopic).orElse(null);
        if (maxProducers == null) {
            Policies policies = this.brokerService.pulsar().getPulsarResources().getNamespaceResources().getPoliciesIfCached(TopicName.get((String)this.topic).getNamespaceObject()).orElseGet(() -> new Policies());
            maxProducers = policies.max_producers_per_topic;
        }
        return (maxProducers = Integer.valueOf(maxProducers != null ? maxProducers.intValue() : this.brokerService.pulsar().getConfiguration().getMaxProducersPerTopic())) > 0 && maxProducers <= this.producers.size();
    }

    protected boolean isSameAddressProducersExceeded(Producer producer) {
        int maxSameAddressProducers = this.brokerService.pulsar().getConfiguration().getMaxSameAddressProducersPerTopic();
        return maxSameAddressProducers > 0 && this.getNumberOfSameAddressProducers(producer.getClientAddress()) >= maxSameAddressProducers;
    }

    public int getNumberOfSameAddressProducers(String clientAddress) {
        int count = 0;
        if (clientAddress != null) {
            for (Producer producer : this.producers.values()) {
                if (!clientAddress.equals(producer.getClientAddress())) continue;
                ++count;
            }
        }
        return count;
    }

    protected boolean isConsumersExceededOnTopic() {
        int maxConsumersPerTopic;
        Integer maxConsumers = this.getTopicPolicies().map(TopicPolicies::getMaxConsumerPerTopic).orElse(null);
        if (maxConsumers == null) {
            Policies policies = this.brokerService.pulsar().getPulsarResources().getNamespaceResources().getPoliciesIfCached(TopicName.get((String)this.topic).getNamespaceObject()).orElseGet(() -> new Policies());
            maxConsumers = policies.max_consumers_per_topic;
        }
        int n = maxConsumersPerTopic = maxConsumers != null ? maxConsumers.intValue() : this.brokerService.pulsar().getConfiguration().getMaxConsumersPerTopic();
        return maxConsumersPerTopic > 0 && maxConsumersPerTopic <= this.getNumberOfConsumers();
    }

    protected boolean isSameAddressConsumersExceededOnTopic(Consumer consumer) {
        int maxSameAddressConsumers = this.brokerService.pulsar().getConfiguration().getMaxSameAddressConsumersPerTopic();
        return maxSameAddressConsumers > 0 && this.getNumberOfSameAddressConsumers(consumer.getClientAddress()) >= maxSameAddressConsumers;
    }

    public abstract int getNumberOfConsumers();

    public abstract int getNumberOfSameAddressConsumers(String var1);

    protected int getNumberOfSameAddressConsumers(String clientAddress, List<? extends Subscription> subscriptions) {
        int count = 0;
        if (clientAddress != null) {
            for (Subscription subscription : subscriptions) {
                count += subscription.getNumberOfSameAddressConsumers(clientAddress);
            }
        }
        return count;
    }

    protected CompletableFuture<Void> addConsumerToSubscription(Subscription subscription, Consumer consumer) {
        if (this.isConsumersExceededOnTopic()) {
            log.warn("[{}] Attempting to add consumer to topic which reached max consumers limit", (Object)this.topic);
            return FutureUtil.failedFuture((Throwable)new BrokerServiceException.ConsumerBusyException("Topic reached max consumers limit"));
        }
        if (this.isSameAddressConsumersExceededOnTopic(consumer)) {
            log.warn("[{}] Attempting to add consumer to topic which reached max same address consumers limit", (Object)this.topic);
            return FutureUtil.failedFuture((Throwable)new BrokerServiceException.ConsumerBusyException("Topic reached max same address consumers limit"));
        }
        return subscription.addConsumer(consumer);
    }

    protected Consumer getActiveConsumer(Subscription subscription) {
        Dispatcher dispatcher = subscription.getDispatcher();
        if (dispatcher instanceof AbstractDispatcherSingleActiveConsumer) {
            return ((AbstractDispatcherSingleActiveConsumer)dispatcher).getActiveConsumer();
        }
        return null;
    }

    @Override
    public void disableCnxAutoRead() {
        this.producers.values().forEach(producer -> producer.getCnx().disableCnxAutoRead());
    }

    @Override
    public void enableCnxAutoRead() {
        this.producers.values().forEach(producer -> producer.getCnx().enableCnxAutoRead());
    }

    protected boolean hasLocalProducers() {
        if (this.producers.isEmpty()) {
            return false;
        }
        for (Producer producer : this.producers.values()) {
            if (producer.isRemote()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("topic", (Object)this.topic).toString();
    }

    @Override
    public Map<String, Producer> getProducers() {
        return this.producers;
    }

    @Override
    public BrokerService getBrokerService() {
        return this.brokerService;
    }

    @Override
    public String getName() {
        return this.topic;
    }

    @Override
    public boolean isEncryptionRequired() {
        return this.isEncryptionRequired;
    }

    @Override
    public boolean getSchemaValidationEnforced() {
        return this.schemaValidationEnforced;
    }

    public void markBatchMessagePublished() {
        this.hasBatchMessagePublished = true;
    }

    public String getReplicatorPrefix() {
        return this.replicatorPrefix;
    }

    @Override
    public CompletableFuture<Boolean> hasSchema() {
        String base = TopicName.get((String)this.getName()).getPartitionedTopicName();
        String id = TopicName.get((String)base).getSchemaName();
        return this.brokerService.pulsar().getSchemaRegistryService().getSchema(id).thenApply(Objects::nonNull);
    }

    @Override
    public CompletableFuture<SchemaVersion> addSchema(SchemaData schema) {
        if (schema == null) {
            return CompletableFuture.completedFuture(SchemaVersion.Empty);
        }
        String base = TopicName.get((String)this.getName()).getPartitionedTopicName();
        String id = TopicName.get((String)base).getSchemaName();
        SchemaRegistryService schemaRegistryService = this.brokerService.pulsar().getSchemaRegistryService();
        if (this.allowAutoUpdateSchema()) {
            return schemaRegistryService.putSchemaIfAbsent(id, schema, this.schemaCompatibilityStrategy);
        }
        return schemaRegistryService.trimDeletedSchemaAndGetList(id).thenCompose(schemaAndMetadataList -> schemaRegistryService.getSchemaVersionBySchemaData((List<SchemaRegistry.SchemaAndMetadata>)schemaAndMetadataList, schema).thenCompose(schemaVersion -> {
            if (schemaVersion == null) {
                return FutureUtil.failedFuture((Throwable)new IncompatibleSchemaException("Schema not found and schema auto updating is disabled."));
            }
            return CompletableFuture.completedFuture(schemaVersion);
        }));
    }

    private boolean allowAutoUpdateSchema() {
        if (this.brokerService.isSystemTopic(this.topic)) {
            return true;
        }
        if (this.isAllowAutoUpdateSchema == null) {
            return this.brokerService.pulsar().getConfig().isAllowAutoUpdateSchemaEnabled();
        }
        return this.isAllowAutoUpdateSchema;
    }

    @Override
    public CompletableFuture<SchemaVersion> deleteSchema() {
        String base = TopicName.get((String)this.getName()).getPartitionedTopicName();
        String id = TopicName.get((String)base).getSchemaName();
        SchemaRegistryService schemaRegistryService = this.brokerService.pulsar().getSchemaRegistryService();
        return BookkeeperSchemaStorage.ignoreUnrecoverableBKException(schemaRegistryService.getSchema(id)).thenCompose(schema -> {
            if (schema != null) {
                log.info("Delete schema storage of id: {}", (Object)id);
                return schemaRegistryService.deleteSchemaStorage(id);
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    @Override
    public CompletableFuture<Void> checkSchemaCompatibleForConsumer(SchemaData schema) {
        String base = TopicName.get((String)this.getName()).getPartitionedTopicName();
        String id = TopicName.get((String)base).getSchemaName();
        return this.brokerService.pulsar().getSchemaRegistryService().checkConsumerCompatibility(id, schema, this.schemaCompatibilityStrategy);
    }

    @Override
    public CompletableFuture<Optional<Long>> addProducer(Producer producer, CompletableFuture<Void> producerQueuedFuture) {
        Preconditions.checkArgument((producer.getTopic() == this ? 1 : 0) != 0);
        return ((CompletableFuture)this.brokerService.checkTopicNsOwnership(this.getName()).thenCompose(__ -> this.incrementTopicEpochIfNeeded(producer, producerQueuedFuture))).thenCompose(producerEpoch -> {
            this.lock.writeLock().lock();
            try {
                this.checkTopicFenced();
                if (this.isTerminated()) {
                    log.warn("[{}] Attempting to add producer to a terminated topic", (Object)this.topic);
                    throw new BrokerServiceException.TopicTerminatedException("Topic was already terminated");
                }
                this.internalAddProducer(producer);
                USAGE_COUNT_UPDATER.incrementAndGet(this);
                if (log.isDebugEnabled()) {
                    log.debug("[{}] [{}] Added producer -- count: {}", new Object[]{this.topic, producer.getProducerName(), USAGE_COUNT_UPDATER.get(this)});
                }
                CompletableFuture<Optional> completableFuture = CompletableFuture.completedFuture(producerEpoch);
                return completableFuture;
            }
            catch (BrokerServiceException e) {
                CompletableFuture completableFuture = FutureUtil.failedFuture((Throwable)e);
                return completableFuture;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletableFuture<Optional<Long>> incrementTopicEpochIfNeeded(Producer producer, CompletableFuture<Void> producerQueuedFuture) {
        this.lock.writeLock().lock();
        try {
            switch (producer.getAccessMode()) {
                case Shared: {
                    if (this.hasExclusiveProducer || !this.waitingExclusiveProducers.isEmpty()) {
                        CompletableFuture completableFuture = FutureUtil.failedFuture((Throwable)new BrokerServiceException.ProducerBusyException("Topic has an existing exclusive producer: " + this.exclusiveProducerName));
                        return completableFuture;
                    }
                    CompletableFuture<Optional<Long>> completableFuture = CompletableFuture.completedFuture(this.topicEpoch);
                    return completableFuture;
                }
                case Exclusive: {
                    if (this.hasExclusiveProducer || !this.waitingExclusiveProducers.isEmpty()) {
                        CompletableFuture completableFuture = FutureUtil.failedFuture((Throwable)new BrokerServiceException.ProducerFencedException("Topic has an existing exclusive producer: " + this.exclusiveProducerName));
                        return completableFuture;
                    }
                    if (!this.producers.isEmpty()) {
                        CompletableFuture completableFuture = FutureUtil.failedFuture((Throwable)new BrokerServiceException.ProducerFencedException("Topic has existing shared producers"));
                        return completableFuture;
                    }
                    if (producer.getTopicEpoch().isPresent() && producer.getTopicEpoch().get() < this.topicEpoch.orElse(-1L)) {
                        CompletableFuture completableFuture = FutureUtil.failedFuture((Throwable)new BrokerServiceException.ProducerFencedException(String.format("Topic epoch has already moved. Current epoch: %d, Producer epoch: %d", this.topicEpoch.get(), producer.getTopicEpoch().get())));
                        return completableFuture;
                    }
                    this.hasExclusiveProducer = true;
                    this.exclusiveProducerName = producer.getProducerName();
                    CompletableFuture<Long> future = producer.getTopicEpoch().isPresent() ? this.setTopicEpoch(producer.getTopicEpoch().get()) : this.incrementTopicEpoch(this.topicEpoch);
                    future.exceptionally(ex -> {
                        this.hasExclusiveProducer = false;
                        this.exclusiveProducerName = null;
                        return null;
                    });
                    CompletionStage completionStage = future.thenApply(epoch -> {
                        this.topicEpoch = Optional.of(epoch);
                        return this.topicEpoch;
                    });
                    return completionStage;
                }
                case WaitForExclusive: {
                    if (this.hasExclusiveProducer || !this.producers.isEmpty()) {
                        CompletableFuture<Optional<Long>> future = new CompletableFuture<Optional<Long>>();
                        log.info("[{}] Queuing producer {} since there's already a producer", (Object)this.topic, (Object)producer);
                        this.waitingExclusiveProducers.add((Pair<Producer, CompletableFuture<Optional<Long>>>)Pair.of((Object)producer, future));
                        producerQueuedFuture.complete(null);
                        CompletableFuture<Optional<Long>> completableFuture = future;
                        return completableFuture;
                    }
                    if (producer.getTopicEpoch().isPresent() && producer.getTopicEpoch().get() < this.topicEpoch.orElse(-1L)) {
                        CompletableFuture future = FutureUtil.failedFuture((Throwable)new BrokerServiceException.ProducerFencedException(String.format("Topic epoch has already moved. Current epoch: %d, Producer epoch: %d", this.topicEpoch.get(), producer.getTopicEpoch().get())));
                        return future;
                    }
                    this.hasExclusiveProducer = true;
                    this.exclusiveProducerName = producer.getProducerName();
                    CompletableFuture<Long> future = producer.getTopicEpoch().isPresent() ? this.setTopicEpoch(producer.getTopicEpoch().get()) : this.incrementTopicEpoch(this.topicEpoch);
                    future.exceptionally(ex -> {
                        this.hasExclusiveProducer = false;
                        this.exclusiveProducerName = null;
                        return null;
                    });
                    CompletionStage completionStage = future.thenApply(epoch -> {
                        this.topicEpoch = Optional.of(epoch);
                        return this.topicEpoch;
                    });
                    return completionStage;
                }
            }
            CompletableFuture future = FutureUtil.failedFuture((Throwable)new BrokerServiceException("Invalid producer access mode: " + producer.getAccessMode()));
            return future;
        }
        catch (Exception e) {
            log.error("Encountered unexpected error during exclusive producer creation", (Throwable)e);
            CompletableFuture completableFuture = FutureUtil.failedFuture((Throwable)new BrokerServiceException(e));
            return completableFuture;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected abstract CompletableFuture<Long> setTopicEpoch(long var1);

    protected abstract CompletableFuture<Long> incrementTopicEpoch(Optional<Long> var1);

    @Override
    public void recordAddLatency(long latency, TimeUnit unit) {
        this.addEntryLatencyStatsUsec.addValue(unit.toMicros(latency));
        PUBLISH_LATENCY.observe(latency, unit);
    }

    protected void setSchemaCompatibilityStrategy(Policies policies) {
        if (this.isSystemTopic()) {
            this.schemaCompatibilityStrategy = this.brokerService.pulsar().getConfig().getSystemTopicSchemaCompatibilityStrategy();
            return;
        }
        this.schemaCompatibilityStrategy = policies.schema_compatibility_strategy;
        if (SchemaCompatibilityStrategy.isUndefined((SchemaCompatibilityStrategy)this.schemaCompatibilityStrategy)) {
            this.schemaCompatibilityStrategy = SchemaCompatibilityStrategy.fromAutoUpdatePolicy((SchemaAutoUpdateCompatibilityStrategy)policies.schema_auto_update_compatibility_strategy);
            if (SchemaCompatibilityStrategy.isUndefined((SchemaCompatibilityStrategy)this.schemaCompatibilityStrategy)) {
                this.schemaCompatibilityStrategy = this.brokerService.pulsar().getConfig().getSchemaCompatibilityStrategy();
            }
        }
    }

    @Override
    public void checkTopicPublishThrottlingRate() {
        this.topicPublishRateLimiter.checkPublishRate();
    }

    @Override
    public void incrementPublishCount(int numOfMessages, long msgSizeInBytes) {
        this.topicPublishRateLimiter.incrementPublishCount(numOfMessages, msgSizeInBytes);
        this.getBrokerPublishRateLimiter().incrementPublishCount(numOfMessages, msgSizeInBytes);
        this.bytesInCounter.add(msgSizeInBytes);
        this.msgInCounter.add(numOfMessages);
    }

    @Override
    public void resetTopicPublishCountAndEnableReadIfRequired() {
        if (!this.getBrokerPublishRateLimiter().isPublishRateExceeded() && this.topicPublishRateLimiter.resetPublishCount()) {
            this.enableProducerReadForPublishRateLimiting();
        }
    }

    @Override
    public void resetBrokerPublishCountAndEnableReadIfRequired(boolean doneBrokerReset) {
        if (!this.topicPublishRateLimiter.isPublishRateExceeded() && doneBrokerReset) {
            this.enableProducerReadForPublishRateLimiting();
        }
    }

    protected void enableProducerReadForPublishRateLimiting() {
        if (this.producers != null) {
            this.producers.values().forEach(producer -> {
                producer.getCnx().cancelPublishRateLimiting();
                producer.getCnx().enableCnxAutoRead();
            });
        }
    }

    protected void enableProducerReadForPublishBufferLimiting() {
        if (this.producers != null) {
            this.producers.values().forEach(producer -> {
                producer.getCnx().cancelPublishBufferLimiting();
                producer.getCnx().enableCnxAutoRead();
            });
        }
    }

    protected void disableProducerRead() {
        if (this.producers != null) {
            this.producers.values().forEach(producer -> producer.getCnx().disableCnxAutoRead());
        }
    }

    protected void checkTopicFenced() throws BrokerServiceException {
        if (this.isFenced) {
            log.warn("[{}] Attempting to add producer to a fenced topic", (Object)this.topic);
            throw new BrokerServiceException.TopicFencedException("Topic is temporarily unavailable");
        }
    }

    @Override
    public long increasePublishLimitedTimes() {
        return RATE_LIMITED_UPDATER.incrementAndGet(this);
    }

    protected void internalAddProducer(Producer producer) throws BrokerServiceException {
        Producer existProducer;
        if (this.isProducersExceeded()) {
            log.warn("[{}] Attempting to add producer to topic which reached max producers limit", (Object)this.topic);
            throw new BrokerServiceException.ProducerBusyException("Topic reached max producers limit");
        }
        if (this.isSameAddressProducersExceeded(producer)) {
            log.warn("[{}] Attempting to add producer to topic which reached max same address producers limit", (Object)this.topic);
            throw new BrokerServiceException.ProducerBusyException("Topic reached max same address producers limit");
        }
        if (log.isDebugEnabled()) {
            log.debug("[{}] {} Got request to create producer ", (Object)this.topic, (Object)producer.getProducerName());
        }
        if ((existProducer = this.producers.putIfAbsent(producer.getProducerName(), producer)) != null) {
            this.tryOverwriteOldProducer(existProducer, producer);
        }
    }

    private void tryOverwriteOldProducer(Producer oldProducer, Producer newProducer) throws BrokerServiceException {
        if (newProducer.isSuccessorTo(oldProducer) && !this.isUserProvidedProducerName(oldProducer) && !this.isUserProvidedProducerName(newProducer)) {
            oldProducer.close(false);
            if (!this.producers.replace(newProducer.getProducerName(), oldProducer, newProducer)) {
                throw new BrokerServiceException.NamingException("Producer with name '" + newProducer.getProducerName() + "' replace concurrency error");
            }
        } else {
            throw new BrokerServiceException.NamingException("Producer with name '" + newProducer.getProducerName() + "' is already connected to topic");
        }
        this.handleProducerRemoved(oldProducer);
    }

    private boolean isUserProvidedProducerName(Producer producer) {
        return producer.isUserProvidedProducerName() && !producer.getProducerName().startsWith(this.replicatorPrefix);
    }

    @Override
    public void removeProducer(Producer producer) {
        Preconditions.checkArgument((producer.getTopic() == this ? 1 : 0) != 0);
        if (this.producers.remove(producer.getProducerName(), producer)) {
            this.handleProducerRemoved(producer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleProducerRemoved(Producer producer) {
        USAGE_COUNT_UPDATER.decrementAndGet(this);
        if (this.hasExclusiveProducer) {
            this.lock.writeLock().lock();
            try {
                this.hasExclusiveProducer = false;
                this.exclusiveProducerName = null;
                Pair<Producer, CompletableFuture<Optional<Long>>> nextWaitingProducer = this.waitingExclusiveProducers.poll();
                if (nextWaitingProducer != null) {
                    Producer nextProducer = (Producer)nextWaitingProducer.getKey();
                    CompletableFuture producerFuture = (CompletableFuture)nextWaitingProducer.getValue();
                    this.hasExclusiveProducer = true;
                    this.exclusiveProducerName = nextProducer.getProducerName();
                    CompletableFuture<Long> future = nextProducer.getTopicEpoch().isPresent() ? this.setTopicEpoch(nextProducer.getTopicEpoch().get()) : this.incrementTopicEpoch(this.topicEpoch);
                    ((CompletableFuture)future.thenAccept(epoch -> {
                        this.topicEpoch = Optional.of(epoch);
                        producerFuture.complete(this.topicEpoch);
                    })).exceptionally(ex -> {
                        this.hasExclusiveProducer = false;
                        this.exclusiveProducerName = null;
                        producerFuture.completeExceptionally((Throwable)ex);
                        return null;
                    });
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("[{}] [{}] Removed producer -- count: {}", new Object[]{this.topic, producer.getProducerName(), USAGE_COUNT_UPDATER.get(this)});
        }
        this.lastActive = System.nanoTime();
    }

    public void handleConsumerAdded(String subscriptionName, String consumerName) {
        USAGE_COUNT_UPDATER.incrementAndGet(this);
        if (log.isDebugEnabled()) {
            log.debug("[{}] [{}] [{}] Added consumer -- count: {}", new Object[]{this.topic, subscriptionName, consumerName, USAGE_COUNT_UPDATER.get(this)});
        }
    }

    public void decrementUsageCount() {
        USAGE_COUNT_UPDATER.decrementAndGet(this);
    }

    public long currentUsageCount() {
        return this.usageCount;
    }

    @Override
    public boolean isPublishRateExceeded() {
        return this.topicPublishRateLimiter.isPublishRateExceeded() || this.getBrokerPublishRateLimiter().isPublishRateExceeded();
    }

    @Override
    public boolean isResourceGroupPublishRateExceeded(int numMessages, int bytes) {
        return this.resourceGroupRateLimitingEnabled && !this.resourceGroupPublishLimiter.tryAcquire(numMessages, bytes);
    }

    @Override
    public boolean isResourceGroupRateLimitingEnabled() {
        return this.resourceGroupRateLimitingEnabled;
    }

    @Override
    public boolean isTopicPublishRateExceeded(int numberMessages, int bytes) {
        return this.preciseTopicPublishRateLimitingEnable && !this.topicPublishRateLimiter.tryAcquire(numberMessages, bytes);
    }

    @Override
    public boolean isBrokerPublishRateExceeded() {
        return this.getBrokerPublishRateLimiter().isPublishRateExceeded();
    }

    public PublishRateLimiter getTopicPublishRateLimiter() {
        return this.topicPublishRateLimiter;
    }

    public PublishRateLimiter getBrokerPublishRateLimiter() {
        return this.brokerService.getBrokerPublishRateLimiter();
    }

    public void updateMaxPublishRate(Policies policies) {
        this.updatePublishDispatcher(Optional.ofNullable(policies));
    }

    private void updatePublishDispatcher(Optional<Policies> optPolicies) {
        Policies policies;
        Optional<PublishRate> topicPublishRate = this.getTopicPolicies().map(TopicPolicies::getPublishRate);
        if (topicPublishRate.isPresent()) {
            log.info("Using topic policy publish rate instead of namespace level topic publish rate on topic {}", (Object)this.topic);
            this.updatePublishDispatcher(topicPublishRate.get());
            return;
        }
        try {
            policies = optPolicies.isPresent() ? optPolicies.get() : this.brokerService.pulsar().getPulsarResources().getNamespaceResources().getPoliciesIfCached(TopicName.get((String)this.topic).getNamespaceObject()).orElseGet(() -> new Policies());
        }
        catch (Exception e) {
            log.warn("[{}] Error getting policies {} and publish throttling will be disabled", (Object)this.topic, (Object)e.getMessage());
            policies = new Policies();
        }
        String clusterName = this.brokerService.pulsar().getConfiguration().getClusterName();
        PublishRate publishRate = policies.publishMaxMessageRate != null ? (PublishRate)policies.publishMaxMessageRate.get(clusterName) : null;
        ServiceConfiguration serviceConfiguration = this.brokerService.pulsar().getConfiguration();
        if (publishRate != null) {
            this.updatePublishDispatcher(publishRate);
        } else {
            PublishRate brokerPublishRate = new PublishRate(serviceConfiguration.getMaxPublishRatePerTopicInMessages(), serviceConfiguration.getMaxPublishRatePerTopicInBytes());
            this.updatePublishDispatcher(brokerPublishRate);
        }
        String rgName = policies.resource_group_name;
        if (rgName != null) {
            ResourceGroup resourceGroup = this.brokerService.getPulsar().getResourceGroupServiceManager().resourceGroupGet(rgName);
            if (resourceGroup != null) {
                this.resourceGroupRateLimitingEnabled = true;
                this.resourceGroupPublishLimiter = resourceGroup.getResourceGroupPublishLimiter();
                this.resourceGroupPublishLimiter.registerRateLimitFunction(this.getName(), () -> this.enableCnxAutoRead());
                log.info("Using resource group {} rate limiter for topic {}", (Object)rgName, (Object)this.topic);
                return;
            }
        } else {
            if (this.resourceGroupRateLimitingEnabled) {
                this.resourceGroupPublishLimiter.unregisterRateLimitFunction(this.getName());
                this.resourceGroupPublishLimiter = null;
                this.resourceGroupRateLimitingEnabled = false;
            }
            this.enableProducerReadForPublishRateLimiting();
        }
    }

    public long getMsgInCounter() {
        return this.msgInCounter.longValue();
    }

    public long getBytesInCounter() {
        return this.bytesInCounter.longValue();
    }

    public long getMsgOutCounter() {
        return this.getStats((boolean)false, (boolean)false).msgOutCounter;
    }

    public long getBytesOutCounter() {
        return this.getStats((boolean)false, (boolean)false).bytesOutCounter;
    }

    public boolean isDeleteWhileInactive() {
        return this.inactiveTopicPolicies.isDeleteWhileInactive();
    }

    public boolean deletePartitionedTopicMetadataWhileInactive() {
        return this.brokerService.pulsar().getConfiguration().isBrokerDeleteInactivePartitionedTopicMetadataEnabled();
    }

    public void setDeleteWhileInactive(boolean deleteWhileInactive) {
        this.inactiveTopicPolicies.setDeleteWhileInactive(deleteWhileInactive);
    }

    protected abstract boolean isTerminated();

    public InactiveTopicPolicies getInactiveTopicPolicies() {
        return this.inactiveTopicPolicies;
    }

    public void resetInactiveTopicPolicies(InactiveTopicDeleteMode inactiveTopicDeleteMode, int maxInactiveDurationSeconds, boolean deleteWhileInactive) {
        this.inactiveTopicPolicies.setInactiveTopicDeleteMode(inactiveTopicDeleteMode);
        this.inactiveTopicPolicies.setMaxInactiveDurationSeconds(maxInactiveDurationSeconds);
        this.inactiveTopicPolicies.setDeleteWhileInactive(deleteWhileInactive);
    }

    public Optional<TopicPolicies> getTopicPolicies() {
        return this.brokerService.getTopicPolicies(TopicName.get((String)this.topic));
    }

    public CompletableFuture<Void> deleteTopicPolicies() {
        return this.brokerService.deleteTopicPolicies(TopicName.get((String)this.topic));
    }

    protected int getWaitingProducersCount() {
        return this.waitingExclusiveProducers.size();
    }

    protected boolean isExceedMaximumMessageSize(int size) {
        if (this.lastTopicMaxMessageSizeCheckTimeStamp + this.topicMaxMessageSizeCheckIntervalMs < System.currentTimeMillis()) {
            this.topicMaxMessageSize = this.getTopicPolicies().map(TopicPolicies::getMaxMessageSize).orElse(0);
            this.lastTopicMaxMessageSizeCheckTimeStamp = System.currentTimeMillis();
        }
        if (this.topicMaxMessageSize == 0) {
            return false;
        }
        return size > this.topicMaxMessageSize;
    }

    protected void updatePublishDispatcher(PublishRate publishRate) {
        if (publishRate != null && (publishRate.publishThrottlingRateInByte > 0L || publishRate.publishThrottlingRateInMsg > 0)) {
            log.info("Enabling publish rate limiting {} ", (Object)publishRate);
            if (!this.preciseTopicPublishRateLimitingEnable) {
                this.brokerService.setupTopicPublishRateLimiterMonitor();
            }
            if (this.topicPublishRateLimiter == null || this.topicPublishRateLimiter == PublishRateLimiter.DISABLED_RATE_LIMITER) {
                this.topicPublishRateLimiter = this.preciseTopicPublishRateLimitingEnable ? new PrecisPublishLimiter(publishRate, () -> this.enableCnxAutoRead(), this.brokerService.pulsar().getExecutor()) : new PublishRateLimiterImpl(publishRate);
            } else {
                this.topicPublishRateLimiter.update(publishRate);
            }
        } else {
            log.info("Disabling publish throttling for {}", (Object)this.topic);
            if (this.topicPublishRateLimiter != null) {
                this.topicPublishRateLimiter.close();
            }
            this.topicPublishRateLimiter = PublishRateLimiter.DISABLED_RATE_LIMITER;
            this.enableProducerReadForPublishRateLimiting();
        }
    }

    public SchemaCompatibilityStrategy getSchemaCompatibilityStrategy() {
        return this.schemaCompatibilityStrategy;
    }
}

