/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.compaction;

import com.google.common.collect.ImmutableMap;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.mledger.impl.LedgerMetadataUtils;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.RawMessage;
import org.apache.pulsar.client.api.RawReader;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.client.impl.RawBatchConverter;
import org.apache.pulsar.common.api.proto.MessageMetadata;
import org.apache.pulsar.common.protocol.Commands;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.compaction.Compactor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwoPhaseCompactor
extends Compactor {
    private static final Logger log = LoggerFactory.getLogger(TwoPhaseCompactor.class);
    private static final int MAX_OUTSTANDING = 500;
    private static final String COMPACTED_TOPIC_LEDGER_PROPERTY = "CompactedTopicLedger";
    private final Duration phaseOneLoopReadTimeout;

    public TwoPhaseCompactor(ServiceConfiguration conf, PulsarClient pulsar, BookKeeper bk, ScheduledExecutorService scheduler) {
        super(conf, pulsar, bk, scheduler);
        this.phaseOneLoopReadTimeout = Duration.ofSeconds(conf.getBrokerServiceCompactionPhaseOneLoopTimeInSeconds());
    }

    @Override
    protected CompletableFuture<Long> doCompaction(RawReader reader, BookKeeper bk) {
        return reader.hasMessageAvailableAsync().thenCompose(available -> {
            if (available.booleanValue()) {
                return this.phaseOne(reader).thenCompose(r -> this.phaseTwo(reader, r.from, r.to, r.lastReadId, r.latestForKey, bk));
            }
            log.info("Skip compaction of the empty topic {}", (Object)reader.getTopic());
            return CompletableFuture.completedFuture(-1L);
        });
    }

    private CompletableFuture<PhaseOneResult> phaseOne(RawReader reader) {
        HashMap latestForKey = new HashMap();
        CompletableFuture<PhaseOneResult> loopPromise = new CompletableFuture<PhaseOneResult>();
        ((CompletableFuture)reader.getLastMessageIdAsync().thenAccept(lastMessageId -> {
            log.info("Commencing phase one of compaction for {}, reading to {}", (Object)reader.getTopic(), lastMessageId);
            MessageIdImpl lastImpl = (MessageIdImpl)lastMessageId;
            MessageIdImpl lastEntryMessageId = new MessageIdImpl(lastImpl.getLedgerId(), lastImpl.getEntryId(), lastImpl.getPartitionIndex());
            this.phaseOneLoop(reader, Optional.empty(), Optional.empty(), (MessageId)lastEntryMessageId, latestForKey, loopPromise);
        })).exceptionally(ex -> {
            loopPromise.completeExceptionally((Throwable)ex);
            return null;
        });
        return loopPromise;
    }

    private void phaseOneLoop(RawReader reader, Optional<MessageId> firstMessageId, Optional<MessageId> toMessageId, MessageId lastMessageId, Map<String, MessageId> latestForKey, CompletableFuture<PhaseOneResult> loopPromise) {
        if (loopPromise.isDone()) {
            return;
        }
        CompletableFuture<RawMessage> future = reader.readNextAsync();
        FutureUtil.addTimeoutHandling(future, (Duration)this.phaseOneLoopReadTimeout, (ScheduledExecutorService)this.scheduler, () -> FutureUtil.createTimeoutException((String)"Timeout", this.getClass(), (String)"phaseOneLoop(...)"));
        ((CompletableFuture)future.thenAcceptAsync(m -> {
            try {
                MessageId to;
                MessageId id = m.getMessageId();
                boolean deletedMessage = false;
                boolean replaceMessage = false;
                this.mxBean.addCompactionReadOp(reader.getTopic(), m.getHeadersAndPayload().readableBytes());
                if (RawBatchConverter.isReadableBatch(m)) {
                    try {
                        for (ImmutableTriple<MessageId, String, Integer> e : RawBatchConverter.extractIdsAndKeysAndSize(m)) {
                            if (e != null) {
                                if ((Integer)e.getRight() > 0) {
                                    MessageId old = latestForKey.put((String)e.getMiddle(), (MessageId)e.getLeft());
                                    replaceMessage = old != null;
                                } else {
                                    deletedMessage = true;
                                    latestForKey.remove(e.getMiddle());
                                }
                            }
                            if (!replaceMessage && !deletedMessage) continue;
                            this.mxBean.addCompactionRemovedEvent(reader.getTopic());
                        }
                    }
                    catch (IOException ioe) {
                        log.info("Error decoding batch for message {}. Whole batch will be included in output", (Object)id, (Object)ioe);
                    }
                } else {
                    Pair<String, Integer> keyAndSize = TwoPhaseCompactor.extractKeyAndSize(m);
                    if (keyAndSize != null) {
                        if ((Integer)keyAndSize.getRight() > 0) {
                            MessageId old = latestForKey.put((String)keyAndSize.getLeft(), id);
                            replaceMessage = old != null;
                        } else {
                            deletedMessage = true;
                            latestForKey.remove(keyAndSize.getLeft());
                        }
                    }
                    if (replaceMessage || deletedMessage) {
                        this.mxBean.addCompactionRemovedEvent(reader.getTopic());
                    }
                }
                MessageId first = firstMessageId.orElse(deletedMessage ? null : id);
                MessageId messageId = to = deletedMessage ? (MessageId)toMessageId.orElse(null) : id;
                if (id.compareTo((Object)lastMessageId) == 0) {
                    loopPromise.complete(new PhaseOneResult(first == null ? id : first, to == null ? id : to, lastMessageId, latestForKey));
                } else {
                    this.phaseOneLoop(reader, Optional.ofNullable(first), Optional.ofNullable(to), lastMessageId, latestForKey, loopPromise);
                }
            }
            finally {
                m.close();
            }
        }, (Executor)this.scheduler)).exceptionally(ex -> {
            loopPromise.completeExceptionally((Throwable)ex);
            return null;
        });
    }

    private CompletableFuture<Long> phaseTwo(RawReader reader, MessageId from, MessageId to, MessageId lastReadId, Map<String, MessageId> latestForKey, BookKeeper bk) {
        Map metadata = LedgerMetadataUtils.buildMetadataForCompactedLedger((String)reader.getTopic(), (byte[])to.toByteArray());
        return this.createLedger(bk, metadata).thenCompose(ledger -> {
            log.info("Commencing phase two of compaction for {}, from {} to {}, compacting {} keys to ledger {}", new Object[]{reader.getTopic(), from, to, latestForKey.size(), ledger.getId()});
            return this.phaseTwoSeekThenLoop(reader, from, to, lastReadId, latestForKey, bk, (LedgerHandle)ledger);
        });
    }

    private CompletableFuture<Long> phaseTwoSeekThenLoop(RawReader reader, MessageId from, MessageId to, MessageId lastReadId, Map<String, MessageId> latestForKey, BookKeeper bk, LedgerHandle ledger) {
        CompletableFuture<Long> promise = new CompletableFuture<Long>();
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)reader.seekAsync(from).thenCompose(v -> {
            Semaphore outstanding = new Semaphore(500);
            CompletableFuture<Void> loopPromise = new CompletableFuture<Void>();
            this.phaseTwoLoop(reader, to, latestForKey, ledger, outstanding, loopPromise);
            return loopPromise;
        })).thenCompose(v -> this.closeLedger(ledger))).thenCompose(v -> reader.acknowledgeCumulativeAsync(lastReadId, (Map<String, Long>)ImmutableMap.of((Object)COMPACTED_TOPIC_LEDGER_PROPERTY, (Object)ledger.getId())))).whenComplete((res, exception) -> {
            if (exception != null) {
                this.deleteLedger(bk, ledger).whenComplete((res2, exception2) -> {
                    if (exception2 != null) {
                        log.warn("Cleanup of ledger {} for failed", (Object)ledger, exception2);
                    }
                    promise.completeExceptionally((Throwable)exception);
                });
            } else {
                promise.complete(ledger.getId());
            }
        });
        return promise;
    }

    private void phaseTwoLoop(RawReader reader, MessageId to, Map<String, MessageId> latestForKey, LedgerHandle lh, Semaphore outstanding, CompletableFuture<Void> promise) {
        if (promise.isDone()) {
            return;
        }
        ((CompletableFuture)reader.readNextAsync().thenAcceptAsync(arg_0 -> this.lambda$phaseTwoLoop$16(promise, reader, latestForKey, outstanding, lh, to, arg_0), (Executor)this.scheduler)).exceptionally(ex -> {
            promise.completeExceptionally((Throwable)ex);
            return null;
        });
    }

    private CompletableFuture<LedgerHandle> createLedger(BookKeeper bk, Map<String, byte[]> metadata) {
        CompletableFuture<LedgerHandle> bkf = new CompletableFuture<LedgerHandle>();
        try {
            bk.asyncCreateLedger(this.conf.getManagedLedgerDefaultEnsembleSize(), this.conf.getManagedLedgerDefaultWriteQuorum(), this.conf.getManagedLedgerDefaultAckQuorum(), Compactor.COMPACTED_TOPIC_LEDGER_DIGEST_TYPE, Compactor.COMPACTED_TOPIC_LEDGER_PASSWORD, (rc, ledger, ctx) -> {
                if (rc != 0) {
                    bkf.completeExceptionally(BKException.create((int)rc));
                } else {
                    bkf.complete(ledger);
                }
            }, null, metadata);
        }
        catch (Throwable t) {
            log.error("Encountered unexpected error when creating compaction ledger", t);
            return FutureUtil.failedFuture((Throwable)t);
        }
        return bkf;
    }

    private CompletableFuture<Void> deleteLedger(BookKeeper bk, LedgerHandle lh) {
        CompletableFuture<Void> bkf = new CompletableFuture<Void>();
        try {
            bk.asyncDeleteLedger(lh.getId(), (rc, ctx) -> {
                if (rc != 0) {
                    bkf.completeExceptionally(BKException.create((int)rc));
                } else {
                    bkf.complete(null);
                }
            }, null);
        }
        catch (Throwable t) {
            return FutureUtil.failedFuture((Throwable)t);
        }
        return bkf;
    }

    private CompletableFuture<Void> closeLedger(LedgerHandle lh) {
        CompletableFuture<Void> bkf = new CompletableFuture<Void>();
        try {
            lh.asyncClose((rc, ledger, ctx) -> {
                if (rc != 0) {
                    bkf.completeExceptionally(BKException.create((int)rc));
                } else {
                    bkf.complete(null);
                }
            }, null);
        }
        catch (Throwable t) {
            return FutureUtil.failedFuture((Throwable)t);
        }
        return bkf;
    }

    private CompletableFuture<Void> addToCompactedLedger(LedgerHandle lh, RawMessage m, String topic) {
        CompletableFuture<Void> bkf = new CompletableFuture<Void>();
        ByteBuf serialized = m.serialize();
        try {
            this.mxBean.addCompactionWriteOp(topic, m.getHeadersAndPayload().readableBytes());
            long start = System.nanoTime();
            lh.asyncAddEntry(serialized, (rc, ledger, eid, ctx) -> {
                this.mxBean.addCompactionLatencyOp(topic, System.nanoTime() - start, TimeUnit.NANOSECONDS);
                if (rc != 0) {
                    bkf.completeExceptionally(BKException.create((int)rc));
                } else {
                    bkf.complete(null);
                }
            }, null);
        }
        catch (Throwable t) {
            return FutureUtil.failedFuture((Throwable)t);
        }
        return bkf;
    }

    private static Pair<String, Integer> extractKeyAndSize(RawMessage m) {
        ByteBuf headersAndPayload = m.getHeadersAndPayload();
        MessageMetadata msgMetadata = Commands.parseMessageMetadata((ByteBuf)headersAndPayload);
        if (msgMetadata.hasPartitionKey()) {
            int size = headersAndPayload.readableBytes();
            if (msgMetadata.hasUncompressedSize()) {
                size = msgMetadata.getUncompressedSize();
            }
            return Pair.of((Object)msgMetadata.getPartitionKey(), (Object)size);
        }
        return null;
    }

    public long getPhaseOneLoopReadTimeoutInSeconds() {
        return this.phaseOneLoopReadTimeout.getSeconds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private /* synthetic */ void lambda$phaseTwoLoop$16(CompletableFuture promise, RawReader reader, Map latestForKey, Semaphore outstanding, LedgerHandle lh, MessageId to, RawMessage m) {
        if (promise.isDone()) {
            m.close();
            return;
        }
        try {
            id = m.getMessageId();
            messageToAdd /* !! */  = Optional.empty();
            this.mxBean.addCompactionReadOp(reader.getTopic(), m.getHeadersAndPayload().readableBytes());
            if (RawBatchConverter.isReadableBatch(m)) {
                try {
                    messageToAdd /* !! */  = RawBatchConverter.rebatchMessage(m, (BiPredicate<String, MessageId>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Z, lambda$phaseTwoLoop$13(java.util.Map java.lang.String org.apache.pulsar.client.api.MessageId ), (Ljava/lang/String;Lorg/apache/pulsar/client/api/MessageId;)Z)((Map)latestForKey));
                }
                catch (IOException ioe) {
                    TwoPhaseCompactor.log.info("Error decoding batch for message {}. Whole batch will be included in output", (Object)id, (Object)ioe);
                    messageToAdd /* !! */  = Optional.of(m);
                }
            } else {
                keyAndSize = TwoPhaseCompactor.extractKeyAndSize(m);
                if (keyAndSize == null) {
                    messageToAdd /* !! */  = Optional.of(m);
                } else {
                    msg = (MessageId)latestForKey.get(keyAndSize.getLeft());
                    if (msg != null && msg.equals(id)) {
                        if ((Integer)keyAndSize.getRight() <= 0) {
                            promise.completeExceptionally(new IllegalArgumentException("Compaction phase found empty record from sorted key-map"));
                        }
                        messageToAdd /* !! */  = Optional.of(m);
                    }
                }
            }
            if (messageToAdd /* !! */ .isPresent()) {
                message = (RawMessage)messageToAdd /* !! */ .get();
                try {
                    outstanding.acquire();
                    addFuture = this.addToCompactedLedger(lh, message, reader.getTopic()).whenComplete((BiConsumer)(BiConsumer<Void, Throwable>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$phaseTwoLoop$14(java.util.concurrent.Semaphore java.util.concurrent.CompletableFuture java.lang.Void java.lang.Throwable ), (Ljava/lang/Void;Ljava/lang/Throwable;)V)((Semaphore)outstanding, (CompletableFuture)promise));
                    if (!to.equals(id)) ** GOTO lbl55
                    addFuture.whenComplete((BiConsumer<Void, Throwable>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$phaseTwoLoop$15(java.util.concurrent.CompletableFuture java.lang.Void java.lang.Throwable ), (Ljava/lang/Void;Ljava/lang/Throwable;)V)((CompletableFuture)promise));
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    promise.completeExceptionally(ie);
                }
                finally {
                    if (message != m) {
                        message.close();
                    }
                }
            } else if (to.equals(id)) {
                try {
                    outstanding.acquire(500);
                    promise.complete(null);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    promise.completeExceptionally(e);
                }
                return;
            }
lbl55:
            // 5 sources

            this.phaseTwoLoop(reader, to, latestForKey, lh, outstanding, promise);
        }
        finally {
            m.close();
        }
    }

    private static /* synthetic */ void lambda$phaseTwoLoop$15(CompletableFuture promise, Void res, Throwable exception2) {
        if (exception2 == null) {
            promise.complete(null);
        }
    }

    private static /* synthetic */ void lambda$phaseTwoLoop$14(Semaphore outstanding, CompletableFuture promise, Void res, Throwable exception2) {
        outstanding.release();
        if (exception2 != null) {
            promise.completeExceptionally(exception2);
        }
    }

    private static /* synthetic */ boolean lambda$phaseTwoLoop$13(Map latestForKey, String key, MessageId subid) {
        return subid.equals(latestForKey.get(key));
    }

    private static class PhaseOneResult {
        final MessageId from;
        final MessageId to;
        final MessageId lastReadId;
        final Map<String, MessageId> latestForKey;

        PhaseOneResult(MessageId from, MessageId to, MessageId lastReadId, Map<String, MessageId> latestForKey) {
            this.from = from;
            this.to = to;
            this.lastReadId = lastReadId;
            this.latestForKey = latestForKey;
        }
    }
}

