/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.v3;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.InputStream;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.pulsar.broker.admin.impl.PackagesBase;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.packages.management.core.common.PackageMetadata;
import org.glassfish.jersey.media.multipart.FormDataParam;

@Path(value="/packages")
@Api(value="packages", tags={"packages"})
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class Packages
extends PackagesBase {
    @GET
    @Path(value="/{type}/{tenant}/{namespace}/{packageName}/{version}/metadata")
    @ApiOperation(value="Get the metadata of a package.", response=PackageMetadata.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Return the metadata of the specified package."), @ApiResponse(code=404, message="The specified package is not existent."), @ApiResponse(code=412, message="The package name is illegal."), @ApiResponse(code=500, message="Internal server error."), @ApiResponse(code=503, message="Package Management Service is not enabled in the broker.")})
    public void getMeta(@PathParam(value="type") String type, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="packageName") String packageName, @PathParam(value="version") String version, @Suspended AsyncResponse asyncResponse) {
        this.internalGetMetadata(type, tenant, namespace, packageName, version, asyncResponse);
    }

    @PUT
    @Path(value="/{type}/{tenant}/{namespace}/{packageName}/{version}/metadata")
    @ApiOperation(value="Update the metadata of a package.")
    @ApiResponses(value={@ApiResponse(code=200, message="Update the metadata of the specified package successfully."), @ApiResponse(code=404, message="The specified package is not existent."), @ApiResponse(code=412, message="The package name is illegal."), @ApiResponse(code=500, message="Internal server error."), @ApiResponse(code=503, message="Package Management Service is not enabled in the broker.")})
    @Consumes(value={"application/json"})
    public void updateMeta(@PathParam(value="type") String type, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="packageName") String packageName, @PathParam(value="version") String version, PackageMetadata metadata, @Suspended AsyncResponse asyncResponse) {
        if (metadata != null) {
            metadata.setModificationTime(System.currentTimeMillis());
            this.internalUpdateMetadata(type, tenant, namespace, packageName, version, metadata, asyncResponse);
        } else {
            asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.BAD_REQUEST, "Unknown error, metadata is null when processing update package metadata request")));
        }
    }

    @POST
    @Path(value="/{type}/{tenant}/{namespace}/{packageName}/{version}")
    @ApiOperation(value="Upload a package.")
    @ApiResponses(value={@ApiResponse(code=200, message="Upload the specified package successfully."), @ApiResponse(code=412, message="The package name is illegal."), @ApiResponse(code=500, message="Internal server error."), @ApiResponse(code=503, message="Package Management Service is not enabled in the broker.")})
    @Consumes(value={"multipart/form-data"})
    public void upload(@PathParam(value="type") String type, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="packageName") String packageName, @PathParam(value="version") String version, @FormDataParam(value="metadata") PackageMetadata packageMetadata, @FormDataParam(value="file") InputStream uploadedInputStream, @Suspended AsyncResponse asyncResponse) {
        if (packageMetadata != null) {
            packageMetadata.setCreateTime(System.currentTimeMillis());
            packageMetadata.setModificationTime(System.currentTimeMillis());
            this.internalUpload(type, tenant, namespace, packageName, version, packageMetadata, uploadedInputStream, asyncResponse);
        } else {
            asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.BAD_REQUEST, "Unknown error, metadata is null when processing update package metadata request")));
        }
    }

    @GET
    @Path(value="/{type}/{tenant}/{namespace}/{packageName}/{version}")
    @ApiOperation(value="Download a package with the package name.", response=StreamingOutput.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Download the specified package successfully."), @ApiResponse(code=404, message="The specified package is not existent."), @ApiResponse(code=412, message="The package name is illegal."), @ApiResponse(code=500, message="Internal server error."), @ApiResponse(code=503, message="Package Management Service is not enabled in the broker.")})
    public StreamingOutput download(@PathParam(value="type") String type, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="packageName") String packageName, @PathParam(value="version") String version) {
        return this.internalDownload(type, tenant, namespace, packageName, version);
    }

    @DELETE
    @Path(value="/{type}/{tenant}/{namespace}/{packageName}/{version}")
    @ApiResponses(value={@ApiResponse(code=200, message="Delete the specified package successfully."), @ApiResponse(code=404, message="The specified package is not existent."), @ApiResponse(code=412, message="The package name is illegal."), @ApiResponse(code=500, message="Internal server error."), @ApiResponse(code=503, message="Package Management Service is not enabled in the broker.")})
    @ApiOperation(value="Delete a package with the package name.")
    public void delete(@PathParam(value="type") String type, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="packageName") String packageName, @PathParam(value="version") String version, @Suspended AsyncResponse asyncResponse) {
        this.internalDelete(type, tenant, namespace, packageName, version, asyncResponse);
    }

    @GET
    @Path(value="/{type}/{tenant}/{namespace}/{packageName}")
    @ApiOperation(value="Get all the versions of a package.", response=String.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Return the package versions of the specified package."), @ApiResponse(code=404, message="The specified package is not existent."), @ApiResponse(code=412, message="The package name is illegal."), @ApiResponse(code=500, message="Internal server error."), @ApiResponse(code=503, message="Package Management Service is not enabled in the broker.")})
    public void listPackageVersion(@PathParam(value="type") String type, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="packageName") String packageName, @Suspended AsyncResponse asyncResponse) {
        this.internalListVersions(type, tenant, namespace, packageName, asyncResponse);
    }

    @GET
    @Path(value="/{type}/{tenant}/{namespace}")
    @ApiOperation(value="Get all the specified type packages in a namespace.", response=PackageMetadata.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Return all the specified type package names in the specified namespace."), @ApiResponse(code=412, message="The package type is illegal."), @ApiResponse(code=500, message="Internal server error."), @ApiResponse(code=503, message="Package Management Service is not enabled in the broker.")})
    public void listPackages(@PathParam(value="type") String type, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @Suspended AsyncResponse asyncResponse) {
        this.internalListPackages(type, tenant, namespace, asyncResponse);
    }
}

