/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.delayed.bucket;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.util.Futures;
import org.apache.pulsar.broker.delayed.bucket.BucketSnapshotPersistenceException;
import org.apache.pulsar.broker.delayed.bucket.BucketSnapshotStorage;
import org.apache.pulsar.broker.delayed.bucket.ImmutableBucket;
import org.apache.pulsar.broker.delayed.proto.DelayedMessageIndexBucketSnapshotFormat;
import org.apache.pulsar.common.util.Codec;
import org.apache.pulsar.common.util.FutureUtil;
import org.roaringbitmap.RoaringBitmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class Bucket {
    private static final Logger log = LoggerFactory.getLogger(Bucket.class);
    static final String DELIMITER = "_";
    static final int MaxRetryTimes = 3;
    protected final String dispatcherName;
    protected final ManagedCursor cursor;
    protected final FutureUtil.Sequencer<Void> sequencer;
    protected final BucketSnapshotStorage bucketSnapshotStorage;
    long startLedgerId;
    long endLedgerId;
    Map<Long, RoaringBitmap> delayedIndexBitMap;
    long numberBucketDelayedMessages;
    int lastSegmentEntryId;
    volatile int currentSegmentEntryId;
    volatile long snapshotLength;
    private volatile Long bucketId;
    private volatile CompletableFuture<Long> snapshotCreateFuture;

    Bucket(String dispatcherName, ManagedCursor cursor, FutureUtil.Sequencer<Void> sequencer, BucketSnapshotStorage storage, long startLedgerId, long endLedgerId) {
        this(dispatcherName, cursor, sequencer, storage, startLedgerId, endLedgerId, new HashMap<Long, RoaringBitmap>(), -1L, -1, 0, 0L, null, null);
    }

    boolean containsMessage(long ledgerId, long entryId) {
        RoaringBitmap bitSet = this.delayedIndexBitMap.get(ledgerId);
        if (bitSet == null) {
            return false;
        }
        return bitSet.contains(entryId, entryId + 1L);
    }

    void putIndexBit(long ledgerId, long entryId) {
        this.delayedIndexBitMap.computeIfAbsent(ledgerId, k -> new RoaringBitmap()).add(entryId, entryId + 1L);
    }

    boolean removeIndexBit(long ledgerId, long entryId) {
        boolean contained = false;
        RoaringBitmap bitSet = this.delayedIndexBitMap.get(ledgerId);
        if (bitSet != null && bitSet.contains(entryId, entryId + 1L)) {
            contained = true;
            bitSet.remove(entryId, entryId + 1L);
            if (bitSet.isEmpty()) {
                this.delayedIndexBitMap.remove(ledgerId);
            }
            if (this.numberBucketDelayedMessages > 0L) {
                --this.numberBucketDelayedMessages;
            }
        }
        return contained;
    }

    String bucketKey() {
        return String.join((CharSequence)DELIMITER, "#pulsar.internal.delayed.bucket", String.valueOf(this.startLedgerId), String.valueOf(this.endLedgerId));
    }

    Optional<CompletableFuture<Long>> getSnapshotCreateFuture() {
        return Optional.ofNullable(this.snapshotCreateFuture);
    }

    Optional<Long> getBucketId() {
        return Optional.ofNullable(this.bucketId);
    }

    long getAndUpdateBucketId() {
        Optional<Long> bucketIdOptional = this.getBucketId();
        if (bucketIdOptional.isPresent()) {
            return bucketIdOptional.get();
        }
        String bucketIdStr = (String)this.cursor.getCursorProperties().get(this.bucketKey());
        long bucketId = Long.parseLong(bucketIdStr);
        this.setBucketId(bucketId);
        return bucketId;
    }

    CompletableFuture<Long> asyncSaveBucketSnapshot(ImmutableBucket bucket, DelayedMessageIndexBucketSnapshotFormat.SnapshotMetadata snapshotMetadata, List<DelayedMessageIndexBucketSnapshotFormat.SnapshotSegment> bucketSnapshotSegments) {
        String bucketKey = bucket.bucketKey();
        String cursorName = Codec.decode((String)this.cursor.getName());
        String topicName = this.dispatcherName.substring(0, this.dispatcherName.lastIndexOf(" / " + cursorName));
        return Futures.executeWithRetry(() -> this.bucketSnapshotStorage.createBucketSnapshot(snapshotMetadata, bucketSnapshotSegments, bucketKey, topicName, cursorName).whenComplete((__, ex) -> {
            if (ex != null) {
                log.warn("[{}] Failed to create bucket snapshot, bucketKey: {}", new Object[]{this.dispatcherName, bucketKey, ex});
            }
        }), BucketSnapshotPersistenceException.class, (int)3).thenCompose(newBucketId -> {
            bucket.setBucketId((Long)newBucketId);
            return ((CompletableFuture)this.putBucketKeyId(bucketKey, (Long)newBucketId).exceptionally(ex -> {
                log.warn("[{}] Failed to record bucketId to cursor property, bucketKey: {}, bucketId: {}", new Object[]{this.dispatcherName, bucketKey, newBucketId, ex});
                return null;
            })).thenApply(__ -> newBucketId);
        });
    }

    private CompletableFuture<Void> putBucketKeyId(String bucketKey, Long bucketId) {
        Objects.requireNonNull(bucketId);
        return this.sequencer.sequential(() -> Futures.executeWithRetry(() -> this.cursor.putCursorProperty(bucketKey, String.valueOf(bucketId)), ManagedLedgerException.BadVersionException.class, (int)3));
    }

    protected CompletableFuture<Void> removeBucketCursorProperty(String bucketKey) {
        return this.sequencer.sequential(() -> Futures.executeWithRetry(() -> this.cursor.removeCursorProperty(bucketKey), ManagedLedgerException.BadVersionException.class, (int)3));
    }

    public String getDispatcherName() {
        return this.dispatcherName;
    }

    public ManagedCursor getCursor() {
        return this.cursor;
    }

    public FutureUtil.Sequencer<Void> getSequencer() {
        return this.sequencer;
    }

    public BucketSnapshotStorage getBucketSnapshotStorage() {
        return this.bucketSnapshotStorage;
    }

    public long getStartLedgerId() {
        return this.startLedgerId;
    }

    public long getEndLedgerId() {
        return this.endLedgerId;
    }

    public Map<Long, RoaringBitmap> getDelayedIndexBitMap() {
        return this.delayedIndexBitMap;
    }

    public long getNumberBucketDelayedMessages() {
        return this.numberBucketDelayedMessages;
    }

    public int getLastSegmentEntryId() {
        return this.lastSegmentEntryId;
    }

    public int getCurrentSegmentEntryId() {
        return this.currentSegmentEntryId;
    }

    public long getSnapshotLength() {
        return this.snapshotLength;
    }

    public void setStartLedgerId(long startLedgerId) {
        this.startLedgerId = startLedgerId;
    }

    public void setEndLedgerId(long endLedgerId) {
        this.endLedgerId = endLedgerId;
    }

    public void setDelayedIndexBitMap(Map<Long, RoaringBitmap> delayedIndexBitMap) {
        this.delayedIndexBitMap = delayedIndexBitMap;
    }

    public void setNumberBucketDelayedMessages(long numberBucketDelayedMessages) {
        this.numberBucketDelayedMessages = numberBucketDelayedMessages;
    }

    public void setLastSegmentEntryId(int lastSegmentEntryId) {
        this.lastSegmentEntryId = lastSegmentEntryId;
    }

    public void setCurrentSegmentEntryId(int currentSegmentEntryId) {
        this.currentSegmentEntryId = currentSegmentEntryId;
    }

    public void setSnapshotLength(long snapshotLength) {
        this.snapshotLength = snapshotLength;
    }

    public void setBucketId(Long bucketId) {
        this.bucketId = bucketId;
    }

    public void setSnapshotCreateFuture(CompletableFuture<Long> snapshotCreateFuture) {
        this.snapshotCreateFuture = snapshotCreateFuture;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Bucket)) {
            return false;
        }
        Bucket other = (Bucket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStartLedgerId() != other.getStartLedgerId()) {
            return false;
        }
        if (this.getEndLedgerId() != other.getEndLedgerId()) {
            return false;
        }
        if (this.getNumberBucketDelayedMessages() != other.getNumberBucketDelayedMessages()) {
            return false;
        }
        if (this.getLastSegmentEntryId() != other.getLastSegmentEntryId()) {
            return false;
        }
        if (this.getCurrentSegmentEntryId() != other.getCurrentSegmentEntryId()) {
            return false;
        }
        if (this.getSnapshotLength() != other.getSnapshotLength()) {
            return false;
        }
        Optional<Long> this$bucketId = this.getBucketId();
        Optional<Long> other$bucketId = other.getBucketId();
        if (this$bucketId == null ? other$bucketId != null : !((Object)this$bucketId).equals(other$bucketId)) {
            return false;
        }
        String this$dispatcherName = this.getDispatcherName();
        String other$dispatcherName = other.getDispatcherName();
        if (this$dispatcherName == null ? other$dispatcherName != null : !this$dispatcherName.equals(other$dispatcherName)) {
            return false;
        }
        ManagedCursor this$cursor = this.getCursor();
        ManagedCursor other$cursor = other.getCursor();
        if (this$cursor == null ? other$cursor != null : !this$cursor.equals(other$cursor)) {
            return false;
        }
        FutureUtil.Sequencer<Void> this$sequencer = this.getSequencer();
        FutureUtil.Sequencer<Void> other$sequencer = other.getSequencer();
        if (this$sequencer == null ? other$sequencer != null : !this$sequencer.equals(other$sequencer)) {
            return false;
        }
        BucketSnapshotStorage this$bucketSnapshotStorage = this.getBucketSnapshotStorage();
        BucketSnapshotStorage other$bucketSnapshotStorage = other.getBucketSnapshotStorage();
        if (this$bucketSnapshotStorage == null ? other$bucketSnapshotStorage != null : !this$bucketSnapshotStorage.equals(other$bucketSnapshotStorage)) {
            return false;
        }
        Map<Long, RoaringBitmap> this$delayedIndexBitMap = this.getDelayedIndexBitMap();
        Map<Long, RoaringBitmap> other$delayedIndexBitMap = other.getDelayedIndexBitMap();
        if (this$delayedIndexBitMap == null ? other$delayedIndexBitMap != null : !((Object)this$delayedIndexBitMap).equals(other$delayedIndexBitMap)) {
            return false;
        }
        Optional<CompletableFuture<Long>> this$snapshotCreateFuture = this.getSnapshotCreateFuture();
        Optional<CompletableFuture<Long>> other$snapshotCreateFuture = other.getSnapshotCreateFuture();
        return !(this$snapshotCreateFuture == null ? other$snapshotCreateFuture != null : !((Object)this$snapshotCreateFuture).equals(other$snapshotCreateFuture));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Bucket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $startLedgerId = this.getStartLedgerId();
        result = result * 59 + (int)($startLedgerId >>> 32 ^ $startLedgerId);
        long $endLedgerId = this.getEndLedgerId();
        result = result * 59 + (int)($endLedgerId >>> 32 ^ $endLedgerId);
        long $numberBucketDelayedMessages = this.getNumberBucketDelayedMessages();
        result = result * 59 + (int)($numberBucketDelayedMessages >>> 32 ^ $numberBucketDelayedMessages);
        result = result * 59 + this.getLastSegmentEntryId();
        result = result * 59 + this.getCurrentSegmentEntryId();
        long $snapshotLength = this.getSnapshotLength();
        result = result * 59 + (int)($snapshotLength >>> 32 ^ $snapshotLength);
        Optional<Long> $bucketId = this.getBucketId();
        result = result * 59 + ($bucketId == null ? 43 : ((Object)$bucketId).hashCode());
        String $dispatcherName = this.getDispatcherName();
        result = result * 59 + ($dispatcherName == null ? 43 : $dispatcherName.hashCode());
        ManagedCursor $cursor = this.getCursor();
        result = result * 59 + ($cursor == null ? 43 : $cursor.hashCode());
        FutureUtil.Sequencer<Void> $sequencer = this.getSequencer();
        result = result * 59 + ($sequencer == null ? 43 : $sequencer.hashCode());
        BucketSnapshotStorage $bucketSnapshotStorage = this.getBucketSnapshotStorage();
        result = result * 59 + ($bucketSnapshotStorage == null ? 43 : $bucketSnapshotStorage.hashCode());
        Map<Long, RoaringBitmap> $delayedIndexBitMap = this.getDelayedIndexBitMap();
        result = result * 59 + ($delayedIndexBitMap == null ? 43 : ((Object)$delayedIndexBitMap).hashCode());
        Optional<CompletableFuture<Long>> $snapshotCreateFuture = this.getSnapshotCreateFuture();
        result = result * 59 + ($snapshotCreateFuture == null ? 43 : ((Object)$snapshotCreateFuture).hashCode());
        return result;
    }

    public String toString() {
        return "Bucket(dispatcherName=" + this.getDispatcherName() + ", cursor=" + this.getCursor() + ", sequencer=" + this.getSequencer() + ", bucketSnapshotStorage=" + this.getBucketSnapshotStorage() + ", startLedgerId=" + this.getStartLedgerId() + ", endLedgerId=" + this.getEndLedgerId() + ", delayedIndexBitMap=" + this.getDelayedIndexBitMap() + ", numberBucketDelayedMessages=" + this.getNumberBucketDelayedMessages() + ", lastSegmentEntryId=" + this.getLastSegmentEntryId() + ", currentSegmentEntryId=" + this.getCurrentSegmentEntryId() + ", snapshotLength=" + this.getSnapshotLength() + ", bucketId=" + this.getBucketId() + ", snapshotCreateFuture=" + this.getSnapshotCreateFuture() + ")";
    }

    public Bucket(String dispatcherName, ManagedCursor cursor, FutureUtil.Sequencer<Void> sequencer, BucketSnapshotStorage bucketSnapshotStorage, long startLedgerId, long endLedgerId, Map<Long, RoaringBitmap> delayedIndexBitMap, long numberBucketDelayedMessages, int lastSegmentEntryId, int currentSegmentEntryId, long snapshotLength, Long bucketId, CompletableFuture<Long> snapshotCreateFuture) {
        this.dispatcherName = dispatcherName;
        this.cursor = cursor;
        this.sequencer = sequencer;
        this.bucketSnapshotStorage = bucketSnapshotStorage;
        this.startLedgerId = startLedgerId;
        this.endLedgerId = endLedgerId;
        this.delayedIndexBitMap = delayedIndexBitMap;
        this.numberBucketDelayedMessages = numberBucketDelayedMessages;
        this.lastSegmentEntryId = lastSegmentEntryId;
        this.currentSegmentEntryId = currentSegmentEntryId;
        this.snapshotLength = snapshotLength;
        this.bucketId = bucketId;
        this.snapshotCreateFuture = snapshotCreateFuture;
    }
}

