/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.delayed.bucket;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.PriorityQueue;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.pulsar.broker.delayed.bucket.DelayedIndexQueue;
import org.apache.pulsar.broker.delayed.proto.DelayedMessageIndexBucketSnapshotFormat;

@NotThreadSafe
class CombinedSegmentDelayedIndexQueue
implements DelayedIndexQueue {
    private static final Comparator<Node> COMPARATOR_NODE = (node1, node2) -> DelayedIndexQueue.COMPARATOR.compare(node1.segmentList.get(node1.segmentListCursor).getIndexes(node1.segmentCursor), node2.segmentList.get(node2.segmentListCursor).getIndexes(node2.segmentCursor));
    private final PriorityQueue<Node> kpq;

    private CombinedSegmentDelayedIndexQueue(List<List<DelayedMessageIndexBucketSnapshotFormat.SnapshotSegment>> segmentLists) {
        this.kpq = new PriorityQueue<Node>(segmentLists.size(), COMPARATOR_NODE);
        for (List<DelayedMessageIndexBucketSnapshotFormat.SnapshotSegment> segmentList : segmentLists) {
            Node node = new Node(segmentList, 0, 0);
            this.kpq.offer(node);
        }
    }

    public static CombinedSegmentDelayedIndexQueue wrap(List<List<DelayedMessageIndexBucketSnapshotFormat.SnapshotSegment>> segmentLists) {
        return new CombinedSegmentDelayedIndexQueue(segmentLists);
    }

    @Override
    public boolean isEmpty() {
        return this.kpq.isEmpty();
    }

    @Override
    public DelayedMessageIndexBucketSnapshotFormat.DelayedIndex peek() {
        return this.getValue(false);
    }

    @Override
    public DelayedMessageIndexBucketSnapshotFormat.DelayedIndex pop() {
        return this.getValue(true);
    }

    private DelayedMessageIndexBucketSnapshotFormat.DelayedIndex getValue(boolean needAdvanceCursor) {
        Node node = this.kpq.peek();
        Objects.requireNonNull(node);
        DelayedMessageIndexBucketSnapshotFormat.SnapshotSegment snapshotSegment = node.segmentList.get(node.segmentListCursor);
        DelayedMessageIndexBucketSnapshotFormat.DelayedIndex delayedIndex = snapshotSegment.getIndexes(node.segmentCursor);
        if (!needAdvanceCursor) {
            return delayedIndex;
        }
        this.kpq.poll();
        if (node.segmentCursor + 1 < snapshotSegment.getIndexesCount()) {
            ++node.segmentCursor;
            this.kpq.offer(node);
        } else {
            node.segmentList.set(node.segmentListCursor, null);
            while (node.segmentListCursor + 1 < node.segmentList.size()) {
                ++node.segmentListCursor;
                node.segmentCursor = 0;
                if (node.segmentList.get(node.segmentListCursor).getIndexesCount() <= 0) continue;
                this.kpq.offer(node);
                break;
            }
        }
        return delayedIndex;
    }

    static class Node {
        List<DelayedMessageIndexBucketSnapshotFormat.SnapshotSegment> segmentList;
        int segmentListCursor;
        int segmentCursor;

        public Node(List<DelayedMessageIndexBucketSnapshotFormat.SnapshotSegment> segmentList, int segmentListCursor, int segmentCursor) {
            this.segmentList = segmentList;
            this.segmentListCursor = segmentListCursor;
            this.segmentCursor = segmentCursor;
        }
    }
}

