/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.delayed.bucket;

import javax.annotation.concurrent.NotThreadSafe;
import org.apache.pulsar.broker.delayed.bucket.DelayedIndexQueue;
import org.apache.pulsar.broker.delayed.proto.DelayedMessageIndexBucketSnapshotFormat;
import org.apache.pulsar.common.util.collections.TripleLongPriorityQueue;

@NotThreadSafe
class TripleLongPriorityDelayedIndexQueue
implements DelayedIndexQueue {
    private final TripleLongPriorityQueue queue;

    private TripleLongPriorityDelayedIndexQueue(TripleLongPriorityQueue queue) {
        this.queue = queue;
    }

    public static TripleLongPriorityDelayedIndexQueue wrap(TripleLongPriorityQueue queue) {
        return new TripleLongPriorityDelayedIndexQueue(queue);
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public DelayedMessageIndexBucketSnapshotFormat.DelayedIndex peek() {
        DelayedMessageIndexBucketSnapshotFormat.DelayedIndex delayedIndex = DelayedMessageIndexBucketSnapshotFormat.DelayedIndex.newBuilder().setTimestamp(this.queue.peekN1()).setLedgerId(this.queue.peekN2()).setEntryId(this.queue.peekN3()).build();
        return delayedIndex;
    }

    @Override
    public DelayedMessageIndexBucketSnapshotFormat.DelayedIndex pop() {
        DelayedMessageIndexBucketSnapshotFormat.DelayedIndex peek = this.peek();
        this.queue.pop();
        return peek;
    }
}

