/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.extensions.filter;

import java.util.Map;
import java.util.Set;
import org.apache.pulsar.broker.loadbalance.BrokerFilterException;
import org.apache.pulsar.broker.loadbalance.extensions.LoadManagerContext;
import org.apache.pulsar.broker.loadbalance.extensions.data.BrokerLookupData;
import org.apache.pulsar.broker.loadbalance.extensions.filter.BrokerFilter;
import org.apache.pulsar.broker.loadbalance.extensions.policies.IsolationPoliciesHelper;
import org.apache.pulsar.common.naming.ServiceUnitId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerIsolationPoliciesFilter
implements BrokerFilter {
    private static final Logger log = LoggerFactory.getLogger(BrokerIsolationPoliciesFilter.class);
    public static final String FILTER_NAME = "broker_isolation_policies_filter";
    private IsolationPoliciesHelper isolationPoliciesHelper;

    public BrokerIsolationPoliciesFilter(IsolationPoliciesHelper helper) {
        this.isolationPoliciesHelper = helper;
    }

    @Override
    public String name() {
        return FILTER_NAME;
    }

    @Override
    public Map<String, BrokerLookupData> filter(Map<String, BrokerLookupData> availableBrokers, ServiceUnitId serviceUnit, LoadManagerContext context) throws BrokerFilterException {
        Set<String> brokerCandidateCache = this.isolationPoliciesHelper.applyIsolationPolicies(availableBrokers, serviceUnit);
        availableBrokers.keySet().retainAll(brokerCandidateCache);
        return availableBrokers;
    }
}

