/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.extensions.policies;

import io.netty.util.concurrent.FastThreadLocal;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.pulsar.broker.loadbalance.extensions.data.BrokerLookupData;
import org.apache.pulsar.broker.loadbalance.impl.LoadManagerShared;
import org.apache.pulsar.broker.loadbalance.impl.SimpleResourceAllocationPolicies;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.ServiceUnitId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsolationPoliciesHelper {
    private static final Logger log = LoggerFactory.getLogger(IsolationPoliciesHelper.class);
    private final SimpleResourceAllocationPolicies policies;
    private static final FastThreadLocal<Set<String>> localBrokerCandidateCache = new FastThreadLocal<Set<String>>(){

        protected Set<String> initialValue() {
            return new HashSet<String>();
        }
    };

    public IsolationPoliciesHelper(SimpleResourceAllocationPolicies policies) {
        this.policies = policies;
    }

    public Set<String> applyIsolationPolicies(final Map<String, BrokerLookupData> availableBrokers, ServiceUnitId serviceUnit) {
        Set brokerCandidateCache = (Set)localBrokerCandidateCache.get();
        brokerCandidateCache.clear();
        LoadManagerShared.applyNamespacePolicies(serviceUnit, this.policies, brokerCandidateCache, availableBrokers.keySet(), new LoadManagerShared.BrokerTopicLoadingPredicate(){

            @Override
            public boolean isEnablePersistentTopics(String brokerUrl) {
                BrokerLookupData lookupData = (BrokerLookupData)availableBrokers.get(brokerUrl.replace("http://", ""));
                return lookupData != null && lookupData.persistentTopicsEnabled();
            }

            @Override
            public boolean isEnableNonPersistentTopics(String brokerUrl) {
                BrokerLookupData lookupData = (BrokerLookupData)availableBrokers.get(brokerUrl.replace("http://", ""));
                return lookupData != null && lookupData.nonPersistentTopicsEnabled();
            }
        });
        return brokerCandidateCache;
    }

    public boolean hasIsolationPolicy(NamespaceName namespaceName) {
        return this.policies.areIsolationPoliciesPresent(namespaceName);
    }
}

