/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.util.Collections;
import java.util.List;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.pulsar.broker.service.BrokerService;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.Subscription;
import org.apache.pulsar.broker.service.plugin.EntryFilter;
import org.apache.pulsar.broker.service.plugin.FilterContext;
import org.apache.pulsar.common.api.proto.MessageMetadata;

public class EntryFilterSupport {
    protected final List<EntryFilter> entryFilters;
    protected final boolean hasFilter;
    protected final FilterContext filterContext;
    protected final Subscription subscription;

    public EntryFilterSupport(Subscription subscription) {
        this.subscription = subscription;
        if (subscription != null && subscription.getTopic() != null) {
            List<EntryFilter> topicEntryFilters;
            BrokerService brokerService = subscription.getTopic().getBrokerService();
            boolean allowOverrideEntryFilters = brokerService.pulsar().getConfiguration().isAllowOverrideEntryFilters();
            this.entryFilters = !allowOverrideEntryFilters ? brokerService.getEntryFilterProvider().getBrokerEntryFilters() : ((topicEntryFilters = subscription.getTopic().getEntryFilters()) != null && !topicEntryFilters.isEmpty() ? topicEntryFilters : brokerService.getEntryFilterProvider().getBrokerEntryFilters());
            this.filterContext = new FilterContext();
        } else {
            this.entryFilters = Collections.emptyList();
            this.filterContext = FilterContext.FILTER_CONTEXT_DISABLED;
        }
        this.hasFilter = CollectionUtils.isNotEmpty(this.entryFilters);
    }

    public EntryFilter.FilterResult runFiltersForEntry(Entry entry, MessageMetadata msgMetadata, Consumer consumer) {
        if (this.hasFilter) {
            this.fillContext(this.filterContext, msgMetadata, this.subscription, consumer);
            return EntryFilterSupport.getFilterResult(this.filterContext, entry, this.entryFilters);
        }
        return EntryFilter.FilterResult.ACCEPT;
    }

    private void fillContext(FilterContext context, MessageMetadata msgMetadata, Subscription subscription, Consumer consumer) {
        context.reset();
        context.setMsgMetadata(msgMetadata);
        context.setSubscription(subscription);
        context.setConsumer(consumer);
    }

    private static EntryFilter.FilterResult getFilterResult(FilterContext filterContext, Entry entry, List<EntryFilter> entryFilters) {
        for (EntryFilter entryFilter : entryFilters) {
            EntryFilter.FilterResult filterResult = entryFilter.filterEntry(entry, filterContext);
            if (filterResult == null) {
                filterResult = EntryFilter.FilterResult.ACCEPT;
            }
            if (filterResult == EntryFilter.FilterResult.ACCEPT) continue;
            return filterResult;
        }
        return EntryFilter.FilterResult.ACCEPT;
    }
}

