/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.delayed;

import io.netty.util.HashedWheelTimer;
import io.netty.util.Timer;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.delayed.DelayedDeliveryTracker;
import org.apache.pulsar.broker.delayed.DelayedDeliveryTrackerFactory;
import org.apache.pulsar.broker.delayed.bucket.BookkeeperBucketSnapshotStorage;
import org.apache.pulsar.broker.delayed.bucket.BucketDelayedDeliveryTracker;
import org.apache.pulsar.broker.delayed.bucket.BucketSnapshotStorage;
import org.apache.pulsar.broker.service.persistent.PersistentDispatcherMultipleConsumers;
import org.apache.pulsar.common.util.FutureUtil;

public class BucketDelayedDeliveryTrackerFactory
implements DelayedDeliveryTrackerFactory {
    BucketSnapshotStorage bucketSnapshotStorage;
    private Timer timer;
    private long tickTimeMillis;
    private boolean isDelayedDeliveryDeliverAtTimeStrict;
    private int delayedDeliveryMaxNumBuckets;
    private long delayedDeliveryMinIndexCountPerBucket;
    private int delayedDeliveryMaxTimeStepPerBucketSnapshotSegmentSeconds;
    private int delayedDeliveryMaxIndexesPerBucketSnapshotSegment;

    @Override
    public void initialize(PulsarService pulsarService) throws Exception {
        ServiceConfiguration config = pulsarService.getConfig();
        this.bucketSnapshotStorage = new BookkeeperBucketSnapshotStorage(pulsarService);
        this.bucketSnapshotStorage.start();
        this.timer = new HashedWheelTimer((ThreadFactory)new DefaultThreadFactory("pulsar-delayed-delivery"), config.getDelayedDeliveryTickTimeMillis(), TimeUnit.MILLISECONDS);
        this.tickTimeMillis = config.getDelayedDeliveryTickTimeMillis();
        this.isDelayedDeliveryDeliverAtTimeStrict = config.isDelayedDeliveryDeliverAtTimeStrict();
        this.delayedDeliveryMinIndexCountPerBucket = config.getDelayedDeliveryMinIndexCountPerBucket();
        this.delayedDeliveryMaxNumBuckets = config.getDelayedDeliveryMaxNumBuckets();
        this.delayedDeliveryMaxTimeStepPerBucketSnapshotSegmentSeconds = config.getDelayedDeliveryMaxTimeStepPerBucketSnapshotSegmentSeconds();
        this.delayedDeliveryMaxIndexesPerBucketSnapshotSegment = config.getDelayedDeliveryMaxIndexesPerBucketSnapshotSegment();
    }

    @Override
    public DelayedDeliveryTracker newTracker(PersistentDispatcherMultipleConsumers dispatcher) {
        return new BucketDelayedDeliveryTracker(dispatcher, this.timer, this.tickTimeMillis, this.isDelayedDeliveryDeliverAtTimeStrict, this.bucketSnapshotStorage, this.delayedDeliveryMinIndexCountPerBucket, TimeUnit.SECONDS.toMillis(this.delayedDeliveryMaxTimeStepPerBucketSnapshotSegmentSeconds), this.delayedDeliveryMaxIndexesPerBucketSnapshotSegment, this.delayedDeliveryMaxNumBuckets);
    }

    public CompletableFuture<Void> cleanResidualSnapshots(ManagedCursor cursor) {
        Map cursorProperties = cursor.getCursorProperties();
        ArrayList futures = new ArrayList();
        FutureUtil.Sequencer sequencer = FutureUtil.Sequencer.create();
        cursorProperties.forEach((k, v) -> {
            if (k != null && v != null && k.startsWith("#pulsar.internal.delayed.bucket")) {
                CompletableFuture future = sequencer.sequential(() -> cursor.removeCursorProperty(k).thenCompose(__ -> this.bucketSnapshotStorage.deleteBucketSnapshot(Long.parseLong(v))));
                futures.add(future);
            }
        });
        return FutureUtil.waitForAll(futures);
    }

    @Override
    public void close() throws Exception {
        if (this.bucketSnapshotStorage != null) {
            this.bucketSnapshotStorage.close();
        }
    }
}

