/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.impl;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.web.PulsarWebResource;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.common.naming.NamedEntity;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.apache.pulsar.common.util.FutureUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantsBase
extends PulsarWebResource {
    private static final Logger log = LoggerFactory.getLogger(TenantsBase.class);

    @GET
    @ApiOperation(value="Get the list of existing tenants.", response=String.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=404, message="Tenant doesn't exist")})
    public void getTenants(@Suspended AsyncResponse asyncResponse) {
        String clientAppId = this.clientAppId();
        ((CompletableFuture)((CompletableFuture)this.validateSuperUserAccessAsync().thenCompose(__ -> this.tenantResources().listTenantsAsync())).thenAccept(tenants -> {
            ArrayList deepCopy = new ArrayList(tenants);
            deepCopy.sort(null);
            asyncResponse.resume(deepCopy);
        })).exceptionally(ex -> {
            log.error("[{}] Failed to get tenants list", (Object)clientAppId, ex);
            TenantsBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @GET
    @Path(value="/{tenant}")
    @ApiOperation(value="Get the admin configuration for a given tenant.", response=TenantInfo.class)
    @ApiResponses(value={@ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=404, message="Tenant does not exist")})
    public void getTenantAdmin(@Suspended AsyncResponse asyncResponse, @ApiParam(value="The tenant name") @PathParam(value="tenant") String tenant) {
        String clientAppId = this.clientAppId();
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateSuperUserAccessAsync().thenCompose(__ -> this.tenantResources().getTenantAsync(tenant))).thenApply(tenantInfo -> {
            if (!tenantInfo.isPresent()) {
                throw new RestException(Response.Status.NOT_FOUND, "Tenant does not exist");
            }
            return (TenantInfo)tenantInfo.get();
        })).thenAccept(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0))).exceptionally(ex -> {
            log.error("[{}] Failed to get tenant admin {}", (Object)clientAppId, ex);
            TenantsBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @PUT
    @Path(value="/{tenant}")
    @ApiOperation(value="Create a new tenant.", notes="This operation requires Pulsar super-user privileges.")
    @ApiResponses(value={@ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=409, message="Tenant already exists"), @ApiResponse(code=412, message="Tenant name is not valid"), @ApiResponse(code=412, message="Clusters can not be empty"), @ApiResponse(code=412, message="Clusters do not exist")})
    public void createTenant(@Suspended AsyncResponse asyncResponse, @ApiParam(value="The tenant name") @PathParam(value="tenant") String tenant, @ApiParam(value="TenantInfo") TenantInfoImpl tenantInfo) {
        String clientAppId = this.clientAppId();
        try {
            NamedEntity.checkName((String)tenant);
        }
        catch (IllegalArgumentException e) {
            log.warn("[{}] Failed to create tenant with invalid name {}", new Object[]{clientAppId, tenant, e});
            asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.PRECONDITION_FAILED, "Tenant name is not valid")));
            return;
        }
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateSuperUserAccessAsync().thenCompose(__ -> this.validatePoliciesReadOnlyAccessAsync())).thenCompose(__ -> this.validateClustersAsync((TenantInfo)tenantInfo))).thenCompose(__ -> this.tenantResources().tenantExistsAsync(tenant))).thenAccept(exist -> {
            if (exist.booleanValue()) {
                throw new RestException(Response.Status.CONFLICT, "Tenant already exist");
            }
        })).thenCompose(__ -> this.tenantResources().listTenantsAsync())).thenAccept(tenants -> {
            int maxTenants = this.pulsar().getConfiguration().getMaxTenants();
            if (maxTenants > 0 && tenants != null && tenants.size() >= maxTenants) {
                throw new RestException(Response.Status.PRECONDITION_FAILED, "Exceed the maximum number of tenants");
            }
        })).thenCompose(__ -> this.tenantResources().createTenantAsync(tenant, (TenantInfo)tenantInfo))).thenAccept(__ -> {
            log.info("[{}] Created tenant {}", (Object)clientAppId, (Object)tenant);
            asyncResponse.resume((Object)Response.noContent().build());
        })).exceptionally(ex -> {
            log.error("[{}] Failed to create tenant {}", new Object[]{clientAppId, tenant, ex});
            TenantsBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @POST
    @Path(value="/{tenant}")
    @ApiOperation(value="Update the admins for a tenant.", notes="This operation requires Pulsar super-user privileges.")
    @ApiResponses(value={@ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=404, message="Tenant does not exist"), @ApiResponse(code=409, message="Tenant already exists"), @ApiResponse(code=412, message="Clusters can not be empty"), @ApiResponse(code=412, message="Clusters do not exist")})
    public void updateTenant(@Suspended AsyncResponse asyncResponse, @ApiParam(value="The tenant name") @PathParam(value="tenant") String tenant, @ApiParam(value="TenantInfo") TenantInfoImpl newTenantAdmin) {
        String clientAppId = this.clientAppId();
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateSuperUserAccessAsync().thenCompose(__ -> this.validatePoliciesReadOnlyAccessAsync())).thenCompose(__ -> this.validateClustersAsync((TenantInfo)newTenantAdmin))).thenCompose(__ -> this.tenantResources().getTenantAsync(tenant))).thenCompose(tenantAdmin -> {
            if (!tenantAdmin.isPresent()) {
                throw new RestException(Response.Status.NOT_FOUND, "Tenant " + tenant + " not found");
            }
            TenantInfo oldTenantAdmin = (TenantInfo)tenantAdmin.get();
            HashSet<String> newClusters = new HashSet<String>(newTenantAdmin.getAllowedClusters());
            return this.canUpdateCluster(tenant, oldTenantAdmin.getAllowedClusters(), newClusters);
        })).thenCompose(__ -> this.tenantResources().updateTenantAsync(tenant, old -> newTenantAdmin))).thenAccept(__ -> {
            log.info("[{}] Successfully updated tenant info {}", (Object)clientAppId, (Object)tenant);
            asyncResponse.resume((Object)Response.noContent().build());
        })).exceptionally(ex -> {
            log.warn("[{}] Failed to update tenant {}", new Object[]{clientAppId, tenant, ex});
            TenantsBase.resumeAsyncResponseExceptionally(asyncResponse, ex);
            return null;
        });
    }

    @DELETE
    @Path(value="/{tenant}")
    @ApiOperation(value="Delete a tenant and all namespaces and topics under it.")
    @ApiResponses(value={@ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=404, message="Tenant does not exist"), @ApiResponse(code=405, message="Broker doesn't allow forced deletion of tenants"), @ApiResponse(code=409, message="The tenant still has active namespaces")})
    public void deleteTenant(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") @ApiParam(value="The tenant name") String tenant, @QueryParam(value="force") @DefaultValue(value="false") boolean force) {
        String clientAppId = this.clientAppId();
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.validateSuperUserAccessAsync().thenCompose(__ -> this.validatePoliciesReadOnlyAccessAsync())).thenCompose(__ -> this.internalDeleteTenant(tenant, force))).thenAccept(__ -> {
            log.info("[{}] Deleted tenant {}", (Object)clientAppId, (Object)tenant);
            asyncResponse.resume((Object)Response.noContent().build());
        })).exceptionally(ex -> {
            Throwable cause = FutureUtil.unwrapCompletionException((Throwable)ex);
            log.error("[{}] Failed to delete tenant {}", new Object[]{clientAppId, tenant, cause});
            if (cause instanceof IllegalStateException) {
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.CONFLICT, cause)));
            } else {
                TenantsBase.resumeAsyncResponseExceptionally(asyncResponse, cause);
            }
            return null;
        });
    }

    protected CompletableFuture<Void> internalDeleteTenant(String tenant, boolean force) {
        return force ? this.internalDeleteTenantAsyncForcefully(tenant) : this.internalDeleteTenantAsync(tenant);
    }

    protected CompletableFuture<Void> internalDeleteTenantAsync(String tenant) {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.tenantResources().tenantExistsAsync(tenant).thenAccept(exists -> {
            if (!exists.booleanValue()) {
                throw new RestException(Response.Status.NOT_FOUND, "Tenant doesn't exist");
            }
        })).thenCompose(__ -> this.hasActiveNamespace(tenant))).thenCompose(__ -> this.tenantResources().deleteTenantAsync(tenant))).thenCompose(__ -> this.pulsar().getPulsarResources().getTopicResources().clearTenantPersistence(tenant))).thenCompose(__ -> this.pulsar().getPulsarResources().getNamespaceResources().deleteTenantAsync(tenant))).thenCompose(__ -> this.pulsar().getPulsarResources().getNamespaceResources().getPartitionedTopicResources().clearPartitionedTopicTenantAsync(tenant))).thenCompose(__ -> this.pulsar().getPulsarResources().getLocalPolicies().deleteLocalPoliciesTenantAsync(tenant))).thenCompose(__ -> this.pulsar().getPulsarResources().getNamespaceResources().deleteBundleDataTenantAsync(tenant));
    }

    protected CompletableFuture<Void> internalDeleteTenantAsyncForcefully(String tenant) {
        if (!this.pulsar().getConfiguration().isForceDeleteTenantAllowed()) {
            return FutureUtil.failedFuture((Throwable)((Object)new RestException(Response.Status.METHOD_NOT_ALLOWED, "Broker doesn't allow forced deletion of tenants")));
        }
        return ((CompletableFuture)((CompletableFuture)this.tenantResources().getListOfNamespacesAsync(tenant).thenApply(namespaces -> {
            ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
            try {
                PulsarAdmin adminClient = this.pulsar().getAdminClient();
                for (String namespace : namespaces) {
                    futures.add(adminClient.namespaces().deleteNamespaceAsync(namespace, true));
                }
            }
            catch (Exception e) {
                log.error("[{}] Failed to force delete namespaces {}", new Object[]{this.clientAppId(), namespaces, e});
                throw new RestException(e);
            }
            return futures;
        })).thenCompose(futures -> FutureUtil.waitForAll((Collection)futures))).thenCompose(__ -> this.internalDeleteTenantAsync(tenant));
    }

    private CompletableFuture<Void> validateClustersAsync(TenantInfo info) {
        if (info == null || info.getAllowedClusters().stream().filter(c -> !StringUtils.isBlank((CharSequence)c)).collect(Collectors.toSet()).isEmpty() || info.getAllowedClusters().stream().anyMatch(ac -> StringUtils.isBlank((CharSequence)ac))) {
            log.warn("[{}] Failed to validate due to clusters are empty", (Object)this.clientAppId());
            return FutureUtil.failedFuture((Throwable)((Object)new RestException(Response.Status.PRECONDITION_FAILED, "Clusters can not be empty")));
        }
        return this.clusterResources().listAsync().thenAccept(availableClusters -> {
            Set allowedClusters = info.getAllowedClusters();
            List nonexistentClusters = allowedClusters.stream().filter(cluster -> !availableClusters.contains(cluster) && !"global".equals(cluster)).collect(Collectors.toList());
            if (nonexistentClusters.size() > 0) {
                log.warn("[{}] Failed to validate due to clusters {} do not exist", (Object)this.clientAppId(), nonexistentClusters);
                throw new RestException(Response.Status.PRECONDITION_FAILED, "Clusters do not exist");
            }
        });
    }
}

