/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.compaction;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.apache.bookkeeper.mledger.util.StatsBuckets;
import org.apache.pulsar.common.stats.Rate;

public class CompactionRecord {
    public static final long[] WRITE_LATENCY_BUCKETS_USEC = new long[]{500L, 1000L, 5000L, 10000L, 20000L, 50000L, 100000L, 200000L, 1000000L};
    private volatile long lastCompactionRemovedEventCount = 0L;
    private volatile long lastCompactionSucceedTimestamp = 0L;
    private volatile long lastCompactionFailedTimestamp = 0L;
    private volatile long lastCompactionDurationTimeInMills = 0L;
    private LongAdder lastCompactionRemovedEventCountOp = new LongAdder();
    private volatile long lastCompactionStartTimeOp;
    private final LongAdder compactionRemovedEventCount = new LongAdder();
    private final LongAdder compactionSucceedCount = new LongAdder();
    private final LongAdder compactionFailedCount = new LongAdder();
    private final LongAdder compactionDurationTimeInMills = new LongAdder();
    public final StatsBuckets writeLatencyStats = new StatsBuckets(WRITE_LATENCY_BUCKETS_USEC);
    public final Rate writeRate = new Rate();
    public final Rate readRate = new Rate();

    public void reset() {
        this.compactionRemovedEventCount.reset();
        this.compactionSucceedCount.reset();
        this.compactionFailedCount.reset();
        this.compactionDurationTimeInMills.reset();
        this.writeLatencyStats.reset();
    }

    public void addCompactionRemovedEvent() {
        this.lastCompactionRemovedEventCountOp.increment();
        this.compactionRemovedEventCount.increment();
    }

    public void addCompactionStartOp() {
        this.lastCompactionRemovedEventCountOp.reset();
        this.lastCompactionStartTimeOp = System.currentTimeMillis();
    }

    public void addCompactionEndOp(boolean succeed) {
        this.lastCompactionDurationTimeInMills = System.currentTimeMillis() - this.lastCompactionStartTimeOp;
        this.compactionDurationTimeInMills.add(this.lastCompactionDurationTimeInMills);
        this.lastCompactionRemovedEventCount = this.lastCompactionRemovedEventCountOp.longValue();
        if (succeed) {
            this.lastCompactionSucceedTimestamp = System.currentTimeMillis();
            this.compactionSucceedCount.increment();
        } else {
            this.lastCompactionFailedTimestamp = System.currentTimeMillis();
            this.compactionFailedCount.increment();
        }
    }

    public void addCompactionReadOp(long readableBytes) {
        this.readRate.recordEvent(readableBytes);
    }

    public void addCompactionWriteOp(long writeableBytes) {
        this.writeRate.recordEvent(writeableBytes);
    }

    public void addCompactionLatencyOp(long latency, TimeUnit unit) {
        this.writeLatencyStats.addValue(unit.toMicros(latency));
    }

    public long getCompactionRemovedEventCount() {
        return this.compactionRemovedEventCount.longValue();
    }

    public long getCompactionSucceedCount() {
        return this.compactionSucceedCount.longValue();
    }

    public long getCompactionFailedCount() {
        return this.compactionFailedCount.longValue();
    }

    public long getCompactionDurationTimeInMills() {
        return this.compactionDurationTimeInMills.longValue();
    }

    public long[] getCompactionLatencyBuckets() {
        this.writeLatencyStats.refresh();
        return this.writeLatencyStats.getBuckets();
    }

    public StatsBuckets getCompactionLatencyStats() {
        return this.writeLatencyStats;
    }

    public double getCompactionReadThroughput() {
        this.readRate.calculateRate();
        return this.readRate.getValueRate();
    }

    public double getCompactionWriteThroughput() {
        this.writeRate.calculateRate();
        return this.writeRate.getValueRate();
    }

    public long getLastCompactionRemovedEventCount() {
        return this.lastCompactionRemovedEventCount;
    }

    public long getLastCompactionSucceedTimestamp() {
        return this.lastCompactionSucceedTimestamp;
    }

    public long getLastCompactionFailedTimestamp() {
        return this.lastCompactionFailedTimestamp;
    }

    public long getLastCompactionDurationTimeInMills() {
        return this.lastCompactionDurationTimeInMills;
    }
}

