/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.intercept;

import com.google.common.annotations.VisibleForTesting;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.intercept.BrokerInterceptor;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.Producer;
import org.apache.pulsar.broker.service.ServerCnx;
import org.apache.pulsar.broker.service.Subscription;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.common.api.proto.BaseCommand;
import org.apache.pulsar.common.api.proto.CommandAck;
import org.apache.pulsar.common.api.proto.MessageMetadata;
import org.apache.pulsar.common.intercept.InterceptException;
import org.apache.pulsar.common.nar.NarClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerInterceptorWithClassLoader
implements BrokerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(BrokerInterceptorWithClassLoader.class);
    private final BrokerInterceptor interceptor;
    private final NarClassLoader narClassLoader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeSendMessage(Subscription subscription, Entry entry, long[] ackSet, MessageMetadata msgMetadata) {
        ClassLoader previousContext = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.narClassLoader);
            this.interceptor.beforeSendMessage(subscription, entry, ackSet, msgMetadata);
        }
        finally {
            Thread.currentThread().setContextClassLoader(previousContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeSendMessage(Subscription subscription, Entry entry, long[] ackSet, MessageMetadata msgMetadata, Consumer consumer) {
        ClassLoader previousContext = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.narClassLoader);
            this.interceptor.beforeSendMessage(subscription, entry, ackSet, msgMetadata, consumer);
        }
        finally {
            Thread.currentThread().setContextClassLoader(previousContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessagePublish(Producer producer, ByteBuf headersAndPayload, Topic.PublishContext publishContext) {
        ClassLoader previousContext = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.narClassLoader);
            this.interceptor.onMessagePublish(producer, headersAndPayload, publishContext);
        }
        finally {
            Thread.currentThread().setContextClassLoader(previousContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void producerCreated(ServerCnx cnx, Producer producer, Map<String, String> metadata) {
        ClassLoader previousContext = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.narClassLoader);
            this.interceptor.producerCreated(cnx, producer, metadata);
        }
        finally {
            Thread.currentThread().setContextClassLoader(previousContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void producerClosed(ServerCnx cnx, Producer producer, Map<String, String> metadata) {
        ClassLoader previousContext = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.narClassLoader);
            this.interceptor.producerClosed(cnx, producer, metadata);
        }
        finally {
            Thread.currentThread().setContextClassLoader(previousContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void consumerCreated(ServerCnx cnx, Consumer consumer, Map<String, String> metadata) {
        ClassLoader previousContext = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.narClassLoader);
            this.interceptor.consumerCreated(cnx, consumer, metadata);
        }
        finally {
            Thread.currentThread().setContextClassLoader(previousContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void consumerClosed(ServerCnx cnx, Consumer consumer, Map<String, String> metadata) {
        ClassLoader previousContext = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.narClassLoader);
            this.interceptor.consumerClosed(cnx, consumer, metadata);
        }
        finally {
            Thread.currentThread().setContextClassLoader(previousContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageProduced(ServerCnx cnx, Producer producer, long startTimeNs, long ledgerId, long entryId, Topic.PublishContext publishContext) {
        ClassLoader previousContext = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.narClassLoader);
            this.interceptor.messageProduced(cnx, producer, startTimeNs, ledgerId, entryId, publishContext);
        }
        finally {
            Thread.currentThread().setContextClassLoader(previousContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageDispatched(ServerCnx cnx, Consumer consumer, long ledgerId, long entryId, ByteBuf headersAndPayload) {
        ClassLoader previousContext = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.narClassLoader);
            this.interceptor.messageDispatched(cnx, consumer, ledgerId, entryId, headersAndPayload);
        }
        finally {
            Thread.currentThread().setContextClassLoader(previousContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageAcked(ServerCnx cnx, Consumer consumer, CommandAck ackCmd) {
        ClassLoader previousContext = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.narClassLoader);
            this.interceptor.messageAcked(cnx, consumer, ackCmd);
        }
        finally {
            Thread.currentThread().setContextClassLoader(previousContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void txnOpened(long tcId, String txnID) {
        ClassLoader previousContext = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.narClassLoader);
            this.interceptor.txnOpened(tcId, txnID);
        }
        finally {
            Thread.currentThread().setContextClassLoader(previousContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void txnEnded(String txnID, long txnAction) {
        ClassLoader previousContext = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.narClassLoader);
            this.interceptor.txnEnded(txnID, txnAction);
        }
        finally {
            Thread.currentThread().setContextClassLoader(previousContext);
        }
    }

    @Override
    public void onConnectionCreated(ServerCnx cnx) {
        ClassLoader previousContext = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.narClassLoader);
            this.interceptor.onConnectionCreated(cnx);
        }
        finally {
            Thread.currentThread().setContextClassLoader(previousContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPulsarCommand(BaseCommand command, ServerCnx cnx) throws InterceptException {
        ClassLoader previousContext = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.narClassLoader);
            this.interceptor.onPulsarCommand(command, cnx);
        }
        finally {
            Thread.currentThread().setContextClassLoader(previousContext);
        }
    }

    @Override
    public void onConnectionClosed(ServerCnx cnx) {
        ClassLoader previousContext = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.narClassLoader);
            this.interceptor.onConnectionClosed(cnx);
        }
        finally {
            Thread.currentThread().setContextClassLoader(previousContext);
        }
    }

    @Override
    public void onWebserviceRequest(ServletRequest request) throws IOException, ServletException, InterceptException {
        ClassLoader previousContext = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.narClassLoader);
            this.interceptor.onWebserviceRequest(request);
        }
        finally {
            Thread.currentThread().setContextClassLoader(previousContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onWebserviceResponse(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        ClassLoader previousContext = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.narClassLoader);
            this.interceptor.onWebserviceResponse(request, response);
        }
        finally {
            Thread.currentThread().setContextClassLoader(previousContext);
        }
    }

    @Override
    public void initialize(PulsarService pulsarService) throws Exception {
        ClassLoader previousContext = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.narClassLoader);
            this.interceptor.initialize(pulsarService);
        }
        finally {
            Thread.currentThread().setContextClassLoader(previousContext);
        }
    }

    @Override
    public void close() {
        ClassLoader previousContext = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.narClassLoader);
            this.interceptor.close();
        }
        finally {
            Thread.currentThread().setContextClassLoader(previousContext);
        }
        try {
            this.narClassLoader.close();
        }
        catch (IOException e) {
            log.warn("Failed to close the broker interceptor class loader", (Throwable)e);
        }
    }

    @VisibleForTesting
    public BrokerInterceptor getInterceptor() {
        return this.interceptor;
    }

    public NarClassLoader getNarClassLoader() {
        return this.narClassLoader;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BrokerInterceptorWithClassLoader)) {
            return false;
        }
        BrokerInterceptorWithClassLoader other = (BrokerInterceptorWithClassLoader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BrokerInterceptor this$interceptor = this.getInterceptor();
        BrokerInterceptor other$interceptor = other.getInterceptor();
        if (this$interceptor == null ? other$interceptor != null : !this$interceptor.equals(other$interceptor)) {
            return false;
        }
        NarClassLoader this$narClassLoader = this.getNarClassLoader();
        NarClassLoader other$narClassLoader = other.getNarClassLoader();
        return !(this$narClassLoader == null ? other$narClassLoader != null : !this$narClassLoader.equals(other$narClassLoader));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BrokerInterceptorWithClassLoader;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BrokerInterceptor $interceptor = this.getInterceptor();
        result = result * 59 + ($interceptor == null ? 43 : $interceptor.hashCode());
        NarClassLoader $narClassLoader = this.getNarClassLoader();
        result = result * 59 + ($narClassLoader == null ? 43 : $narClassLoader.hashCode());
        return result;
    }

    public String toString() {
        return "BrokerInterceptorWithClassLoader(interceptor=" + this.getInterceptor() + ", narClassLoader=" + this.getNarClassLoader() + ")";
    }

    public BrokerInterceptorWithClassLoader(BrokerInterceptor interceptor, NarClassLoader narClassLoader) {
        this.interceptor = interceptor;
        this.narClassLoader = narClassLoader;
    }
}

