/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.extensions.channel;

import com.google.common.annotations.VisibleForTesting;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.loadbalance.extensions.channel.ServiceUnitState;
import org.apache.pulsar.broker.loadbalance.extensions.channel.ServiceUnitStateData;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.topics.TopicCompactionStrategy;

public class ServiceUnitStateCompactionStrategy
implements TopicCompactionStrategy<ServiceUnitStateData> {
    private final Schema<ServiceUnitStateData> schema = Schema.JSON(ServiceUnitStateData.class);
    private BiConsumer<String, ServiceUnitStateData> skippedMsgHandler;
    private boolean checkBrokers = true;

    public void setSkippedMsgHandler(BiConsumer<String, ServiceUnitStateData> skippedMsgHandler) {
        this.skippedMsgHandler = skippedMsgHandler;
    }

    public void handleSkippedMessage(String key, ServiceUnitStateData cur) {
        if (this.skippedMsgHandler != null) {
            this.skippedMsgHandler.accept(key, cur);
        }
    }

    public Schema<ServiceUnitStateData> getSchema() {
        return this.schema;
    }

    @VisibleForTesting
    public void checkBrokers(boolean check) {
        this.checkBrokers = check;
    }

    public boolean shouldKeepLeft(ServiceUnitStateData from, ServiceUnitStateData to) {
        ServiceUnitState state;
        if (to == null) {
            return false;
        }
        if (from != null && (from.versionId() != Long.MAX_VALUE || to.versionId() != Long.MIN_VALUE)) {
            if (from.versionId() >= to.versionId()) {
                return true;
            }
            if (from.versionId() < to.versionId() - 1L) {
                return false;
            }
        }
        if (to.force()) {
            return false;
        }
        ServiceUnitState prevState = ServiceUnitStateData.state(from);
        if (!ServiceUnitState.isValidTransition(prevState, state = ServiceUnitStateData.state(to))) {
            return true;
        }
        if (this.checkBrokers) {
            switch (prevState) {
                case Owned: {
                    switch (state) {
                        case Splitting: {
                            return StringUtils.isNotBlank((CharSequence)to.dstBroker()) || !from.dstBroker().equals(to.sourceBroker());
                        }
                        case Releasing: {
                            return this.invalidUnload(from, to);
                        }
                    }
                }
                case Assigning: {
                    switch (state) {
                        case Owned: {
                            return this.notEquals(from, to);
                        }
                    }
                }
                case Releasing: {
                    switch (state) {
                        case Assigning: {
                            return StringUtils.isBlank((CharSequence)to.dstBroker()) || this.notEquals(from, to);
                        }
                        case Free: {
                            return this.notEquals(from, to);
                        }
                    }
                }
                case Splitting: {
                    switch (state) {
                        case Deleted: {
                            return this.notEquals(from, to);
                        }
                    }
                }
                case Free: {
                    switch (state) {
                        case Assigning: {
                            return StringUtils.isNotBlank((CharSequence)to.sourceBroker()) || StringUtils.isBlank((CharSequence)to.dstBroker());
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean notEquals(ServiceUnitStateData from, ServiceUnitStateData to) {
        return !StringUtils.equals((CharSequence)from.dstBroker(), (CharSequence)to.dstBroker()) || !StringUtils.equals((CharSequence)from.sourceBroker(), (CharSequence)to.sourceBroker());
    }

    private boolean invalidUnload(ServiceUnitStateData from, ServiceUnitStateData to) {
        return StringUtils.isBlank((CharSequence)to.sourceBroker()) || !from.dstBroker().equals(to.sourceBroker()) || from.dstBroker().equals(to.dstBroker());
    }
}

