/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.extensions.manager;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.loadbalance.extensions.ExtensibleLoadManagerImpl;
import org.apache.pulsar.broker.loadbalance.extensions.data.BrokerLookupData;
import org.apache.pulsar.broker.lookup.LookupResult;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.metadata.api.coordination.LockManager;
import org.apache.pulsar.policies.data.loadbalancer.ServiceLookupData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedirectManager {
    private static final Logger log = LoggerFactory.getLogger(RedirectManager.class);
    private final PulsarService pulsar;
    private final LockManager<BrokerLookupData> brokerLookupDataLockManager;

    public RedirectManager(PulsarService pulsar) {
        this.pulsar = pulsar;
        this.brokerLookupDataLockManager = pulsar.getCoordinationService().getLockManager(BrokerLookupData.class);
    }

    @VisibleForTesting
    public RedirectManager(PulsarService pulsar, LockManager<BrokerLookupData> brokerLookupDataLockManager) {
        this.pulsar = pulsar;
        this.brokerLookupDataLockManager = brokerLookupDataLockManager;
    }

    public CompletableFuture<Map<String, BrokerLookupData>> getAvailableBrokerLookupDataAsync() {
        return this.brokerLookupDataLockManager.listLocks("/loadbalance/brokers").thenCompose(availableBrokers -> {
            ConcurrentHashMap map = new ConcurrentHashMap();
            ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
            for (String brokerId : availableBrokers) {
                futures.add(this.brokerLookupDataLockManager.readLock(String.format("%s/%s", "/loadbalance/brokers", brokerId)).thenAccept(lookupDataOpt -> {
                    if (lookupDataOpt.isPresent()) {
                        map.put(brokerId, (BrokerLookupData)lookupDataOpt.get());
                    } else {
                        log.warn("Got an empty lookup data, brokerId: {}", (Object)brokerId);
                    }
                }));
            }
            return FutureUtil.waitForAll(futures).thenApply(__ -> map);
        });
    }

    public CompletableFuture<Optional<LookupResult>> findRedirectLookupResultAsync() {
        String currentLMClassName = this.pulsar.getConfiguration().getLoadManagerClassName();
        boolean debug = ExtensibleLoadManagerImpl.debug(this.pulsar.getConfiguration(), log);
        return this.getAvailableBrokerLookupDataAsync().thenApply(lookupDataMap -> {
            if (lookupDataMap.isEmpty()) {
                String errorMsg = "No available broker found.";
                log.warn(errorMsg);
                throw new IllegalStateException(errorMsg);
            }
            AtomicReference latestServiceLookupData = new AtomicReference();
            AtomicLong lastStartTimestamp = new AtomicLong(0L);
            lookupDataMap.forEach((key, value) -> {
                if (lastStartTimestamp.get() <= value.getStartTimestamp()) {
                    lastStartTimestamp.set(value.getStartTimestamp());
                    latestServiceLookupData.set(value);
                }
            });
            if (latestServiceLookupData.get() == null) {
                String errorMsg = "No latest service lookup data found.";
                log.warn(errorMsg);
                throw new IllegalStateException(errorMsg);
            }
            if (Objects.equals(((ServiceLookupData)latestServiceLookupData.get()).getLoadManagerClassName(), currentLMClassName)) {
                if (debug) {
                    log.info("No need to redirect, current load manager class name: {}", (Object)currentLMClassName);
                }
                return Optional.empty();
            }
            ServiceLookupData serviceLookupDataObj = (ServiceLookupData)latestServiceLookupData.get();
            ArrayList candidateBrokers = new ArrayList();
            lookupDataMap.forEach((key, value) -> {
                if (Objects.equals(value.getLoadManagerClassName(), serviceLookupDataObj.getLoadManagerClassName())) {
                    candidateBrokers.add(value);
                }
            });
            ServiceLookupData selectedBroker = (ServiceLookupData)candidateBrokers.get((int)(Math.random() * (double)candidateBrokers.size()));
            return Optional.of(new LookupResult(selectedBroker.getWebServiceUrl(), selectedBroker.getWebServiceUrlTls(), selectedBroker.getPulsarServiceUrl(), selectedBroker.getPulsarServiceUrlTls(), true));
        });
    }
}

