/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.extensions.store;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.apache.pulsar.broker.loadbalance.extensions.store.LoadDataStore;
import org.apache.pulsar.broker.loadbalance.extensions.store.LoadDataStoreException;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.TableView;
import org.apache.pulsar.common.util.FutureUtil;

public class TableViewLoadDataStoreImpl<T>
implements LoadDataStore<T> {
    private volatile TableView<T> tableView;
    private volatile Producer<T> producer;
    private final PulsarClient client;
    private final String topic;
    private final Class<T> clazz;

    public TableViewLoadDataStoreImpl(PulsarClient client, String topic, Class<T> clazz) throws LoadDataStoreException {
        try {
            this.client = client;
            this.topic = topic;
            this.clazz = clazz;
        }
        catch (Exception e) {
            throw new LoadDataStoreException(e);
        }
    }

    @Override
    public synchronized CompletableFuture<Void> pushAsync(String key, T loadData) {
        if (this.producer == null) {
            return FutureUtil.failedFuture((Throwable)new IllegalStateException("producer has not been started"));
        }
        return this.producer.newMessage().key(key).value(loadData).sendAsync().thenAccept(__ -> {});
    }

    @Override
    public synchronized CompletableFuture<Void> removeAsync(String key) {
        if (this.producer == null) {
            return FutureUtil.failedFuture((Throwable)new IllegalStateException("producer has not been started"));
        }
        return this.producer.newMessage().key(key).value(null).sendAsync().thenAccept(__ -> {});
    }

    @Override
    public synchronized Optional<T> get(String key) {
        this.validateTableViewStart();
        return Optional.ofNullable(this.tableView.get(key));
    }

    @Override
    public synchronized void forEach(BiConsumer<String, T> action) {
        this.validateTableViewStart();
        this.tableView.forEach(action);
    }

    @Override
    public synchronized Set<Map.Entry<String, T>> entrySet() {
        this.validateTableViewStart();
        return this.tableView.entrySet();
    }

    @Override
    public synchronized int size() {
        this.validateTableViewStart();
        return this.tableView.size();
    }

    @Override
    public synchronized void closeTableView() throws IOException {
        if (this.tableView != null) {
            this.tableView.close();
            this.tableView = null;
        }
    }

    @Override
    public synchronized void start() throws LoadDataStoreException {
        this.startProducer();
        this.startTableView();
    }

    @Override
    public synchronized void startTableView() throws LoadDataStoreException {
        if (this.tableView == null) {
            try {
                this.tableView = this.client.newTableViewBuilder(Schema.JSON(this.clazz)).topic(this.topic).create();
            }
            catch (PulsarClientException e) {
                this.tableView = null;
                throw new LoadDataStoreException(e);
            }
        }
    }

    @Override
    public synchronized void startProducer() throws LoadDataStoreException {
        if (this.producer == null) {
            try {
                this.producer = this.client.newProducer(Schema.JSON(this.clazz)).topic(this.topic).create();
            }
            catch (PulsarClientException e) {
                this.producer = null;
                throw new LoadDataStoreException(e);
            }
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.producer != null) {
            this.producer.close();
            this.producer = null;
        }
        this.closeTableView();
    }

    @Override
    public synchronized void init() throws IOException {
        this.close();
        this.start();
    }

    private synchronized void validateTableViewStart() {
        if (this.tableView == null) {
            throw new IllegalStateException("table view has not been started");
        }
    }
}

