/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.google.common.base.Strings;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.pulsar.PulsarStandalone;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.common.configuration.PulsarConfigurationLoader;
import org.apache.pulsar.docs.tools.CmdGenerateDocs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarStandaloneStarter
extends PulsarStandalone {
    private static final Logger log = LoggerFactory.getLogger(PulsarStandaloneStarter.class);
    private static final String PULSAR_CONFIG_FILE = "pulsar.config.file";
    @Parameter(names={"-g", "--generate-docs"}, description="Generate docs")
    private boolean generateDocs = false;

    public PulsarStandaloneStarter(String[] args) throws Exception {
        JCommander jcommander = new JCommander();
        try {
            jcommander.addObject((Object)this);
            jcommander.parse(args);
            if (this.isHelp()) {
                jcommander.usage();
                this.exit(0);
            }
            if (Strings.isNullOrEmpty((String)this.getConfigFile())) {
                String configFile = System.getProperty(PULSAR_CONFIG_FILE);
                if (Strings.isNullOrEmpty((String)configFile)) {
                    throw new IllegalArgumentException("Config file not specified. Please use -c, --config-file or -Dpulsar.config.file to specify the config file.");
                }
                this.setConfigFile(configFile);
            }
            if (this.generateDocs) {
                CmdGenerateDocs cmd = new CmdGenerateDocs("pulsar");
                cmd.addCommand("standalone", (Object)this);
                cmd.run(null);
                this.exit(0);
            }
            if (this.isNoBroker() && this.isOnlyBroker()) {
                log.error("Only one option is allowed between '--no-broker' and '--only-broker'");
                jcommander.usage();
                return;
            }
        }
        catch (Exception e) {
            jcommander.usage();
            log.error(e.getMessage());
            this.exit(1);
        }
        try (FileInputStream inputStream = new FileInputStream(this.getConfigFile());){
            this.config = (ServiceConfiguration)PulsarConfigurationLoader.create((InputStream)inputStream, ServiceConfiguration.class);
        }
        if (this.getAdvertisedAddress() != null) {
            this.config.setAdvertisedAddress(this.getAdvertisedAddress());
        } else if (StringUtils.isBlank((CharSequence)this.config.getAdvertisedAddress()) && StringUtils.isBlank((CharSequence)this.config.getAdvertisedListeners())) {
            this.config.setAdvertisedAddress("localhost");
        }
        if (!PulsarStandaloneStarter.argsContains(args, "--zookeeper-port") && StringUtils.isNotBlank((CharSequence)this.config.getMetadataStoreUrl())) {
            String[] metadataStoreUrl = this.config.getMetadataStoreUrl().split(",")[0].split(":");
            if (metadataStoreUrl.length == 2) {
                this.setZkPort(Integer.parseInt(metadataStoreUrl[1]));
            } else if (metadataStoreUrl.length == 3) {
                String zkPort = metadataStoreUrl[2];
                if (zkPort.contains("/")) {
                    this.setZkPort(Integer.parseInt(zkPort.substring(0, zkPort.lastIndexOf("/"))));
                } else {
                    this.setZkPort(Integer.parseInt(zkPort));
                }
            }
        }
        this.registerShutdownHook();
    }

    protected void registerShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                if (this.fnWorkerService != null) {
                    this.fnWorkerService.stop();
                }
                if (this.broker != null) {
                    this.broker.close();
                }
                if (this.bkEnsemble != null) {
                    this.bkEnsemble.stop();
                }
            }
            catch (Exception e) {
                log.error("Shutdown failed: {}", (Object)e.getMessage(), (Object)e);
            }
            finally {
                LogManager.shutdown();
            }
        }));
    }

    protected void exit(int status) {
        System.exit(status);
    }

    private static boolean argsContains(String[] args, String arg) {
        return Arrays.asList(args).contains(arg);
    }

    public static void main(String[] args) throws Exception {
        PulsarStandaloneStarter standalone = new PulsarStandaloneStarter(args);
        try {
            standalone.start();
        }
        catch (Throwable th) {
            log.error("Failed to start pulsar service.", th);
            LogManager.shutdown();
            Runtime.getRuntime().exit(1);
        }
    }
}

