/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timer;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.websocket.DeploymentException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.mledger.LedgerOffloader;
import org.apache.bookkeeper.mledger.LedgerOffloaderFactory;
import org.apache.bookkeeper.mledger.LedgerOffloaderStats;
import org.apache.bookkeeper.mledger.ManagedLedgerFactory;
import org.apache.bookkeeper.mledger.impl.NullLedgerOffloader;
import org.apache.bookkeeper.mledger.offload.Offloaders;
import org.apache.bookkeeper.mledger.offload.OffloadersCache;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.PulsarVersion;
import org.apache.pulsar.broker.BookKeeperClientFactory;
import org.apache.pulsar.broker.BookKeeperClientFactoryImpl;
import org.apache.pulsar.broker.MetadataSessionExpiredPolicy;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.ServiceConfigurationUtils;
import org.apache.pulsar.broker.ShutdownService;
import org.apache.pulsar.broker.TransactionMetadataStoreService;
import org.apache.pulsar.broker.authentication.AuthenticationService;
import org.apache.pulsar.broker.authorization.AuthorizationService;
import org.apache.pulsar.broker.intercept.BrokerInterceptor;
import org.apache.pulsar.broker.intercept.BrokerInterceptors;
import org.apache.pulsar.broker.loadbalance.LeaderBroker;
import org.apache.pulsar.broker.loadbalance.LeaderElectionService;
import org.apache.pulsar.broker.loadbalance.LoadManager;
import org.apache.pulsar.broker.loadbalance.LoadReportUpdaterTask;
import org.apache.pulsar.broker.loadbalance.LoadResourceQuotaUpdaterTask;
import org.apache.pulsar.broker.loadbalance.LoadSheddingTask;
import org.apache.pulsar.broker.loadbalance.extensions.ExtensibleLoadManagerImpl;
import org.apache.pulsar.broker.lookup.v1.TopicLookup;
import org.apache.pulsar.broker.namespace.NamespaceService;
import org.apache.pulsar.broker.protocol.ProtocolHandlers;
import org.apache.pulsar.broker.qos.DefaultMonotonicSnapshotClock;
import org.apache.pulsar.broker.qos.MonotonicSnapshotClock;
import org.apache.pulsar.broker.resourcegroup.ResourceGroupService;
import org.apache.pulsar.broker.resourcegroup.ResourceUsageTopicTransportManager;
import org.apache.pulsar.broker.resourcegroup.ResourceUsageTransportManager;
import org.apache.pulsar.broker.resources.ClusterResources;
import org.apache.pulsar.broker.resources.PulsarResources;
import org.apache.pulsar.broker.rest.Topics;
import org.apache.pulsar.broker.service.BrokerService;
import org.apache.pulsar.broker.service.PulsarMetadataEventSynchronizer;
import org.apache.pulsar.broker.service.SystemTopicBasedTopicPoliciesService;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.broker.service.TopicPoliciesService;
import org.apache.pulsar.broker.service.TransactionBufferSnapshotServiceFactory;
import org.apache.pulsar.broker.service.schema.SchemaRegistryService;
import org.apache.pulsar.broker.service.schema.SchemaStorageFactory;
import org.apache.pulsar.broker.stats.MetricsGenerator;
import org.apache.pulsar.broker.stats.prometheus.PrometheusRawMetricsProvider;
import org.apache.pulsar.broker.stats.prometheus.PulsarPrometheusMetricsServlet;
import org.apache.pulsar.broker.storage.ManagedLedgerStorage;
import org.apache.pulsar.broker.transaction.buffer.TransactionBufferProvider;
import org.apache.pulsar.broker.transaction.buffer.impl.TransactionBufferClientImpl;
import org.apache.pulsar.broker.transaction.pendingack.TransactionPendingAckStoreProvider;
import org.apache.pulsar.broker.transaction.pendingack.impl.MLPendingAckStoreProvider;
import org.apache.pulsar.broker.validator.MultipleListenerValidator;
import org.apache.pulsar.broker.validator.TransactionBatchedWriteValidator;
import org.apache.pulsar.broker.web.WebService;
import org.apache.pulsar.broker.web.plugin.servlet.AdditionalServlet;
import org.apache.pulsar.broker.web.plugin.servlet.AdditionalServletWithClassLoader;
import org.apache.pulsar.broker.web.plugin.servlet.AdditionalServletWithPulsarService;
import org.apache.pulsar.broker.web.plugin.servlet.AdditionalServlets;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminBuilder;
import org.apache.pulsar.client.api.AuthenticationFactory;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.transaction.TransactionBufferClient;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.apache.pulsar.client.impl.conf.ConfigurationDataUtils;
import org.apache.pulsar.client.internal.PropertiesUtils;
import org.apache.pulsar.client.util.ExecutorProvider;
import org.apache.pulsar.client.util.ScheduledExecutorProvider;
import org.apache.pulsar.common.conf.InternalConfigurationData;
import org.apache.pulsar.common.configuration.PulsarConfiguration;
import org.apache.pulsar.common.configuration.PulsarConfigurationLoader;
import org.apache.pulsar.common.configuration.VipStatus;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.SystemTopicNames;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.ClusterDataImpl;
import org.apache.pulsar.common.policies.data.OffloadPoliciesImpl;
import org.apache.pulsar.common.protocol.schema.SchemaStorage;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.common.util.GracefulExecutorServicesShutdown;
import org.apache.pulsar.common.util.Reflections;
import org.apache.pulsar.common.util.ThreadDumpUtil;
import org.apache.pulsar.common.util.netty.EventLoopUtil;
import org.apache.pulsar.compaction.CompactionServiceFactory;
import org.apache.pulsar.compaction.Compactor;
import org.apache.pulsar.compaction.PulsarCompactionServiceFactory;
import org.apache.pulsar.compaction.StrategicTwoPhaseCompactor;
import org.apache.pulsar.compaction.TopicCompactionService;
import org.apache.pulsar.functions.worker.ErrorNotifier;
import org.apache.pulsar.functions.worker.WorkerConfig;
import org.apache.pulsar.functions.worker.WorkerService;
import org.apache.pulsar.metadata.api.MetadataEventSynchronizer;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.MetadataStoreConfig;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.MetadataStoreFactory;
import org.apache.pulsar.metadata.api.Notification;
import org.apache.pulsar.metadata.api.NotificationType;
import org.apache.pulsar.metadata.api.coordination.CoordinationService;
import org.apache.pulsar.metadata.api.coordination.LeaderElectionState;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.apache.pulsar.metadata.api.extended.SessionEvent;
import org.apache.pulsar.metadata.coordination.impl.CoordinationServiceImpl;
import org.apache.pulsar.packages.management.core.PackagesManagement;
import org.apache.pulsar.packages.management.core.PackagesStorage;
import org.apache.pulsar.packages.management.core.PackagesStorageConfiguration;
import org.apache.pulsar.packages.management.core.PackagesStorageProvider;
import org.apache.pulsar.packages.management.core.impl.DefaultPackagesStorageConfiguration;
import org.apache.pulsar.packages.management.core.impl.PackagesManagementImpl;
import org.apache.pulsar.policies.data.loadbalancer.AdvertisedListener;
import org.apache.pulsar.transaction.coordinator.TransactionMetadataStoreProvider;
import org.apache.pulsar.transaction.coordinator.impl.MLTransactionMetadataStoreProvider;
import org.apache.pulsar.websocket.WebSocketConsumerServlet;
import org.apache.pulsar.websocket.WebSocketMultiTopicConsumerServlet;
import org.apache.pulsar.websocket.WebSocketProducerServlet;
import org.apache.pulsar.websocket.WebSocketReaderServlet;
import org.apache.pulsar.websocket.WebSocketService;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarService
implements AutoCloseable,
ShutdownService {
    private static final Logger LOG = LoggerFactory.getLogger(PulsarService.class);
    private static final double GRACEFUL_SHUTDOWN_TIMEOUT_RATIO_OF_TOTAL_TIMEOUT = 0.5;
    private static final int DEFAULT_MONOTONIC_CLOCK_GRANULARITY_MILLIS = 8;
    private final ServiceConfiguration config;
    private NamespaceService nsService = null;
    private ManagedLedgerStorage managedLedgerClientFactory = null;
    private LeaderElectionService leaderElectionService = null;
    private BrokerService brokerService = null;
    private WebService webService = null;
    private WebSocketService webSocketService = null;
    private TopicPoliciesService topicPoliciesService = TopicPoliciesService.DISABLED;
    private BookKeeperClientFactory bkClientFactory;
    protected CompactionServiceFactory compactionServiceFactory;
    private StrategicTwoPhaseCompactor strategicCompactor;
    private ResourceUsageTransportManager resourceUsageTransportManager;
    private ResourceGroupService resourceGroupServiceManager;
    private final ScheduledExecutorService executor;
    private OrderedExecutor orderedExecutor;
    private final ScheduledExecutorService loadManagerExecutor;
    private ScheduledExecutorService compactorExecutor;
    private OrderedScheduler offloaderScheduler;
    private OffloadersCache offloadersCache = new OffloadersCache();
    private LedgerOffloader defaultOffloader;
    private LedgerOffloaderStats offloaderStats;
    private Map<NamespaceName, LedgerOffloader> ledgerOffloaderMap = new ConcurrentHashMap<NamespaceName, LedgerOffloader>();
    private ScheduledFuture<?> loadReportTask = null;
    private LoadSheddingTask loadSheddingTask = null;
    private ScheduledFuture<?> loadResourceQuotaTask = null;
    private final AtomicReference<LoadManager> loadManager = new AtomicReference();
    private PulsarAdmin adminClient = null;
    private PulsarClient client = null;
    private final String bindAddress;
    private final String advertisedAddress;
    private String webServiceAddress;
    private String webServiceAddressTls;
    private String brokerServiceUrl;
    private String brokerServiceUrlTls;
    private final String brokerVersion;
    private SchemaStorage schemaStorage = null;
    private SchemaRegistryService schemaRegistryService = null;
    private final WorkerConfig workerConfig;
    private final Optional<WorkerService> functionWorkerService;
    private ProtocolHandlers protocolHandlers = null;
    private final Consumer<Integer> processTerminator;
    protected final EventLoopGroup ioEventLoopGroup;
    private final ExecutorProvider brokerClientSharedInternalExecutorProvider;
    private final ExecutorProvider brokerClientSharedExternalExecutorProvider;
    private final ScheduledExecutorProvider brokerClientSharedScheduledExecutorProvider;
    private final Timer brokerClientSharedTimer;
    private MetricsGenerator metricsGenerator;
    private TransactionMetadataStoreService transactionMetadataStoreService;
    private TransactionBufferProvider transactionBufferProvider;
    private TransactionBufferClient transactionBufferClient;
    private HashedWheelTimer transactionTimer;
    private BrokerInterceptor brokerInterceptor;
    private AdditionalServlets brokerAdditionalServlets;
    private PackagesManagement packagesManagement = null;
    private PulsarPrometheusMetricsServlet metricsServlet;
    private List<PrometheusRawMetricsProvider> pendingMetricsProviders;
    private MetadataStoreExtended localMetadataStore;
    private PulsarMetadataEventSynchronizer localMetadataSynchronizer;
    private CoordinationService coordinationService;
    private TransactionBufferSnapshotServiceFactory transactionBufferSnapshotServiceFactory;
    private MetadataStore configurationMetadataStore;
    private PulsarMetadataEventSynchronizer configMetadataSynchronizer;
    private boolean shouldShutdownConfigurationMetadataStore;
    private PulsarResources pulsarResources;
    private TransactionPendingAckStoreProvider transactionPendingAckStoreProvider;
    private final ExecutorProvider transactionExecutorProvider;
    private final DefaultMonotonicSnapshotClock monotonicSnapshotClock;
    private String brokerId;
    private volatile State state;
    private final ReentrantLock mutex = new ReentrantLock();
    private final Condition isClosedCondition = this.mutex.newCondition();
    private volatile CompletableFuture<Void> closeFuture;
    private Map<String, AdvertisedListener> advertisedListeners;

    public PulsarService(ServiceConfiguration config) {
        this(config, Optional.empty(), exitCode -> LOG.info("Process termination requested with code {}. Ignoring, as this constructor is intended for tests. ", exitCode));
    }

    public PulsarService(ServiceConfiguration config, Optional<WorkerService> functionWorkerService, Consumer<Integer> processTerminator) {
        this(config, new WorkerConfig(), functionWorkerService, processTerminator);
    }

    public PulsarService(ServiceConfiguration config, WorkerConfig workerConfig, Optional<WorkerService> functionWorkerService, Consumer<Integer> processTerminator) {
        this.state = State.Init;
        PulsarConfigurationLoader.isComplete((Object)config);
        TransactionBatchedWriteValidator.validate(config);
        this.config = config;
        this.advertisedListeners = MultipleListenerValidator.validateAndAnalysisAdvertisedListener((ServiceConfiguration)config);
        this.advertisedAddress = ServiceConfigurationUtils.getDefaultOrConfiguredAddress((String)config.getAdvertisedAddress());
        this.bindAddress = ServiceConfigurationUtils.getDefaultOrConfiguredAddress((String)config.getBindAddress());
        this.brokerVersion = PulsarVersion.getVersion();
        this.processTerminator = processTerminator;
        this.loadManagerExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new ExecutorProvider.ExtendedThreadFactory("pulsar-load-manager"));
        this.workerConfig = workerConfig;
        this.functionWorkerService = functionWorkerService;
        this.executor = Executors.newScheduledThreadPool(config.getNumExecutorThreadPoolSize(), (ThreadFactory)new ExecutorProvider.ExtendedThreadFactory("pulsar"));
        this.transactionExecutorProvider = config.isTransactionCoordinatorEnabled() ? new ExecutorProvider(this.getConfiguration().getNumTransactionReplayThreadPoolSize(), "pulsar-transaction-executor") : null;
        this.ioEventLoopGroup = EventLoopUtil.newEventLoopGroup((int)config.getNumIOThreads(), (boolean)config.isEnableBusyWait(), (ThreadFactory)new DefaultThreadFactory("pulsar-io"));
        this.brokerClientSharedInternalExecutorProvider = new ExecutorProvider(1, "broker-client-shared-internal-executor");
        this.brokerClientSharedExternalExecutorProvider = new ExecutorProvider(1, "broker-client-shared-external-executor");
        this.brokerClientSharedScheduledExecutorProvider = new ScheduledExecutorProvider(1, "broker-client-shared-scheduled-executor");
        this.brokerClientSharedTimer = new HashedWheelTimer((ThreadFactory)new DefaultThreadFactory("broker-client-shared-timer"), 1L, TimeUnit.MILLISECONDS);
        this.offloaderStats = LedgerOffloaderStats.create((boolean)false, (boolean)false, null, (int)0);
        this.monotonicSnapshotClock = new DefaultMonotonicSnapshotClock(TimeUnit.MILLISECONDS.toNanos(8L), System::nanoTime);
    }

    public MetadataStore createConfigurationMetadataStore(PulsarMetadataEventSynchronizer synchronizer) throws MetadataStoreException {
        return MetadataStoreFactory.create((String)this.config.getConfigurationMetadataStoreUrl(), (MetadataStoreConfig)MetadataStoreConfig.builder().sessionTimeoutMillis((int)this.config.getMetadataStoreSessionTimeoutMillis()).allowReadOnlyOperations(this.config.isMetadataStoreAllowReadOnlyOperations()).configFilePath(this.config.getMetadataStoreConfigPath()).batchingEnabled(this.config.isMetadataStoreBatchingEnabled()).batchingMaxDelayMillis(this.config.getMetadataStoreBatchingMaxDelayMillis()).batchingMaxOperations(this.config.getMetadataStoreBatchingMaxOperations()).batchingMaxSizeKb(this.config.getMetadataStoreBatchingMaxSizeKb()).metadataStoreName("configuration-metadata-store").synchronizer((MetadataEventSynchronizer)synchronizer).build());
    }

    public void closeMetadataServiceSession() throws Exception {
        this.localMetadataStore.close();
    }

    private void closeLeaderElectionService() throws Exception {
        if (ExtensibleLoadManagerImpl.isLoadManagerExtensionEnabled(this)) {
            ExtensibleLoadManagerImpl.get(this.loadManager.get()).getLeaderElectionService().close();
        } else if (this.leaderElectionService != null) {
            this.leaderElectionService.close();
            this.leaderElectionService = null;
        }
    }

    @Override
    public void close() throws PulsarServerException {
        try {
            this.closeAsync().get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof PulsarServerException) {
                throw (PulsarServerException)cause;
            }
            if (this.getConfiguration().getBrokerShutdownTimeoutMs() == 0L && (cause instanceof TimeoutException || cause instanceof CancellationException)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Shutdown timeout ignored when timeout is 0, which is primarily used in tests to forcefully shutdown the broker", cause);
                }
            }
            throw new PulsarServerException(cause);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> closeAsync() {
        this.mutex.lock();
        try {
            ArrayList<CompletionStage> asyncCloseFutures;
            GracefulExecutorServicesShutdown executorServicesShutdown;
            block45: {
                if (this.closeFuture != null) {
                    CompletableFuture<Void> completableFuture = this.closeFuture;
                    return completableFuture;
                }
                LOG.info("Closing PulsarService");
                if (this.brokerService != null) {
                    this.brokerService.unloadNamespaceBundlesGracefully();
                }
                this.state = State.Closing;
                if (this.resourceUsageTransportManager != null) {
                    try {
                        this.resourceUsageTransportManager.close();
                    }
                    catch (Exception e) {
                        LOG.warn("ResourceUsageTransportManager closing failed {}", (Object)e.getMessage());
                    }
                    this.resourceUsageTransportManager = null;
                }
                if (this.resourceGroupServiceManager != null) {
                    try {
                        this.resourceGroupServiceManager.close();
                    }
                    catch (Exception e) {
                        LOG.warn("ResourceGroupServiceManager closing failed {}", (Object)e.getMessage());
                    }
                    this.resourceGroupServiceManager = null;
                }
                if (this.webService != null) {
                    try {
                        this.webService.close();
                        this.webService = null;
                    }
                    catch (Exception e) {
                        LOG.error("Web service closing failed", (Throwable)e);
                    }
                }
                this.resetMetricsServlet();
                if (this.compactionServiceFactory != null) {
                    try {
                        this.compactionServiceFactory.close();
                    }
                    catch (Exception e) {
                        LOG.warn("CompactionServiceFactory closing failed {}", (Object)e.getMessage());
                    }
                    this.compactionServiceFactory = null;
                }
                if (this.webSocketService != null) {
                    this.webSocketService.close();
                }
                if (this.brokerAdditionalServlets != null) {
                    this.brokerAdditionalServlets.close();
                    this.brokerAdditionalServlets = null;
                }
                executorServicesShutdown = GracefulExecutorServicesShutdown.initiate().timeout(Duration.ofMillis((long)(0.5 * (double)this.getConfiguration().getBrokerShutdownTimeoutMs())));
                if (this.protocolHandlers != null) {
                    this.protocolHandlers.close();
                    this.protocolHandlers = null;
                }
                if (this.loadSheddingTask != null) {
                    this.loadSheddingTask.cancel();
                }
                executorServicesShutdown.shutdown(new ExecutorService[]{this.loadManagerExecutor});
                asyncCloseFutures = new ArrayList<CompletionStage>();
                if (this.brokerService != null) {
                    CompletableFuture<Void> brokerCloseFuture = this.brokerService.closeAsync();
                    if (this.transactionMetadataStoreService != null) {
                        asyncCloseFutures.add(brokerCloseFuture.whenComplete((__, ___) -> {
                            this.transactionMetadataStoreService.close();
                            this.transactionMetadataStoreService = null;
                        }));
                    } else {
                        asyncCloseFutures.add(brokerCloseFuture);
                    }
                    this.brokerService = null;
                }
                if (this.managedLedgerClientFactory != null) {
                    try {
                        this.managedLedgerClientFactory.close();
                    }
                    catch (Exception e) {
                        LOG.warn("ManagedLedgerClientFactory closing failed {}", (Object)e.getMessage());
                    }
                    this.managedLedgerClientFactory = null;
                }
                if (this.bkClientFactory != null) {
                    this.bkClientFactory.close();
                    this.bkClientFactory = null;
                }
                this.closeLeaderElectionService();
                if (this.adminClient != null) {
                    this.adminClient.close();
                    this.adminClient = null;
                }
                if (this.transactionBufferSnapshotServiceFactory != null) {
                    this.transactionBufferSnapshotServiceFactory.close();
                    this.transactionBufferSnapshotServiceFactory = null;
                }
                if (this.transactionBufferClient != null) {
                    this.transactionBufferClient.close();
                }
                if (this.client != null) {
                    this.client.close();
                    this.client = null;
                }
                if (this.nsService != null) {
                    this.nsService.close();
                    this.nsService = null;
                }
                executorServicesShutdown.shutdown(new ExecutorService[]{this.compactorExecutor});
                executorServicesShutdown.shutdown(new ExecutorService[]{this.offloaderScheduler});
                executorServicesShutdown.shutdown(new ExecutorService[]{this.executor});
                executorServicesShutdown.shutdown(new ExecutorService[]{this.orderedExecutor});
                LoadManager loadManager = this.loadManager.get();
                if (loadManager != null) {
                    loadManager.stop();
                }
                if (this.schemaRegistryService != null) {
                    this.schemaRegistryService.close();
                }
                this.offloadersCache.close();
                if (this.coordinationService != null) {
                    try {
                        this.coordinationService.close();
                    }
                    catch (Exception e) {
                        Throwable cause = FutureUtil.unwrapCompletionException((Throwable)e);
                        if (cause instanceof MetadataStoreException.AlreadyClosedException) break block45;
                        throw e;
                    }
                }
            }
            this.closeLocalMetadataStore();
            if (this.configurationMetadataStore != null && this.shouldShutdownConfigurationMetadataStore) {
                this.configurationMetadataStore.close();
                if (this.configMetadataSynchronizer != null) {
                    this.configMetadataSynchronizer.close();
                    this.configMetadataSynchronizer = null;
                }
            }
            if (this.transactionExecutorProvider != null) {
                this.transactionExecutorProvider.shutdownNow();
            }
            MLPendingAckStoreProvider.closeBufferedWriterMetrics();
            MLTransactionMetadataStoreProvider.closeBufferedWriterMetrics();
            if (this.offloaderStats != null) {
                this.offloaderStats.close();
            }
            this.brokerClientSharedExternalExecutorProvider.shutdownNow();
            this.brokerClientSharedInternalExecutorProvider.shutdownNow();
            this.brokerClientSharedScheduledExecutorProvider.shutdownNow();
            this.brokerClientSharedTimer.stop();
            this.monotonicSnapshotClock.close();
            asyncCloseFutures.add(EventLoopUtil.shutdownGracefully((EventLoopGroup)this.ioEventLoopGroup));
            asyncCloseFutures.add(executorServicesShutdown.handle());
            this.closeFuture = this.addTimeoutHandling(FutureUtil.waitForAllAndSupportCancel(asyncCloseFutures));
            this.closeFuture.handle((v, t) -> {
                if (t == null) {
                    LOG.info("Closed");
                } else if (t instanceof CancellationException) {
                    LOG.info("Closed (shutdown cancelled)");
                } else if (t instanceof TimeoutException) {
                    LOG.info("Closed (shutdown timeout)");
                } else {
                    LOG.warn("Closed with errors", t);
                }
                this.state = State.Closed;
                this.isClosedCondition.signalAll();
                return null;
            });
            CompletableFuture<Void> completableFuture = this.closeFuture;
            return completableFuture;
        }
        catch (Exception e) {
            PulsarServerException pse = e instanceof CompletionException && e.getCause() instanceof MetadataStoreException ? new PulsarServerException((Throwable)MetadataStoreException.unwrap((Throwable)e)) : (e.getCause() instanceof CompletionException && e.getCause().getCause() instanceof MetadataStoreException ? new PulsarServerException((Throwable)MetadataStoreException.unwrap((Throwable)e.getCause())) : new PulsarServerException((Throwable)e));
            CompletableFuture completableFuture = FutureUtil.failedFuture((Throwable)pse);
            return completableFuture;
        }
        finally {
            this.mutex.unlock();
        }
    }

    private synchronized void resetMetricsServlet() {
        this.metricsServlet = null;
    }

    private CompletableFuture<Void> addTimeoutHandling(CompletableFuture<Void> future) {
        long brokerShutdownTimeoutMs = this.getConfiguration().getBrokerShutdownTimeoutMs();
        if (brokerShutdownTimeoutMs <= 0L) {
            return future;
        }
        ScheduledExecutorService shutdownExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new ExecutorProvider.ExtendedThreadFactory(this.getClass().getSimpleName() + "-shutdown"));
        FutureUtil.addTimeoutHandling(future, (Duration)Duration.ofMillis(brokerShutdownTimeoutMs), (ScheduledExecutorService)shutdownExecutor, () -> FutureUtil.createTimeoutException((String)"Timeout in close", this.getClass(), (String)"close"));
        future.handle((v, t) -> {
            if (t instanceof TimeoutException) {
                LOG.info("Shutdown timed out after {} ms", (Object)brokerShutdownTimeoutMs);
                LOG.info(ThreadDumpUtil.buildThreadDiagnosticString());
            }
            shutdownExecutor.shutdownNow();
            return null;
        });
        return future;
    }

    public ServiceConfiguration getConfiguration() {
        return this.config;
    }

    public Optional<WorkerConfig> getWorkerConfig() {
        return this.functionWorkerService.map(service -> this.workerConfig);
    }

    public Map<String, String> getProtocolDataToAdvertise() {
        if (null == this.protocolHandlers) {
            return Collections.emptyMap();
        }
        return this.protocolHandlers.getProtocolDataToAdvertise();
    }

    public void start() throws PulsarServerException {
        LOG.info("Starting Pulsar Broker service; version: '{}'", (Object)(this.brokerVersion != null ? this.brokerVersion : "unknown"));
        LOG.info("Git Revision {}", (Object)PulsarVersion.getGitSha());
        LOG.info("Git Branch {}", (Object)PulsarVersion.getGitBranch());
        LOG.info("Built by {} on {} at {}", new Object[]{PulsarVersion.getBuildUser(), PulsarVersion.getBuildHost(), PulsarVersion.getBuildTime()});
        long startTimestamp = System.currentTimeMillis();
        this.mutex.lock();
        try {
            if (this.state != State.Init) {
                throw new PulsarServerException("Cannot start the service once it was stopped");
            }
            if (this.config.getWebServicePort().isEmpty() && this.config.getWebServicePortTls().isEmpty()) {
                throw new IllegalArgumentException("webServicePort/webServicePortTls must be present");
            }
            if (this.config.isAuthorizationEnabled() && !this.config.isAuthenticationEnabled()) {
                throw new IllegalStateException("Invalid broker configuration. Authentication must be enabled with authenticationEnabled=true when authorization is enabled with authorizationEnabled=true.");
            }
            if (this.config.getDefaultRetentionSizeInMB() > 0 && this.config.getBacklogQuotaDefaultLimitBytes() > 0L && this.config.getBacklogQuotaDefaultLimitBytes() >= (long)this.config.getDefaultRetentionSizeInMB() * 1024L * 1024L) {
                throw new IllegalArgumentException(String.format("The retention size must > the backlog quota limit size, but the configured backlog quota limit bytes is %d, the retention size is %d", this.config.getBacklogQuotaDefaultLimitBytes(), (long)this.config.getDefaultRetentionSizeInMB() * 1024L * 1024L));
            }
            if (this.config.getDefaultRetentionTimeInMinutes() > 0 && this.config.getBacklogQuotaDefaultLimitSecond() > 0 && this.config.getBacklogQuotaDefaultLimitSecond() >= this.config.getDefaultRetentionTimeInMinutes() * 60) {
                throw new IllegalArgumentException(String.format("The retention time must > the backlog quota limit time, but the configured backlog quota limit time duration is %d, the retention time duration is %d", this.config.getBacklogQuotaDefaultLimitSecond(), this.config.getDefaultRetentionTimeInMinutes() * 60));
            }
            this.localMetadataSynchronizer = StringUtils.isNotBlank((CharSequence)this.config.getMetadataSyncEventTopic()) ? new PulsarMetadataEventSynchronizer(this, this.config.getMetadataSyncEventTopic()) : null;
            this.localMetadataStore = this.createLocalMetadataStore(this.localMetadataSynchronizer);
            this.localMetadataStore.registerSessionListener(this::handleMetadataSessionEvent);
            this.coordinationService = new CoordinationServiceImpl(this.localMetadataStore);
            if (this.config.isConfigurationStoreSeparated()) {
                this.configMetadataSynchronizer = StringUtils.isNotBlank((CharSequence)this.config.getConfigurationMetadataSyncEventTopic()) ? new PulsarMetadataEventSynchronizer(this, this.config.getConfigurationMetadataSyncEventTopic()) : null;
                this.configurationMetadataStore = this.createConfigurationMetadataStore(this.configMetadataSynchronizer);
                this.shouldShutdownConfigurationMetadataStore = true;
            } else {
                this.configurationMetadataStore = this.localMetadataStore;
                this.shouldShutdownConfigurationMetadataStore = false;
            }
            this.pulsarResources = this.newPulsarResources();
            this.orderedExecutor = this.newOrderedExecutor();
            this.protocolHandlers = ProtocolHandlers.load(this.config);
            this.protocolHandlers.initialize(this.config);
            this.bkClientFactory = this.newBookKeeperClientFactory();
            this.managedLedgerClientFactory = this.newManagedLedgerClientFactory();
            this.brokerService = this.newBrokerService(this);
            this.loadManager.set(LoadManager.create(this));
            this.startNamespaceService();
            this.schemaStorage = this.createAndStartSchemaStorage();
            this.schemaRegistryService = SchemaRegistryService.create(this.schemaStorage, this.config.getSchemaRegistryCompatibilityCheckers(), this.executor);
            OffloadPoliciesImpl defaultOffloadPolicies = OffloadPoliciesImpl.create((Properties)this.getConfiguration().getProperties());
            OrderedScheduler offloaderScheduler = this.getOffloaderScheduler(defaultOffloadPolicies);
            int interval = this.config.getManagedLedgerStatsPeriodSeconds();
            boolean exposeTopicMetrics = this.config.isExposeTopicLevelMetricsInPrometheus();
            this.offloaderStats = LedgerOffloaderStats.create((boolean)this.config.isExposeManagedLedgerMetricsInPrometheus(), (boolean)exposeTopicMetrics, (ScheduledExecutorService)offloaderScheduler, (int)interval);
            this.defaultOffloader = this.createManagedLedgerOffloader(defaultOffloadPolicies);
            this.setBrokerInterceptor(this.newBrokerInterceptor());
            BrokerInterceptor interceptor = this.getBrokerInterceptor();
            if (interceptor != null) {
                this.brokerService.setInterceptor(interceptor);
                interceptor.initialize(this);
            }
            this.brokerService.start();
            this.brokerAdditionalServlets = AdditionalServlets.load((PulsarConfiguration)this.config);
            this.webService = new WebService(this);
            this.createMetricsServlet();
            this.addWebServerHandlers(this.webService, this.metricsServlet, this.config);
            this.webService.start();
            if (this.config.getBrokerServicePort().equals(Optional.of(0))) {
                this.config.setBrokerServicePort(this.brokerService.getListenPort());
            }
            if (this.config.getBrokerServicePortTls().equals(Optional.of(0))) {
                this.config.setBrokerServicePortTls(this.brokerService.getListenPortTls());
            }
            this.webServiceAddress = this.webAddress(this.config);
            this.webServiceAddressTls = this.webAddressTls(this.config);
            this.brokerServiceUrl = this.brokerUrl(this.config);
            this.brokerServiceUrlTls = this.brokerUrlTls(this.config);
            Object[] objectArray = new Object[2];
            objectArray[0] = this.advertisedAddress;
            objectArray[1] = this.config.getWebServicePort().or(() -> ((ServiceConfiguration)this.config).getWebServicePortTls()).orElseThrow();
            this.brokerId = String.format("%s:%s", objectArray);
            if (this.compactionServiceFactory == null) {
                this.compactionServiceFactory = this.loadCompactionServiceFactory();
            }
            if (null != this.webSocketService) {
                ClusterDataImpl clusterData = ClusterDataImpl.builder().serviceUrl(this.webServiceAddress).serviceUrlTls(this.webServiceAddressTls).brokerServiceUrl(this.brokerServiceUrl).brokerServiceUrlTls(this.brokerServiceUrlTls).build();
                this.webSocketService.setLocalCluster((ClusterData)clusterData);
            }
            this.startLeaderElectionService();
            this.startLoadManagementService();
            this.nsService.initialize();
            if (this.config.isTopicLevelPoliciesEnabled() && this.config.isSystemTopicEnabled()) {
                this.topicPoliciesService = new SystemTopicBasedTopicPoliciesService(this);
            }
            this.topicPoliciesService.start();
            this.nsService.registerBootstrapNamespaces();
            if (this.config.isTransactionCoordinatorEnabled()) {
                MLTransactionMetadataStoreProvider.initBufferedWriterMetrics((String)this.getAdvertisedAddress());
                MLPendingAckStoreProvider.initBufferedWriterMetrics(this.getAdvertisedAddress());
                this.transactionBufferSnapshotServiceFactory = new TransactionBufferSnapshotServiceFactory(this.getClient());
                this.transactionTimer = new HashedWheelTimer((ThreadFactory)new DefaultThreadFactory("pulsar-transaction-timer"));
                this.transactionBufferClient = TransactionBufferClientImpl.create(this, this.transactionTimer, this.config.getTransactionBufferClientMaxConcurrentRequests(), this.config.getTransactionBufferClientOperationTimeoutInMills());
                this.transactionMetadataStoreService = new TransactionMetadataStoreService(TransactionMetadataStoreProvider.newProvider((String)this.config.getTransactionMetadataStoreProviderClassName()), this, this.transactionBufferClient, this.transactionTimer);
                this.transactionBufferProvider = TransactionBufferProvider.newProvider(this.config.getTransactionBufferProviderClassName());
                this.transactionPendingAckStoreProvider = TransactionPendingAckStoreProvider.newProvider(this.config.getTransactionPendingAckStoreProviderClassName());
            }
            this.metricsGenerator = new MetricsGenerator(this);
            this.protocolHandlers.start(this.brokerService);
            Map<String, Map<InetSocketAddress, ChannelInitializer<SocketChannel>>> protocolHandlerChannelInitializers = this.protocolHandlers.newChannelInitializers();
            this.brokerService.startProtocolHandlers(protocolHandlerChannelInitializers);
            this.acquireSLANamespace();
            this.startWorkerService(this.brokerService.getAuthenticationService(), this.brokerService.getAuthorizationService());
            if (this.config.isEnablePackagesManagement()) {
                this.startPackagesManagementService();
            }
            this.resourceUsageTransportManager = ResourceUsageTransportManager.DISABLE_RESOURCE_USAGE_TRANSPORT_MANAGER;
            if (StringUtils.isNotBlank((CharSequence)this.config.getResourceUsageTransportClassName())) {
                Class<?> clazz = Class.forName(this.config.getResourceUsageTransportClassName());
                Constructor<?> ctor = clazz.getConstructor(PulsarService.class);
                Object object = ctor.newInstance(this);
                this.resourceUsageTransportManager = (ResourceUsageTopicTransportManager)object;
            }
            this.resourceGroupServiceManager = new ResourceGroupService(this);
            if (this.localMetadataSynchronizer != null) {
                this.localMetadataSynchronizer.start();
            }
            if (this.configMetadataSynchronizer != null) {
                this.configMetadataSynchronizer.start();
            }
            long currentTimestamp = System.currentTimeMillis();
            long bootstrapTimeSeconds = TimeUnit.MILLISECONDS.toSeconds(currentTimestamp - startTimestamp);
            String bootstrapMessage = "bootstrap service " + (String)(this.config.getWebServicePort().isPresent() ? "port = " + this.config.getWebServicePort().get() : "") + (String)(this.config.getWebServicePortTls().isPresent() ? ", tls-port = " + this.config.getWebServicePortTls() : "") + (String)(StringUtils.isNotEmpty((CharSequence)this.brokerServiceUrl) ? ", broker url= " + this.brokerServiceUrl : "") + (String)(StringUtils.isNotEmpty((CharSequence)this.brokerServiceUrlTls) ? ", broker tls url= " + this.brokerServiceUrlTls : "");
            LOG.info("messaging service is ready, bootstrap_seconds={}, {}, cluster={}, configs={}", new Object[]{bootstrapTimeSeconds, bootstrapMessage, this.config.getClusterName(), this.config});
            this.state = State.Started;
        }
        catch (Exception e) {
            LOG.error("Failed to start Pulsar service: {}", (Object)e.getMessage(), (Object)e);
            throw new PulsarServerException((Throwable)e);
        }
        finally {
            this.mutex.unlock();
        }
    }

    protected BrokerInterceptor newBrokerInterceptor() throws IOException {
        return BrokerInterceptors.load(this.config);
    }

    @VisibleForTesting
    protected OrderedExecutor newOrderedExecutor() {
        return OrderedExecutor.newBuilder().numThreads(this.config.getNumOrderedExecutorThreads()).name("pulsar-ordered").build();
    }

    @VisibleForTesting
    protected ManagedLedgerStorage newManagedLedgerClientFactory() throws Exception {
        return ManagedLedgerStorage.create(this.config, this.localMetadataStore, this.bkClientFactory, this.ioEventLoopGroup);
    }

    @VisibleForTesting
    protected PulsarResources newPulsarResources() {
        PulsarResources pulsarResources = new PulsarResources((MetadataStore)this.localMetadataStore, this.configurationMetadataStore, this.config.getMetadataStoreOperationTimeoutSeconds());
        pulsarResources.getClusterResources().getStore().registerListener(this::handleDeleteCluster);
        return pulsarResources;
    }

    private synchronized void createMetricsServlet() {
        this.metricsServlet = new PulsarPrometheusMetricsServlet(this, this.config.isExposeTopicLevelMetricsInPrometheus(), this.config.isExposeConsumerLevelMetricsInPrometheus(), this.config.isExposeProducerLevelMetricsInPrometheus(), this.config.isSplitTopicAndPartitionLabelInPrometheus());
        if (this.pendingMetricsProviders != null) {
            this.pendingMetricsProviders.forEach(provider -> this.metricsServlet.addRawMetricsProvider((PrometheusRawMetricsProvider)provider));
            this.pendingMetricsProviders = null;
        }
    }

    private void addWebServerHandlers(WebService webService, PulsarPrometheusMetricsServlet metricsServlet, ServiceConfiguration config) throws PulsarServerException, PulsarClientException, MalformedURLException, ServletException, DeploymentException {
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        attributeMap.put("pulsar", this);
        HashMap<String, Object> vipAttributeMap = new HashMap<String, Object>();
        vipAttributeMap.put("statusFilePath", config.getStatusFilePath());
        vipAttributeMap.put("isReadyProbe", () -> this.state == State.Started);
        webService.addRestResource("/", false, vipAttributeMap, false, VipStatus.class);
        webService.addRestResources("/admin", true, attributeMap, false, "org.apache.pulsar.broker.admin.v1");
        webService.addRestResources("/admin/v2", true, attributeMap, true, "org.apache.pulsar.broker.admin.v2");
        webService.addRestResources("/admin/v3", true, attributeMap, true, "org.apache.pulsar.broker.admin.v3");
        webService.addRestResource("/lookup", true, attributeMap, true, TopicLookup.class, org.apache.pulsar.broker.lookup.v2.TopicLookup.class);
        webService.addRestResource("/topics", true, attributeMap, true, Topics.class);
        webService.addServlet("/metrics", new ServletHolder((Servlet)metricsServlet), config.isAuthenticateMetricsEndpoint(), attributeMap);
        this.addWebSocketServiceHandler(webService, attributeMap, config);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Attempting to add static directory");
        }
        webService.addStaticResources("/static", "/static");
        this.addBrokerAdditionalServlets(webService, attributeMap, config);
    }

    private void handleMetadataSessionEvent(SessionEvent e) {
        LOG.info("Received metadata service session event: {}", (Object)e);
        if (e == SessionEvent.SessionLost && this.config.getZookeeperSessionExpiredPolicy() == MetadataSessionExpiredPolicy.shutdown) {
            LOG.warn("The session with metadata service was lost. Shutting down.\n{}\n", (Object)ThreadDumpUtil.buildThreadDiagnosticString());
            this.shutdownNow();
        }
    }

    private void addBrokerAdditionalServlets(WebService webService, Map<String, Object> attributeMap, ServiceConfiguration config) {
        if (this.getBrokerAdditionalServlets() != null) {
            Collection additionalServletCollection = this.getBrokerAdditionalServlets().getServlets().values();
            for (AdditionalServletWithClassLoader servletWithClassLoader : additionalServletCollection) {
                servletWithClassLoader.loadConfig((PulsarConfiguration)config);
                AdditionalServlet additionalServlet = servletWithClassLoader.getServlet();
                if (additionalServlet instanceof AdditionalServletWithPulsarService) {
                    ((AdditionalServletWithPulsarService)additionalServlet).setPulsarService(this);
                }
                webService.addServlet(servletWithClassLoader.getBasePath(), servletWithClassLoader.getServletHolder(), config.isAuthenticationEnabled(), attributeMap);
                LOG.info("Broker add additional servlet basePath {} ", (Object)servletWithClassLoader.getBasePath());
            }
        }
    }

    private void addWebSocketServiceHandler(WebService webService, Map<String, Object> attributeMap, ServiceConfiguration config) throws PulsarServerException, PulsarClientException, MalformedURLException, ServletException, DeploymentException {
        if (config.isWebSocketServiceEnabled()) {
            this.webSocketService = new WebSocketService(null, config);
            this.webSocketService.start();
            WebSocketProducerServlet producerWebSocketServlet = new WebSocketProducerServlet(this.webSocketService);
            webService.addServlet("/ws/producer", new ServletHolder((Servlet)producerWebSocketServlet), true, attributeMap);
            webService.addServlet("/ws/v2/producer", new ServletHolder((Servlet)producerWebSocketServlet), true, attributeMap);
            WebSocketConsumerServlet consumerWebSocketServlet = new WebSocketConsumerServlet(this.webSocketService);
            webService.addServlet("/ws/consumer", new ServletHolder((Servlet)consumerWebSocketServlet), true, attributeMap);
            webService.addServlet("/ws/v2/consumer", new ServletHolder((Servlet)consumerWebSocketServlet), true, attributeMap);
            WebSocketReaderServlet readerWebSocketServlet = new WebSocketReaderServlet(this.webSocketService);
            webService.addServlet("/ws/reader", new ServletHolder((Servlet)readerWebSocketServlet), true, attributeMap);
            webService.addServlet("/ws/v2/reader", new ServletHolder((Servlet)readerWebSocketServlet), true, attributeMap);
            WebSocketMultiTopicConsumerServlet multiTopicConsumerWebSocketServlet = new WebSocketMultiTopicConsumerServlet(this.webSocketService);
            webService.addServlet("/ws/v3/consumer", new ServletHolder((Servlet)multiTopicConsumerWebSocketServlet), true, attributeMap);
        }
    }

    private void handleDeleteCluster(Notification notification) {
        if (this.isRunning() && ClusterResources.pathRepresentsClusterName((String)notification.getPath()) && notification.getType() == NotificationType.Deleted) {
            String clusterName = ClusterResources.clusterNameFromPath((String)notification.getPath());
            this.getBrokerService().closeAndRemoveReplicationClient(clusterName);
        }
    }

    public MetadataStoreExtended createLocalMetadataStore(PulsarMetadataEventSynchronizer synchronizer) throws MetadataStoreException, PulsarServerException {
        return MetadataStoreExtended.create((String)this.config.getMetadataStoreUrl(), (MetadataStoreConfig)MetadataStoreConfig.builder().sessionTimeoutMillis((int)this.config.getMetadataStoreSessionTimeoutMillis()).allowReadOnlyOperations(this.config.isMetadataStoreAllowReadOnlyOperations()).configFilePath(this.config.getMetadataStoreConfigPath()).batchingEnabled(this.config.isMetadataStoreBatchingEnabled()).batchingMaxDelayMillis(this.config.getMetadataStoreBatchingMaxDelayMillis()).batchingMaxOperations(this.config.getMetadataStoreBatchingMaxOperations()).batchingMaxSizeKb(this.config.getMetadataStoreBatchingMaxSizeKb()).synchronizer((MetadataEventSynchronizer)synchronizer).metadataStoreName("metadata-store").build());
    }

    protected void closeLocalMetadataStore() throws Exception {
        if (this.localMetadataStore != null) {
            this.localMetadataStore.close();
        }
        if (this.localMetadataSynchronizer != null) {
            this.localMetadataSynchronizer.close();
            this.localMetadataSynchronizer = null;
        }
    }

    protected void startLeaderElectionService() {
        if (ExtensibleLoadManagerImpl.isLoadManagerExtensionEnabled(this)) {
            LOG.info("The load manager extension is enabled. Skipping PulsarService LeaderElectionService.");
            return;
        }
        this.leaderElectionService = new LeaderElectionService(this.coordinationService, this.getBrokerId(), this.getSafeWebServiceAddress(), state -> {
            if (state == LeaderElectionState.Leading) {
                LOG.info("This broker was elected leader");
                if (this.getConfiguration().isLoadBalancerEnabled()) {
                    long resourceQuotaUpdateInterval = TimeUnit.MINUTES.toMillis(this.getConfiguration().getLoadBalancerResourceQuotaUpdateIntervalMinutes());
                    if (this.loadSheddingTask != null) {
                        this.loadSheddingTask.cancel();
                    }
                    if (this.loadResourceQuotaTask != null) {
                        this.loadResourceQuotaTask.cancel(false);
                    }
                    this.loadSheddingTask = new LoadSheddingTask(this.loadManager, this.loadManagerExecutor, this.config);
                    this.loadSheddingTask.start();
                    this.loadResourceQuotaTask = this.loadManagerExecutor.scheduleAtFixedRate(new LoadResourceQuotaUpdaterTask(this.loadManager), resourceQuotaUpdateInterval, resourceQuotaUpdateInterval, TimeUnit.MILLISECONDS);
                }
            } else {
                if (this.leaderElectionService != null) {
                    Optional<LeaderBroker> currentLeader = this.leaderElectionService.getCurrentLeader();
                    if (currentLeader.isPresent()) {
                        LOG.info("This broker is a follower. Current leader is {}", currentLeader);
                    } else {
                        LOG.info("This broker is a follower. No leader has been elected yet");
                    }
                }
                if (this.loadSheddingTask != null) {
                    this.loadSheddingTask.cancel();
                    this.loadSheddingTask = null;
                }
                if (this.loadResourceQuotaTask != null) {
                    this.loadResourceQuotaTask.cancel(false);
                    this.loadResourceQuotaTask = null;
                }
            }
        });
        this.leaderElectionService.start();
    }

    protected void acquireSLANamespace() {
        try {
            boolean acquiredSLANamespace;
            NamespaceName nsName = NamespaceService.getSLAMonitorNamespace(this.getBrokerId(), this.config);
            if (!this.pulsarResources.getNamespaceResources().namespaceExists(nsName)) {
                LOG.info("SLA Namespace = {} doesn't exist.", (Object)nsName);
                return;
            }
            try {
                acquiredSLANamespace = this.nsService.registerSLANamespace();
                LOG.info("Register SLA Namespace = {}, returned - {}.", (Object)nsName, (Object)acquiredSLANamespace);
            }
            catch (PulsarServerException e) {
                acquiredSLANamespace = false;
            }
            if (!acquiredSLANamespace) {
                this.nsService.unloadSLANamespace();
            }
        }
        catch (Exception ex) {
            LOG.warn("Exception while trying to unload the SLA namespace, will try to unload the namespace again after 1 minute. Exception:", (Throwable)ex);
            this.executor.schedule(this::acquireSLANamespace, 1L, TimeUnit.MINUTES);
        }
        catch (Throwable ex) {
            LOG.warn("Exception while trying to unload the SLA namespace, will not try to unload the namespace again. Exception:", ex);
        }
    }

    public void waitUntilClosed() throws InterruptedException {
        this.mutex.lock();
        try {
            while (this.state != State.Closed) {
                this.isClosedCondition.await();
            }
        }
        finally {
            this.mutex.unlock();
        }
    }

    protected void startNamespaceService() throws PulsarServerException {
        LOG.info("Starting name space service, bootstrap namespaces=" + this.config.getBootstrapNamespaces());
        this.nsService = this.getNamespaceServiceProvider().get();
    }

    public Supplier<NamespaceService> getNamespaceServiceProvider() throws PulsarServerException {
        return () -> new NamespaceService(this);
    }

    protected void startLoadManagementService() throws PulsarServerException {
        LOG.info("Starting load management service ...");
        this.loadManager.get().start();
        if (this.config.isLoadBalancerEnabled() && !ExtensibleLoadManagerImpl.isLoadManagerExtensionEnabled(this)) {
            LOG.info("Starting load balancer");
            if (this.loadReportTask == null) {
                long loadReportMinInterval = this.config.getLoadBalancerReportUpdateMinIntervalMillis();
                this.loadReportTask = this.loadManagerExecutor.scheduleAtFixedRate(new LoadReportUpdaterTask(this.loadManager), loadReportMinInterval, loadReportMinInterval, TimeUnit.MILLISECONDS);
            }
        }
    }

    public void loadNamespaceTopics(NamespaceBundle bundle) {
        this.executor.submit(() -> {
            LOG.info("Loading all topics on bundle: {}", (Object)bundle);
            NamespaceName nsName = bundle.getNamespaceObject();
            ArrayList<CompletableFuture<Optional<Topic>>> persistentTopics = new ArrayList<CompletableFuture<Optional<Topic>>>();
            long topicLoadStart = System.nanoTime();
            for (String topic : this.getNamespaceService().getListOfPersistentTopics(nsName).get(this.config.getMetadataStoreOperationTimeoutSeconds(), TimeUnit.SECONDS)) {
                try {
                    CompletableFuture<Optional<Topic>> future;
                    TopicName topicName = TopicName.get((String)topic);
                    if (!bundle.includes(topicName) || SystemTopicNames.isTransactionInternalName((TopicName)topicName) || (future = this.brokerService.getTopicIfExists(topic)) == null) continue;
                    persistentTopics.add(future);
                }
                catch (Throwable t) {
                    LOG.warn("Failed to preload topic {}", (Object)topic, (Object)t);
                }
            }
            if (!persistentTopics.isEmpty()) {
                FutureUtil.waitForAll(persistentTopics).thenRun(() -> {
                    double topicLoadTimeSeconds = (double)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - topicLoadStart) / 1000.0;
                    long numTopicsLoaded = persistentTopics.stream().filter(optionalTopicFuture -> optionalTopicFuture.getNow(Optional.empty()).isPresent()).count();
                    LOG.info("Loaded {} topics on {} -- time taken: {} seconds", new Object[]{numTopicsLoaded, bundle, topicLoadTimeSeconds});
                });
            }
            return null;
        });
    }

    public String getStatusFilePath() {
        if (this.config == null) {
            return null;
        }
        return this.config.getStatusFilePath();
    }

    public InternalConfigurationData getInternalConfigurationData() {
        return new InternalConfigurationData(this.config.getMetadataStoreUrl(), this.config.getConfigurationMetadataStoreUrl(), new ClientConfiguration().getZkLedgersRootPath(), this.config.isBookkeeperMetadataStoreSeparated() ? this.config.getBookkeeperMetadataStoreUrl() : null, (String)this.getWorkerConfig().map(WorkerConfig::getStateStorageServiceUrl).orElse(null));
    }

    public boolean isRunning() {
        return this.state == State.Started || this.state == State.Init;
    }

    public LeaderElectionService getLeaderElectionService() {
        if (ExtensibleLoadManagerImpl.isLoadManagerExtensionEnabled(this)) {
            return ExtensibleLoadManagerImpl.get(this.loadManager.get()).getLeaderElectionService();
        }
        return this.leaderElectionService;
    }

    public NamespaceService getNamespaceService() {
        return this.nsService;
    }

    public Optional<WorkerService> getWorkerServiceOpt() {
        return this.functionWorkerService;
    }

    public WorkerService getWorkerService() throws UnsupportedOperationException {
        return this.functionWorkerService.orElseThrow(() -> new UnsupportedOperationException("Pulsar Function Worker is not enabled, probably functionsWorkerEnabled is set to false"));
    }

    public BookKeeper getBookKeeperClient() {
        return this.getManagedLedgerClientFactory().getBookKeeperClient();
    }

    public ManagedLedgerFactory getManagedLedgerFactory() {
        return this.getManagedLedgerClientFactory().getManagedLedgerFactory();
    }

    public LedgerOffloader getManagedLedgerOffloader(NamespaceName namespaceName, OffloadPoliciesImpl offloadPolicies) {
        if (offloadPolicies == null) {
            return this.getDefaultOffloader();
        }
        return this.ledgerOffloaderMap.compute(namespaceName, (ns, offloader) -> {
            try {
                if (offloader != null && Objects.equals(offloader.getOffloadPolicies(), offloadPolicies)) {
                    return offloader;
                }
                if (offloader != null) {
                    offloader.close();
                }
                return this.createManagedLedgerOffloader(offloadPolicies);
            }
            catch (PulsarServerException e) {
                LOG.error("create ledgerOffloader failed for namespace {}", (Object)namespaceName.toString(), (Object)e);
                return new NullLedgerOffloader();
            }
        });
    }

    public LedgerOffloader createManagedLedgerOffloader(OffloadPoliciesImpl offloadPolicies) throws PulsarServerException {
        try {
            if (StringUtils.isNotBlank((CharSequence)offloadPolicies.getManagedLedgerOffloadDriver())) {
                Preconditions.checkNotNull((Object)offloadPolicies.getOffloadersDirectory(), (String)"Offloader driver is configured to be '%s' but no offloaders directory is configured.", (Object)offloadPolicies.getManagedLedgerOffloadDriver());
                PulsarService pulsarService = this;
                synchronized (pulsarService) {
                    Offloaders offloaders = this.offloadersCache.getOrLoadOffloaders(offloadPolicies.getOffloadersDirectory(), this.config.getNarExtractionDirectory());
                    LedgerOffloaderFactory offloaderFactory = offloaders.getOffloaderFactory(offloadPolicies.getManagedLedgerOffloadDriver());
                    try {
                        return offloaderFactory.create(offloadPolicies, Map.of("S3ManagedLedgerOffloaderSoftwareVersion".toLowerCase(), PulsarVersion.getVersion(), "S3ManagedLedgerOffloaderSoftwareGitSha".toLowerCase(), PulsarVersion.getGitSha(), "pulsarClusterName".toLowerCase(), this.config.getClusterName()), this.schemaStorage, this.getOffloaderScheduler(offloadPolicies), this.offloaderStats);
                    }
                    catch (IOException ioe) {
                        throw new PulsarServerException(ioe.getMessage(), ioe.getCause());
                    }
                }
            }
            LOG.debug("No ledger offloader configured, using NULL instance");
            return NullLedgerOffloader.INSTANCE;
        }
        catch (Throwable t) {
            throw new PulsarServerException(t);
        }
    }

    private SchemaStorage createAndStartSchemaStorage() throws Exception {
        SchemaStorageFactory factoryInstance = (SchemaStorageFactory)Reflections.createInstance((String)this.config.getSchemaRegistryStorageClassName(), SchemaStorageFactory.class, (ClassLoader)Thread.currentThread().getContextClassLoader());
        SchemaStorage schemaStorage = factoryInstance.create(this);
        schemaStorage.start();
        return schemaStorage;
    }

    public BookKeeperClientFactory newBookKeeperClientFactory() {
        return new BookKeeperClientFactoryImpl();
    }

    public BookKeeperClientFactory getBookKeeperClientFactory() {
        return this.bkClientFactory;
    }

    public synchronized ScheduledExecutorService getCompactorExecutor() {
        if (this.compactorExecutor == null) {
            this.compactorExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new ExecutorProvider.ExtendedThreadFactory("compaction"));
        }
        return this.compactorExecutor;
    }

    public Compactor getNullableCompactor() {
        CompactionServiceFactory compactionServiceFactory = this.compactionServiceFactory;
        if (compactionServiceFactory instanceof PulsarCompactionServiceFactory) {
            PulsarCompactionServiceFactory pulsarCompactedServiceFactory = (PulsarCompactionServiceFactory)compactionServiceFactory;
            return pulsarCompactedServiceFactory.getNullableCompactor();
        }
        return null;
    }

    public StrategicTwoPhaseCompactor newStrategicCompactor() throws PulsarServerException {
        return new StrategicTwoPhaseCompactor(this.getConfiguration(), this.getClient(), this.getBookKeeperClient(), this.getCompactorExecutor());
    }

    public synchronized StrategicTwoPhaseCompactor getStrategicCompactor() throws PulsarServerException {
        if (this.strategicCompactor == null) {
            this.strategicCompactor = this.newStrategicCompactor();
        }
        return this.strategicCompactor;
    }

    protected synchronized OrderedScheduler getOffloaderScheduler(OffloadPoliciesImpl offloadPolicies) {
        if (this.offloaderScheduler == null) {
            this.offloaderScheduler = (OrderedScheduler)OrderedScheduler.newSchedulerBuilder().numThreads(offloadPolicies.getManagedLedgerOffloadMaxThreads().intValue()).name("offloader").build();
        }
        return this.offloaderScheduler;
    }

    public PulsarClientImpl createClientImpl(ClientConfigurationData clientConf) throws PulsarClientException {
        return PulsarClientImpl.builder().conf(clientConf).eventLoopGroup(this.ioEventLoopGroup).timer(this.brokerClientSharedTimer).internalExecutorProvider(this.brokerClientSharedInternalExecutorProvider).externalExecutorProvider(this.brokerClientSharedExternalExecutorProvider).scheduledExecutorProvider(this.brokerClientSharedScheduledExecutorProvider).build();
    }

    public synchronized PulsarClient getClient() throws PulsarServerException {
        if (this.client == null) {
            try {
                ClientConfigurationData initialConf = new ClientConfigurationData();
                initialConf.setMemoryLimitBytes(0L);
                initialConf.setStatsIntervalSeconds(0L);
                Map overrides = PropertiesUtils.filterAndMapProperties((Properties)this.getConfiguration().getProperties(), (String)"brokerClient_");
                ClientConfigurationData conf = (ClientConfigurationData)ConfigurationDataUtils.loadData((Map)overrides, (Object)initialConf, ClientConfigurationData.class);
                conf.setConnectionMaxIdleSeconds(-1);
                boolean tlsEnabled = this.getConfiguration().isBrokerClientTlsEnabled();
                conf.setServiceUrl(tlsEnabled ? this.brokerServiceUrlTls : this.brokerServiceUrl);
                if (tlsEnabled) {
                    conf.setTlsCiphers(this.getConfiguration().getBrokerClientTlsCiphers());
                    conf.setTlsProtocols(this.getConfiguration().getBrokerClientTlsProtocols());
                    conf.setTlsAllowInsecureConnection(this.getConfiguration().isTlsAllowInsecureConnection());
                    conf.setTlsHostnameVerificationEnable(this.getConfiguration().isTlsHostnameVerificationEnabled());
                    if (this.getConfiguration().isBrokerClientTlsEnabledWithKeyStore()) {
                        conf.setUseKeyStoreTls(true);
                        conf.setTlsTrustStoreType(this.getConfiguration().getBrokerClientTlsTrustStoreType());
                        conf.setTlsTrustStorePath(this.getConfiguration().getBrokerClientTlsTrustStore());
                        conf.setTlsTrustStorePassword(this.getConfiguration().getBrokerClientTlsTrustStorePassword());
                        conf.setTlsKeyStoreType(this.getConfiguration().getBrokerClientTlsKeyStoreType());
                        conf.setTlsKeyStorePath(this.getConfiguration().getBrokerClientTlsKeyStore());
                        conf.setTlsKeyStorePassword(this.getConfiguration().getBrokerClientTlsKeyStorePassword());
                    } else {
                        conf.setTlsTrustCertsFilePath(StringUtils.isNotBlank((CharSequence)this.getConfiguration().getBrokerClientTrustCertsFilePath()) ? this.getConfiguration().getBrokerClientTrustCertsFilePath() : this.getConfiguration().getTlsTrustCertsFilePath());
                        conf.setTlsKeyFilePath(this.getConfiguration().getBrokerClientKeyFilePath());
                        conf.setTlsCertificateFilePath(this.getConfiguration().getBrokerClientCertificateFilePath());
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)this.getConfiguration().getBrokerClientAuthenticationPlugin())) {
                    conf.setAuthPluginClassName(this.getConfiguration().getBrokerClientAuthenticationPlugin());
                    conf.setAuthParams(this.getConfiguration().getBrokerClientAuthenticationParameters());
                    conf.setAuthParamMap(null);
                    conf.setAuthentication(AuthenticationFactory.create((String)this.getConfiguration().getBrokerClientAuthenticationPlugin(), (String)this.getConfiguration().getBrokerClientAuthenticationParameters()));
                }
                this.client = this.createClientImpl(conf);
            }
            catch (Exception e) {
                throw new PulsarServerException((Throwable)e);
            }
        }
        return this.client;
    }

    public synchronized PulsarAdmin getAdminClient() throws PulsarServerException {
        if (this.adminClient == null) {
            try {
                String adminApiUrl;
                ServiceConfiguration conf = this.getConfiguration();
                String string = adminApiUrl = conf.isBrokerClientTlsEnabled() ? this.webServiceAddressTls : this.webServiceAddress;
                if (adminApiUrl == null) {
                    throw new IllegalArgumentException("Web service address was not set properly , isBrokerClientTlsEnabled: " + conf.isBrokerClientTlsEnabled() + ", webServiceAddressTls: " + this.webServiceAddressTls + ", webServiceAddress: " + this.webServiceAddress);
                }
                PulsarAdminBuilder builder = PulsarAdmin.builder().serviceHttpUrl(adminApiUrl);
                builder.loadConf(PropertiesUtils.filterAndMapProperties((Properties)this.config.getProperties(), (String)"brokerClient_"));
                builder.authentication(conf.getBrokerClientAuthenticationPlugin(), conf.getBrokerClientAuthenticationParameters());
                if (conf.isBrokerClientTlsEnabled()) {
                    builder.tlsCiphers(this.config.getBrokerClientTlsCiphers()).tlsProtocols(this.config.getBrokerClientTlsProtocols());
                    if (conf.isBrokerClientTlsEnabledWithKeyStore()) {
                        builder.useKeyStoreTls(true).tlsTrustStoreType(conf.getBrokerClientTlsTrustStoreType()).tlsTrustStorePath(conf.getBrokerClientTlsTrustStore()).tlsTrustStorePassword(conf.getBrokerClientTlsTrustStorePassword()).tlsKeyStoreType(conf.getBrokerClientTlsKeyStoreType()).tlsKeyStorePath(conf.getBrokerClientTlsKeyStore()).tlsKeyStorePassword(conf.getBrokerClientTlsKeyStorePassword());
                    } else {
                        builder.tlsTrustCertsFilePath(conf.getBrokerClientTrustCertsFilePath()).tlsKeyFilePath(conf.getBrokerClientKeyFilePath()).tlsCertificateFilePath(conf.getBrokerClientCertificateFilePath());
                    }
                    builder.allowTlsInsecureConnection(conf.isTlsAllowInsecureConnection()).enableTlsHostnameVerification(conf.isTlsHostnameVerificationEnabled());
                }
                builder.readTimeout(conf.getMetadataStoreOperationTimeoutSeconds(), TimeUnit.SECONDS);
                this.adminClient = builder.build();
                LOG.info("created admin with url {} ", (Object)adminApiUrl);
            }
            catch (Exception e) {
                throw new PulsarServerException((Throwable)e);
            }
        }
        return this.adminClient;
    }

    protected String brokerUrl(ServiceConfiguration config) {
        AdvertisedListener internalListener = ServiceConfigurationUtils.getInternalListener((ServiceConfiguration)config, (String)"pulsar");
        return internalListener.getBrokerServiceUrl() != null ? internalListener.getBrokerServiceUrl().toString() : null;
    }

    public static String brokerUrl(String host, int port) {
        return ServiceConfigurationUtils.brokerUrl((String)host, (int)port);
    }

    public String brokerUrlTls(ServiceConfiguration config) {
        AdvertisedListener internalListener = ServiceConfigurationUtils.getInternalListener((ServiceConfiguration)config, (String)"pulsar+ssl");
        return internalListener.getBrokerServiceUrlTls() != null ? internalListener.getBrokerServiceUrlTls().toString() : null;
    }

    public static String brokerUrlTls(String host, int port) {
        return ServiceConfigurationUtils.brokerUrlTls((String)host, (int)port);
    }

    public String webAddress(ServiceConfiguration config) {
        if (config.getWebServicePort().isPresent()) {
            AdvertisedListener internalListener = ServiceConfigurationUtils.getInternalListener((ServiceConfiguration)config, (String)"http");
            return internalListener.getBrokerHttpUrl() != null ? internalListener.getBrokerHttpUrl().toString() : PulsarService.webAddress(ServiceConfigurationUtils.getWebServiceAddress((ServiceConfiguration)config), this.getListenPortHTTP().orElseThrow());
        }
        return null;
    }

    public static String webAddress(String host, int port) {
        return String.format("http://%s:%d", host, port);
    }

    public String webAddressTls(ServiceConfiguration config) {
        if (config.getWebServicePortTls().isPresent()) {
            AdvertisedListener internalListener = ServiceConfigurationUtils.getInternalListener((ServiceConfiguration)config, (String)"https");
            return internalListener.getBrokerHttpsUrl() != null ? internalListener.getBrokerHttpsUrl().toString() : PulsarService.webAddressTls(ServiceConfigurationUtils.getWebServiceAddress((ServiceConfiguration)config), this.getListenPortHTTPS().orElseThrow());
        }
        return null;
    }

    public static String webAddressTls(String host, int port) {
        return String.format("https://%s:%d", host, port);
    }

    public String getSafeWebServiceAddress() {
        return this.webServiceAddressTls != null ? this.webServiceAddressTls : this.webServiceAddress;
    }

    @Deprecated
    public String getSafeBrokerServiceUrl() {
        return this.brokerServiceUrlTls != null ? this.brokerServiceUrlTls : this.brokerServiceUrl;
    }

    public String getBrokerId() {
        return Objects.requireNonNull(this.brokerId, "brokerId is not initialized before start has been called");
    }

    public synchronized void addPrometheusRawMetricsProvider(PrometheusRawMetricsProvider metricsProvider) {
        if (this.metricsServlet == null) {
            if (this.pendingMetricsProviders == null) {
                this.pendingMetricsProviders = new LinkedList<PrometheusRawMetricsProvider>();
            }
            this.pendingMetricsProviders.add(metricsProvider);
        } else {
            this.metricsServlet.addRawMetricsProvider(metricsProvider);
        }
    }

    private void startWorkerService(AuthenticationService authenticationService, AuthorizationService authorizationService) throws Exception {
        if (this.functionWorkerService.isPresent()) {
            if (this.workerConfig.isUseTls() || this.brokerServiceUrl == null) {
                this.workerConfig.setPulsarServiceUrl(this.brokerServiceUrlTls);
            } else {
                this.workerConfig.setPulsarServiceUrl(this.brokerServiceUrl);
            }
            if (this.workerConfig.isUseTls() || this.webServiceAddress == null) {
                this.workerConfig.setPulsarWebServiceUrl(this.webServiceAddressTls);
                this.workerConfig.setFunctionWebServiceUrl(this.webServiceAddressTls);
            } else {
                this.workerConfig.setPulsarWebServiceUrl(this.webServiceAddress);
                this.workerConfig.setFunctionWebServiceUrl(this.webServiceAddress);
            }
            LOG.info("Starting function worker service: serviceUrl = {}, webServiceUrl = {}, functionWebServiceUrl = {}", new Object[]{this.workerConfig.getPulsarServiceUrl(), this.workerConfig.getPulsarWebServiceUrl(), this.workerConfig.getFunctionWebServiceUrl()});
            this.functionWorkerService.get().initInBroker(this.config, this.workerConfig, this.pulsarResources, this.getInternalConfigurationData());
            this.functionWorkerService.get().start(authenticationService, authorizationService, ErrorNotifier.getShutdownServiceImpl((ShutdownService)this));
            LOG.info("Function worker service started");
        }
    }

    public PackagesManagement getPackagesManagement() throws UnsupportedOperationException {
        if (this.packagesManagement == null) {
            throw new UnsupportedOperationException("Package Management Service is not enabled in the broker.");
        }
        return this.packagesManagement;
    }

    private void startPackagesManagementService() throws IOException {
        this.packagesManagement = new PackagesManagementImpl();
        PackagesStorageProvider storageProvider = PackagesStorageProvider.newProvider((String)this.config.getPackagesManagementStorageProvider());
        DefaultPackagesStorageConfiguration storageConfiguration = new DefaultPackagesStorageConfiguration();
        storageConfiguration.setProperty(this.config.getProperties());
        PackagesStorage storage = storageProvider.getStorage((PackagesStorageConfiguration)storageConfiguration);
        storage.initialize();
        this.packagesManagement.initialize(storage);
    }

    public Optional<Integer> getListenPortHTTP() {
        return this.webService.getListenPortHTTP();
    }

    public Optional<Integer> getListenPortHTTPS() {
        return this.webService.getListenPortHTTPS();
    }

    public Optional<Integer> getBrokerListenPort() {
        return this.brokerService.getListenPort();
    }

    public Optional<Integer> getBrokerListenPortTls() {
        return this.brokerService.getListenPortTls();
    }

    public MonotonicSnapshotClock getMonotonicSnapshotClock() {
        return this.monotonicSnapshotClock;
    }

    public static WorkerConfig initializeWorkerConfigFromBrokerConfig(ServiceConfiguration brokerConfig, String workerConfigFile) throws IOException {
        WorkerConfig workerConfig = WorkerConfig.load((String)workerConfigFile);
        workerConfig.setWorkerPort((Integer)brokerConfig.getWebServicePort().orElse(null));
        workerConfig.setWorkerPortTls((Integer)brokerConfig.getWebServicePortTls().orElse(null));
        String hostname = ServiceConfigurationUtils.getDefaultOrConfiguredAddress((String)brokerConfig.getAdvertisedAddress());
        workerConfig.setWorkerHostname(hostname);
        workerConfig.setPulsarFunctionsCluster(brokerConfig.getClusterName());
        workerConfig.setAuthenticationEnabled(brokerConfig.isAuthenticationEnabled());
        workerConfig.setAuthenticationProviders(brokerConfig.getAuthenticationProviders());
        workerConfig.setAuthorizationEnabled(brokerConfig.isAuthorizationEnabled());
        workerConfig.setAuthorizationProvider(brokerConfig.getAuthorizationProvider());
        workerConfig.setConfigurationMetadataStoreUrl(brokerConfig.getConfigurationMetadataStoreUrl());
        workerConfig.setMetadataStoreSessionTimeoutMillis(brokerConfig.getMetadataStoreSessionTimeoutMillis());
        workerConfig.setMetadataStoreOperationTimeoutSeconds(brokerConfig.getMetadataStoreOperationTimeoutSeconds());
        workerConfig.setMetadataStoreCacheExpirySeconds(brokerConfig.getMetadataStoreCacheExpirySeconds());
        workerConfig.setTlsAllowInsecureConnection(brokerConfig.isTlsAllowInsecureConnection());
        workerConfig.setTlsEnabled(brokerConfig.isTlsEnabled());
        workerConfig.setTlsEnableHostnameVerification(brokerConfig.isTlsHostnameVerificationEnabled());
        workerConfig.setBrokerClientTrustCertsFilePath(brokerConfig.getBrokerClientTrustCertsFilePath());
        workerConfig.setTlsTrustCertsFilePath(brokerConfig.getTlsTrustCertsFilePath());
        workerConfig.setBrokerClientAuthenticationPlugin(brokerConfig.getBrokerClientAuthenticationPlugin());
        workerConfig.setBrokerClientAuthenticationParameters(brokerConfig.getBrokerClientAuthenticationParameters());
        workerConfig.setSuperUserRoles(brokerConfig.getSuperUserRoles());
        workerConfig.setProxyRoles(brokerConfig.getProxyRoles());
        workerConfig.setFunctionsWorkerEnablePackageManagement(brokerConfig.isFunctionsWorkerEnablePackageManagement());
        if (StringUtils.isBlank((CharSequence)workerConfig.getFunctionsWorkerServiceNarPackage())) {
            workerConfig.setFunctionsWorkerServiceNarPackage(brokerConfig.getFunctionsWorkerServiceNarPackage());
        }
        workerConfig.setWorkerId("c-" + brokerConfig.getClusterName() + "-fw-" + hostname + "-" + (workerConfig.getTlsEnabled() ? workerConfig.getWorkerPortTls() : workerConfig.getWorkerPort()));
        return workerConfig;
    }

    public void shutdownNow() {
        LOG.info("Invoking Pulsar service immediate shutdown");
        try {
            this.closeMetadataServiceSession();
        }
        catch (Exception e) {
            LOG.warn("Failed to close metadata service session: {}", (Object)e.getMessage());
        }
        this.processTerminator.accept(-1);
    }

    @VisibleForTesting
    protected BrokerService newBrokerService(PulsarService pulsar) throws Exception {
        return new BrokerService(pulsar, this.ioEventLoopGroup);
    }

    private CompactionServiceFactory loadCompactionServiceFactory() {
        String compactionServiceFactoryClassName = this.config.getCompactionServiceFactoryClassName();
        CompactionServiceFactory compactionServiceFactory = (CompactionServiceFactory)Reflections.createInstance((String)compactionServiceFactoryClassName, CompactionServiceFactory.class, (ClassLoader)Thread.currentThread().getContextClassLoader());
        compactionServiceFactory.initialize(this).join();
        return compactionServiceFactory;
    }

    public CompletableFuture<TopicCompactionService> newTopicCompactionService(String topic) {
        try {
            CompactionServiceFactory compactionServiceFactory = this.getCompactionServiceFactory();
            return compactionServiceFactory.newTopicCompactionService(topic);
        }
        catch (Throwable e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    public ServiceConfiguration getConfig() {
        return this.config;
    }

    public NamespaceService getNsService() {
        return this.nsService;
    }

    public ManagedLedgerStorage getManagedLedgerClientFactory() {
        return this.managedLedgerClientFactory;
    }

    public BrokerService getBrokerService() {
        return this.brokerService;
    }

    public WebService getWebService() {
        return this.webService;
    }

    public WebSocketService getWebSocketService() {
        return this.webSocketService;
    }

    public TopicPoliciesService getTopicPoliciesService() {
        return this.topicPoliciesService;
    }

    public BookKeeperClientFactory getBkClientFactory() {
        return this.bkClientFactory;
    }

    public CompactionServiceFactory getCompactionServiceFactory() {
        return this.compactionServiceFactory;
    }

    public ResourceUsageTransportManager getResourceUsageTransportManager() {
        return this.resourceUsageTransportManager;
    }

    public ResourceGroupService getResourceGroupServiceManager() {
        return this.resourceGroupServiceManager;
    }

    public ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    public OrderedExecutor getOrderedExecutor() {
        return this.orderedExecutor;
    }

    public ScheduledExecutorService getLoadManagerExecutor() {
        return this.loadManagerExecutor;
    }

    public OrderedScheduler getOffloaderScheduler() {
        return this.offloaderScheduler;
    }

    public OffloadersCache getOffloadersCache() {
        return this.offloadersCache;
    }

    public LedgerOffloader getDefaultOffloader() {
        return this.defaultOffloader;
    }

    public LedgerOffloaderStats getOffloaderStats() {
        return this.offloaderStats;
    }

    public Map<NamespaceName, LedgerOffloader> getLedgerOffloaderMap() {
        return this.ledgerOffloaderMap;
    }

    public ScheduledFuture<?> getLoadReportTask() {
        return this.loadReportTask;
    }

    public LoadSheddingTask getLoadSheddingTask() {
        return this.loadSheddingTask;
    }

    public ScheduledFuture<?> getLoadResourceQuotaTask() {
        return this.loadResourceQuotaTask;
    }

    public AtomicReference<LoadManager> getLoadManager() {
        return this.loadManager;
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    public String getAdvertisedAddress() {
        return this.advertisedAddress;
    }

    public String getWebServiceAddress() {
        return this.webServiceAddress;
    }

    public String getWebServiceAddressTls() {
        return this.webServiceAddressTls;
    }

    public String getBrokerServiceUrl() {
        return this.brokerServiceUrl;
    }

    public String getBrokerServiceUrlTls() {
        return this.brokerServiceUrlTls;
    }

    public String getBrokerVersion() {
        return this.brokerVersion;
    }

    public SchemaStorage getSchemaStorage() {
        return this.schemaStorage;
    }

    public SchemaRegistryService getSchemaRegistryService() {
        return this.schemaRegistryService;
    }

    public Optional<WorkerService> getFunctionWorkerService() {
        return this.functionWorkerService;
    }

    public ProtocolHandlers getProtocolHandlers() {
        return this.protocolHandlers;
    }

    public Consumer<Integer> getProcessTerminator() {
        return this.processTerminator;
    }

    public EventLoopGroup getIoEventLoopGroup() {
        return this.ioEventLoopGroup;
    }

    public ExecutorProvider getBrokerClientSharedInternalExecutorProvider() {
        return this.brokerClientSharedInternalExecutorProvider;
    }

    public ExecutorProvider getBrokerClientSharedExternalExecutorProvider() {
        return this.brokerClientSharedExternalExecutorProvider;
    }

    public ScheduledExecutorProvider getBrokerClientSharedScheduledExecutorProvider() {
        return this.brokerClientSharedScheduledExecutorProvider;
    }

    public Timer getBrokerClientSharedTimer() {
        return this.brokerClientSharedTimer;
    }

    public MetricsGenerator getMetricsGenerator() {
        return this.metricsGenerator;
    }

    public TransactionMetadataStoreService getTransactionMetadataStoreService() {
        return this.transactionMetadataStoreService;
    }

    public TransactionBufferProvider getTransactionBufferProvider() {
        return this.transactionBufferProvider;
    }

    public TransactionBufferClient getTransactionBufferClient() {
        return this.transactionBufferClient;
    }

    public HashedWheelTimer getTransactionTimer() {
        return this.transactionTimer;
    }

    public BrokerInterceptor getBrokerInterceptor() {
        return this.brokerInterceptor;
    }

    public AdditionalServlets getBrokerAdditionalServlets() {
        return this.brokerAdditionalServlets;
    }

    public PulsarPrometheusMetricsServlet getMetricsServlet() {
        return this.metricsServlet;
    }

    public List<PrometheusRawMetricsProvider> getPendingMetricsProviders() {
        return this.pendingMetricsProviders;
    }

    public MetadataStoreExtended getLocalMetadataStore() {
        return this.localMetadataStore;
    }

    public PulsarMetadataEventSynchronizer getLocalMetadataSynchronizer() {
        return this.localMetadataSynchronizer;
    }

    public CoordinationService getCoordinationService() {
        return this.coordinationService;
    }

    public TransactionBufferSnapshotServiceFactory getTransactionBufferSnapshotServiceFactory() {
        return this.transactionBufferSnapshotServiceFactory;
    }

    public MetadataStore getConfigurationMetadataStore() {
        return this.configurationMetadataStore;
    }

    public PulsarMetadataEventSynchronizer getConfigMetadataSynchronizer() {
        return this.configMetadataSynchronizer;
    }

    public boolean isShouldShutdownConfigurationMetadataStore() {
        return this.shouldShutdownConfigurationMetadataStore;
    }

    public PulsarResources getPulsarResources() {
        return this.pulsarResources;
    }

    public TransactionPendingAckStoreProvider getTransactionPendingAckStoreProvider() {
        return this.transactionPendingAckStoreProvider;
    }

    public ExecutorProvider getTransactionExecutorProvider() {
        return this.transactionExecutorProvider;
    }

    public State getState() {
        return this.state;
    }

    public ReentrantLock getMutex() {
        return this.mutex;
    }

    public Condition getIsClosedCondition() {
        return this.isClosedCondition;
    }

    public CompletableFuture<Void> getCloseFuture() {
        return this.closeFuture;
    }

    public Map<String, AdvertisedListener> getAdvertisedListeners() {
        return this.advertisedListeners;
    }

    protected void setNsService(NamespaceService nsService) {
        this.nsService = nsService;
    }

    protected void setManagedLedgerClientFactory(ManagedLedgerStorage managedLedgerClientFactory) {
        this.managedLedgerClientFactory = managedLedgerClientFactory;
    }

    protected void setLeaderElectionService(LeaderElectionService leaderElectionService) {
        this.leaderElectionService = leaderElectionService;
    }

    protected void setBrokerService(BrokerService brokerService) {
        this.brokerService = brokerService;
    }

    protected void setWebService(WebService webService) {
        this.webService = webService;
    }

    protected void setWebSocketService(WebSocketService webSocketService) {
        this.webSocketService = webSocketService;
    }

    protected void setTopicPoliciesService(TopicPoliciesService topicPoliciesService) {
        this.topicPoliciesService = topicPoliciesService;
    }

    protected void setBkClientFactory(BookKeeperClientFactory bkClientFactory) {
        this.bkClientFactory = bkClientFactory;
    }

    protected void setCompactionServiceFactory(CompactionServiceFactory compactionServiceFactory) {
        this.compactionServiceFactory = compactionServiceFactory;
    }

    protected void setStrategicCompactor(StrategicTwoPhaseCompactor strategicCompactor) {
        this.strategicCompactor = strategicCompactor;
    }

    protected void setResourceUsageTransportManager(ResourceUsageTransportManager resourceUsageTransportManager) {
        this.resourceUsageTransportManager = resourceUsageTransportManager;
    }

    protected void setResourceGroupServiceManager(ResourceGroupService resourceGroupServiceManager) {
        this.resourceGroupServiceManager = resourceGroupServiceManager;
    }

    protected void setOrderedExecutor(OrderedExecutor orderedExecutor) {
        this.orderedExecutor = orderedExecutor;
    }

    protected void setCompactorExecutor(ScheduledExecutorService compactorExecutor) {
        this.compactorExecutor = compactorExecutor;
    }

    protected void setOffloaderScheduler(OrderedScheduler offloaderScheduler) {
        this.offloaderScheduler = offloaderScheduler;
    }

    protected void setOffloadersCache(OffloadersCache offloadersCache) {
        this.offloadersCache = offloadersCache;
    }

    protected void setDefaultOffloader(LedgerOffloader defaultOffloader) {
        this.defaultOffloader = defaultOffloader;
    }

    protected void setOffloaderStats(LedgerOffloaderStats offloaderStats) {
        this.offloaderStats = offloaderStats;
    }

    protected void setLedgerOffloaderMap(Map<NamespaceName, LedgerOffloader> ledgerOffloaderMap) {
        this.ledgerOffloaderMap = ledgerOffloaderMap;
    }

    protected void setLoadReportTask(ScheduledFuture<?> loadReportTask) {
        this.loadReportTask = loadReportTask;
    }

    protected void setLoadSheddingTask(LoadSheddingTask loadSheddingTask) {
        this.loadSheddingTask = loadSheddingTask;
    }

    protected void setLoadResourceQuotaTask(ScheduledFuture<?> loadResourceQuotaTask) {
        this.loadResourceQuotaTask = loadResourceQuotaTask;
    }

    protected void setAdminClient(PulsarAdmin adminClient) {
        this.adminClient = adminClient;
    }

    protected void setClient(PulsarClient client) {
        this.client = client;
    }

    protected void setWebServiceAddress(String webServiceAddress) {
        this.webServiceAddress = webServiceAddress;
    }

    protected void setWebServiceAddressTls(String webServiceAddressTls) {
        this.webServiceAddressTls = webServiceAddressTls;
    }

    protected void setBrokerServiceUrl(String brokerServiceUrl) {
        this.brokerServiceUrl = brokerServiceUrl;
    }

    protected void setBrokerServiceUrlTls(String brokerServiceUrlTls) {
        this.brokerServiceUrlTls = brokerServiceUrlTls;
    }

    protected void setSchemaStorage(SchemaStorage schemaStorage) {
        this.schemaStorage = schemaStorage;
    }

    protected void setSchemaRegistryService(SchemaRegistryService schemaRegistryService) {
        this.schemaRegistryService = schemaRegistryService;
    }

    protected void setProtocolHandlers(ProtocolHandlers protocolHandlers) {
        this.protocolHandlers = protocolHandlers;
    }

    protected void setMetricsGenerator(MetricsGenerator metricsGenerator) {
        this.metricsGenerator = metricsGenerator;
    }

    protected void setTransactionMetadataStoreService(TransactionMetadataStoreService transactionMetadataStoreService) {
        this.transactionMetadataStoreService = transactionMetadataStoreService;
    }

    protected void setTransactionBufferProvider(TransactionBufferProvider transactionBufferProvider) {
        this.transactionBufferProvider = transactionBufferProvider;
    }

    protected void setTransactionBufferClient(TransactionBufferClient transactionBufferClient) {
        this.transactionBufferClient = transactionBufferClient;
    }

    protected void setTransactionTimer(HashedWheelTimer transactionTimer) {
        this.transactionTimer = transactionTimer;
    }

    protected void setBrokerInterceptor(BrokerInterceptor brokerInterceptor) {
        this.brokerInterceptor = brokerInterceptor;
    }

    protected void setBrokerAdditionalServlets(AdditionalServlets brokerAdditionalServlets) {
        this.brokerAdditionalServlets = brokerAdditionalServlets;
    }

    protected void setPackagesManagement(PackagesManagement packagesManagement) {
        this.packagesManagement = packagesManagement;
    }

    protected void setMetricsServlet(PulsarPrometheusMetricsServlet metricsServlet) {
        this.metricsServlet = metricsServlet;
    }

    protected void setPendingMetricsProviders(List<PrometheusRawMetricsProvider> pendingMetricsProviders) {
        this.pendingMetricsProviders = pendingMetricsProviders;
    }

    protected void setLocalMetadataStore(MetadataStoreExtended localMetadataStore) {
        this.localMetadataStore = localMetadataStore;
    }

    protected void setLocalMetadataSynchronizer(PulsarMetadataEventSynchronizer localMetadataSynchronizer) {
        this.localMetadataSynchronizer = localMetadataSynchronizer;
    }

    protected void setCoordinationService(CoordinationService coordinationService) {
        this.coordinationService = coordinationService;
    }

    protected void setTransactionBufferSnapshotServiceFactory(TransactionBufferSnapshotServiceFactory transactionBufferSnapshotServiceFactory) {
        this.transactionBufferSnapshotServiceFactory = transactionBufferSnapshotServiceFactory;
    }

    protected void setConfigurationMetadataStore(MetadataStore configurationMetadataStore) {
        this.configurationMetadataStore = configurationMetadataStore;
    }

    protected void setConfigMetadataSynchronizer(PulsarMetadataEventSynchronizer configMetadataSynchronizer) {
        this.configMetadataSynchronizer = configMetadataSynchronizer;
    }

    protected void setShouldShutdownConfigurationMetadataStore(boolean shouldShutdownConfigurationMetadataStore) {
        this.shouldShutdownConfigurationMetadataStore = shouldShutdownConfigurationMetadataStore;
    }

    protected void setPulsarResources(PulsarResources pulsarResources) {
        this.pulsarResources = pulsarResources;
    }

    protected void setTransactionPendingAckStoreProvider(TransactionPendingAckStoreProvider transactionPendingAckStoreProvider) {
        this.transactionPendingAckStoreProvider = transactionPendingAckStoreProvider;
    }

    protected void setBrokerId(String brokerId) {
        this.brokerId = brokerId;
    }

    protected void setState(State state) {
        this.state = state;
    }

    protected void setCloseFuture(CompletableFuture<Void> closeFuture) {
        this.closeFuture = closeFuture;
    }

    protected void setAdvertisedListeners(Map<String, AdvertisedListener> advertisedListeners) {
        this.advertisedListeners = advertisedListeners;
    }

    public static enum State {
        Init,
        Started,
        Closing,
        Closed;

    }
}

