/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.extensions;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.loadbalance.extensions.data.BrokerLookupData;
import org.apache.pulsar.common.classification.InterfaceAudience;
import org.apache.pulsar.common.classification.InterfaceStability;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.NotificationType;

@InterfaceAudience.LimitedPrivate
@InterfaceStability.Unstable
public interface BrokerRegistry
extends AutoCloseable {
    public void start() throws PulsarServerException;

    public boolean isStarted();

    public CompletableFuture<Void> registerAsync();

    public void unregister() throws MetadataStoreException;

    public String getBrokerId();

    public CompletableFuture<List<String>> getAvailableBrokersAsync();

    public CompletableFuture<Optional<BrokerLookupData>> lookupAsync(String var1);

    public CompletableFuture<Map<String, BrokerLookupData>> getAvailableBrokerLookupDataAsync();

    public void addListener(BiConsumer<String, NotificationType> var1);

    @Override
    public void close() throws PulsarServerException;
}

