/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.plugin;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.pulsar.broker.service.plugin.EntryFilter;
import org.apache.pulsar.broker.service.plugin.FilterContext;
import org.apache.pulsar.common.nar.NarClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryFilterWithClassLoader
implements EntryFilter {
    private static final Logger log = LoggerFactory.getLogger(EntryFilterWithClassLoader.class);
    private final EntryFilter entryFilter;
    private final NarClassLoader classLoader;
    private final boolean classLoaderOwned;

    public EntryFilterWithClassLoader(EntryFilter entryFilter, NarClassLoader classLoader, boolean classLoaderOwned) {
        this.entryFilter = entryFilter;
        this.classLoader = classLoader;
        this.classLoaderOwned = classLoaderOwned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EntryFilter.FilterResult filterEntry(Entry entry, FilterContext context) {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.classLoader);
            EntryFilter.FilterResult filterResult = this.entryFilter.filterEntry(entry, context);
            return filterResult;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    @VisibleForTesting
    public EntryFilter getEntryFilter() {
        return this.entryFilter;
    }

    @Override
    public void close() {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.classLoader);
            this.entryFilter.close();
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
        if (this.classLoaderOwned) {
            log.info("Closing classloader {} for EntryFilter {}", (Object)this.classLoader, (Object)this.entryFilter.getClass().getName());
            try {
                this.classLoader.close();
            }
            catch (IOException e) {
                log.error("close EntryFilterWithClassLoader failed", (Throwable)e);
            }
        }
    }

    public String toString() {
        return "EntryFilterWithClassLoader(entryFilter=" + String.valueOf(this.getEntryFilter()) + ", classLoader=" + String.valueOf(this.classLoader) + ", classLoaderOwned=" + this.classLoaderOwned + ")";
    }
}

