/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.namespace;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.pulsar.policies.data.loadbalancer.AdvertisedListener;

public class NamespaceEphemeralData {
    private String nativeUrl;
    private String nativeUrlTls;
    private String httpUrl;
    private String httpUrlTls;
    private boolean disabled;
    private Map<String, AdvertisedListener> advertisedListeners;

    public NamespaceEphemeralData(String brokerUrl, String brokerUrlTls, String httpUrl, String httpUrlTls, boolean disabled) {
        this(brokerUrl, brokerUrlTls, httpUrl, httpUrlTls, disabled, null);
    }

    public NamespaceEphemeralData(String brokerUrl, String brokerUrlTls, String httpUrl, String httpUrlTls, boolean disabled, Map<String, AdvertisedListener> advertisedListeners) {
        this.nativeUrl = brokerUrl;
        this.nativeUrlTls = brokerUrlTls;
        this.httpUrl = httpUrl;
        this.httpUrlTls = httpUrlTls;
        this.disabled = disabled;
        this.advertisedListeners = advertisedListeners == null ? Collections.emptyMap() : new HashMap<String, AdvertisedListener>(advertisedListeners);
    }

    @NotNull
    public Map<String, AdvertisedListener> getAdvertisedListeners() {
        if (this.advertisedListeners == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.advertisedListeners);
    }

    @Generated
    public String getNativeUrl() {
        return this.nativeUrl;
    }

    @Generated
    public String getNativeUrlTls() {
        return this.nativeUrlTls;
    }

    @Generated
    public String getHttpUrl() {
        return this.httpUrl;
    }

    @Generated
    public String getHttpUrlTls() {
        return this.httpUrlTls;
    }

    @Generated
    public boolean isDisabled() {
        return this.disabled;
    }

    @Generated
    public void setNativeUrl(String nativeUrl) {
        this.nativeUrl = nativeUrl;
    }

    @Generated
    public void setNativeUrlTls(String nativeUrlTls) {
        this.nativeUrlTls = nativeUrlTls;
    }

    @Generated
    public void setHttpUrl(String httpUrl) {
        this.httpUrl = httpUrl;
    }

    @Generated
    public void setHttpUrlTls(String httpUrlTls) {
        this.httpUrlTls = httpUrlTls;
    }

    @Generated
    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    @Generated
    public void setAdvertisedListeners(Map<String, AdvertisedListener> advertisedListeners) {
        this.advertisedListeners = advertisedListeners;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NamespaceEphemeralData)) {
            return false;
        }
        NamespaceEphemeralData other = (NamespaceEphemeralData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDisabled() != other.isDisabled()) {
            return false;
        }
        String this$nativeUrl = this.getNativeUrl();
        String other$nativeUrl = other.getNativeUrl();
        if (this$nativeUrl == null ? other$nativeUrl != null : !this$nativeUrl.equals(other$nativeUrl)) {
            return false;
        }
        String this$nativeUrlTls = this.getNativeUrlTls();
        String other$nativeUrlTls = other.getNativeUrlTls();
        if (this$nativeUrlTls == null ? other$nativeUrlTls != null : !this$nativeUrlTls.equals(other$nativeUrlTls)) {
            return false;
        }
        String this$httpUrl = this.getHttpUrl();
        String other$httpUrl = other.getHttpUrl();
        if (this$httpUrl == null ? other$httpUrl != null : !this$httpUrl.equals(other$httpUrl)) {
            return false;
        }
        String this$httpUrlTls = this.getHttpUrlTls();
        String other$httpUrlTls = other.getHttpUrlTls();
        if (this$httpUrlTls == null ? other$httpUrlTls != null : !this$httpUrlTls.equals(other$httpUrlTls)) {
            return false;
        }
        Map<String, AdvertisedListener> this$advertisedListeners = this.getAdvertisedListeners();
        Map<String, AdvertisedListener> other$advertisedListeners = other.getAdvertisedListeners();
        return !(this$advertisedListeners == null ? other$advertisedListeners != null : !((Object)this$advertisedListeners).equals(other$advertisedListeners));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof NamespaceEphemeralData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDisabled() ? 79 : 97);
        String $nativeUrl = this.getNativeUrl();
        result = result * 59 + ($nativeUrl == null ? 43 : $nativeUrl.hashCode());
        String $nativeUrlTls = this.getNativeUrlTls();
        result = result * 59 + ($nativeUrlTls == null ? 43 : $nativeUrlTls.hashCode());
        String $httpUrl = this.getHttpUrl();
        result = result * 59 + ($httpUrl == null ? 43 : $httpUrl.hashCode());
        String $httpUrlTls = this.getHttpUrlTls();
        result = result * 59 + ($httpUrlTls == null ? 43 : $httpUrlTls.hashCode());
        Map<String, AdvertisedListener> $advertisedListeners = this.getAdvertisedListeners();
        result = result * 59 + ($advertisedListeners == null ? 43 : ((Object)$advertisedListeners).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "NamespaceEphemeralData(nativeUrl=" + this.getNativeUrl() + ", nativeUrlTls=" + this.getNativeUrlTls() + ", httpUrl=" + this.getHttpUrl() + ", httpUrlTls=" + this.getHttpUrlTls() + ", disabled=" + this.isDisabled() + ", advertisedListeners=" + this.getAdvertisedListeners() + ")";
    }

    @Generated
    public NamespaceEphemeralData() {
    }
}

