/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import lombok.Generated;
import org.apache.pulsar.broker.service.schema.exceptions.IncompatibleSchemaException;
import org.apache.pulsar.broker.service.schema.exceptions.InvalidSchemaDataException;
import org.apache.pulsar.common.api.proto.ServerError;
import org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.transaction.common.exception.TransactionConflictException;
import org.apache.pulsar.transaction.coordinator.exceptions.CoordinatorException;

public class BrokerServiceException
extends Exception {
    public BrokerServiceException(String msg) {
        super(msg);
    }

    public BrokerServiceException(Throwable t) {
        super(t);
    }

    public BrokerServiceException(String message, Throwable cause) {
        super(message, cause);
    }

    public static ServerError getClientErrorCode(Throwable t) {
        return BrokerServiceException.getClientErrorCode(t, true);
    }

    private static ServerError getClientErrorCode(Throwable t, boolean checkCauseIfUnknown) {
        if (t instanceof ServerMetadataException) {
            return ServerError.MetadataError;
        }
        if (t instanceof NamingException) {
            return ServerError.ProducerBusy;
        }
        if (t instanceof PersistenceException) {
            return ServerError.PersistenceError;
        }
        if (t instanceof ConsumerBusyException) {
            return ServerError.ConsumerBusy;
        }
        if (t instanceof SubscriptionBusyException) {
            return ServerError.ConsumerBusy;
        }
        if (t instanceof ProducerBusyException) {
            return ServerError.ProducerBusy;
        }
        if (t instanceof UnsupportedVersionException) {
            return ServerError.UnsupportedVersionError;
        }
        if (t instanceof TooManyRequestsException) {
            return ServerError.TooManyRequests;
        }
        if (t instanceof TopicTerminatedException) {
            return ServerError.TopicTerminatedError;
        }
        if (t instanceof ServiceUnitNotReadyException || t instanceof TopicFencedException || t instanceof SubscriptionFencedException) {
            return ServerError.ServiceNotReady;
        }
        if (t instanceof TopicNotFoundException) {
            return ServerError.TopicNotFound;
        }
        if (t instanceof SubscriptionNotFoundException) {
            return ServerError.SubscriptionNotFound;
        }
        if (t instanceof IncompatibleSchemaException || t instanceof InvalidSchemaDataException) {
            return ServerError.IncompatibleSchema;
        }
        if (t instanceof ConsumerAssignException) {
            return ServerError.ConsumerAssignError;
        }
        if (t instanceof CoordinatorException.CoordinatorNotFoundException) {
            return ServerError.TransactionCoordinatorNotFound;
        }
        if (t instanceof CoordinatorException.InvalidTxnStatusException) {
            return ServerError.InvalidTxnStatus;
        }
        if (t instanceof NotAllowedException) {
            return ServerError.NotAllowedError;
        }
        if (t instanceof ProducerFencedException) {
            return ServerError.ProducerFenced;
        }
        if (t instanceof TransactionConflictException) {
            return ServerError.TransactionConflict;
        }
        if (t instanceof CoordinatorException.TransactionNotFoundException) {
            return ServerError.TransactionNotFound;
        }
        if (checkCauseIfUnknown) {
            return BrokerServiceException.getClientErrorCode(t.getCause(), false);
        }
        return ServerError.UnknownError;
    }

    public static class ServerMetadataException
    extends BrokerServiceException {
        public ServerMetadataException(Throwable t) {
            super(t);
        }

        public ServerMetadataException(String msg) {
            super(msg);
        }
    }

    public static class NamingException
    extends BrokerServiceException {
        public NamingException(String msg) {
            super(msg);
        }
    }

    public static class PersistenceException
    extends BrokerServiceException {
        public PersistenceException(Throwable t) {
            super(t);
        }

        public PersistenceException(String msg) {
            super(msg);
        }
    }

    public static class ConsumerBusyException
    extends BrokerServiceException {
        public ConsumerBusyException(String msg) {
            super(msg);
        }
    }

    public static class SubscriptionBusyException
    extends BrokerServiceException {
        public SubscriptionBusyException(String msg) {
            super(msg);
        }
    }

    public static class ProducerBusyException
    extends BrokerServiceException {
        public ProducerBusyException(String msg) {
            super(msg);
        }
    }

    public static class UnsupportedVersionException
    extends BrokerServiceException {
        public UnsupportedVersionException(String msg) {
            super(msg);
        }
    }

    public static class TooManyRequestsException
    extends BrokerServiceException {
        public TooManyRequestsException(String msg) {
            super(msg);
        }
    }

    public static class TopicTerminatedException
    extends BrokerServiceException {
        public TopicTerminatedException(String msg) {
            super(msg);
        }

        public TopicTerminatedException(Throwable t) {
            super(t);
        }
    }

    public static class ServiceUnitNotReadyException
    extends BrokerServiceException {
        public ServiceUnitNotReadyException(String msg) {
            super(msg);
        }

        public ServiceUnitNotReadyException(String msg, Throwable t) {
            super(msg, t);
        }
    }

    public static class TopicFencedException
    extends BrokerServiceException {
        public TopicFencedException(String msg) {
            super(msg);
        }
    }

    public static class SubscriptionFencedException
    extends BrokerServiceException {
        public SubscriptionFencedException(String msg) {
            super(msg);
        }
    }

    public static class TopicNotFoundException
    extends BrokerServiceException {
        public TopicNotFoundException(String msg) {
            super(msg);
        }
    }

    public static class SubscriptionNotFoundException
    extends BrokerServiceException {
        public SubscriptionNotFoundException(String msg) {
            super(msg);
        }
    }

    public static class ConsumerAssignException
    extends BrokerServiceException {
        public ConsumerAssignException(String msg) {
            super(msg);
        }
    }

    public static class NotAllowedException
    extends BrokerServiceException {
        public NotAllowedException(String msg) {
            super(msg);
        }
    }

    public static class ProducerFencedException
    extends BrokerServiceException {
        public ProducerFencedException(String msg) {
            super(msg);
        }
    }

    public static class TopicBacklogQuotaExceededException
    extends BrokerServiceException {
        private final BacklogQuota.RetentionPolicy retentionPolicy;

        public TopicBacklogQuotaExceededException(BacklogQuota.RetentionPolicy retentionPolicy) {
            super("Cannot create producer on topic with backlog quota exceeded");
            this.retentionPolicy = retentionPolicy;
        }

        @Generated
        public BacklogQuota.RetentionPolicy getRetentionPolicy() {
            return this.retentionPolicy;
        }
    }

    public static class TopicPoliciesCacheNotInitException
    extends BrokerServiceException {
        public TopicPoliciesCacheNotInitException() {
            super("Topic policies cache have not init.");
        }
    }

    public static class AlreadyRunningException
    extends BrokerServiceException {
        public AlreadyRunningException(String msg) {
            super(msg);
        }
    }

    public static class SubscriptionInvalidCursorPosition
    extends BrokerServiceException {
        public SubscriptionInvalidCursorPosition(String msg) {
            super(msg);
        }
    }

    public static class SubscriptionConflictUnloadException
    extends BrokerServiceException {
        public SubscriptionConflictUnloadException(String msg) {
            super(msg);
        }
    }

    public static class UnsupportedSubscriptionException
    extends BrokerServiceException {
        public UnsupportedSubscriptionException(String msg) {
            super(msg);
        }
    }

    public static class TopicBusyException
    extends BrokerServiceException {
        public TopicBusyException(String msg) {
            super(msg);
        }

        public TopicBusyException(String msg, Throwable t) {
            super(msg, t);
        }
    }

    public static class TopicMigratedException
    extends BrokerServiceException {
        public TopicMigratedException(String msg) {
            super(msg);
        }

        public TopicMigratedException(Throwable t) {
            super(t);
        }
    }

    @Deprecated
    public static class AddEntryMetadataException
    extends BrokerServiceException {
        public AddEntryMetadataException(Throwable t) {
            super(t);
        }
    }

    public static class TopicClosedException
    extends BrokerServiceException {
        public TopicClosedException(Throwable t) {
            super(t);
        }
    }
}

