/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats.prometheus;

import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.time.Clock;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.stats.prometheus.MetricsExports;
import org.apache.pulsar.broker.stats.prometheus.PrometheusMetricsGenerator;
import org.apache.pulsar.broker.stats.prometheus.PrometheusMetricsServlet;
import org.apache.pulsar.broker.web.GzipHandlerUtil;
import org.eclipse.jetty.server.HttpOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarPrometheusMetricsServlet
extends PrometheusMetricsServlet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PulsarPrometheusMetricsServlet.class);
    private static final long serialVersionUID = 1L;
    private static final int EXECUTOR_MAX_THREADS = 4;
    private final PrometheusMetricsGenerator prometheusMetricsGenerator;
    private final boolean gzipCompressionEnabledForMetrics;

    public PulsarPrometheusMetricsServlet(PulsarService pulsar, boolean includeTopicMetrics, boolean includeConsumerMetrics, boolean includeProducerMetrics, boolean splitTopicAndPartitionLabel) {
        super(pulsar.getConfiguration().getMetricsServletTimeoutMs(), pulsar.getConfiguration().getClusterName(), 4);
        MetricsExports.initialize();
        this.prometheusMetricsGenerator = new PrometheusMetricsGenerator(pulsar, includeTopicMetrics, includeConsumerMetrics, includeProducerMetrics, splitTopicAndPartitionLabel, Clock.systemUTC());
        this.gzipCompressionEnabledForMetrics = GzipHandlerUtil.isGzipCompressionEnabledForEndpoint((List)pulsar.getConfiguration().getHttpServerGzipCompressionExcludedPaths(), (String)"/metrics");
    }

    public void destroy() {
        super.destroy();
        this.prometheusMetricsGenerator.close();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        final AsyncContext context = request.startAsync();
        if (this.metricsServletTimeoutMs > 0L) {
            context.setTimeout(this.metricsServletTimeoutMs * 2L);
        }
        long startNanos = System.nanoTime();
        final AtomicBoolean skipWritingResponse = new AtomicBoolean(false);
        context.addListener(new AsyncListener(){

            public void onComplete(AsyncEvent event) throws IOException {
            }

            public void onTimeout(AsyncEvent event) throws IOException {
                log.warn("Prometheus metrics request timed out");
                skipWritingResponse.set(true);
                HttpServletResponse res = (HttpServletResponse)context.getResponse();
                if (!res.isCommitted()) {
                    res.setStatus(500);
                }
                context.complete();
            }

            public void onError(AsyncEvent event) throws IOException {
                skipWritingResponse.set(true);
            }

            public void onStartAsync(AsyncEvent event) throws IOException {
            }
        });
        PrometheusMetricsGenerator.MetricsBuffer metricsBuffer = this.prometheusMetricsGenerator.renderToBuffer(this.executor, this.metricsProviders);
        if (metricsBuffer == null) {
            log.info("Service is closing, skip writing metrics.");
            response.setStatus(500);
            context.complete();
            return;
        }
        boolean compressOutput = this.gzipCompressionEnabledForMetrics && this.isGzipAccepted(request);
        ((CompletableFuture)metricsBuffer.getBufferFuture().thenCompose(responseBuffer -> {
            if (compressOutput) {
                return responseBuffer.getCompressedBuffer(this.executor);
            }
            return CompletableFuture.completedFuture(responseBuffer.getUncompressedBuffer());
        })).whenComplete((buffer, ex) -> this.executor.execute(() -> {
            try {
                long elapsedNanos = System.nanoTime() - startNanos;
                if (this.metricsServletTimeoutMs > 0L && elapsedNanos > TimeUnit.MILLISECONDS.toNanos(this.metricsServletTimeoutMs)) {
                    log.warn("Prometheus metrics request was too long in queue ({}ms). Skipping sending metrics.", (Object)TimeUnit.NANOSECONDS.toMillis(elapsedNanos));
                    if (!response.isCommitted() && !skipWritingResponse.get()) {
                        response.setStatus(500);
                    }
                    return;
                }
                if (skipWritingResponse.get()) {
                    log.warn("Response has timed or failed, skip writing metrics.");
                    return;
                }
                if (response.isCommitted()) {
                    log.warn("Response is already committed, cannot write metrics");
                    return;
                }
                if (ex != null) {
                    log.error("Failed to generate metrics", ex);
                    response.setStatus(500);
                    return;
                }
                if (buffer == null) {
                    log.error("Failed to generate metrics, buffer is null");
                    response.setStatus(500);
                } else {
                    ServletOutputStream outputStream;
                    response.setStatus(200);
                    response.setContentType("text/plain;charset=utf-8");
                    if (compressOutput) {
                        response.setHeader("Content-Encoding", "gzip");
                    }
                    if ((outputStream = response.getOutputStream()) instanceof HttpOutput) {
                        HttpOutput output = (HttpOutput)outputStream;
                        for (ByteBuffer nioBuffer : buffer.nioBuffers()) {
                            output.write(nioBuffer);
                        }
                    } else {
                        int length = buffer.readableBytes();
                        if (length > 0) {
                            buffer.duplicate().readBytes((OutputStream)outputStream, length);
                        }
                    }
                }
            }
            catch (EOFException e) {
                log.error("Failed to write metrics to response due to EOFException");
            }
            catch (IOException e) {
                log.error("Failed to write metrics to response", (Throwable)e);
            }
            finally {
                metricsBuffer.release();
                context.complete();
            }
        }));
    }

    private boolean isGzipAccepted(HttpServletRequest request) {
        String acceptEncoding = request.getHeader("Accept-Encoding");
        if (acceptEncoding != null) {
            return Arrays.stream(acceptEncoding.split(",")).map(String::trim).anyMatch(str -> "gzip".equalsIgnoreCase((String)str));
        }
        return false;
    }
}

