/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.authentication;

import java.io.IOException;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.regex.Pattern;
import javax.naming.AuthenticationException;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.pulsar.common.api.AuthData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarSaslServer {
    private static final Logger log = LoggerFactory.getLogger(PulsarSaslServer.class);
    private final SaslServer saslServer;
    private final Pattern allowedIdsPattern;
    private final Subject serverSubject;
    private static final String GSSAPI = "GSSAPI";

    public PulsarSaslServer(Subject subject, Pattern allowedIdsPattern) throws IOException, LoginException {
        this.serverSubject = subject;
        this.allowedIdsPattern = allowedIdsPattern;
        this.saslServer = this.createSaslServer(this.serverSubject);
    }

    private SaslServer createSaslServer(Subject subject) throws IOException {
        final SaslServerCallbackHandler callbackHandler = new SaslServerCallbackHandler(this.allowedIdsPattern);
        if (subject.getPrincipals().size() > 0) {
            try {
                String serviceHostname;
                String servicePrincipalName;
                Object[] principals = subject.getPrincipals().toArray();
                Principal servicePrincipal = (Principal)principals[0];
                if (log.isDebugEnabled()) {
                    log.debug("Authentication will use SASL/JAAS/Kerberos, servicePrincipal is {}", (Object)servicePrincipal);
                }
                String servicePrincipalNameAndHostname = servicePrincipal.getName();
                int indexOf = servicePrincipalNameAndHostname.indexOf("/");
                String serviceHostnameAndKerbDomain = servicePrincipalNameAndHostname.substring(indexOf + 1, servicePrincipalNameAndHostname.length());
                int indexOfAt = serviceHostnameAndKerbDomain.indexOf("@");
                if (indexOf > 0) {
                    servicePrincipalName = servicePrincipalNameAndHostname.substring(0, indexOf);
                    serviceHostname = serviceHostnameAndKerbDomain.substring(0, indexOfAt);
                } else {
                    servicePrincipalName = servicePrincipalNameAndHostname.substring(0, indexOfAt);
                    serviceHostname = null;
                }
                if (log.isDebugEnabled()) {
                    log.debug("serviceHostname is '{}', servicePrincipalName is '{}', SASL mechanism(mech) is '{}'.", new Object[]{serviceHostname, servicePrincipalName, GSSAPI});
                }
                try {
                    return Subject.doAs(subject, new PrivilegedExceptionAction<SaslServer>(){

                        @Override
                        public SaslServer run() {
                            try {
                                SaslServer saslServer = Sasl.createSaslServer(PulsarSaslServer.GSSAPI, servicePrincipalName, serviceHostname, null, callbackHandler);
                                return saslServer;
                            }
                            catch (SaslException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw new SaslException("error on GSSAPI boot", e.getCause());
                }
            }
            catch (IndexOutOfBoundsException e) {
                throw new SaslException("error on GSSAPI boot", e);
            }
        }
        String errorMessage = "Authentication use SASL/JAAS/GSSAPI but server not have Principals";
        log.error(errorMessage);
        throw new SaslException(errorMessage);
    }

    public boolean isComplete() {
        return this.saslServer.isComplete();
    }

    public String getAuthorizationID() throws IllegalStateException {
        return this.saslServer.getAuthorizationID();
    }

    public AuthData response(AuthData token) throws AuthenticationException {
        try {
            return AuthData.of((byte[])this.saslServer.evaluateResponse(token.getBytes()));
        }
        catch (SaslException e) {
            log.error("response: Failed to evaluate client token:", (Throwable)e);
            throw new AuthenticationException(e.getMessage());
        }
    }

    static class SaslServerCallbackHandler
    implements CallbackHandler {
        Pattern allowedIdsPattern;

        public SaslServerCallbackHandler(Pattern pattern) {
            this.allowedIdsPattern = pattern;
        }

        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (!(callback instanceof AuthorizeCallback)) {
                    throw new UnsupportedCallbackException(callback, "Unrecognized SASL GSSAPI Server Callback.");
                }
                this.handleAuthorizeCallback((AuthorizeCallback)callback);
            }
        }

        private void handleAuthorizeCallback(AuthorizeCallback ac) {
            String authorizationID;
            String authenticationID = ac.getAuthenticationID();
            if (!authenticationID.equals(authorizationID = ac.getAuthorizationID())) {
                ac.setAuthorized(false);
                log.info("Forbidden access to client: authenticationID: {} is different from authorizationID: {}", (Object)authenticationID, (Object)authorizationID);
                return;
            }
            if (!this.allowedIdsPattern.matcher(authenticationID).matches()) {
                ac.setAuthorized(false);
                log.info("Forbidden access to client: authenticationID {}, is not allowed (see {} property).", (Object)authenticationID, (Object)"saslJaasClientAllowedIds");
                return;
            }
            ac.setAuthorized(true);
            log.info("Successfully authenticated client: authenticationID: {};  authorizationID: {}.", (Object)authenticationID, (Object)authorizationID);
        }
    }
}

