/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.authentication;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.Base64;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.naming.AuthenticationException;
import javax.net.ssl.SSLSession;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.authentication.AuthenticationDataHttps;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.broker.authentication.AuthenticationProvider;
import org.apache.pulsar.broker.authentication.AuthenticationState;
import org.apache.pulsar.broker.authentication.PulsarSaslServer;
import org.apache.pulsar.broker.authentication.SaslAuthenticationDataSource;
import org.apache.pulsar.broker.authentication.SaslAuthenticationState;
import org.apache.pulsar.broker.authentication.SaslRoleToken;
import org.apache.pulsar.broker.authentication.SaslRoleTokenSigner;
import org.apache.pulsar.broker.web.AuthenticationFilter;
import org.apache.pulsar.common.api.AuthData;
import org.apache.pulsar.common.sasl.JAASCredentialsContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationProviderSasl
implements AuthenticationProvider {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationProviderSasl.class);
    private Pattern allowedIdsPattern;
    private Map<String, String> configuration;
    private JAASCredentialsContainer jaasCredentialsContainer;
    private String loginContextName;
    private static final long SASL_ROLE_TOKEN_LIVE_SECONDS = 3600L;
    private SaslRoleTokenSigner signer;
    private ConcurrentHashMap<Long, AuthenticationState> authStates = new ConcurrentHashMap();

    public void initialize(ServiceConfiguration config) throws IOException {
        this.configuration = Maps.newHashMap();
        String allowedIdsPatternRegExp = config.getSaslJaasClientAllowedIds();
        this.configuration.put("saslJaasClientAllowedIds", allowedIdsPatternRegExp);
        this.configuration.put("saslJaasServerSectionName", config.getSaslJaasServerSectionName());
        this.configuration.put("kerberos.kinit", config.getKinitCommand());
        try {
            this.allowedIdsPattern = Pattern.compile(allowedIdsPatternRegExp);
        }
        catch (PatternSyntaxException error) {
            log.error("Invalid regular expression for id " + allowedIdsPatternRegExp, (Throwable)error);
            throw new IOException(error);
        }
        this.loginContextName = config.getSaslJaasServerSectionName();
        if (this.jaasCredentialsContainer == null) {
            log.info("JAAS loginContext is: {}.", (Object)this.loginContextName);
            try {
                this.jaasCredentialsContainer = new JAASCredentialsContainer(this.loginContextName, (CallbackHandler)new PulsarSaslServer.SaslServerCallbackHandler(this.allowedIdsPattern), this.configuration);
            }
            catch (LoginException e) {
                log.error("JAAS login in broker failed", (Throwable)e);
                throw new IOException(e);
            }
        }
        this.signer = new SaslRoleTokenSigner(Long.toString(new Random().nextLong()).getBytes());
    }

    public String authenticate(AuthenticationDataSource authData) throws AuthenticationException {
        if (authData instanceof SaslAuthenticationDataSource) {
            return ((SaslAuthenticationDataSource)authData).getAuthorizationID();
        }
        throw new AuthenticationException("Not support authDataSource type, expect sasl.");
    }

    public String getAuthMethodName() {
        return "sasl";
    }

    public void close() throws IOException {
    }

    public AuthenticationState newAuthState(AuthData authData, SocketAddress remoteAddress, SSLSession sslSession) throws AuthenticationException {
        try {
            return new SaslAuthenticationState(new SaslAuthenticationDataSource(new PulsarSaslServer(this.jaasCredentialsContainer.getSubject(), this.allowedIdsPattern)));
        }
        catch (Throwable t) {
            log.error("Failed create sasl auth state", t);
            throw new AuthenticationException(t.getMessage());
        }
    }

    public String authRoleFromHttpRequest(HttpServletRequest httpRequest) throws AuthenticationException {
        SaslRoleToken token;
        String tokenStr = httpRequest.getHeader("SaslAuthRoleToken");
        if (tokenStr == null) {
            return null;
        }
        String unSigned = this.signer.verifyAndExtract(tokenStr);
        try {
            token = SaslRoleToken.parse(unSigned);
            if (log.isDebugEnabled()) {
                log.debug("server side get role token: {}, session in token:{}, session in request:{}", new Object[]{token, token.getSession(), httpRequest.getRemoteAddr()});
            }
        }
        catch (Exception e) {
            log.error("token parse failed, with exception: ", (Throwable)e);
            return "SaslAuthRoleTokenExpired";
        }
        if (!token.isExpired()) {
            return token.getUserRole();
        }
        if (token.isExpired()) {
            return "SaslAuthRoleTokenExpired";
        }
        return null;
    }

    private String createAuthRoleToken(String role, String sessionId) {
        long expireAtMs = System.currentTimeMillis() + 3600000L;
        SaslRoleToken token = new SaslRoleToken(role, sessionId, expireAtMs);
        String signed = this.signer.sign(token.toString());
        if (log.isDebugEnabled()) {
            log.debug("create role token token: {}, role: {} session :{}, expires:{}\nsigned:{}", new Object[]{token, token.getUserRole(), token.getSession(), token.getExpires(), signed});
        }
        return signed;
    }

    private AuthenticationState getAuthState(HttpServletRequest request) {
        String id = request.getHeader("SASL-Server-ID");
        if (id == null) {
            return null;
        }
        try {
            return this.authStates.get(Long.parseLong(id));
        }
        catch (NumberFormatException e) {
            log.error("[{}] Wrong Id String in Token {}. e:", new Object[]{request.getRequestURI(), id, e});
            return null;
        }
    }

    private void setResponseHeaderState(HttpServletResponse response, String state) {
        response.setHeader("SASL-Type", "Kerberos");
        response.setHeader("State", state);
    }

    public boolean authenticateHttpRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AuthenticationState state = this.getAuthState(request);
        String saslAuthRoleToken = this.authRoleFromHttpRequest(request);
        if (saslAuthRoleToken != null) {
            if (saslAuthRoleToken.equalsIgnoreCase("SaslAuthRoleTokenExpired")) {
                this.setResponseHeaderState(response, "SaslAuthRoleTokenExpired");
                response.sendError(401, "Role token expired");
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Server side role token expired: {}", (Object)request.getRequestURI(), (Object)saslAuthRoleToken);
                }
                return false;
            }
            if (request.getHeader("State").equalsIgnoreCase("Done")) {
                request.setAttribute(AuthenticationFilter.AuthenticatedRoleAttributeName, (Object)saslAuthRoleToken);
                request.setAttribute(AuthenticationFilter.AuthenticatedDataAttributeName, (Object)new AuthenticationDataHttps(request));
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Server side role token OK to go on: {}", (Object)request.getRequestURI(), (Object)saslAuthRoleToken);
                }
                return true;
            }
            Preconditions.checkState((boolean)request.getHeader("State").equalsIgnoreCase("ServerCheckToken"));
            this.setResponseHeaderState(response, "Done");
            response.setHeader("SASL-Server-ID", request.getHeader("SASL-Server-ID"));
            response.setStatus(200);
            if (log.isDebugEnabled()) {
                log.debug("[{}] Server side role token verified success: {}", (Object)request.getRequestURI(), (Object)saslAuthRoleToken);
            }
            return false;
        }
        if (state == null || request.getHeader("State").equalsIgnoreCase("Init")) {
            state = this.newAuthState(null, null, null);
            this.authStates.put(state.getStateId(), state);
        }
        Preconditions.checkState((request.getHeader("SASL-Token") != null ? 1 : 0) != 0, (Object)"Header token should exist if no role token.");
        AuthData clientData = AuthData.of((byte[])Base64.getDecoder().decode(request.getHeader("SASL-Token")));
        AuthData brokerData = state.authenticate(clientData);
        if (state.isComplete()) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] SASL server authentication complete, send OK to client.", (Object)request.getRequestURI());
            }
            String authRole = state.getAuthRole();
            String authToken = this.createAuthRoleToken(authRole, String.valueOf(state.getStateId()));
            response.setHeader("SaslAuthRoleToken", authToken);
            response.setHeader("SASL-Server-ID", String.valueOf(state.getStateId()));
            this.setResponseHeaderState(response, "Done");
            response.setStatus(200);
            this.authStates.remove(state.getStateId());
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug("[{}] SASL server authentication not complete, send {} back to client.", (Object)request.getRequestURI(), (Object)401);
        }
        this.setResponseHeaderState(response, "ING");
        response.setHeader("SASL-Server-ID", String.valueOf(state.getStateId()));
        response.setHeader("SASL-Token", Base64.getEncoder().encodeToString(brokerData.getBytes()));
        response.sendError(401, "SASL Authentication not complete.");
        return false;
    }
}

