/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.authentication;

import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicLong;
import javax.naming.AuthenticationException;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.broker.authentication.AuthenticationState;
import org.apache.pulsar.broker.authentication.SaslAuthenticationDataSource;
import org.apache.pulsar.common.api.AuthData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslAuthenticationState
implements AuthenticationState {
    private static final Logger log = LoggerFactory.getLogger(SaslAuthenticationState.class);
    private final long stateId = stateIdGenerator.incrementAndGet();
    private static final AtomicLong stateIdGenerator = new AtomicLong(0L);
    private final SaslAuthenticationDataSource authenticationDataSource;

    public SaslAuthenticationState(AuthenticationDataSource authenticationDataSource) {
        Preconditions.checkArgument((boolean)(authenticationDataSource instanceof SaslAuthenticationDataSource));
        this.authenticationDataSource = (SaslAuthenticationDataSource)authenticationDataSource;
    }

    public String getAuthRole() {
        return this.authenticationDataSource.getAuthorizationID();
    }

    public AuthenticationDataSource getAuthDataSource() {
        return this.authenticationDataSource;
    }

    public boolean isComplete() {
        return this.authenticationDataSource.isComplete();
    }

    public AuthData authenticate(AuthData authData) throws AuthenticationException {
        return this.authenticationDataSource.authenticate(authData);
    }

    public long getStateId() {
        return this.stateId;
    }
}

