/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.util.Random;
import java.util.concurrent.TimeUnit;

public class Backoff {
    private static final long DEFAULT_INTERVAL_IN_NANOSECONDS = TimeUnit.MILLISECONDS.toNanos(100L);
    private static final long MAX_BACKOFF_INTERVAL_NANOSECONDS = TimeUnit.SECONDS.toNanos(30L);
    private final long initial;
    private final long max;
    private long next;
    private static final Random random = new Random();

    public Backoff(long initial, TimeUnit unitInitial, long max, TimeUnit unitMax) {
        this.initial = unitInitial.toMillis(initial);
        this.max = unitMax.toMillis(max);
        this.next = this.initial;
    }

    public long next() {
        long current = this.next;
        if (current < this.max) {
            this.next = Math.min(this.next * 2L, this.max);
        }
        current += (long)random.nextInt((int)current / 4);
        return current;
    }

    public void reduceToHalf() {
        if (this.next > this.initial) {
            this.next = Math.max(this.next / 2L, this.initial);
        }
    }

    public void reset() {
        this.next = this.initial;
    }

    public static boolean shouldBackoff(long initialTimestamp, TimeUnit unitInitial, int failedAttempts) {
        long initialTimestampInNano = unitInitial.toNanos(initialTimestamp);
        long currentTime = System.nanoTime();
        long interval = DEFAULT_INTERVAL_IN_NANOSECONDS;
        for (int i = 1; i < failedAttempts; ++i) {
            if ((interval *= 2L) <= MAX_BACKOFF_INTERVAL_NANOSECONDS) continue;
            interval = MAX_BACKOFF_INTERVAL_NANOSECONDS;
            break;
        }
        return currentTime < initialTimestampInNano + interval;
    }
}

