/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.yahoo.sketches.quantiles.DoublesSketch;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.io.IOException;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.apache.pulsar.client.api.ProducerConfiguration;
import org.apache.pulsar.client.impl.ProducerImpl;
import org.apache.pulsar.client.impl.ProducerStatsDisabled;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerStats
implements Serializable {
    private static final long serialVersionUID = 1L;
    private TimerTask stat;
    private Timeout statTimeout;
    private ProducerImpl producer;
    private PulsarClientImpl pulsarClient;
    private long oldTime;
    private long statsIntervalSeconds;
    private final LongAdder numMsgsSent;
    private final LongAdder numBytesSent;
    private final LongAdder numSendFailed;
    private final LongAdder numAcksReceived;
    private final LongAdder totalMsgsSent;
    private final LongAdder totalBytesSent;
    private final LongAdder totalSendFailed;
    private final LongAdder totalAcksReceived;
    private final DecimalFormat dec;
    private final DecimalFormat throughputFormat;
    private final DoublesSketch ds;
    private final double[] percentiles = new double[]{0.5, 0.95, 0.99, 0.999, 0.9999};
    public static final ProducerStats PRODUCER_STATS_DISABLED = new ProducerStatsDisabled();
    private static final Logger log = LoggerFactory.getLogger(ProducerStats.class);

    public ProducerStats() {
        this.numMsgsSent = null;
        this.numBytesSent = null;
        this.numSendFailed = null;
        this.numAcksReceived = null;
        this.totalMsgsSent = null;
        this.totalBytesSent = null;
        this.totalSendFailed = null;
        this.totalAcksReceived = null;
        this.dec = null;
        this.throughputFormat = null;
        this.ds = null;
    }

    public ProducerStats(PulsarClientImpl pulsarClient, ProducerConfiguration conf, ProducerImpl producer) {
        this.pulsarClient = pulsarClient;
        this.statsIntervalSeconds = pulsarClient.getConfiguration().getStatsIntervalSeconds();
        this.producer = producer;
        this.numMsgsSent = new LongAdder();
        this.numBytesSent = new LongAdder();
        this.numSendFailed = new LongAdder();
        this.numAcksReceived = new LongAdder();
        this.totalMsgsSent = new LongAdder();
        this.totalBytesSent = new LongAdder();
        this.totalSendFailed = new LongAdder();
        this.totalAcksReceived = new LongAdder();
        this.ds = DoublesSketch.builder().build(256);
        this.dec = new DecimalFormat("0.000");
        this.throughputFormat = new DecimalFormat("0.00");
        this.init(conf);
    }

    private void init(ProducerConfiguration conf) {
        ObjectMapper m = new ObjectMapper();
        m.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        ObjectWriter w = m.writerWithDefaultPrettyPrinter();
        try {
            log.info("Starting Pulsar producer perf with config: {}", (Object)w.writeValueAsString((Object)conf));
            log.info("Pulsar client config: {}", (Object)w.writeValueAsString((Object)this.pulsarClient.getConfiguration()));
        }
        catch (IOException e) {
            log.error("Failed to dump config info: {}", (Throwable)e);
        }
        this.stat = timeout -> {
            if (timeout.isCancelled()) {
                return;
            }
            try {
                double[] percentileValues;
                long now = System.nanoTime();
                double elapsed = (double)(now - this.oldTime) / 1.0E9;
                this.oldTime = now;
                long currentNumMsgsSent = this.numMsgsSent.sumThenReset();
                long currentNumBytesSent = this.numBytesSent.sumThenReset();
                long currentNumSendFailedMsgs = this.numSendFailed.sumThenReset();
                long currentNumAcksReceived = this.numAcksReceived.sumThenReset();
                this.totalMsgsSent.add(currentNumMsgsSent);
                this.totalBytesSent.add(currentNumBytesSent);
                this.totalSendFailed.add(currentNumSendFailedMsgs);
                this.totalAcksReceived.add(currentNumAcksReceived);
                DoublesSketch doublesSketch = this.ds;
                synchronized (doublesSketch) {
                    percentileValues = this.ds.getQuantiles(this.percentiles);
                    this.ds.reset();
                }
                if ((currentNumMsgsSent | currentNumSendFailedMsgs | currentNumAcksReceived | currentNumMsgsSent) != 0L) {
                    for (int i = 0; i < percentileValues.length; ++i) {
                        if (percentileValues[i] != Double.NaN) continue;
                        percentileValues[i] = 0.0;
                    }
                    log.info("[{}] [{}] Pending messages: {} --- Publish throughput: {} msg/s --- {} Mbit/s --- Latency: med: {} ms - 95pct: {} ms - 99pct: {} ms - 99.9pct: {} ms - 99.99pct: {} ms --- Ack received rate: {} ack/s --- Failed messages: {}", new Object[]{this.producer.getTopic(), this.producer.getProducerName(), this.producer.getPendingQueueSize(), this.throughputFormat.format((double)currentNumMsgsSent / elapsed), this.throughputFormat.format((double)currentNumBytesSent / elapsed / 1024.0 / 1024.0 * 8.0), this.dec.format(percentileValues[0] / 1000.0), this.dec.format(percentileValues[1] / 1000.0), this.dec.format(percentileValues[2] / 1000.0), this.dec.format(percentileValues[3] / 1000.0), this.dec.format(percentileValues[4] / 1000.0), this.throughputFormat.format((double)currentNumAcksReceived / elapsed), currentNumSendFailedMsgs});
                }
            }
            catch (Exception e) {
                log.error("[{}] [{}]: {}", new Object[]{this.producer.getTopic(), this.producer.getProducerName(), e.getMessage()});
            }
            finally {
                this.statTimeout = this.pulsarClient.timer().newTimeout(this.stat, this.statsIntervalSeconds, TimeUnit.SECONDS);
            }
        };
        this.oldTime = System.nanoTime();
        this.statTimeout = this.pulsarClient.timer().newTimeout(this.stat, this.statsIntervalSeconds, TimeUnit.SECONDS);
    }

    Timeout getStatTimeout() {
        return this.statTimeout;
    }

    void updateNumMsgsSent(long numMsgs, long totalMsgsSize) {
        this.numMsgsSent.add(numMsgs);
        this.numBytesSent.add(totalMsgsSize);
    }

    void incrementSendFailed() {
        this.numSendFailed.increment();
    }

    void incrementSendFailed(long numMsgs) {
        this.numSendFailed.add(numMsgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incrementNumAcksReceived(long latencyNs) {
        this.numAcksReceived.increment();
        DoublesSketch doublesSketch = this.ds;
        synchronized (doublesSketch) {
            this.ds.update((double)TimeUnit.NANOSECONDS.toMicros(latencyNs));
        }
    }

    void reset() {
        this.numMsgsSent.reset();
        this.numBytesSent.reset();
        this.numSendFailed.reset();
        this.numAcksReceived.reset();
        this.totalMsgsSent.reset();
        this.totalBytesSent.reset();
        this.totalSendFailed.reset();
        this.totalAcksReceived.reset();
    }

    void updateCumulativeStats(ProducerStats stats) {
        if (stats == null) {
            return;
        }
        this.numMsgsSent.add(stats.numMsgsSent.longValue());
        this.numBytesSent.add(stats.numBytesSent.longValue());
        this.numSendFailed.add(stats.numSendFailed.longValue());
        this.numAcksReceived.add(stats.numAcksReceived.longValue());
        this.totalMsgsSent.add(stats.numMsgsSent.longValue());
        this.totalBytesSent.add(stats.numBytesSent.longValue());
        this.totalSendFailed.add(stats.numSendFailed.longValue());
        this.totalAcksReceived.add(stats.numAcksReceived.longValue());
    }

    public long getNumMsgsSent() {
        return this.numMsgsSent.longValue();
    }

    public long getNumBytesSent() {
        return this.numBytesSent.longValue();
    }

    public long getNumSendFailed() {
        return this.numSendFailed.longValue();
    }

    public long getNumAcksReceived() {
        return this.numAcksReceived.longValue();
    }

    public long getTotalMsgsSent() {
        return this.totalMsgsSent.longValue();
    }

    public long getTotalBytesSent() {
        return this.totalBytesSent.longValue();
    }

    public long getTotalSendFailed() {
        return this.totalSendFailed.longValue();
    }

    public long getTotalAcksReceived() {
        return this.totalAcksReceived.longValue();
    }

    public void cancelStatsTimeout() {
        if (this.statTimeout != null) {
            this.statTimeout.cancel();
            this.statTimeout = null;
        }
    }
}

