/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class ExecutorProvider {
    private final int numThreads;
    private final List<ExecutorService> executors;
    private final AtomicInteger currentThread = new AtomicInteger(0);

    public ExecutorProvider(int numThreads, String threadNamePrefix) {
        Preconditions.checkArgument((numThreads > 0 ? 1 : 0) != 0);
        this.numThreads = numThreads;
        Preconditions.checkNotNull((Object)threadNamePrefix);
        this.executors = Lists.newArrayListWithCapacity((int)numThreads);
        for (int i = 0; i < numThreads; ++i) {
            this.executors.add(Executors.newSingleThreadExecutor((ThreadFactory)new DefaultThreadFactory(threadNamePrefix)));
        }
    }

    public ExecutorService getExecutor() {
        return this.executors.get((this.currentThread.getAndIncrement() & Integer.MAX_VALUE) % this.numThreads);
    }

    public void shutdownNow() {
        this.executors.forEach(executor -> executor.shutdownNow());
    }
}

