/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.EncodedAuthenticationParameterSupport;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.auth.AuthenticationDisabled;

public final class AuthenticationFactory {
    private static Map<String, String> parseAuthParamsString(String authParamsString) {
        HashMap<String, String> authParams = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)authParamsString)) {
            String[] params;
            for (String p : params = authParamsString.split(",")) {
                String[] kv = p.split(":");
                if (kv.length != 2) continue;
                authParams.put(kv[0], kv[1]);
            }
        }
        return authParams;
    }

    public static final Authentication create(String authPluginClassName, String authParamsString) throws PulsarClientException.UnsupportedAuthenticationException {
        try {
            if (StringUtils.isNotBlank((CharSequence)authPluginClassName)) {
                Class<?> authClass = Class.forName(authPluginClassName);
                Authentication auth = (Authentication)authClass.newInstance();
                if (auth instanceof EncodedAuthenticationParameterSupport) {
                    ((EncodedAuthenticationParameterSupport)((Object)auth)).configure(authParamsString);
                } else {
                    auth.configure(AuthenticationFactory.parseAuthParamsString(authParamsString));
                }
                return auth;
            }
            return new AuthenticationDisabled();
        }
        catch (Throwable t) {
            throw new PulsarClientException.UnsupportedAuthenticationException(t);
        }
    }

    public static final Authentication create(String authPluginClassName, Map<String, String> authParams) throws PulsarClientException.UnsupportedAuthenticationException {
        try {
            if (StringUtils.isNotBlank((CharSequence)authPluginClassName)) {
                Class<?> authClass = Class.forName(authPluginClassName);
                Authentication auth = (Authentication)authClass.newInstance();
                auth.configure(authParams);
                return auth;
            }
            return new AuthenticationDisabled();
        }
        catch (Throwable t) {
            throw new PulsarClientException.UnsupportedAuthenticationException(t);
        }
    }
}

