/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.AuthenticationFactory;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.auth.AuthenticationDisabled;

public class ClientConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Authentication authentication = new AuthenticationDisabled();
    private long operationTimeoutMs = 30000L;
    private long statsIntervalSeconds = 60L;
    private int numIoThreads = 1;
    private int numListenerThreads = 1;
    private int connectionsPerBroker = 1;
    private boolean useTcpNoDelay = true;
    private boolean useTls = false;
    private String tlsTrustCertsFilePath = "";
    private boolean tlsAllowInsecureConnection = false;
    private int concurrentLookupRequest = 5000;
    private int maxNumberOfRejectedRequestPerConnection = 50;

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    public void setAuthentication(String authPluginClassName, String authParamsString) throws PulsarClientException.UnsupportedAuthenticationException {
        this.authentication = AuthenticationFactory.create(authPluginClassName, authParamsString);
    }

    public void setAuthentication(String authPluginClassName, Map<String, String> authParams) throws PulsarClientException.UnsupportedAuthenticationException {
        this.authentication = AuthenticationFactory.create(authPluginClassName, authParams);
    }

    public long getOperationTimeoutMs() {
        return this.operationTimeoutMs;
    }

    public void setOperationTimeout(int operationTimeout, TimeUnit unit) {
        Preconditions.checkArgument((operationTimeout >= 0 ? 1 : 0) != 0);
        this.operationTimeoutMs = unit.toMillis(operationTimeout);
    }

    public int getIoThreads() {
        return this.numIoThreads;
    }

    public void setIoThreads(int numIoThreads) {
        Preconditions.checkArgument((numIoThreads > 0 ? 1 : 0) != 0);
        this.numIoThreads = numIoThreads;
    }

    public int getListenerThreads() {
        return this.numListenerThreads;
    }

    public void setListenerThreads(int numListenerThreads) {
        Preconditions.checkArgument((numListenerThreads > 0 ? 1 : 0) != 0);
        this.numListenerThreads = numListenerThreads;
    }

    public int getConnectionsPerBroker() {
        return this.connectionsPerBroker;
    }

    public void setConnectionsPerBroker(int connectionsPerBroker) {
        Preconditions.checkArgument((connectionsPerBroker > 0 ? 1 : 0) != 0, (Object)"Connections per broker need to be greater than 0");
        this.connectionsPerBroker = connectionsPerBroker;
    }

    public boolean isUseTcpNoDelay() {
        return this.useTcpNoDelay;
    }

    public void setUseTcpNoDelay(boolean useTcpNoDelay) {
        this.useTcpNoDelay = useTcpNoDelay;
    }

    public boolean isUseTls() {
        return this.useTls;
    }

    public void setUseTls(boolean useTls) {
        this.useTls = useTls;
    }

    public String getTlsTrustCertsFilePath() {
        return this.tlsTrustCertsFilePath;
    }

    public void setTlsTrustCertsFilePath(String tlsTrustCertsFilePath) {
        this.tlsTrustCertsFilePath = tlsTrustCertsFilePath;
    }

    public boolean isTlsAllowInsecureConnection() {
        return this.tlsAllowInsecureConnection;
    }

    public void setTlsAllowInsecureConnection(boolean tlsAllowInsecureConnection) {
        this.tlsAllowInsecureConnection = tlsAllowInsecureConnection;
    }

    public long getStatsIntervalSeconds() {
        return this.statsIntervalSeconds;
    }

    public void setStatsInterval(long statsInterval, TimeUnit unit) {
        this.statsIntervalSeconds = unit.toSeconds(statsInterval);
    }

    public int getConcurrentLookupRequest() {
        return this.concurrentLookupRequest;
    }

    public void setConcurrentLookupRequest(int concurrentLookupRequest) {
        this.concurrentLookupRequest = concurrentLookupRequest;
    }

    public int getMaxNumberOfRejectedRequestPerConnection() {
        return this.maxNumberOfRejectedRequestPerConnection;
    }

    public void setMaxNumberOfRejectedRequestPerConnection(int maxNumberOfRejectedRequestPerConnection) {
        this.maxNumberOfRejectedRequestPerConnection = maxNumberOfRejectedRequestPerConnection;
    }
}

