/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.ConsumerCryptoFailureAction;
import org.apache.pulsar.client.api.CryptoKeyReader;
import org.apache.pulsar.client.api.MessageListener;
import org.apache.pulsar.client.api.SubscriptionType;

public class ConsumerConfiguration
implements Serializable {
    static long minAckTimeoutMillis = 1000L;
    private static final long serialVersionUID = 1L;
    private SubscriptionType subscriptionType = SubscriptionType.Exclusive;
    private MessageListener messageListener;
    private int receiverQueueSize = 1000;
    private String consumerName = null;
    private long ackTimeoutMillis = 0L;
    private int priorityLevel = 0;
    private CryptoKeyReader cryptoKeyReader = null;
    private ConsumerCryptoFailureAction cryptoFailureAction = ConsumerCryptoFailureAction.FAIL;

    public long getAckTimeoutMillis() {
        return this.ackTimeoutMillis;
    }

    public ConsumerConfiguration setAckTimeout(long ackTimeout, TimeUnit timeUnit) {
        long ackTimeoutMillis = timeUnit.toMillis(ackTimeout);
        Preconditions.checkArgument((ackTimeoutMillis >= minAckTimeoutMillis ? 1 : 0) != 0, (Object)("Ack timeout should be should be greater than " + minAckTimeoutMillis + " ms"));
        this.ackTimeoutMillis = ackTimeoutMillis;
        return this;
    }

    public SubscriptionType getSubscriptionType() {
        return this.subscriptionType;
    }

    public ConsumerConfiguration setSubscriptionType(SubscriptionType subscriptionType) {
        Preconditions.checkNotNull((Object)((Object)subscriptionType));
        this.subscriptionType = subscriptionType;
        return this;
    }

    public MessageListener getMessageListener() {
        return this.messageListener;
    }

    public ConsumerConfiguration setMessageListener(MessageListener messageListener) {
        Preconditions.checkNotNull((Object)messageListener);
        this.messageListener = messageListener;
        return this;
    }

    public int getReceiverQueueSize() {
        return this.receiverQueueSize;
    }

    public CryptoKeyReader getCryptoKeyReader() {
        return this.cryptoKeyReader;
    }

    public ConsumerConfiguration setCryptoKeyReader(CryptoKeyReader cryptoKeyReader) {
        Preconditions.checkNotNull((Object)cryptoKeyReader);
        this.cryptoKeyReader = cryptoKeyReader;
        return this;
    }

    public void setCryptoFailureAction(ConsumerCryptoFailureAction action) {
        this.cryptoFailureAction = action;
    }

    public ConsumerCryptoFailureAction getCryptoFailureAction() {
        return this.cryptoFailureAction;
    }

    public ConsumerConfiguration setReceiverQueueSize(int receiverQueueSize) {
        Preconditions.checkArgument((receiverQueueSize >= 0 ? 1 : 0) != 0, (Object)"Receiver queue size cannot be negative");
        this.receiverQueueSize = receiverQueueSize;
        return this;
    }

    public String getConsumerName() {
        return this.consumerName;
    }

    public ConsumerConfiguration setConsumerName(String consumerName) {
        Preconditions.checkArgument((consumerName != null && !consumerName.equals("") ? 1 : 0) != 0);
        this.consumerName = consumerName;
        return this;
    }

    public int getPriorityLevel() {
        return this.priorityLevel;
    }

    public void setPriorityLevel(int priorityLevel) {
        this.priorityLevel = priorityLevel;
    }
}

