/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.CompressionType;
import org.apache.pulsar.client.api.CryptoKeyReader;
import org.apache.pulsar.client.api.MessageRouter;
import org.apache.pulsar.client.api.ProducerCryptoFailureAction;
import org.apache.pulsar.client.impl.RoundRobinPartitionMessageRouterImpl;
import org.apache.pulsar.client.impl.SinglePartitionMessageRouterImpl;
import org.apache.pulsar.common.util.collections.ConcurrentOpenHashSet;

public class ProducerConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String producerName = null;
    private long sendTimeoutMs = 30000L;
    private boolean blockIfQueueFull = false;
    private int maxPendingMessages = 1000;
    private MessageRoutingMode messageRouteMode = MessageRoutingMode.SinglePartition;
    private MessageRouter customMessageRouter = null;
    private long batchingMaxPublishDelayMs = 10L;
    private int batchingMaxMessages = 1000;
    private boolean batchingEnabled = false;
    private CryptoKeyReader cryptoKeyReader;
    private ConcurrentOpenHashSet<String> encryptionKeys;
    private CompressionType compressionType = CompressionType.NONE;
    private Long initialSequenceId = null;
    private ProducerCryptoFailureAction cryptoFailureAction = ProducerCryptoFailureAction.FAIL;

    public String getProducerName() {
        return this.producerName;
    }

    public void setProducerName(String producerName) {
        this.producerName = producerName;
    }

    public long getSendTimeoutMs() {
        return this.sendTimeoutMs;
    }

    public ProducerConfiguration setSendTimeout(int sendTimeout, TimeUnit unit) {
        Preconditions.checkArgument((sendTimeout >= 0 ? 1 : 0) != 0);
        this.sendTimeoutMs = unit.toMillis(sendTimeout);
        return this;
    }

    public int getMaxPendingMessages() {
        return this.maxPendingMessages;
    }

    public ProducerConfiguration setMaxPendingMessages(int maxPendingMessages) {
        Preconditions.checkArgument((maxPendingMessages > 0 ? 1 : 0) != 0);
        this.maxPendingMessages = maxPendingMessages;
        return this;
    }

    public boolean getBlockIfQueueFull() {
        return this.blockIfQueueFull;
    }

    public ProducerConfiguration setBlockIfQueueFull(boolean blockIfQueueFull) {
        this.blockIfQueueFull = blockIfQueueFull;
        return this;
    }

    public ProducerConfiguration setMessageRoutingMode(MessageRoutingMode messageRouteMode) {
        Preconditions.checkNotNull((Object)((Object)messageRouteMode));
        this.messageRouteMode = messageRouteMode;
        return this;
    }

    public MessageRoutingMode getMessageRoutingMode() {
        return this.messageRouteMode;
    }

    public ProducerConfiguration setCompressionType(CompressionType compressionType) {
        this.compressionType = compressionType;
        return this;
    }

    public CompressionType getCompressionType() {
        return this.compressionType;
    }

    public ProducerConfiguration setMessageRouter(MessageRouter messageRouter) {
        Preconditions.checkNotNull((Object)messageRouter);
        this.setMessageRoutingMode(MessageRoutingMode.CustomPartition);
        this.customMessageRouter = messageRouter;
        return this;
    }

    public MessageRouter getMessageRouter(int numPartitions) {
        MessageRouter messageRouter;
        switch (this.messageRouteMode) {
            case CustomPartition: {
                Preconditions.checkNotNull((Object)this.customMessageRouter);
                messageRouter = this.customMessageRouter;
                break;
            }
            case RoundRobinPartition: {
                messageRouter = new RoundRobinPartitionMessageRouterImpl(numPartitions);
                break;
            }
            default: {
                messageRouter = new SinglePartitionMessageRouterImpl(numPartitions);
            }
        }
        return messageRouter;
    }

    public boolean getBatchingEnabled() {
        return this.batchingEnabled;
    }

    public ProducerConfiguration setBatchingEnabled(boolean batchMessagesEnabled) {
        this.batchingEnabled = batchMessagesEnabled;
        return this;
    }

    public CryptoKeyReader getCryptoKeyReader() {
        return this.cryptoKeyReader;
    }

    public ProducerConfiguration setCryptoKeyReader(CryptoKeyReader cryptoKeyReader) {
        Preconditions.checkNotNull((Object)cryptoKeyReader);
        this.cryptoKeyReader = cryptoKeyReader;
        return this;
    }

    public ConcurrentOpenHashSet<String> getEncryptionKeys() {
        return this.encryptionKeys;
    }

    public boolean isEncryptionEnabled() {
        return this.encryptionKeys != null && !this.encryptionKeys.isEmpty();
    }

    public void addEncryptionKey(String key) {
        if (this.encryptionKeys == null) {
            this.encryptionKeys = new ConcurrentOpenHashSet(16, 1);
        }
        this.encryptionKeys.add((Object)key);
    }

    public void removeEncryptionKey(String key) {
        if (this.encryptionKeys != null) {
            this.encryptionKeys.remove((Object)key);
        }
    }

    public void setCryptoFailureAction(ProducerCryptoFailureAction action) {
        this.cryptoFailureAction = action;
    }

    public ProducerCryptoFailureAction getCryptoFailureAction() {
        return this.cryptoFailureAction;
    }

    public long getBatchingMaxPublishDelayMs() {
        return this.batchingMaxPublishDelayMs;
    }

    public ProducerConfiguration setBatchingMaxPublishDelay(long batchDelay, TimeUnit timeUnit) {
        long delayInMs = timeUnit.toMillis(batchDelay);
        Preconditions.checkArgument((delayInMs >= 1L ? 1 : 0) != 0, (Object)"configured value for batch delay must be at least 1ms");
        this.batchingMaxPublishDelayMs = delayInMs;
        return this;
    }

    public int getBatchingMaxMessages() {
        return this.batchingMaxMessages;
    }

    public ProducerConfiguration setBatchingMaxMessages(int batchMessagesMaxMessagesPerBatch) {
        Preconditions.checkArgument((batchMessagesMaxMessagesPerBatch > 0 ? 1 : 0) != 0);
        this.batchingMaxMessages = batchMessagesMaxMessagesPerBatch;
        return this;
    }

    public Optional<Long> getInitialSequenceId() {
        return this.initialSequenceId != null ? Optional.of(this.initialSequenceId) : Optional.empty();
    }

    public ProducerConfiguration setInitialSequenceId(long initialSequenceId) {
        this.initialSequenceId = initialSequenceId;
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProducerConfiguration) {
            ProducerConfiguration other = (ProducerConfiguration)obj;
            return Objects.equal((Object)this.sendTimeoutMs, (Object)other.sendTimeoutMs) && Objects.equal((Object)this.maxPendingMessages, (Object)other.maxPendingMessages) && Objects.equal((Object)((Object)this.messageRouteMode), (Object)((Object)other.messageRouteMode));
        }
        return false;
    }

    public static enum MessageRoutingMode {
        SinglePartition,
        RoundRobinPartition,
        CustomPartition;

    }
}

