/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import java.util.List;
import org.apache.pulsar.client.impl.MessageImpl;
import org.apache.pulsar.client.impl.SendCallback;
import org.apache.pulsar.common.api.Commands;
import org.apache.pulsar.common.api.proto.PulsarApi;
import org.apache.pulsar.common.compression.CompressionCodec;
import org.apache.pulsar.common.compression.CompressionCodecProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BatchMessageContainer {
    private SendCallback previousCallback = null;
    private final PulsarApi.CompressionType compressionType;
    private final CompressionCodec compressor;
    private final String topicName;
    private final String producerName;
    final int maxNumMessagesInBatch;
    PulsarApi.MessageMetadata.Builder messageMetadata = PulsarApi.MessageMetadata.newBuilder();
    int numMessagesInBatch = 0;
    long currentBatchSizeBytes = 0L;
    long sequenceId = -1L;
    ByteBuf batchedMessageMetadataAndPayload;
    List<MessageImpl> messages = Lists.newArrayList();
    SendCallback firstCallback;
    protected static final long MAX_MESSAGE_BATCH_SIZE_BYTES = 131072L;
    private static final Logger log = LoggerFactory.getLogger(BatchMessageContainer.class);

    BatchMessageContainer(int maxNumMessagesInBatch, PulsarApi.CompressionType compressionType, String topicName, String producerName) {
        this.maxNumMessagesInBatch = maxNumMessagesInBatch;
        this.compressionType = compressionType;
        this.compressor = CompressionCodecProvider.getCompressionCodec((PulsarApi.CompressionType)compressionType);
        this.topicName = topicName;
        this.producerName = producerName;
    }

    boolean hasSpaceInBatch(MessageImpl msg) {
        int messageSize = msg.getDataBuffer().readableBytes();
        return (long)messageSize + this.currentBatchSizeBytes <= 131072L && this.numMessagesInBatch < this.maxNumMessagesInBatch;
    }

    void add(MessageImpl msg, SendCallback callback) {
        if (log.isDebugEnabled()) {
            log.debug("[{}] [{}] add message to batch, num messages in batch so far {}", new Object[]{this.topicName, this.producerName, this.numMessagesInBatch});
        }
        if (++this.numMessagesInBatch == 1) {
            this.sequenceId = Commands.initBatchMessageMetadata((PulsarApi.MessageMetadata.Builder)this.messageMetadata, (PulsarApi.MessageMetadata.Builder)msg.getMessageBuilder());
            this.firstCallback = callback;
            this.batchedMessageMetadataAndPayload = PooledByteBufAllocator.DEFAULT.buffer(131072, 5232640);
        }
        if (this.previousCallback != null) {
            this.previousCallback.addCallback(callback);
        }
        this.previousCallback = callback;
        this.currentBatchSizeBytes += (long)msg.getDataBuffer().readableBytes();
        PulsarApi.MessageMetadata.Builder msgBuilder = msg.getMessageBuilder();
        this.batchedMessageMetadataAndPayload = Commands.serializeSingleMessageInBatchWithPayload((PulsarApi.MessageMetadata.Builder)msgBuilder, (ByteBuf)msg.getDataBuffer(), (ByteBuf)this.batchedMessageMetadataAndPayload);
        this.messages.add(msg);
        msgBuilder.recycle();
    }

    ByteBuf getCompressedBatchMetadataAndPayload() {
        int uncompressedSize = this.batchedMessageMetadataAndPayload.readableBytes();
        ByteBuf compressedPayload = this.compressor.encode(this.batchedMessageMetadataAndPayload);
        this.batchedMessageMetadataAndPayload.release();
        if (this.compressionType != PulsarApi.CompressionType.NONE) {
            this.messageMetadata.setCompression(this.compressionType);
            this.messageMetadata.setUncompressedSize(uncompressedSize);
        }
        return compressedPayload;
    }

    PulsarApi.MessageMetadata setBatchAndBuild() {
        this.messageMetadata.setNumMessagesInBatch(this.numMessagesInBatch);
        if (log.isDebugEnabled()) {
            log.debug("[{}] [{}] num messages in batch being closed are {}", new Object[]{this.topicName, this.producerName, this.numMessagesInBatch});
        }
        return this.messageMetadata.build();
    }

    ByteBuf getBatchedSingleMessageMetadataAndPayload() {
        return this.batchedMessageMetadataAndPayload;
    }

    void clear() {
        this.messages = Lists.newArrayList();
        this.firstCallback = null;
        this.previousCallback = null;
        this.messageMetadata.clear();
        this.numMessagesInBatch = 0;
        this.currentBatchSizeBytes = 0L;
        this.sequenceId = -1L;
    }

    boolean isEmpty() {
        return this.messages.isEmpty();
    }
}

